/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.naming.BModuleScheme;
import javax.baja.spy.ISpyDir;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;

public final class WebDev {
    private final String name;
    private boolean enabled;
    private static final Map<String, WebDev> webDevs;
    private static final Logger log;
    private static volatile Properties props;
    private static volatile BAbsTime lastModified;
    private static final String NIAGARA_USER_HOME;

    private WebDev(String name) {
        this.name = name;
    }

    private WebDev(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebDev get(String name) {
        WebDev wd;
        WebDev.load();
        Map<String, WebDev> map = webDevs;
        synchronized (map) {
            wd = webDevs.get(name);
            if (wd == null) {
                wd = new WebDev(name);
                webDevs.put(name, wd);
                lastModified = BAbsTime.now();
            }
        }
        return wd;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        lastModified = BAbsTime.now();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WebDev> getWebDevs() {
        Map<String, WebDev> map = webDevs;
        synchronized (map) {
            return webDevs.values().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        }
    }

    public static BAbsTime getLastModified() {
        WebDev.load();
        return lastModified;
    }

    private static File getWebDevFile() {
        return new File(NIAGARA_USER_HOME + File.separator + "etc" + File.separator + "webdev.properties");
    }

    public static void save() {
        AccessController.doPrivileged(() -> {
            if (!WebDev.getWebDevFile().getParentFile().exists()) {
                WebDev.getWebDevFile().getParentFile().mkdirs();
            }
            try (PrintWriter out = new PrintWriter(new FileWriter(WebDev.getWebDevFile()));){
                out.println("#");
                out.println("# WebDev file saved: " + new Date());
                out.println("#");
                for (WebDev wd : WebDev.getWebDevs()) {
                    out.println(wd.getName() + "=" + (wd.isEnabled() ? "true" : "false"));
                }
            }
            catch (IOException e) {
                System.out.println("ERROR: Canot save 'webdev.properties'");
                System.out.println("  " + e);
            }
            return null;
        });
    }

    public static void load() {
        AccessController.doPrivileged(() -> {
            Map<String, WebDev> map = webDevs;
            synchronized (map) {
                if (props == null) {
                    props = new Properties();
                    try {
                        File file = WebDev.getWebDevFile();
                        try {
                            long lm = file.lastModified();
                            lastModified = lm <= 0L ? BAbsTime.now() : BAbsTime.make((long)lm);
                        }
                        catch (Exception e) {
                            lastModified = BAbsTime.now();
                        }
                        try (FileInputStream in = new FileInputStream(file);){
                            props.load(in);
                        }
                    }
                    catch (Exception file) {
                        // empty catch block
                    }
                    if (props != null) {
                        Enumeration<Object> keys = props.keys();
                        while (keys.hasMoreElements()) {
                            Object k = keys.nextElement();
                            WebDev wd = new WebDev(k.toString(), props.get(k).equals("true"));
                            webDevs.put(k.toString(), wd);
                        }
                    }
                }
            }
            return null;
        });
    }

    public static boolean isAnyWebDevEnabled() {
        return WebDev.getWebDevs().stream().anyMatch(WebDev::isEnabled);
    }

    static {
        Spy.ROOT.add("webDevSetup", (Spy)new WebDevSpy());
        webDevs = new HashMap<String, WebDev>();
        log = Logger.getLogger("webDev");
        lastModified = BAbsTime.NULL;
        NIAGARA_USER_HOME = AccessController.doPrivileged(() -> System.getProperty("niagara.user.home"));
    }

    private static final class MessageWebDevSetupSpy
    extends WebDevSpy {
        String message;

        private MessageWebDevSetupSpy(String message) {
            this.message = message;
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            out.write("<br/><b>");
            out.write(this.message);
            out.write("</b><br/><br/>");
            super.write(out);
        }
    }

    private static class WebDevSpy
    extends Spy
    implements ISpyDir {
        private WebDevSpy() {
        }

        public String[] list() {
            return new String[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"save")) {
                log.info("Saved 'webdev.properties'.");
                WebDev.save();
                return new MessageWebDevSetupSpy("Saved 'webdev.properties' file");
            }
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"enableAll")) {
                Map map = webDevs;
                synchronized (map) {
                    webDevs.values().forEach(wd -> wd.setEnabled(true));
                }
                return new MessageWebDevSetupSpy("Enabled All");
            }
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"disableAll")) {
                Map map = webDevs;
                synchronized (map) {
                    webDevs.values().forEach(wd -> wd.setEnabled(false));
                }
                return new MessageWebDevSetupSpy("Disabled All");
            }
            String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
            if (namePart.indexOf("enable-") == 0) {
                WebDev wd2;
                String wdName = namePart.substring(7, namePart.length());
                Map map = webDevs;
                synchronized (map) {
                    wd2 = (WebDev)webDevs.get(wdName);
                }
                if (wd2 != null) {
                    wd2.setEnabled(true);
                    return new MessageWebDevSetupSpy("Enabled: " + wdName);
                }
                return new MessageWebDevSetupSpy("Error enabing: could not find: " + wdName);
            }
            if (namePart.indexOf("disable-") == 0) {
                WebDev wd3;
                String wdName = namePart.substring(8, namePart.length());
                Map map = webDevs;
                synchronized (map) {
                    wd3 = (WebDev)webDevs.get(wdName);
                }
                if (wd3 != null) {
                    wd3.setEnabled(false);
                    return new MessageWebDevSetupSpy("Disabled: " + wdName);
                }
                return new MessageWebDevSetupSpy("Error disabling: could not find: " + wdName);
            }
            return null;
        }

        public void write(SpyWriter out) throws Exception {
            out.startTable(true);
            out.unsafe().trTitle((Object)("Web Devs [" + out.createLink("spy:/webDevSetup/" + SpyWriter.addCsrfToken((String)"save"), (Object)"Save To File") + "] [" + out.createLink("spy:/webDevSetup/" + SpyWriter.addCsrfToken((String)"enableAll"), (Object)"Enable All") + "]  [" + out.createLink("spy:/webDevSetup/" + SpyWriter.addCsrfToken((String)"disableAll"), (Object)"Disable All") + "]"), 2);
            out.w((Object)"<tr><th align='left'>webdev.properties</th><td align='left'>").w((Object)lastModified).w((Object)"</td></tr>\n");
            out.w((Object)"<tr><th align='left'>Module Dev Mode</th><td align='left'>").w((Object)(BModuleScheme.isModuleDevEnabled() ? "[Enabled]" : "[Disabled]")).w((Object)"</td></tr>\n");
            out.w((Object)"<tr>").thTitle((Object)"Name").thTitle((Object)"State").w((Object)"</tr>");
            for (WebDev wd : WebDev.getWebDevs()) {
                String name = wd.getName();
                boolean enabled = wd.isEnabled();
                out.w((Object)"<tr>");
                out.w((Object)"<td align='left' nowrap='true'>").w((Object)name).w((Object)"</td>");
                out.w((Object)"<td>");
                out.w((Object)"[<a href='spy:/webDevSetup/");
                out.safe((Object)(enabled ? SpyWriter.addCsrfToken((String)("disable-" + name)) : SpyWriter.addCsrfToken((String)("enable-" + name))));
                out.w((Object)"'>");
                out.w((Object)(enabled ? "Enabled" : "Disabled"));
                out.w((Object)"</a>]");
                out.w((Object)"</td>");
                out.w((Object)"</tr>\n");
            }
            out.endTable();
        }
    }
}

