/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.web.servlets.NWebOp;
import java.io.IOException;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebService;
import javax.baja.web.WebOp;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BWebServlet
extends BAbstractService {
    public static final Property servletName = BWebServlet.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BWebServlet.class);
    private final Servlet servlet = new Servlet();

    public String getServletName() {
        return this.getString(servletName);
    }

    public void setServletName(String v) {
        this.setString(servletName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public OrdTarget resolve(WebOp op) throws Exception {
        return op.getBaseOrdTarget();
    }

    public void service(WebOp op) throws Exception {
        String method = TextUtil.toLowerCase((String)op.getRequest().getMethod());
        if (method.equals("get")) {
            this.doGet(op);
        } else if (method.equals("post")) {
            this.doPost(op);
        } else if (method.equals("put")) {
            this.doPut(op);
        } else if (method.equals("delete")) {
            this.doDelete(op);
        } else {
            op.getResponse().sendError(405, method);
        }
    }

    private void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (!this.getEnabled()) {
                resp.sendError(410);
                return;
            }
            Context cx = (Context)req.getAttribute("niagara.context");
            if (!this.getPermissions(cx).hasOperatorRead()) {
                resp.sendError(403);
                return;
            }
            OrdTarget target = this.getNavOrd().resolve((BObject)BLocalHost.INSTANCE, cx);
            BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
            NWebOp op = new NWebOp(target, service, req, resp);
            op.fw((Object)this);
            OrdTarget newTarget = this.resolve(op);
            if (newTarget != target) {
                op = new NWebOp(newTarget, service, req, resp);
                op.fw((Object)this);
            }
            req.setAttribute("niagara.target", (Object)newTarget);
            req.setAttribute("niagara.op", (Object)op);
            this.service(op);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(WebOp c) throws Exception {
        c.getResponse().sendError(405, "get");
    }

    public void doDelete(WebOp c) throws Exception {
        c.getResponse().sendError(405, "delete");
    }

    public void doPost(WebOp op) throws Exception {
        String protocol = op.getRequest().getProtocol();
        String msg = "Post not allowed";
        if (protocol.endsWith("1.1")) {
            op.getResponse().sendError(405, msg);
        } else {
            op.getResponse().sendError(400, msg);
        }
    }

    public void doPut(WebOp op) throws Exception {
        String protocol = op.getRequest().getProtocol();
        String msg = "Put not allowed";
        if (protocol.endsWith("1.1")) {
            op.getResponse().sendError(405, msg);
        } else {
            op.getResponse().sendError(400, msg);
        }
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.register();
                break;
            }
            case 12: {
                this.unregister();
                break;
            }
            case 2: {
                if (!this.isRunning() || !((Property)a).getName().equals(servletName.getName())) break;
                this.unregister();
                this.register();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void register() {
        try {
            BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
            BWebServer server = service.getWebServer();
            if (server != null) {
                server.register(this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void unregister() {
        try {
            BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
            BWebServer server = service.getWebServer();
            if (server != null) {
                server.unregister(this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void setValidServletName(boolean valid) {
        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (!valid ? 1 : 0) != 0));
        this.updateStatus();
    }

    public final HttpServlet getHttpServlet() {
        return this.servlet;
    }

    private final class Servlet
    extends HttpServlet {
        private Servlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            BWebServlet.this.doService(req, resp);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            BWebServlet.this.doService(req, resp);
        }

        protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            BWebServlet.this.doService(req, resp);
        }

        protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            BWebServlet.this.doService(req, resp);
        }
    }
}

