/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.nre.firewall.IpProtocol;
import com.tridium.security.BISecurityInfoSource;
import com.tridium.security.BSecurityInfo;
import com.tridium.sys.Nre;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CertAliasCasePropertyValidator;
import com.tridium.web.BHostHeaderValidationSettings;
import com.tridium.web.BHostnameRedirectSettings;
import com.tridium.web.BSameSiteEnum;
import com.tridium.web.WebUtil;
import com.tridium.web.rpc.BUserDataConfig;
import com.tridium.web.servlets.UnauthenticatedCache;
import com.tridium.web.servlets.WebStartServlet;
import com.tridium.web.warmup.BWebWarmupConfig;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.firewall.BServerPort;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BAppletModuleCachingType;
import javax.baja.web.BCacheConfig;
import javax.baja.web.BClientEnvironments;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebStartConfig;
import javax.baja.web.BXFrameOptionsEnum;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.baja.web.http.BHttpHeaderProviders;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="httpPort", type="BServerPort", defaultValue="new BServerPort(80, IpProtocol.TCP)"), @NiagaraProperty(name="httpEnabled", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsPort", type="BServerPort", defaultValue="new BServerPort(443, IpProtocol.TCP)"), @NiagaraProperty(name="httpsEnabled", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsOnly", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsMinProtocol", type="BSslTlsEnum", defaultValue="BSslTlsEnum.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="cipherSuiteGroup", type="BTlsCipherSuiteGroup", defaultValue="BTlsCipherSuiteGroup.recommended", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsCert", type="String", defaultValue="tridium", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="requireHttpsForPasswords", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="xFrameOptions", type="BXFrameOptionsEnum", defaultValue="BXFrameOptionsEnum.sameorigin", flags=5, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="rememberUserIdCookie", type="boolean", defaultValue="true"), @NiagaraProperty(name="sameSite", type="BSameSiteEnum", defaultValue="BSameSiteEnum.lax", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="allowUsernameAutocomplete", type="boolean", defaultValue="true"), @NiagaraProperty(name="loginTemplate", type="BTypeSpec", defaultValue="BTypeSpec.NULL", facets={@Facet(name="BFacets.ALLOW_NULL", value="BBoolean.TRUE"), @Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"web:LoginTemplate\")")}), @NiagaraProperty(name="gzipEnabled", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="logFileDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^^webLogs\")", flags=1), @NiagaraProperty(name="clientEnvironments", type="BClientEnvironments", defaultValue="new BClientEnvironments()"), @NiagaraProperty(name="showStackTrace", type="boolean", defaultValue="false"), @NiagaraProperty(name="appletModuleCachingType", type="web:AppletModuleCachingType", defaultValue="BAppletModuleCachingType.host"), @NiagaraProperty(name="webStartConfig", type="web:WebStartConfig", defaultValue="new BWebStartConfig()"), @NiagaraProperty(name="cacheConfig", type="web:CacheConfig", defaultValue="new BCacheConfig()"), @NiagaraProperty(name="warmupConfig", type="web:WebWarmupConfig", defaultValue="new BWebWarmupConfig()", flags=65536), @NiagaraProperty(name="hostnameRedirectSettings", type="web:HostnameRedirectSettings", defaultValue="new BHostnameRedirectSettings()"), @NiagaraProperty(name="httpHeaderProviders", type="web:HttpHeaderProviders", defaultValue="new BHttpHeaderProviders()"), @NiagaraProperty(name="hostHeaderValidationSettings", type="web:HostHeaderValidationSettings", defaultValue="new BHostHeaderValidationSettings()")})
@NiagaraAction(name="resetAllConnections", flags=128)
public final class BWebService
extends BAbstractService
implements BIRestrictedComponent,
BISecurityInfoSource,
BISecurityDashboardProvider {
    public static final Property httpPort = BWebService.newProperty((int)0, (BValue)new BServerPort(80, IpProtocol.TCP), null);
    public static final Property httpEnabled = BWebService.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property httpsPort = BWebService.newProperty((int)0, (BValue)new BServerPort(443, IpProtocol.TCP), null);
    public static final Property httpsEnabled = BWebService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property httpsOnly = BWebService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property httpsMinProtocol = BWebService.newProperty((int)0, (BValue)BSslTlsEnum.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property cipherSuiteGroup = BWebService.newProperty((int)0, (BValue)BTlsCipherSuiteGroup.recommended, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property httpsCert = BWebService.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    public static final Property requireHttpsForPasswords = BWebService.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property xFrameOptions = BWebService.newProperty((int)5, (BValue)BXFrameOptionsEnum.sameorigin, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property rememberUserIdCookie = BWebService.newProperty((int)0, (boolean)true, null);
    public static final Property sameSite = BWebService.newProperty((int)0, (BValue)BSameSiteEnum.lax, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property allowUsernameAutocomplete = BWebService.newProperty((int)0, (boolean)true, null);
    public static final Property loginTemplate = BWebService.newProperty((int)0, (BValue)BTypeSpec.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"allowNull", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"web:LoginTemplate"))));
    public static final Property gzipEnabled = BWebService.newProperty((int)4, (boolean)false, null);
    public static final Property logFileDirectory = BWebService.newProperty((int)1, (BValue)BOrd.make((String)"file:^^webLogs"), null);
    public static final Property clientEnvironments = BWebService.newProperty((int)0, (BValue)new BClientEnvironments(), null);
    public static final Property showStackTrace = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property appletModuleCachingType = BWebService.newProperty((int)0, (BValue)BAppletModuleCachingType.host, null);
    public static final Property webStartConfig = BWebService.newProperty((int)0, (BValue)new BWebStartConfig(), null);
    public static final Property cacheConfig = BWebService.newProperty((int)0, (BValue)new BCacheConfig(), null);
    public static final Property warmupConfig = BWebService.newProperty((int)65536, (BValue)new BWebWarmupConfig(), null);
    public static final Property hostnameRedirectSettings = BWebService.newProperty((int)0, (BValue)new BHostnameRedirectSettings(), null);
    public static final Property httpHeaderProviders = BWebService.newProperty((int)0, (BValue)new BHttpHeaderProviders(), null);
    public static final Property hostHeaderValidationSettings = BWebService.newProperty((int)0, (BValue)new BHostHeaderValidationSettings(), null);
    public static final Action resetAllConnections = BWebService.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BWebService.class);
    public static final Logger log = Logger.getLogger(BWebService.class.getName());
    private static final BIcon icon = BIcon.std((String)"navOnly/webService.png");
    private static final int VERSION = 2;
    private static final double MILLIS_IN_NINETY_DAYS = BRelTime.makeDays((int)90).getMillis();
    private CertAliasCasePropertyValidator validator = new CertAliasCasePropertyValidator(httpsCert.getName());
    private static BWebService cachedService;

    public BServerPort getHttpPort() {
        return (BServerPort)this.get(httpPort);
    }

    public void setHttpPort(BServerPort v) {
        this.set(httpPort, (BValue)v, null);
    }

    public boolean getHttpEnabled() {
        return this.getBoolean(httpEnabled);
    }

    public void setHttpEnabled(boolean v) {
        this.setBoolean(httpEnabled, v, null);
    }

    public BServerPort getHttpsPort() {
        return (BServerPort)this.get(httpsPort);
    }

    public void setHttpsPort(BServerPort v) {
        this.set(httpsPort, (BValue)v, null);
    }

    public boolean getHttpsEnabled() {
        return this.getBoolean(httpsEnabled);
    }

    public void setHttpsEnabled(boolean v) {
        this.setBoolean(httpsEnabled, v, null);
    }

    public boolean getHttpsOnly() {
        return this.getBoolean(httpsOnly);
    }

    public void setHttpsOnly(boolean v) {
        this.setBoolean(httpsOnly, v, null);
    }

    public BSslTlsEnum getHttpsMinProtocol() {
        return (BSslTlsEnum)this.get(httpsMinProtocol);
    }

    public void setHttpsMinProtocol(BSslTlsEnum v) {
        this.set(httpsMinProtocol, (BValue)v, null);
    }

    public BTlsCipherSuiteGroup getCipherSuiteGroup() {
        return (BTlsCipherSuiteGroup)this.get(cipherSuiteGroup);
    }

    public void setCipherSuiteGroup(BTlsCipherSuiteGroup v) {
        this.set(cipherSuiteGroup, (BValue)v, null);
    }

    public String getHttpsCert() {
        return this.getString(httpsCert);
    }

    public void setHttpsCert(String v) {
        this.setString(httpsCert, v, null);
    }

    public boolean getRequireHttpsForPasswords() {
        return this.getBoolean(requireHttpsForPasswords);
    }

    public void setRequireHttpsForPasswords(boolean v) {
        this.setBoolean(requireHttpsForPasswords, v, null);
    }

    public BXFrameOptionsEnum getXFrameOptions() {
        return (BXFrameOptionsEnum)this.get(xFrameOptions);
    }

    public void setXFrameOptions(BXFrameOptionsEnum v) {
        this.set(xFrameOptions, (BValue)v, null);
    }

    public boolean getRememberUserIdCookie() {
        return this.getBoolean(rememberUserIdCookie);
    }

    public void setRememberUserIdCookie(boolean v) {
        this.setBoolean(rememberUserIdCookie, v, null);
    }

    public BSameSiteEnum getSameSite() {
        return (BSameSiteEnum)this.get(sameSite);
    }

    public void setSameSite(BSameSiteEnum v) {
        this.set(sameSite, (BValue)v, null);
    }

    public boolean getAllowUsernameAutocomplete() {
        return this.getBoolean(allowUsernameAutocomplete);
    }

    public void setAllowUsernameAutocomplete(boolean v) {
        this.setBoolean(allowUsernameAutocomplete, v, null);
    }

    public BTypeSpec getLoginTemplate() {
        return (BTypeSpec)this.get(loginTemplate);
    }

    public void setLoginTemplate(BTypeSpec v) {
        this.set(loginTemplate, (BValue)v, null);
    }

    public boolean getGzipEnabled() {
        return this.getBoolean(gzipEnabled);
    }

    public void setGzipEnabled(boolean v) {
        this.setBoolean(gzipEnabled, v, null);
    }

    public BOrd getLogFileDirectory() {
        return (BOrd)this.get(logFileDirectory);
    }

    public void setLogFileDirectory(BOrd v) {
        this.set(logFileDirectory, (BValue)v, null);
    }

    public BClientEnvironments getClientEnvironments() {
        return (BClientEnvironments)this.get(clientEnvironments);
    }

    public void setClientEnvironments(BClientEnvironments v) {
        this.set(clientEnvironments, (BValue)v, null);
    }

    public boolean getShowStackTrace() {
        return this.getBoolean(showStackTrace);
    }

    public void setShowStackTrace(boolean v) {
        this.setBoolean(showStackTrace, v, null);
    }

    public BAppletModuleCachingType getAppletModuleCachingType() {
        return (BAppletModuleCachingType)this.get(appletModuleCachingType);
    }

    public void setAppletModuleCachingType(BAppletModuleCachingType v) {
        this.set(appletModuleCachingType, (BValue)v, null);
    }

    public BWebStartConfig getWebStartConfig() {
        return (BWebStartConfig)this.get(webStartConfig);
    }

    public void setWebStartConfig(BWebStartConfig v) {
        this.set(webStartConfig, (BValue)v, null);
    }

    public BCacheConfig getCacheConfig() {
        return (BCacheConfig)this.get(cacheConfig);
    }

    public void setCacheConfig(BCacheConfig v) {
        this.set(cacheConfig, (BValue)v, null);
    }

    public BWebWarmupConfig getWarmupConfig() {
        return (BWebWarmupConfig)this.get(warmupConfig);
    }

    public void setWarmupConfig(BWebWarmupConfig v) {
        this.set(warmupConfig, (BValue)v, null);
    }

    public BHostnameRedirectSettings getHostnameRedirectSettings() {
        return (BHostnameRedirectSettings)this.get(hostnameRedirectSettings);
    }

    public void setHostnameRedirectSettings(BHostnameRedirectSettings v) {
        this.set(hostnameRedirectSettings, (BValue)v, null);
    }

    public BHttpHeaderProviders getHttpHeaderProviders() {
        return (BHttpHeaderProviders)this.get(httpHeaderProviders);
    }

    public void setHttpHeaderProviders(BHttpHeaderProviders v) {
        this.set(httpHeaderProviders, (BValue)v, null);
    }

    public BHostHeaderValidationSettings getHostHeaderValidationSettings() {
        return (BHostHeaderValidationSettings)this.get(hostHeaderValidationSettings);
    }

    public void setHostHeaderValidationSettings(BHostHeaderValidationSettings v) {
        this.set(hostHeaderValidationSettings, (BValue)v, null);
    }

    public void resetAllConnections() {
        this.invoke(resetAllConnections, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "web");
    }

    public IWebEnv getWebEnv(WebOp op) {
        return this.getClientEnvironments().getWebEnv(op);
    }

    public BWebServer getWebServer() {
        BWebServer[] servers = (BWebServer[])this.getChildren(BWebServer.class);
        return servers.length == 0 ? null : servers[0];
    }

    public static BWebService getMainService() {
        BWebService service = cachedService;
        if (service == null || service.getComponentSpace() == null || !service.isRunning()) {
            try {
                cachedService = service = (BWebService)Sys.getService((Type)TYPE);
            }
            catch (ServiceNotFoundException e) {
                cachedService = null;
                throw e;
            }
        }
        return service;
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.getHostHeaderValidationSettings().getValidHostHeaders().isEmpty()) {
            this.getHostHeaderValidationSettings().autoPopulateValidHostHeaders();
        }
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.getComponentSpace().enableMixIn(BWebProfileConfig.TYPE);
        BUserService us = (BUserService)Sys.getService((Type)BUserService.TYPE);
        Property prop = us.getProperty("secureOnlyPasswordSet");
        if (prop != null && !us.get(prop).equals((Object)prop.getDefaultValue())) {
            this.setRequireHttpsForPasswords(((BIBoolean)us.get(prop)).getBoolean());
        }
        if (Sys.isStationStarted() && this.getHostHeaderValidationSettings().getValidHostHeaders().isEmpty()) {
            this.getHostHeaderValidationSettings().autoPopulateValidHostHeaders();
        }
        WebUtil.setStationTheme();
    }

    public void started() {
        if (((BUserDataConfig[])this.getChildren(BUserDataConfig.class)).length == 0) {
            this.add("UserDataConfig", (BValue)new BUserDataConfig());
            this.setDisplayName(this.getProperty("UserDataConfig"), BFormat.make((String)"%lexicon(web:userDataConfig)%"), null);
        }
        if (!Flags.has((BComplex)this, (Slot)xFrameOptions, (int)0x10000000)) {
            this.getHttpHeaderProviders().getXFrameOptions().setXFrameOptions(this.getXFrameOptions());
            Flags.add((BComponent)this, (Slot)xFrameOptions, null, (int[])new int[]{0x10000000});
        }
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.getComponentSpace().disableMixIn(BWebProfileConfig.TYPE);
    }

    protected void enabled() {
        super.enabled();
        this.getWebServer().scheduleRestart();
    }

    protected void disabled() {
        super.disabled();
        BWebServer server = this.getWebServer();
        server.post(() -> server.stopWebServer(null));
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BSecurityInfo getSecurityInfo() {
        BSecurityInfo info = new BSecurityInfo();
        info.setSourceName(this.getDisplayName(null));
        if (this.isMounted()) {
            info.setHyperlink(this.getSlotPathOrd());
        }
        info.add("alias", (BValue)BString.make((String)this.getHttpsCert()));
        return info;
    }

    public void added(Property property, Context context) {
        if (this.isRunning()) {
            UnauthenticatedCache.checkForInit(property.getName());
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning()) {
            UnauthenticatedCache.checkForInit(property.getName());
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        String name = property.getName();
        if (this.isRunning()) {
            BWebServer webServer;
            UnauthenticatedCache.checkForInit(property.getName());
            if (property.isFrozen() && (webServer = this.getWebServer()) != null) {
                webServer.webServiceConfigurationChanged(property, context);
                if (httpPort == property || httpsPort == property || enabled == property || httpEnabled == property || httpsEnabled == property) {
                    this.updatePlatformSummaryFields();
                } else if (webStartConfig == property) {
                    WebStartServlet.onWebStartConfigChanged();
                }
            }
        }
        if (property.equals(xFrameOptions)) {
            this.getHttpHeaderProviders().getXFrameOptions().setXFrameOptions(this.getXFrameOptions());
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (value instanceof BWebServer && this.getWebServer() != null) {
            throw new LocalizableRuntimeException("web", "thereCanOnlyBeOne");
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.verifyWebServer();
    }

    public void childParented(Property property, BValue newChild, Context context) {
        super.childParented(property, newChild, context);
        this.verifyWebServer();
    }

    public void childUnparented(Property property, BValue oldChild, Context context) {
        super.childUnparented(property, oldChild, context);
        this.verifyWebServer();
    }

    private void verifyWebServer() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getWebServer() == null) {
            this.configFail(this.getLexicon().getText("web.noWebServer"));
        } else {
            this.configOk();
        }
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (2 == x) {
            Property p;
            if (this.isRunning() && (httpPort == (p = (Property)a) || httpsPort == p)) {
                this.updatePlatformSummaryFields();
            }
        } else if (23 == x) {
            this.updatePlatformSummaryFields();
        }
        return super.fw(x, a, b, c, d);
    }

    private void updatePlatformSummaryFields() {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int httpPort = -1;
        int httpsPort = -1;
        if (this.getHttpEnabled() && this.getEnabled()) {
            httpPort = this.getHttpPort().getPublicServerPort();
        }
        if (this.getHttpsEnabled() && this.getEnabled()) {
            httpsPort = this.getHttpsPort().getPublicServerPort();
        }
        keys.add("httpport");
        values.add(String.valueOf(httpPort));
        keys.add("httpsport");
        values.add(String.valueOf(httpsPort));
        Nre.getPlatform().reportSummaryFields(keys.toArray(new String[keys.size()]), values.toArray(new String[values.size()]));
    }

    public BComponent getHttpConnectionDetails(Context cx) {
        BComponent details = new BComponent();
        details.add("enabled", (BValue)BBoolean.make((boolean)this.getEnabled()));
        details.add("httpEnabled", (BValue)BBoolean.make((boolean)this.getHttpEnabled()));
        details.add("httpsEnabled", (BValue)BBoolean.make((boolean)this.getHttpsEnabled()));
        details.add("httpsPort", (BValue)BInteger.make((int)this.getHttpsPort().getPublicServerPort()));
        details.add("httpPort", (BValue)BInteger.make((int)this.getHttpPort().getPublicServerPort()));
        return details;
    }

    public void doResetAllConnections(Context context) throws Exception {
        new Thread(){

            @Override
            public void run() {
                BWebServer webServer = BWebService.this.getWebServer();
                if (webServer != null) {
                    webServer.invalidateAllSessions();
                }
            }
        }.start();
    }

    public BIcon getIcon() {
        return icon;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 2;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.addTlsItems(items);
        this.addCipherSuiteGroupItems(items);
        this.addStationCertificateItems(items);
        this.addPasswordParameters(items);
        this.addSameSiteItem(items);
        this.addHostHeaderValidationItem(items);
        return items;
    }

    private void addTlsItems(List<SecurityDashboardItem> items) {
        if (this.getHttpEnabled() && !this.getHttpsEnabled()) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (String)"securityDashboard.webTlsProtocolOff.summary", (String)"securityDashboard.webTlsProtocolOff.description"));
        }
        if (!this.getHttpEnabled() && this.getHttpsEnabled()) {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (String)"securityDashboard.webTlsProtocolOn.summary", (String)"securityDashboard.webTlsProtocolOn.description"));
        }
        if (this.getHttpEnabled() && this.getHttpsEnabled() && this.getHttpsOnly()) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (String)"securityDashboard.webForwarding.summary", (String)"securityDashboard.webForwarding.description"));
        }
        if (this.getHttpEnabled() && this.getHttpsEnabled() && !this.getHttpsOnly()) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (String)"securityDashboard.webNonTlsProtocol.summary", (String)"securityDashboard.webNonTlsProtocol.description"));
        }
        if (this.getHttpsEnabled()) {
            BSecurityItemStatus status = this.getHttpsMinProtocol().equals((Object)BSslTlsEnum.tlsv1_2) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
            items.add(SecurityDashboardItem.make((LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webTlsProtocol.summary", (BSimple[])new BSimple[]{this.getHttpsMinProtocol()}), (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webTlsProtocol.description", (BSimple[])new BSimple[]{BSslTlsEnum.tlsv1_2}), (BSecurityItemStatus)status));
        }
    }

    private void addCipherSuiteGroupItems(List<SecurityDashboardItem> items) {
        if (this.getHttpsEnabled()) {
            BSecurityItemStatus status = this.getCipherSuiteGroup().equals((Object)BTlsCipherSuiteGroup.recommended) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
            items.add(SecurityDashboardItem.make((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.cipherSuiteGroup.summary", (BSimple[])new BSimple[]{this.getCipherSuiteGroup()}), (String)"securityDashboard.cipherSuiteGroup.description", (BSecurityItemStatus)status));
        }
    }

    private void addStationCertificateItems(List<SecurityDashboardItem> items) {
        if (this.getHttpsEnabled()) {
            try {
                X509Certificate certificate = CertManagerFactory.getInstance().getKeyStore().getCertificate(this.getHttpsCert());
                try {
                    certificate.checkValidity();
                    Date date = new Date();
                    if ((double)(certificate.getNotAfter().getTime() - date.getTime()) < MILLIS_IN_NINETY_DAYS) {
                        items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webCertificateNearExpiry.summary", (BSimple[])new BSimple[]{BString.make((String)this.getHttpsCert()), BAbsTime.make((long)certificate.getNotAfter().getTime())}), (String)"securityDashboard.webCertificateNearExpiry.description"));
                    } else {
                        items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webCertificateValid.summary", (String)this.getHttpsCert()), (String)"securityDashboard.webCertificateValid.description"));
                    }
                }
                catch (CertificateExpiredException e) {
                    items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webCertificateExpired.summary", (String)this.getHttpsCert()), (String)"securityDashboard.webCertificateExpired.description"));
                }
                catch (CertificateNotYetValidException e) {
                    items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webCertificateNotYetValidException.summary", (BSimple[])new BSimple[]{BString.make((String)this.getHttpsCert()), BAbsTime.make((long)certificate.getNotBefore().getTime())}), (String)"securityDashboard.webCertificateNotYetValidException.description"));
                }
                if (this.isSelfSigned(certificate)) {
                    items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webCertificateSelfSigned.summary", (String)this.getHttpsCert()), (String)"securityDashboard.webCertificateSelfSigned.description"));
                } else {
                    items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webCertificateNotSelfSigned.summary", (String)this.getHttpsCert()), (String)"securityDashboard.webCertificateNotSelfSigned.description"));
                }
            }
            catch (Exception e) {
                items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.webCertificateNotAvailable.summary", (String)this.getHttpsCert()), (String)"securityDashboard.webCertificateNotAvailable.description"));
            }
        }
    }

    private void addPasswordParameters(List<SecurityDashboardItem> items) {
        BSecurityItemStatus status;
        String summaryKey;
        if (this.getRequireHttpsForPasswords()) {
            summaryKey = "securityDashboard.requireHttpsForPasswordTrue.summary";
            status = BSecurityItemStatus.securityStatusOK;
        } else {
            summaryKey = "securityDashboard.requireHttpsForPasswordFalse.summary";
            status = BSecurityItemStatus.securityStatusWarning;
        }
        String descriptionKey = "securityDashboard.requireHttpsForPassword.description";
        items.add(SecurityDashboardItem.make((Type)TYPE, (String)summaryKey, (String)descriptionKey, (BSecurityItemStatus)status));
    }

    private void addSameSiteItem(List<SecurityDashboardItem> items) {
        BSameSiteEnum sameSite = this.getSameSite();
        BSecurityItemStatus status = sameSite == BSameSiteEnum.none ? BSecurityItemStatus.securityStatusWarning : BSecurityItemStatus.securityStatusOK;
        items.add(SecurityDashboardItem.make((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sameSite.summary", (BSimple[])new BSimple[]{sameSite}), (String)"securityDashboard.sameSite.description", (BSecurityItemStatus)status));
    }

    private void addHostHeaderValidationItem(List<SecurityDashboardItem> items) {
        if (this.getHostHeaderValidationSettings().getValidateHostHeader()) {
            if (this.getHostHeaderValidationSettings().getValidHostHeaders().contains("*")) {
                items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (String)"securityDashboard.hostHeader.wildcard.summary", (String)"securityDashboard.hostHeader.description"));
            } else {
                items.add(SecurityDashboardItem.makeOk((Type)TYPE, (String)"securityDashboard.hostHeader.ok.summary", (String)"securityDashboard.hostHeader.description"));
            }
        } else {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (String)"securityDashboard.hostHeader.validationOff.summary", (String)"securityDashboard.hostHeader.description"));
        }
    }

    private boolean isSelfSigned(X509Certificate certificate) {
        return certificate.getIssuerDN().equals(certificate.getSubjectDN());
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (ArrayUtil.indexOf((Object[])properties, (Object)httpsCert) > -1) {
            return this.validator;
        }
        return super.getPropertyValidator(properties, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (httpsCert.equals(property)) {
            return this.validator;
        }
        return super.getPropertyValidator(property, context);
    }
}

