/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BClientEnvironment;
import javax.baja.web.IWebEnv;
import javax.baja.web.UserAgent;
import javax.baja.web.WebOp;

public abstract class BUserAgentClientEnvironment
extends BClientEnvironment {
    public static final Property userAgentPattern = BUserAgentClientEnvironment.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BUserAgentClientEnvironment.class);
    private static Logger envLog = Logger.getLogger("web.env");
    private Pattern compiledPattern;

    public String getUserAgentPattern() {
        return this.getString(userAgentPattern);
    }

    public void setUserAgentPattern(String v) {
        this.setString(userAgentPattern, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public abstract Type getWebProfileConfigType();

    public abstract IWebEnv makeWebEnv(WebOp var1);

    @Override
    public void started() {
        super.started();
        this.initPattern();
        this.enableMixIn();
    }

    public void stopped() {
        this.disableMixIn();
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(userAgentPattern)) {
            this.initPattern();
        } else {
            super.changed(p, cx);
        }
    }

    @Override
    public IWebEnv doMatchWebEnv(WebOp op) {
        UserAgent ua = op.getUserAgent();
        if (ua == null) {
            return null;
        }
        String txt = ua.toString();
        if (this.matchesUserAgentPattern(txt)) {
            return this.makeWebEnv(op);
        }
        return null;
    }

    @Override
    public IWebEnv doGetWebEnv(WebOp op) {
        return this.makeWebEnv(op);
    }

    public boolean matchesUserAgentPattern(String txt) {
        Matcher matcher = this.compiledPattern.matcher(txt);
        if (matcher.find()) {
            if (envLog.isLoggable(Level.FINE)) {
                envLog.fine("match: " + txt + " -> " + this.getUserAgentPattern());
            }
            return true;
        }
        return false;
    }

    private void initPattern() {
        int options = 34;
        try {
            this.compiledPattern = Pattern.compile(this.getUserAgentPattern(), options);
            this.updateStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false), "");
        }
        catch (PatternSyntaxException e) {
            this.updateStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true), "Invalid expression: '" + this.getUserAgentPattern() + "'");
        }
    }

    private void enableMixIn() {
        if (!this.isMounted()) {
            return;
        }
        if (this.getStatus().isFault()) {
            return;
        }
        BComponentSpace space = this.getComponentSpace();
        space.enableMixIn(this.getWebProfileConfigType());
    }

    private void disableMixIn() {
        BComponentSpace space = this.getComponentSpace();
        space.disableMixIn(this.getWebProfileConfigType());
    }
}

