/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;

public abstract class BServletView
extends BSingleton
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BServletView.class);
    private final Logger log = Logger.getLogger("web.servletView");

    public Type getType() {
        return TYPE;
    }

    public void service(WebOp c) throws Exception {
        String method;
        long start = Clock.millis();
        switch (method = TextUtil.toLowerCase((String)c.getRequest().getMethod())) {
            case "get": {
                this.doGet(c);
                break;
            }
            case "post": {
                this.doPost(c);
                break;
            }
            case "put": {
                this.doPut(c);
                break;
            }
            default: {
                c.getResponse().sendError(405, method);
            }
        }
        long end = Clock.millis();
        if (this.log.isLoggable(Level.FINE)) {
            HttpServletRequest request = c.getRequest();
            StringJoiner joiner = new StringJoiner("");
            joiner.add("Served request for ").add(request.getMethod()).add(" ").add(request.getRequestURI()).add(request.getQueryString() != null ? request.getQueryString() : "").add(" in ").add("" + (end - start)).add("ms");
            this.log.fine(joiner.toString());
        }
    }

    public void doGet(WebOp c) throws Exception {
        c.getResponse().sendError(405, "get");
    }

    public void doPost(WebOp c) throws Exception {
        String protocol = c.getRequest().getProtocol();
        String msg = "Post not allowed";
        if (protocol.endsWith("1.1")) {
            c.getResponse().sendError(405, msg);
        } else {
            c.getResponse().sendError(400, msg);
        }
    }

    public void doPut(WebOp c) throws Exception {
        String protocol = c.getRequest().getProtocol();
        String msg = "Put not allowed";
        if (protocol.endsWith("1.1")) {
            c.getResponse().sendError(405, msg);
        } else {
            c.getResponse().sendError(400, msg);
        }
    }
}

