/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.web.BClientEnvServlet;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BClientEnvironment;
import javax.baja.web.BDefaultClientEnvironment;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.baja.web.mobile.BMobileClientEnvironment;

public class BClientEnvironments
extends BVector {
    public static final Property envServlet = BClientEnvironments.newProperty((int)4, (BValue)new BClientEnvServlet(), null);
    public static final Type TYPE = Sys.loadType(BClientEnvironments.class);

    public BClientEnvServlet getEnvServlet() {
        return (BClientEnvServlet)this.get(envServlet);
    }

    public void setEnvServlet(BClientEnvServlet v) {
        this.set(envServlet, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() {
        try {
            Feature mobileFeature = Sys.getLicenseManager().getFeature("Tridium", "mobile");
            if (mobileFeature != null && !mobileFeature.isExpired() && BMobileClientEnvironment.isMobileAvailable() && this.get("mobile") == null) {
                this.add("mobile", (BValue)new BMobileClientEnvironment());
            }
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {
            // empty catch block
        }
    }

    public IWebEnv getWebEnv(WebOp op) {
        BClientEnvironment clientEnv;
        IWebEnv webEnv = (IWebEnv)op.getRequest().getSession(true).getAttribute("webenv");
        if (webEnv != null) {
            return webEnv;
        }
        SlotCursor c = this.getProperties();
        while (c.next(BClientEnvironment.class) && (webEnv = (clientEnv = (BClientEnvironment)c.get()).matchWebEnv(op)) == null) {
        }
        if (webEnv == null) {
            webEnv = new BDefaultClientEnvironment().getWebEnv(op);
        }
        op.getRequest().getSession(true).setAttribute("webenv", (Object)webEnv);
        return webEnv;
    }
}

