/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;

public abstract class BClientEnvironment
extends BComponent
implements BIStatus {
    public static final Property enabled = BClientEnvironment.newProperty((int)0, (boolean)true, null);
    public static final Property status = BClientEnvironment.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BClientEnvironment.newProperty((int)3, (String)"", null);
    public static final Type TYPE = Sys.loadType(BClientEnvironment.class);

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final IWebEnv matchWebEnv(WebOp webOp) {
        if (this.getStatus().isDisabled() || this.getStatus().isFault()) {
            return null;
        }
        return this.doMatchWebEnv(webOp);
    }

    protected abstract IWebEnv doMatchWebEnv(WebOp var1);

    public final IWebEnv getWebEnv(WebOp op) {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        return this.doGetWebEnv(op);
    }

    protected abstract IWebEnv doGetWebEnv(WebOp var1);

    public void started() {
        if (!this.getEnabled()) {
            this.updateStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true), null);
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            this.updateStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (!this.getEnabled() ? 1 : 0) != 0), null);
        } else {
            super.changed(p, cx);
        }
    }

    protected void updateStatus(BStatus newStatus, String faultCause) {
        this.setStatus(newStatus);
        if (faultCause != null) {
            this.setFaultCause(faultCause);
        }
    }
}

