/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.nre.SupplierWithException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.file.BIFile;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.types.text.BCssFile;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public final class UnauthenticatedCache {
    private static final Map<String, Content> uriToContent = new ConcurrentHashMap<String, Content>();
    private static final Logger LOGGER = Logger.getLogger("niagara.unauthenticatedCache");
    private static final Pattern webRcPattern = Pattern.compile("^[.\\w,\\s-]+\\.(css|js|png|svg|gif|jpg|jpeg|txt|ico)$", 2);
    private static final String WEB_FILE_CACHE_SPY_NAME = "webFileCache";
    private static final String SPY_NAME = "unauthenticatedCache";

    private UnauthenticatedCache() {
    }

    public static void checkForInit(String propertyName) {
        if (propertyName.equals("logo") || propertyName.equals("loginCss") || propertyName.equals("favicon")) {
            UnauthenticatedCache.init();
        }
    }

    public static void clearCache() {
        uriToContent.clear();
    }

    public static synchronized void init() {
        try {
            SpyDir spy;
            BOrd ord;
            uriToContent.remove("/login/logo");
            uriToContent.remove("/login/loginCss");
            uriToContent.remove("/favicon.ico");
            BWebService service = BWebService.getMainService();
            BValue val = service.get("logo");
            if (val != null) {
                ord = BOrd.make((String)val.toString());
                try {
                    UnauthenticatedCache.storeContent("/login/logo", ord, BImageFile.TYPE);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Unable to initialize logo", e);
                }
            }
            if ((val = service.get("loginCss")) != null) {
                ord = BOrd.make((String)val.toString());
                try {
                    UnauthenticatedCache.storeContent("/login/loginCss", ord, BCssFile.TYPE);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Unable to initialize loginCss", e);
                }
            }
            BOrd icon = BOrd.make((String)"module://web/com/tridium/web/rc/favicon.ico");
            val = service.get("favicon");
            if (val != null) {
                icon = BOrd.make((String)val.toString());
            }
            if (icon != null && !icon.isNull()) {
                try {
                    UnauthenticatedCache.storeContent("/favicon.ico", icon, BImageFile.TYPE);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Unable to initialize favicon", e);
                }
            }
            if ((spy = (SpyDir)Spy.ROOT.find(WEB_FILE_CACHE_SPY_NAME)) == null) {
                spy = new SpyDir();
                Spy.ROOT.add(WEB_FILE_CACHE_SPY_NAME, (Spy)spy);
            }
            if (spy.find(SPY_NAME) == null) {
                spy.add(SPY_NAME, (Spy)new UnauthenticatedCacheSpy());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to initialize", e);
        }
    }

    public static boolean allowOrd(BOrd ord) {
        if (ord.isNull()) {
            return false;
        }
        OrdQuery[] queries = null;
        try {
            queries = ord.parse();
            if (queries.length != 1) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        String scheme = queries[0].getScheme();
        if (scheme.equals("module")) {
            return true;
        }
        if (scheme.equals("file")) {
            String body = queries[0].getBody();
            if (body.contains("..")) {
                return false;
            }
            return body.startsWith("^^public/");
        }
        return false;
    }

    public static synchronized Content getContent(String uri) {
        return uriToContent.get(uri);
    }

    public static Content storeContent(String uri, BIFile file) throws Exception {
        return UnauthenticatedCache.storeContent(uri, file, false);
    }

    public static synchronized Content storeContent(String uri, BIFile file, boolean keepFile) throws Exception {
        Content content = new Content(file, keepFile);
        uriToContent.put(uri, content);
        return content;
    }

    public static Content storeContent(String uri, Content content) {
        uriToContent.put(uri, content);
        return content;
    }

    public static Content storeContent(String uri, BOrd ord) throws Exception {
        return UnauthenticatedCache.storeContent(uri, ord, BIFile.TYPE);
    }

    public static Content storeContent(String uri, BOrd ord, Type expectedFileType) throws Exception {
        if (UnauthenticatedCache.allowOrd(ord)) {
            BOrd fileOrd = ord.normalize();
            return (Content)UnauthenticatedCache.runDoPrivileged(() -> {
                BIFile file = (BIFile)fileOrd.get((BObject)BLocalHost.INSTANCE);
                if (file.getType().is(expectedFileType)) {
                    return UnauthenticatedCache.storeContent(uri, file, false);
                }
                return null;
            });
        }
        return null;
    }

    private static <T> T runDoPrivileged(SupplierWithException<T, Exception> supplier) throws Exception {
        try {
            return (T)AccessController.doPrivileged(() -> supplier.get());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static void send(HttpServletResponse resp, Content content) throws Exception {
        resp.setContentType(content.getMimeType());
        byte[] bytes = content.getContent();
        resp.setContentLength(bytes.length);
        try (ServletOutputStream out = resp.getOutputStream();){
            out.write(bytes);
        }
    }

    public static abstract class CacheSpy
    extends SpyDir {
        private final String displayName;
        private final String uri;

        protected CacheSpy(String displayName, String uri) {
            this.add("clearCache", (Spy)new ClearCacheSpy());
            this.displayName = displayName;
            this.uri = uri;
        }

        protected abstract void clearCache();

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"clearCache")) {
                return super.find("clearCache");
            }
            return super.find(name);
        }

        public void write(SpyWriter out) throws Exception {
            out.w((Object)"<b>").a(this.uri + '/' + SpyWriter.addCsrfToken((String)"clearCache"), (Object)"Clear Cache").w((Object)"</b><br/><br/>");
        }

        class ClearCacheSpy
        extends SpyDir {
            ClearCacheSpy() {
            }

            public void write(SpyWriter out) throws Exception {
                try {
                    CacheSpy.this.clearCache();
                    out.w((Object)"<b>").safe((Object)CacheSpy.this.displayName).w((Object)" Clear Cache Complete</b>");
                    out.w((Object)"<br/>");
                }
                catch (Exception e) {
                    out.w((Object)"<b>").safe((Object)CacheSpy.this.displayName).w((Object)" Clear Cache Failed</b>");
                    out.w((Object)"<br/>");
                    out.w((Object)"<p>").safe((Object)e.getMessage()).w((Object)"</p>");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.WARNING, CacheSpy.this.displayName + " Cache Clear failed", e);
                    }
                    LOGGER.log(Level.WARNING, CacheSpy.this.displayName + " Cache Clear failed");
                }
                out.w((Object)"<br/>");
                out.w((Object)"<b><a ").attr("href", CacheSpy.this.uri).w((Object)"'>return to ").safe((Object)CacheSpy.this.displayName).w((Object)"</a></b>");
            }
        }
    }

    private static final class UnauthenticatedCacheSpy
    extends CacheSpy {
        UnauthenticatedCacheSpy() {
            super("Unauthenticated Cache", "/webFileCache/unauthenticatedCache");
        }

        @Override
        protected void clearCache() {
            UnauthenticatedCache.clearCache();
            UnauthenticatedCache.init();
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            super.write(out);
            out.startTable(true);
            out.trTitle((Object)("Unauthenticated Cache [" + uriToContent.size() + "]"), 43);
            out.tr().th().w((Object)"<b>Resource").w((Object)"</b>").endTh().th().w((Object)"<b>Size").w((Object)"</b>").endTh().th().w((Object)"<b>Cache File Only").endTh().endTr();
            for (Map.Entry entry : uriToContent.entrySet()) {
                String size = ((Content)entry.getValue()).getContent().length / 1024 + " kb";
                boolean fileOnly = ((Content)entry.getValue()).getFile() != null;
                out.tr(entry.getKey(), (Object)size, (Object)fileOnly);
            }
            out.endTable();
        }
    }

    public static class Content {
        private final String mimeType;
        private byte[] content;
        private BIFile file;

        public Content(BIFile file) throws Exception {
            this(file, true);
        }

        public Content(BIFile file, boolean keepFile) throws Exception {
            if (file.isDirectory() || !webRcPattern.matcher(file.getFileName()).matches()) {
                throw new Exception("Unauthorized");
            }
            this.mimeType = file.getMimeType();
            if (keepFile) {
                this.file = file;
            } else {
                this.content = file.getStore().read();
            }
        }

        public Content(byte[] content, String mimeType) {
            this.content = content;
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public BIFile getFile() {
            return this.file;
        }

        public byte[] getContent() throws Exception {
            if (this.file != null) {
                return this.file.getStore().read();
            }
            return this.content;
        }
    }
}

