/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.session.NiagaraSession;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionTimeoutServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long timeout = -1L;
        NiagaraWebSession niagaraSession = WebSessionUtil.getSession(req);
        if (niagaraSession != null) {
            timeout = niagaraSession.getSessionTimeRemaining();
        } else {
            this.sendError(resp, "Invalid session: Not a Niagara session");
        }
        resp.setContentType("text/plain");
        resp.getWriter().print(timeout);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long timeout = -1L;
        NiagaraWebSession session = WebSessionUtil.getSession(req, false);
        if (session instanceof NiagaraSession) {
            long offsetL = 0L;
            String offset = req.getParameter("offset");
            if (offset != null) {
                try {
                    offsetL = Long.parseLong(offset);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            NiagaraWebSession nSession = session;
            nSession.resetSessionTimeout(offsetL);
            timeout = nSession.getSessionTimeRemaining();
        } else {
            this.sendError(resp, "Invalid session: Not a Niagara session");
        }
        resp.setContentType("text/plain");
        resp.getWriter().print(timeout);
    }

    private void sendError(HttpServletResponse resp, String error) throws IOException {
        this.log(error);
        resp.sendError(403);
    }
}

