/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.web.HttpHeaderUtil;
import com.tridium.web.WebEnv;
import com.tridium.web.WebUtil;
import com.tridium.web.servlets.NWebOp;
import com.tridium.web.servlets.WbServlet;
import com.tridium.web.warmup.BWebWarmupConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.license.Feature;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.spy.BSpy;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BIFormFactorMax;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BServletView;
import javax.baja.web.BWebService;
import javax.baja.web.IWebEnv;
import javax.baja.web.js.BIJavaScript;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class OrdServlet
extends HttpServlet {
    private static Logger log = null;
    private boolean licenseUi;
    private boolean licenseWb;
    public static final String FILE_NAME_PARAMETER_KEY = "fileName";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
            Feature feature = service.getLicenseFeature();
            this.licenseUi = feature.getb("ui", false);
            this.licenseWb = feature.getb("ui.wb", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void destroy() {
        this.licenseUi = false;
        this.licenseWb = false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(req, resp);
    }

    private void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AgentList allViewInfos;
        BWebWarmupConfig.webActivity();
        OrdTarget target = (OrdTarget)req.getAttribute("niagara.target");
        if (target == null) {
            this.log("No Target available");
            resp.sendError(404);
            return;
        }
        NWebOp op = (NWebOp)((Object)req.getAttribute("niagara.op"));
        if (op == null) {
            this.log("No WebOp available");
            resp.sendError(404);
            return;
        }
        IWebEnv env = op.getWebEnv();
        if (!(target.get() instanceof BSpy)) {
            BIWebProfile profile;
            if (!this.licenseUi) {
                if (log == null) {
                    log = Logger.getLogger("web");
                    log.severe("web ui not licensed");
                }
                resp.sendError(403);
                return;
            }
            if (!this.licenseWb && WebEnv.wbProfile != null && (profile = env.getWebProfile(op)) != null && profile.getType().is(WebEnv.wbProfile)) {
                if (log == null) {
                    log = Logger.getLogger("web");
                    log.severe("web ui.wb not licensed");
                }
                resp.sendError(403);
                return;
            }
        }
        if ((allViewInfos = (AgentList)req.getAttribute("niagara.allViewInfos")) == null || allViewInfos.size() == 0) {
            this.log("No views available");
            resp.sendError(404);
            return;
        }
        AgentInfo viewInfo = (AgentInfo)req.getAttribute("niagara.viewInfo");
        if (viewInfo == null) {
            BPermissions actual = op.getPermissionsForTarget();
            BPermissions required = (BPermissions)req.getAttribute("niagara.viewInfoRequiredPerm");
            if (required == null) {
                required = BPermissions.all;
            }
            this.log("User has no permissions to access view: '" + actual + "' < '" + required + "'");
            resp.sendError(403);
            return;
        }
        try {
            TypeInfo viewTypeInfo = viewInfo.getAgentType();
            if (viewTypeInfo.is(WebEnv.pxView) || WebEnv.wbView != null && viewInfo.getAgentType().is(WebEnv.wbView) || viewTypeInfo.is(BIFormFactorMax.TYPE) && viewTypeInfo.is(BIJavaScript.TYPE)) {
                WbServlet.serviceView(viewInfo, op);
            } else {
                BObject view = viewInfo.getInstance();
                if (view instanceof BServletView) {
                    ((BServletView)view).service(op);
                } else if (view instanceof BExporter && "GET".equals(req.getMethod())) {
                    BExporter exporter = (BExporter)view;
                    resp.setContentType(exporter.getFileMimeType());
                    Map<String, String> parameters = OrdServlet.getViewParameters(target);
                    if (!parameters.isEmpty()) {
                        OrdServlet.applyParametersToProperties(parameters, (BComponent)exporter, (Context)op);
                        if (parameters.containsKey(FILE_NAME_PARAMETER_KEY)) {
                            String fileName = OrdServlet.makeDownloadFileName(parameters.get(FILE_NAME_PARAMETER_KEY), exporter.getFileExtension());
                            OrdServlet.setDownloadFileNameOnResponse(fileName, resp);
                        }
                    }
                    exporter.export((ExportOp)op);
                } else {
                    resp.sendError(404);
                }
            }
        }
        catch (Throwable e) {
            this.log(e.getMessage(), e);
            WebUtil.sendSafeErrorToUser(resp, 404, e, (Context)op);
        }
    }

    private static Map<String, String> getViewParameters(OrdTarget target) {
        ViewQuery viewQuery = target.getViewQuery();
        return viewQuery == null ? Collections.emptyMap() : viewQuery.getParameters();
    }

    private static void setDownloadFileNameOnResponse(String fileName, HttpServletResponse response) {
        response.setHeader("Content-Disposition", HttpHeaderUtil.getContentDispositionFileName(fileName, true));
    }

    private static String makeDownloadFileName(String fileName, String fileExtension) {
        return fileName + "." + fileExtension;
    }

    private static void applyParametersToProperties(Map<String, String> parameters, BComponent component, Context cx) throws IOException {
        boolean isValueEscaped = Boolean.valueOf(parameters.get("ve"));
        for (String name : parameters.keySet()) {
            BValue value;
            Property property = component.getProperty(name);
            if (property == null || !OrdServlet.isValueDecodableFromParameter(value = component.get(property))) continue;
            String paramValue = parameters.get(name);
            if (!name.equals("ve") && isValueEscaped) {
                paramValue = SlotPath.unescape((String)paramValue);
            }
            BValue newValue = (BValue)value.asSimple().decodeFromString(paramValue);
            component.set(property, newValue, cx);
        }
    }

    private static boolean isValueDecodableFromParameter(BValue value) {
        if (!value.isSimple()) {
            return false;
        }
        return !OrdServlet.isSecuritySensitive(value);
    }

    private static boolean isSecuritySensitive(BValue value) {
        return value instanceof BIUnlinkable || value instanceof BBlob;
    }
}

