/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.sys.station.Station;
import com.tridium.web.rpc.UserDataUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.baja.agent.BIAgent;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"web:WebService"})})
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="baja:Boolean", defaultValue="BBoolean.TRUE"), @NiagaraProperty(name="icon", flags=4, type="baja:Icon", defaultValue="BIcon.std(\"book.png\")")})
@NiagaraActions(value={@NiagaraAction(name="flush"), @NiagaraAction(name="clearMyData", flags=128), @NiagaraAction(name="clearAll", flags=128)})
public final class BUserDataConfig
extends BComponent
implements BIService,
BIAgent {
    public static final Property enabled = BUserDataConfig.newProperty((int)0, (boolean)BBoolean.TRUE.getBoolean(), null);
    public static final Property icon = BUserDataConfig.newProperty((int)4, (BValue)BIcon.std((String)"book.png"), null);
    public static final Action flush = BUserDataConfig.newAction((int)0, null);
    public static final Action clearMyData = BUserDataConfig.newAction((int)128, null);
    public static final Action clearAll = BUserDataConfig.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BUserDataConfig.class);
    private static final Log LOG = Log.getLog((String)"web");
    private static final Set<String> USERNAMES = new LinkedHashSet<String>();
    private static final Pattern VALID_CHARS = Pattern.compile("^[\\w\\._][\\w\\._ ]*(?<! )$");
    private static final int K = 1024;
    public static final int MAX_KEY_LENGTH = 32;
    public static final String USER_QUOTA_PROP = "niagara.userData.userQuota";
    private static int USER_QUOTA = 16384;
    public static final String TOTAL_QUOTA_PROP = "niagara.userData.totalQuota";
    private static int TOTAL_QUOTA;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BIcon getIcon() {
        return (BIcon)this.get(icon);
    }

    public void setIcon(BIcon v) {
        this.set(icon, (BValue)v, null);
    }

    public void flush() {
        this.invoke(flush, null, null);
    }

    public void clearMyData() {
        this.invoke(clearMyData, null, null);
    }

    public void clearAll() {
        this.invoke(clearAll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public String get(String key, Context cx) throws PrivilegedActionException, IOException {
        if (!this.getEnabled()) {
            return null;
        }
        byte[] data = BUserDataConfig.readFile(cx.getUser().getUsername(), key);
        return data == null ? null : new String(data, "UTF-8");
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public void put(String key, String data, Context cx) throws PrivilegedActionException, UnsupportedEncodingException {
        if (!this.getEnabled()) {
            return;
        }
        FlushOnStationSaveListener.ensureAdded();
        BUserDataConfig.writeFile(cx.getUser().getUsername(), key, data.getBytes("UTF-8"));
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public void delete(String key, Context cx) throws PrivilegedActionException {
        if (!this.getEnabled()) {
            return;
        }
        FlushOnStationSaveListener.ensureAdded();
        BUserDataConfig.deleteFile(cx.getUser().getUsername(), key);
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public void clear(Context cx) throws PrivilegedActionException {
        this.doClearMyData(cx);
    }

    public void doClearMyData(Context cx) throws PrivilegedActionException {
        if (!this.getEnabled()) {
            return;
        }
        FlushOnStationSaveListener.ensureAdded();
        BUserDataConfig.emptyUserDirectory(cx.getUser().getUsername());
    }

    @NiagaraRpc(permissions="WI", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public void clearAll(Context cx) throws PrivilegedActionException {
        this.doClearAll(cx);
    }

    public void doClearAll(Context cx) throws PrivilegedActionException {
        if (!this.getEnabled()) {
            return;
        }
        FlushOnStationSaveListener.ensureAdded();
        BUserDataConfig.emptyAllUserDirectories();
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public void flush(Context cx) throws PrivilegedActionException {
        this.doFlush(cx);
    }

    public void doFlush(Context cx) throws PrivilegedActionException {
        BUserDataConfig.flushAllDirectories();
    }

    private static byte[] readFile(String userName, String fileName) throws PrivilegedActionException {
        BUserDataConfig.validateKey(fileName);
        return AccessController.doPrivileged(() -> {
            File dataFile;
            File userTmpHome = new File(UserDataUtils.getTmpHome(), userName);
            if (!userTmpHome.isDirectory()) {
                BUserDataConfig.copyToTemp(userName, userTmpHome, UserDataUtils.getPermanentHome(userName));
            }
            if ((dataFile = new File(userTmpHome, fileName)).exists()) {
                return UserDataUtils.fileContents(dataFile);
            }
            return null;
        });
    }

    private static synchronized void writeFile(String userName, String fileName, byte[] data) throws PrivilegedActionException {
        BUserDataConfig.validateKey(fileName);
        AccessController.doPrivileged(() -> {
            BUserDataConfig.writeTmpFile(userName, new File(UserDataUtils.getTmpHome(userName), fileName), data);
            return null;
        });
    }

    private static synchronized void deleteFile(String userName, String fileName) throws PrivilegedActionException {
        BUserDataConfig.validateKey(fileName);
        AccessController.doPrivileged(() -> {
            new File(UserDataUtils.getTmpHome(userName), fileName).delete();
            return null;
        });
    }

    private static synchronized void emptyUserDirectory(String userName) throws PrivilegedActionException {
        AccessController.doPrivileged(() -> {
            UserDataUtils.empty(UserDataUtils.getTmpHome(userName));
            return null;
        });
    }

    private static synchronized void emptyAllUserDirectories() throws PrivilegedActionException {
        USERNAMES.clear();
        AccessController.doPrivileged(() -> {
            for (File file : UserDataUtils.getTmpHome().listFiles()) {
                UserDataUtils.empty(file);
            }
            for (File file : UserDataUtils.getPermanentHome().getNavChildren()) {
                UserDataUtils.empty((BIFile)file);
            }
            return null;
        });
    }

    private static void flushAllDirectories() throws PrivilegedActionException {
        USERNAMES.clear();
        AccessController.doPrivileged(() -> {
            BUserDataConfig.flushToPermanent(UserDataUtils.getTmpHome(), UserDataUtils.getPermanentHome());
            return null;
        });
    }

    private static void validateKey(String key) {
        if (key.length() > 32) {
            throw new IllegalArgumentException("key length exceeded");
        }
        if (!VALID_CHARS.matcher(key).matches()) {
            throw new IllegalArgumentException("invalid characters in key");
        }
    }

    private static String removeOldestUsername() {
        if (USERNAMES.isEmpty()) {
            return null;
        }
        String name = USERNAMES.iterator().next();
        USERNAMES.remove(name);
        return name;
    }

    private static void writeTmpFile(String userName, File file, byte[] data) throws IOException {
        if (UserDataUtils.size(UserDataUtils.getTmpHome(userName).toPath()) + (long)data.length > (long)BUserDataConfig.getUserQuota()) {
            throw new IOException("User quota exceeded");
        }
        int totalQuota = BUserDataConfig.getTotalQuota();
        if (data.length > totalQuota) {
            throw new IOException("Total quota exceeded");
        }
        while (UserDataUtils.size(UserDataUtils.getTmpHome().toPath()) + (long)data.length > (long)totalQuota) {
            String oldestUser = BUserDataConfig.removeOldestUsername();
            BUserDataConfig.flushToPermanent(UserDataUtils.getTmpHome(oldestUser), UserDataUtils.getPermanentHome(oldestUser));
        }
        USERNAMES.add(userName);
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(data);
        }
    }

    private static void copyToPerm(File tmpFile, BIFile permFile) throws IOException {
        try (OutputStream out = permFile.getOutputStream();){
            Files.copy(tmpFile.toPath(), out);
        }
    }

    private static void copyToTemp(String userName, File tmpFile, BIFile permFile) throws IOException {
        if (permFile.isDirectory()) {
            for (BIFile kid : permFile.getFileSpace().getChildren(permFile)) {
                BUserDataConfig.copyToTemp(userName, new File(tmpFile, kid.getFileName()), kid);
            }
        } else if (!tmpFile.exists()) {
            BUserDataConfig.writeTmpFile(userName, tmpFile, permFile.read());
        }
    }

    private static void flushToPermanent(File tmpFile, BIFile permFile) throws IOException {
        if (tmpFile.isDirectory()) {
            for (File kid : tmpFile.listFiles()) {
                if (kid.isDirectory()) {
                    BIFile permDir = UserDataUtils.mkdir(permFile, kid.getName());
                    UserDataUtils.empty(permDir);
                    BUserDataConfig.flushToPermanent(kid, permDir);
                    continue;
                }
                BUserDataConfig.flushToPermanent(kid, UserDataUtils.replaceFile(permFile, kid.getName()));
            }
            UserDataUtils.deleteRecursive(tmpFile);
        } else {
            BUserDataConfig.copyToPerm(tmpFile, permFile);
            tmpFile.delete();
        }
    }

    private static int getUserQuota() {
        return USER_QUOTA;
    }

    private static int getTotalQuota() {
        return TOTAL_QUOTA;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    static {
        try {
            USER_QUOTA = AccessController.doPrivileged(() -> Integer.getInteger(USER_QUOTA_PROP, 16384));
        }
        catch (Exception e) {
            LOG.error("Could not retrieve niagara.userData.userQuota", (Throwable)e);
        }
        TOTAL_QUOTA = 131072;
        try {
            TOTAL_QUOTA = AccessController.doPrivileged(() -> {
                boolean embedded = PlatformUtil.getPlatformProvider().isEmbedded();
                int def = embedded ? 131072 : Integer.MAX_VALUE;
                return Integer.getInteger(TOTAL_QUOTA_PROP, def);
            });
        }
        catch (Exception e) {
            LOG.error("Could not retrieve niagara.userData.totalQuota", (Throwable)e);
        }
    }

    private static final class FlushOnStationSaveListener {
        private static final Station.SaveListener INSTANCE = new Station.SaveListener(){

            public void stationSave() throws Exception {
                BUserDataConfig.flushAllDirectories();
            }

            public void stationSaveOk() throws Exception {
            }

            public void stationSaveFail(String cause) throws Exception {
            }
        };

        private FlushOnStationSaveListener() {
        }

        private static void ensureAdded() {
        }

        static {
            Station.addSaveListener((Station.SaveListener)INSTANCE);
        }
    }
}

