/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import com.tridium.logging.BLoggingService;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLogRpc
extends BComponent {
    public static final Type TYPE = Sys.loadType(BLogRpc.class);

    public Type getType() {
        return TYPE;
    }

    private BLogRpc() {
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox), @Transport(type=TransportType.web)})
    public static synchronized void log(String logName, String logLevel, String msg, Context cx) {
        Level level;
        if (!BLogRpc.isRemoteLoggingEnabled()) {
            return;
        }
        Logger log = Logger.getLogger(logName);
        if (log.isLoggable(level = Level.parse(logLevel))) {
            log.log(level, cx.getUser() + "@" + cx.getFacet("remoteAddr") + ": " + msg);
        }
    }

    private static boolean isRemoteLoggingEnabled() {
        Optional serviceOptional = Sys.findService((Type)BLoggingService.TYPE);
        return serviceOptional.isPresent() && ((BLoggingService)serviceOptional.get()).getEnableRemoteLogging();
    }
}

