/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import com.tridium.web.servlets.FileServlet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.types.text.BITextFile;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.FileUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BFileRpc
extends BObject {
    public static final Type TYPE = Sys.loadType(BFileRpc.class);
    private static final String onlyOfflineError = "Not offline mode!";
    private static BajaFileUtil.BajaFileWriter fileWriter = BajaFileUtil.getDefaultFileWriter();

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String readTextFile(String ord, Context cx) throws Exception {
        return BFileRpc.readTextFile(BOrd.make((String)ord).resolve((BObject)BLocalHost.INSTANCE, cx));
    }

    public static String readTextFile(OrdTarget target) throws Exception {
        if (!FileServlet.canRead(target)) {
            throw new PermissionException("Cannot read file: " + target.getOrd());
        }
        if (Sys.isStation()) {
            throw new PermissionException(onlyOfflineError);
        }
        try {
            return AccessController.doPrivileged(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean exists(String ord, Context cx) {
        return fileWriter.exists(BOrd.make((String)ord), cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean isWritable(String ord, Context cx) {
        return fileWriter.isWritable(BOrd.make((String)ord), cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void writeTextFile(String ord, String contents, Context cx) throws Exception {
        BFileRpc.writeTextFile(BOrd.make((String)ord).resolve((BObject)BLocalHost.INSTANCE, cx), contents);
    }

    public static void writeTextFile(OrdTarget target, String contents) throws Exception {
        if (!FileServlet.canWrite(target)) {
            throw new PermissionException("Cannot write to file: " + target.getOrd());
        }
        if (Sys.isStation()) {
            throw new PermissionException(onlyOfflineError);
        }
        BITextFile file = (BITextFile)target.get();
        try {
            AccessController.doPrivileged(() -> {
                try (ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
                     OutputStream out = file.getOutputStream();){
                    FileUtil.pipe((InputStream)in, (OutputStream)out);
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }
}

