/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters.cache;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public final class ServletOutputStreamWrapper
extends ServletOutputStream {
    private final ServletOutputStream servletOut;
    private final OutputStream wrappedOut;
    private final Consumer<Throwable> throwableConsumer;

    public ServletOutputStreamWrapper(ServletOutputStream servletOut, OutputStream wrappedOut, Consumer<Throwable> throwableConsumer) throws IOException {
        this.servletOut = servletOut;
        this.wrappedOut = wrappedOut;
        this.throwableConsumer = throwableConsumer;
    }

    public void write(int b) throws IOException {
        try {
            this.wrappedOut.write(b);
            this.servletOut.write(b);
        }
        catch (Throwable t) {
            if (this.throwableConsumer != null) {
                this.throwableConsumer.accept(t);
            }
            throw t;
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            this.servletOut.write(b);
            this.wrappedOut.write(b);
        }
        catch (Throwable t) {
            if (this.throwableConsumer != null) {
                this.throwableConsumer.accept(t);
            }
            throw t;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.servletOut.write(b, off, len);
            this.wrappedOut.write(b, off, len);
        }
        catch (Throwable t) {
            if (this.throwableConsumer != null) {
                this.throwableConsumer.accept(t);
            }
            throw t;
        }
    }

    public void flush() throws IOException {
        try {
            try {
                this.servletOut.flush();
            }
            finally {
                this.wrappedOut.flush();
            }
        }
        catch (Throwable t) {
            if (this.throwableConsumer != null) {
                this.throwableConsumer.accept(t);
            }
            throw t;
        }
    }

    public void close() throws IOException {
        try {
            try {
                this.servletOut.close();
            }
            finally {
                this.wrappedOut.close();
            }
        }
        catch (Throwable t) {
            if (this.throwableConsumer != null) {
                this.throwableConsumer.accept(t);
            }
            throw t;
        }
    }

    public boolean isReady() {
        return this.servletOut.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.servletOut.setWriteListener(writeListener);
    }
}

