/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.net.BHttpScheme;
import com.tridium.net.BHttpsScheme;
import com.tridium.net.HttpUtil;
import com.tridium.util.CustomThemeModuleManager;
import com.tridium.util.ThrowableUtil;
import com.tridium.web.RequireJsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Base64;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.file.BFileScheme;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.types.image.BImageFile;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.OrdUtil;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconModule;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebService;
import javax.baja.web.UserAgent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EofException;

public final class WebUtil {
    private static String[] webstartBrowserFileExtensions;
    private static final LexiconModule LEX;
    private static final Logger log;
    public static final String hxThemeKey = "selectedHxTheme";
    public static final String wbThemeKey = "selectedWorkbenchTheme";
    private static final String BROWSER_EXTS;
    private static final String LINE_SEPARATOR;

    private WebUtil() {
    }

    public static String getRedirect(HttpServletRequest req, String path) {
        try {
            StringBuilder buf = new StringBuilder();
            String scheme = TextUtil.toLowerCase((String)req.getScheme());
            buf.append(scheme);
            buf.append("://");
            buf.append(req.getServerName());
            int port = req.getServerPort();
            if (!(scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443)) {
                buf.append(':').append(port);
            }
            if (!path.startsWith("/")) {
                String uri = req.getRequestURI();
                int i = uri.lastIndexOf(47);
                buf.append(uri.substring(0, i));
            }
            buf.append(path);
            return buf.toString();
        }
        catch (Exception exception) {
            return path;
        }
    }

    public static String toUri(OrdTarget base, HttpServletRequest req, BOrd ord) {
        boolean hasWebstartBrowserQuery = false;
        OrdQuery[] query = ord.parse();
        if (query.length > 0 && query[0].getBody().length() > 0) {
            if (UserAgent.isNiagaraAxWebStart(req) && !(hasWebstartBrowserQuery = WebUtil.hasWebStartBrowserQuery(query)) && WebUtil.requiresWebStartBrowserViewQuery(query)) {
                ord = WebUtil.addWebStartBrowserQuery(query);
                query = ord.parse();
                hasWebstartBrowserQuery = true;
            }
            if (!hasWebstartBrowserQuery && query[0].getScheme().equals(BModuleScheme.INSTANCE.getId())) {
                return "/module" + query[0].getBody().substring(1) + "?version=" + RequireJsUtil.getUrlVersion();
            }
            if (query[0].getScheme().equals(BHttpScheme.INSTANCE.getId()) || query[0].getScheme().equals(BHttpsScheme.INSTANCE.getId())) {
                return ord.toString();
            }
        }
        String basePath = "/ord?";
        return WebUtil.toUri(base, basePath, ord);
    }

    public static String toUri(OrdTarget base, String prefix, BOrd ord) {
        OrdQuery[] baseQueries;
        BOrd fixOrd = ord.relativizeToSession();
        fixOrd = OrdUtil.replaceBackups((BOrd)fixOrd);
        String fix = HttpUtil.encodeUrl((String)fixOrd.toString());
        OrdQuery[] ordQueries = ord.parse();
        boolean relativize = true;
        if (ord.toString().startsWith("ip:") && base != null && (baseQueries = base.getOrd().parse()).length > 1 && ordQueries.length > 1) {
            if (!baseQueries[0].toString().equals(ordQueries[0].toString())) {
                relativize = false;
            }
            if (!baseQueries[1].toString().equals(ordQueries[1].toString())) {
                relativize = false;
            }
        }
        if (relativize) {
            return prefix + fix;
        }
        boolean useHttps = false;
        if (ordQueries != null) {
            for (int i = ordQueries.length - 1; i >= 0; --i) {
                String query;
                if (ordQueries[i] == null || (query = ordQueries[i].toString()) == null || !query.startsWith("fox:") && !query.startsWith("foxs:")) continue;
                useHttps = query.startsWith("foxs:");
                break;
            }
        }
        StringBuilder buf = new StringBuilder();
        if (useHttps) {
            buf.append("https://");
        } else {
            buf.append("http://");
        }
        String hostAddr = ordQueries[0].getBody();
        if (hostAddr.indexOf(58) != hostAddr.lastIndexOf(58) && !hostAddr.startsWith("[") && !hostAddr.endsWith("]")) {
            buf.append('[').append(hostAddr).append(']');
        } else {
            buf.append(hostAddr);
        }
        buf.append(prefix);
        buf.append(fix);
        return buf.toString();
    }

    public static String getLogo(BWebService service) {
        if (service == null) {
            return null;
        }
        BValue logo = service.get("logo");
        if (logo == null) {
            return null;
        }
        return logo.toString();
    }

    public static void closeOutputStream(OutputStream stream) {
        block3: {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable e) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, "Cannot close OutputStream", e);
            }
        }
    }

    public static boolean isPasswordChangeAllowed(HttpServletRequest request) {
        if (request == null || request.isSecure()) {
            return true;
        }
        try {
            BWebService ws = (BWebService)Sys.getService((Type)BWebService.TYPE);
            return !ws.getRequireHttpsForPasswords();
        }
        catch (ServiceNotFoundException e) {
            return false;
        }
    }

    public static void handleServletPrivilegedException(PrivilegedActionException e) throws ServletException, IOException {
        Exception e2 = e.getException();
        if (e2 instanceof ServletException) {
            throw (ServletException)e2;
        }
        if (e2 instanceof IOException) {
            throw (IOException)e2;
        }
        throw new ServletException((Throwable)e2);
    }

    public static String createDataUri(BIFile file) throws IOException {
        try (InputStream in = file.getInputStream();){
            if (file instanceof BImageFile) {
                byte[] data = FileUtil.read((InputStream)in, (long)file.getSize());
                String string = "data:" + file.getMimeType() + ";base64," + Base64.getEncoder().encodeToString(data);
                return string;
            }
            String s = BajaFileUtil.readString((BIFile)file);
            String string = "data:" + file.getMimeType() + ";charset=utf-8," + URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("%21", "!").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%7E", "~");
            return string;
        }
    }

    public static void sendSafeErrorToUser(HttpServletResponse resp, int statusCode, Throwable t, Context cx) throws IOException {
        WebUtil.sendSafeErrorToUser(resp, statusCode, t, null, cx);
    }

    public static void sendSafeErrorToUser(HttpServletResponse resp, int statusCode, Throwable t, String niceMessage, Context cx) throws IOException {
        WebUtil.sendSafeErrorToUser(resp, statusCode, WebUtil.toUserMessage(niceMessage, t, cx));
    }

    public static void sendSafeErrorToUser(HttpServletResponse resp, int statusCode, String msg) throws IOException {
        if (msg != null && !msg.isEmpty()) {
            resp.sendError(statusCode, msg);
        } else {
            resp.sendError(statusCode);
        }
    }

    public static String toUserMessage(Throwable t, Context cx) {
        return WebUtil.toUserMessage(null, t, cx);
    }

    public static String toUserMessage(String niceMessage, Throwable t, Context cx) {
        boolean showTrace = ((BWebService)Sys.getService((Type)BWebService.TYPE)).getShowStackTrace();
        boolean isSecurityException = ThrowableUtil.toSecurity((Throwable)t).isPresent();
        String details = showTrace && !isSecurityException ? ThrowableUtil.dumpToString((Throwable)t) : "";
        String msg = niceMessage != null && !niceMessage.isEmpty() ? niceMessage : WebUtil.removeThrowablePrefixes(null, t, cx);
        if (!details.isEmpty()) {
            msg = msg + LINE_SEPARATOR + details;
        }
        return msg;
    }

    public static String removeThrowablePrefixes(String message, Throwable t, Context cx) {
        String causeClassPrefix;
        String throwableMessage;
        if (t == null) {
            return message;
        }
        boolean isSecurityException = t instanceof SecurityException;
        Throwable cause = t.getCause();
        if (t instanceof Localizable) {
            throwableMessage = ((Localizable)t).toString(cx);
            if (throwableMessage == null) {
                throwableMessage = t.getMessage();
            }
        } else {
            if (isSecurityException) {
                return LEX.getText("web.server.error", cx);
            }
            throwableMessage = t.getMessage();
        }
        if (t.toString().equals(message) || throwableMessage == null) {
            String classPrefix = t.getClass().getName() + ": ";
            if (throwableMessage == null && message != null && t.toString().startsWith(classPrefix)) {
                throwableMessage = t.toString().substring(classPrefix.length());
            }
            return WebUtil.removeThrowablePrefixes(throwableMessage, cause, cx);
        }
        if (cause != null && throwableMessage.startsWith(causeClassPrefix = cause.getClass().getName() + ": ")) {
            throwableMessage = throwableMessage.substring(causeClassPrefix.length());
            return WebUtil.removeThrowablePrefixes(throwableMessage, cause, cx);
        }
        return throwableMessage;
    }

    public static boolean isAbortException(Throwable e) {
        if (e instanceof IOException && "An established connection was aborted by the software in your host machine".equals(e.getMessage())) {
            return true;
        }
        if (e instanceof EofException) {
            return true;
        }
        if (e.getCause() == null) {
            return false;
        }
        return WebUtil.isAbortException(e.getCause());
    }

    public static boolean hasWebStartBrowserQuery(OrdQuery[] queries) {
        if (queries.length > 0) {
            for (OrdQuery query : queries) {
                ViewQuery vq;
                if (!(query instanceof ViewQuery) || !"true".equalsIgnoreCase((vq = (ViewQuery)query).getParameter("appletReload", "")) && !"true".equalsIgnoreCase(vq.getParameter("browser", ""))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean requiresWebStartBrowserViewQuery(OrdQuery[] queries) {
        boolean foundFileType = false;
        boolean foundViewQuery = false;
        block0: for (OrdQuery query : queries) {
            if (query.getScheme().equals(BFileScheme.INSTANCE.getId()) || query.getScheme().equals(BModuleScheme.INSTANCE.getId())) {
                String body = query.getBody();
                if (body == null) continue;
                body = body.toLowerCase();
                for (String ext : WebUtil.getWebStartBrowserFileExtensions()) {
                    if (!body.endsWith(ext)) continue;
                    foundFileType = true;
                    continue block0;
                }
                continue;
            }
            if (!(query instanceof ViewQuery)) continue;
            foundViewQuery = true;
        }
        return foundFileType && !foundViewQuery;
    }

    public static BOrd addWebStartBrowserQuery(OrdQuery[] query) {
        OrdQueryList list = new OrdQueryList(query);
        list.add((OrdQuery)new ViewQuery("?browser=true"));
        return BOrd.make((OrdQuery[])list.toArray()).normalize();
    }

    public static void setStationTheme() {
        try {
            BDynamicEnum defaultTheme = CustomThemeModuleManager.getDefaultThemeEnum();
            BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            for (BWebProfileConfig config : (BWebProfileConfig[])userService.getUserPrototypes().getDefaultPrototype().getChildren(BWebProfileConfig.class)) {
                BValue o = config.get(hxThemeKey);
                if (o instanceof BDynamicEnum) {
                    defaultTheme = (BDynamicEnum)o;
                    break;
                }
                o = config.get(wbThemeKey);
                if (!(o instanceof BDynamicEnum)) continue;
                defaultTheme = (BDynamicEnum)o;
                break;
            }
            CustomThemeModuleManager.setStationTheme((BDynamicEnum)defaultTheme);
        }
        catch (Exception e) {
            Logger.getLogger("com.tridium.ui.theme").log(Level.SEVERE, "Cannot load station theme", e);
        }
    }

    private static synchronized String[] getWebStartBrowserFileExtensions() {
        if (webstartBrowserFileExtensions == null) {
            String enc = BROWSER_EXTS;
            StringTokenizer tokenizer = new StringTokenizer(enc, ";");
            webstartBrowserFileExtensions = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                WebUtil.webstartBrowserFileExtensions[i++] = tokenizer.nextToken().toLowerCase();
            }
        }
        return webstartBrowserFileExtensions;
    }

    public static String escapeJsStringLiteral(String s) {
        int codePointCount = s.codePointCount(0, s.length());
        StringBuilder b = new StringBuilder(s.length());
        block13: for (int i = 0; i < codePointCount; ++i) {
            int codePoint = s.codePointAt(i);
            switch (codePoint) {
                case 34: {
                    b.append("\\\"");
                    continue block13;
                }
                case 39: {
                    b.append("\\'");
                    continue block13;
                }
                case 92: {
                    b.append("\\\\");
                    continue block13;
                }
                case 10: {
                    b.append("\\n");
                    continue block13;
                }
                case 13: {
                    b.append("\\r");
                    continue block13;
                }
                case 8232: {
                    b.append("\\u2028");
                    continue block13;
                }
                case 8233: {
                    b.append("\\u2029");
                    continue block13;
                }
                case 38: {
                    b.append("\\u0026");
                    continue block13;
                }
                case 60: {
                    b.append("\\u003c");
                    continue block13;
                }
                case 62: {
                    b.append("\\u003e");
                    continue block13;
                }
                case 96: {
                    b.append("\\u0060");
                    continue block13;
                }
                default: {
                    b.appendCodePoint(codePoint);
                }
            }
        }
        return b.toString();
    }

    public static BWebProfileConfig getHandheldHxProfileConfig() {
        BWebProfileConfig hxConfig = new BWebProfileConfig();
        hxConfig.setTypeSpec(BTypeSpec.make((String)"hx:HandheldHxProfile"));
        return hxConfig;
    }

    public static <T> T getParameter(ServletRequest req, String name, Function<String, T> fn, T fallbackValue) {
        String value = req.getParameter(name);
        if (value == null) {
            return fallbackValue;
        }
        return fn.apply(value);
    }

    static {
        LEX = LexiconModule.make((String)"web");
        log = Logger.getLogger("web");
        BROWSER_EXTS = AccessController.doPrivileged(() -> System.getProperty("niagara.webstart.browser.exts", ".pdf"));
        LINE_SEPARATOR = AccessController.doPrivileged(() -> System.getProperty("line.separator"));
    }

    public static class ProfileFilter
    extends AgentFilter {
        BIWebProfile profile;
        BObject target;

        public ProfileFilter(BIWebProfile profile, BObject target) {
            this.profile = profile;
            this.target = target;
        }

        public boolean include(AgentInfo agent) {
            if (this.profile == null) {
                return true;
            }
            if (!this.profile.hasView(this.target, agent)) {
                return false;
            }
            if (agent.getAppName() != null) {
                String[] profileAppNames;
                for (String profileAppName : profileAppNames = this.profile.getAppNames()) {
                    if (!profileAppName.equals(agent.getAppName())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

