/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.nre.util.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RestUtil {
    private final HttpServletRequest req;
    private final HttpServletResponse resp;
    private Accept[] acceptArray;
    private final String[] path;
    private final String pathInfo;
    private static final Pattern pathRegExPattern = Pattern.compile("([^/]+)");
    private static final Pattern customMediaSubTypePattern = Pattern.compile("^vnd\\.tridium\\.([a-zA-Z]+)-v([0-9.]+)\\+([a-zA-Z]+).*");
    private static final Pattern qualityPattern = Pattern.compile("[; ]*q=([0-9.]+)");
    private static final Pattern acceptPattern = Pattern.compile("([a-zA-Z0-9.+*-]+)\\/([a-zA-Z0-9.+*-]+)(.*)");
    private Accept defaultAccept = new Accept("*", "*", "");

    public RestUtil(HttpServletRequest req, HttpServletResponse resp) {
        this.req = req;
        this.resp = resp;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        ArrayList<String> pathArray = new ArrayList<String>();
        Matcher matcher = pathRegExPattern.matcher(pathInfo);
        while (matcher.find()) {
            String group = matcher.group();
            pathArray.add(group);
        }
        this.path = pathArray.toArray(new String[pathArray.size()]);
        this.pathInfo = pathInfo;
        ArrayList<Accept> acceptList = new ArrayList<Accept>();
        String acceptStr = req.getHeader("Accept");
        if (acceptStr != null) {
            String[] a = acceptStr.split(",");
            for (int i = 0; i < a.length; ++i) {
                Matcher matcher2 = acceptPattern.matcher(a[i].trim());
                if (!matcher2.matches()) continue;
                String params = null;
                if (matcher2.groupCount() == 3) {
                    params = matcher2.group(3);
                }
                if (params == null) {
                    params = "";
                }
                acceptList.add(new Accept(matcher2.group(1), matcher2.group(2), params));
            }
            Collections.sort(acceptList);
        }
        this.acceptArray = acceptList.toArray(new Accept[acceptList.size()]);
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.resp;
    }

    public String[] getPath() {
        return this.path;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String get(int index, String def) {
        return index >= 0 && index < this.path.length ? this.path[index] : def;
    }

    public String get(int index) {
        return this.get(index, "");
    }

    public boolean has(int index, String name) {
        return this.get(index, "").equals(name);
    }

    public boolean has(int index) {
        return this.get(index, null) != null;
    }

    public boolean matches(String pattern) {
        return this.pathInfo.matches(pattern);
    }

    public boolean matches(Pattern pattern) {
        return pattern.matcher(this.pathInfo).matches();
    }

    public Accept[] getAccepts() {
        return this.acceptArray;
    }

    public boolean acceptJson() {
        if (this.acceptArray.length == 0) {
            return true;
        }
        for (int i = 0; i < this.acceptArray.length; ++i) {
            if (!this.acceptArray[i].isJson()) continue;
            return true;
        }
        return false;
    }

    public boolean acceptXml() {
        if (this.acceptArray.length == 0) {
            return true;
        }
        for (int i = 0; i < this.acceptArray.length; ++i) {
            if (!this.acceptArray[i].isXml()) continue;
            return true;
        }
        return false;
    }

    public boolean acceptHtml() {
        if (this.acceptArray.length == 0) {
            return true;
        }
        for (int i = 0; i < this.acceptArray.length; ++i) {
            if (!this.acceptArray[i].isHtml()) continue;
            return true;
        }
        return false;
    }

    public Accept getJsonAccept() {
        if (this.acceptArray.length == 0) {
            return this.defaultAccept;
        }
        for (int i = 0; i < this.acceptArray.length; ++i) {
            if (!this.acceptArray[i].isJson()) continue;
            return this.acceptArray[i];
        }
        return null;
    }

    public Accept getXmlAccept() {
        if (this.acceptArray.length == 0) {
            return this.defaultAccept;
        }
        for (int i = 0; i < this.acceptArray.length; ++i) {
            if (!this.acceptArray[i].isXml()) continue;
            return this.acceptArray[i];
        }
        return null;
    }

    public Accept getHtmlAccept() {
        if (this.acceptArray.length == 0) {
            return this.defaultAccept;
        }
        for (int i = 0; i < this.acceptArray.length; ++i) {
            if (!this.acceptArray[i].isHtml()) continue;
            return this.acceptArray[i];
        }
        return null;
    }

    public RestUtil respond(Accept accept, String defaultContentType) {
        String media = accept.isGeneric() ? defaultContentType : accept.getMedia();
        this.resp.setContentType(media + "; charset=UTF-8");
        this.resp.setHeader("transfer-encoding", "chunked");
        this.resp.setHeader("Connection", "keep-alive");
        return this;
    }

    public RestUtil respondNoCache() {
        this.resp.addHeader("Pragma", "no-cache");
        this.resp.addHeader("Expires", "-1");
        this.resp.addHeader("Cache-Control", "no-store");
        return this;
    }

    public static final class Accept
    implements Comparable<Accept> {
        private String type;
        private String subType;
        private String parameters;
        private boolean isJson;
        private boolean isHtml;
        private boolean isXml;
        private boolean isCustomMediaType;
        private String customProto = "";
        private Version customVersion = defaultVersion;
        private static final Version defaultVersion = new Version("1");
        private double quality = 1.0;

        private Accept(String type, String subType, String parameters) {
            this.type = type.intern();
            this.subType = subType.intern();
            this.parameters = parameters;
            this.parse();
            this.parseParams();
        }

        private void parse() {
            if (this.type == "*" && this.subType == "*") {
                this.isJson = true;
                this.isHtml = true;
                this.isXml = true;
            } else if (this.type == "application") {
                if (this.subType == "json") {
                    this.isJson = true;
                } else if (this.subType == "xml") {
                    this.isXml = true;
                } else if (this.subType == "*") {
                    this.isJson = true;
                    this.isXml = true;
                    this.isHtml = true;
                } else {
                    Matcher customMatcher = customMediaSubTypePattern.matcher(this.subType);
                    if (customMatcher.matches()) {
                        this.isCustomMediaType = true;
                        String groupStr = customMatcher.group(1);
                        if (groupStr != null) {
                            this.customProto = groupStr;
                        }
                        if ((groupStr = customMatcher.group(2)) != null) {
                            this.customVersion = new Version(groupStr);
                        }
                        if ((groupStr = customMatcher.group(3)) != null) {
                            String g = groupStr.toLowerCase();
                            if (g.equals("json")) {
                                this.isJson = true;
                            } else if (g.equals("xml")) {
                                this.isXml = true;
                            } else if (g.equals("html")) {
                                this.isHtml = true;
                            }
                        }
                    }
                }
            } else if (this.type == "text" && this.subType == "html") {
                this.isHtml = true;
            }
        }

        private void parseParams() {
            if (this.parameters.length() == 0) {
                return;
            }
            Matcher matcher = qualityPattern.matcher(this.parameters);
            if (matcher.matches()) {
                this.quality = Double.parseDouble(matcher.group(1));
                if (this.quality > 1.0) {
                    this.quality = 1.0;
                } else if (this.quality < 0.0) {
                    this.quality = 0.0;
                }
            }
        }

        @Override
        public int compareTo(Accept acc) {
            if (this.quality == acc.quality) {
                if (this.isCustomMediaType) {
                    return -1;
                }
                if (acc.isCustomMediaType) {
                    return 1;
                }
                if (this.isGeneric()) {
                    return 1;
                }
                if (acc.isGeneric()) {
                    return -1;
                }
                if (this.isJson && !acc.isJson) {
                    return -1;
                }
                if (!this.isJson && acc.isJson) {
                    return 1;
                }
                if (this.isJson && acc.isJson) {
                    return 0;
                }
                if (this.isXml && !acc.isXml) {
                    return -1;
                }
                if (!this.isXml && acc.isXml) {
                    return 1;
                }
                if (this.isXml && acc.isXml) {
                    return 0;
                }
                return 0;
            }
            if (this.quality > acc.quality) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Accept)) {
                return false;
            }
            Accept acc = (Accept)obj;
            return acc.type == this.type && acc.subType == this.subType && acc.parameters.equals(this.parameters);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.subType.hashCode();
            result = 31 * result + this.parameters.hashCode();
            return result;
        }

        public boolean isJson() {
            return this.isJson;
        }

        public boolean isHtml() {
            return this.isHtml;
        }

        public boolean isXml() {
            return this.isXml;
        }

        public String getMedia() {
            return this.type + "/" + this.subType;
        }

        public boolean isCustomMediaType() {
            return this.isCustomMediaType;
        }

        public String getCustomProtocol() {
            return this.customProto;
        }

        public Version getCustomVersion() {
            return this.customVersion;
        }

        public double getQuality() {
            return this.quality;
        }

        public boolean isGeneric() {
            return this.type == "*" || this.type == "application" && this.subType == "*";
        }
    }
}

