/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.crypto.core.cert.TridiumHostnameVerifier;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.nre.util.InterfaceNetworkSettings;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(type="boolean", name="validateHostHeader", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(type="String", name="validHostHeaders", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BHostHeaderValidationSettings
extends BComponent
implements IPropertyValidator {
    public static final Property validateHostHeader = BHostHeaderValidationSettings.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property validHostHeaders = BHostHeaderValidationSettings.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BHostHeaderValidationSettings.class);
    private Set<String> mergedValidHostHeaders = null;
    private static final String SPLIT_REGEX = "\\s*[;,]\\s*";
    private static final String LOCALHOST = "localhost";
    private static final String LOOPBACK_IPV4 = "127.0.0.1";
    private static final String LOOPBACK_IPV6 = "::1";

    public boolean getValidateHostHeader() {
        return this.getBoolean(validateHostHeader);
    }

    public void setValidateHostHeader(boolean v) {
        this.setBoolean(validateHostHeader, v, null);
    }

    public String getValidHostHeaders() {
        return this.getString(validHostHeaders);
    }

    public void setValidHostHeaders(String v) {
        this.setString(validHostHeaders, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BWebService;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.initValidHostHeaders();
        }
        super.started();
    }

    public void stationStarted() throws Exception {
        this.initValidHostHeaders();
        super.stationStarted();
    }

    public void changed(Property property, Context context) {
        if (Sys.isStationStarted() && validHostHeaders.equals(property)) {
            this.initValidHostHeaders();
        }
        super.changed(property, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        String proposedHostHeaders = ((BString)validatable.getProposedValue(validHostHeaders)).getString();
        StringJoiner invalidHostHeaders = new StringJoiner(", ");
        for (String configuredHostname : proposedHostHeaders.trim().split(SPLIT_REGEX)) {
            String hostname = configuredHostname.trim();
            if (hostname.startsWith("*.")) {
                if (IPAddressUtil.isHostname((String)hostname.substring(hostname.indexOf(46) + 1))) continue;
                invalidHostHeaders.add(hostname);
                continue;
            }
            if (IPAddressUtil.isHostname((String)hostname) || IPAddressUtil.isIpv4Address((String)hostname) || IPAddressUtil.isIpv6Address((String)hostname)) continue;
            invalidHostHeaders.add(hostname);
        }
        if (invalidHostHeaders.length() > 0) {
            throw new LocalizableRuntimeException("web", "web.hostHeaderValidation.invalidHostHeader", new Object[]{invalidHostHeaders});
        }
    }

    public boolean isHostHeaderFormatValid(String hostHeader) {
        try {
            URI uri = new URI("http://" + hostHeader);
            String hostname = uri.getHost();
            if (hostname.startsWith("[") && hostname.endsWith("]")) {
                hostname = hostname.substring(1, hostname.length() - 1);
            }
            return IPAddressUtil.isHostname((String)hostname) || IPAddressUtil.isIpv4Address((String)hostname) || IPAddressUtil.isIpv6Address((String)hostname);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isHostHeaderValid(String hostHeader, boolean isSecure) throws SecurityException {
        if (!this.getValidateHostHeader()) {
            return true;
        }
        try {
            String scheme = isSecure ? "https://" : "http://";
            URI uri = new URI(scheme + hostHeader);
            return this.isHostHeaderPortValid(uri.getPort(), isSecure) && this.isHostHeaderHostnameValid(uri.getHost());
        }
        catch (Exception e) {
            BWebService.log.log(Level.FINE, "Host header could not be validated.", e);
            return false;
        }
    }

    private boolean isHostHeaderPortValid(int port, boolean isSecure) {
        int expectedPort;
        BWebService webService = (BWebService)this.getParent();
        if (webService == null) {
            BWebService.log.fine("Could not find web service to validate host header port");
            return false;
        }
        if (port == -1) {
            port = isSecure ? 443 : 80;
        }
        int n = expectedPort = isSecure ? webService.getHttpsPort().getPublicServerPort() : webService.getHttpPort().getPublicServerPort();
        if (expectedPort != port) {
            if (BWebService.log.isLoggable(Level.FINE)) {
                BWebService.log.fine("Expected host header port " + expectedPort + " but found " + port);
            }
            return false;
        }
        return true;
    }

    private boolean isHostHeaderHostnameValid(String hostHeaderHostname) {
        if (hostHeaderHostname.startsWith("[") && hostHeaderHostname.endsWith("]")) {
            hostHeaderHostname = hostHeaderHostname.substring(1, hostHeaderHostname.length() - 1);
        }
        for (String validHostHeader : this.getMergedValidHostHeaders()) {
            if (!TridiumHostnameVerifier.verifyHostname((String)hostHeaderHostname, (String)validHostHeader)) continue;
            return true;
        }
        if (BWebService.log.isLoggable(Level.FINE)) {
            BWebService.log.fine("Host header does match configured valid host headers: " + hostHeaderHostname);
        }
        return false;
    }

    public void autoPopulateValidHostHeaders() {
        if (!this.getValidHostHeaders().isEmpty()) {
            return;
        }
        HashSet<String> validHostHeaders = new HashSet<String>();
        this.addRedirectHostname(validHostHeaders);
        this.addTcpIpPlatformServiceHostname(validHostHeaders);
        this.addInetAddressHostname(validHostHeaders);
        this.setValidHostHeaders(String.join((CharSequence)";", validHostHeaders));
    }

    private void addRedirectHostname(Set<String> validHostHeaders) {
        String hostname;
        BWebService webService = (BWebService)this.getParent();
        if (webService != null && webService.getHostnameRedirectSettings().getRedirectToHostname() && !(hostname = webService.getHostnameRedirectSettings().getHostname()).isEmpty()) {
            validHostHeaders.add(hostname);
            if (BWebService.log.isLoggable(Level.FINE)) {
                BWebService.log.fine("Added " + hostname + " from Web Service redirect settings to valid host headers");
            }
        }
    }

    private void addTcpIpPlatformServiceHostname(Set<String> validHostHeaders) {
        try {
            BComponent tcpIpPlatformService = Sys.getService((Type)BTypeSpec.make((String)"platform", (String)"TcpIpPlatformService").getResolvedType());
            AccessController.doPrivileged(() -> {
                Method loadProperties = tcpIpPlatformService.getClass().getMethod("doCheckPropertiesLoaded", new Class[0]);
                loadProperties.invoke((Object)tcpIpPlatformService, new Object[0]);
                return null;
            });
            BComponent tcpIpHostSettings = (BComponent)tcpIpPlatformService.get("settings");
            String hostname = ((BString)tcpIpHostSettings.get("hostName")).getString();
            if (!hostname.isEmpty()) {
                validHostHeaders.add(hostname);
                if (BWebService.log.isLoggable(Level.FINE)) {
                    BWebService.log.fine("Added " + hostname + " from Tcp Ip Platform Service to valid host headers");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addInetAddressHostname(Set<String> validHostHeaders) {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            if (!hostname.isEmpty()) {
                validHostHeaders.add(hostname);
                if (BWebService.log.isLoggable(Level.FINE)) {
                    BWebService.log.fine("Added " + hostname + " from InetAdrress to valid host headers");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Set<String> getValidLocalIpAddresses() {
        InterfaceNetworkSettings[] settings;
        HashSet<String> validLocalIpAddresses = new HashSet<String>();
        for (InterfaceNetworkSettings setting : settings = IPAddressUtil.getLocalHostInterfaces()) {
            validLocalIpAddresses.add(BHostHeaderValidationSettings.trimAddress(setting.getInetAddress().getHostAddress()));
        }
        validLocalIpAddresses.add(LOCALHOST);
        validLocalIpAddresses.add(LOOPBACK_IPV4);
        validLocalIpAddresses.add(LOOPBACK_IPV6);
        return validLocalIpAddresses;
    }

    private static String trimAddress(String address) {
        int index = address.indexOf("%");
        if (index >= 0) {
            return address.substring(0, index);
        }
        return address;
    }

    private Set<String> getMergedValidHostHeaders() {
        if (this.mergedValidHostHeaders == null) {
            this.initValidHostHeaders();
        }
        return this.mergedValidHostHeaders;
    }

    private void initValidHostHeaders() {
        this.mergedValidHostHeaders = new HashSet<String>();
        this.mergedValidHostHeaders.addAll(Arrays.asList(this.getValidHostHeaders().trim().split(SPLIT_REGEX)));
        this.mergedValidHostHeaders.addAll(BHostHeaderValidationSettings.getValidLocalIpAddresses());
        if (BWebService.log.isLoggable(Level.FINER)) {
            StringJoiner validHostHeaders = new StringJoiner(", ");
            for (String hostHeader : this.mergedValidHostHeaders) {
                validHostHeaders.add(hostHeader);
            }
            BWebService.log.finer("Found valid host headers: " + validHostHeaders);
        }
    }
}

