/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.BUsernameAndPasswordFE;
import com.tridium.workbench.auth.CredentialsList;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridium.workbench.ord.BHostOrdFE;
import com.tridium.workbench.shell.BGeneralOptions;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbPlugin;

public class BHostSelectPane
extends BEdgePane {
    public static final Action addressModified = BHostSelectPane.newAction((int)0, null);
    public static final Action foxsModified = BHostSelectPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BHostSelectPane.class);
    public static final BImage logo = BImage.make((String)"module://icons/x32/connect.png");
    public static final BImage keys = BImage.make((String)"module://icons/x16/keys.png");
    BIntegerFE portFE;
    BBooleanFE useFoxsFE;
    BHostOrdFE hostOrdFE;
    BLink link = null;
    BUsernameAndPasswordFE credentialsEditor;
    BCheckBox saveCredentials;

    public void addressModified() {
        this.invoke(addressModified, null, null);
    }

    public void foxsModified() {
        this.invoke(foxsModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHostSelectPane() {
        this(BOrd.NULL, BGeneralOptions.make().getIsDefaultConnectionTypeSsl() ? 4911 : 1911, BGeneralOptions.make().getIsDefaultConnectionTypeSsl());
    }

    public BHostSelectPane(BOrd host, int port, boolean useFoxs) {
        UiLexicon lex = UiLexicon.bajaui();
        BLabel logoLabel = new BLabel(logo);
        logoLabel.setValign(BValign.top);
        String lexTitle = lex.getText("auth.title");
        String lexDesc = lex.getText("auth.description");
        String lexHost = lex.getText("auth.host");
        String lexPort = lex.getText("auth.port");
        String lexFoxs = lex.getText("auth.foxs");
        String lexCred = lex.getText("auth.credentials");
        String lexSaveCred = lex.getText("auth.saveCredentials");
        BFont bold = Theme.widget().getBoldText();
        BGridPane sum = new BGridPane(2);
        sum.setHalign(BHalign.left);
        sum.add(null, (BValue)new BLabel(lexHost, bold));
        this.hostOrdFE = new BHostOrdFE();
        BFacets facets = BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE, (String)"mruAutoSave", (BIDataValue)BBoolean.FALSE);
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        if (!allowCaching) {
            AuthUtil.saveCredentials = false;
        }
        this.saveCredentials = new BCheckBox(lexSaveCred, AuthUtil.saveCredentials);
        this.saveCredentials.setEnabled(allowCaching);
        this.hostOrdFE.loadValue((BObject)host, (Context)facets);
        this.link = this.linkTo((BComponent)this.hostOrdFE, (Slot)BHostOrdFE.pluginModified, (Slot)addressModified);
        sum.add(null, (BValue)this.hostOrdFE);
        sum.add(null, (BValue)new BLabel(lexPort, bold));
        this.portFE = new BIntegerFE();
        this.portFE.loadValue((BObject)BInteger.make((int)port));
        sum.add(null, (BValue)this.portFE);
        sum.add(null, (BValue)new BLabel(lexFoxs, bold));
        this.useFoxsFE = new BBooleanFE();
        this.useFoxsFE.loadValue((BObject)BBoolean.make((boolean)useFoxs));
        sum.add(null, (BValue)this.useFoxsFE);
        this.linkTo((BComponent)this.useFoxsFE, (Slot)BWbPlugin.pluginModified, (Slot)foxsModified);
        this.credentialsEditor = new BUsernameAndPasswordFE();
        this.credentialsEditor.loadValue((BObject)new BUsernameAndPassword());
        BGridPane credInput = new BGridPane(1);
        credInput.setHalign(BHalign.left);
        credInput.add(null, (BValue)new BLabel(lexCred, bold));
        credInput.add(null, (BValue)new BBorderPane((BWidget)this.credentialsEditor, 0.0, 0.0, 0.0, 20.0));
        BGridPane content = new BGridPane(1);
        content.setHalign(BHalign.left);
        content.setRowGap(10.0);
        content.add(null, (BValue)sum);
        content.add(null, (BValue)credInput);
        content.add(null, (BValue)this.saveCredentials);
        this.setCenter((BWidget)new BBorderPane((BWidget)content, 5.0, 5.0, 5.0, 5.0));
        if (host != BOrd.NULL) {
            String text = this.addressToOrdString(this.getHostOrd(), this.getPort(), useFoxs);
            BUsernameAndPassword cred = (BUsernameAndPassword)CredentialsList.INSTANCE.lookup(text);
            try {
                if (!this.hostOrdFE.saveValue().equals((Object)BOrd.make((String)"ip:")) && (cred == null || cred.getUsername() == null || cred.getUsername().isEmpty())) {
                    this.saveCredentials.setSelected(false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.doAddressModified();
    }

    public String getHostString() {
        try {
            return this.hostOrdFE.saveValue().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getPort() {
        try {
            return ((BInteger)this.portFE.saveValue()).getInt();
        }
        catch (Exception e) {
            return 1911;
        }
    }

    public boolean getUseFoxs() {
        try {
            return ((BBoolean)this.useFoxsFE.saveValue()).getBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    public BOrd getHostOrd() {
        try {
            this.remove((BComplex)this.link);
            this.hostOrdFE.setModified();
            this.addressToOrdString(this.getHostOrd(), this.getPort(), this.getUseFoxs());
            this.link = this.linkTo((BComponent)this.hostOrdFE, (Slot)BHostOrdFE.pluginModified, (Slot)addressModified);
            BOrd hostOrd = (BOrd)this.hostOrdFE.saveValue();
            return hostOrd;
        }
        catch (Exception e) {
            return BOrd.NULL;
        }
    }

    public BICredentials getCredentials() {
        try {
            BICredentials cr = (BICredentials)this.credentialsEditor.saveValue();
            return cr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BUsernameAndPassword();
        }
    }

    public boolean getRememberCredentials() {
        return this.saveCredentials.isSelected();
    }

    public String getRealm() {
        return this.addressToOrdString(this.getHostOrd(), this.getPort(), this.getUseFoxs());
    }

    protected String addressToOrdString(BOrd hostOrd, int port, boolean useFoxs) {
        String ord = hostOrd.toString();
        if (useFoxs) {
            ord = ord + "|foxs:";
            if (port != 4911) {
                ord = ord + port;
            }
        } else {
            ord = ord + "|fox:";
            if (port != 1911) {
                ord = ord + port;
            }
        }
        return ord;
    }

    public void doAddressModified() {
        try {
            String text = this.addressToOrdString(this.getHostOrd(), this.getPort(), this.getUseFoxs());
            BUsernameAndPassword cred = (BUsernameAndPassword)CredentialsList.INSTANCE.lookup(text);
            if (cred != null) {
                this.credentialsEditor.loadValue((BObject)cred);
            } else {
                this.credentialsEditor.loadValue((BObject)new BUsernameAndPassword());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doFoxsModified() {
        if (this.getUseFoxs()) {
            this.portFE.loadValue((BObject)BInteger.make((int)4911));
        } else {
            this.portFE.loadValue((BObject)BInteger.make((int)1911));
        }
    }
}

