/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.audio;

import com.tridium.alarm.ui.IAudioPlayer;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.util.Queue;

public class SoundPlayer
implements IAudioPlayer {
    protected boolean stopRequest = false;
    protected Queue media = new Queue();
    protected HashMap<Object, Array<BValue>> soundToSourcesMap = new HashMap();
    protected HashMap<BValue, Object> sourceToSoundMap = new HashMap();
    protected boolean isPlaying = false;
    protected BRelTime delay = BRelTime.make((long)1000L);
    public static final Logger logger = Logger.getLogger("bajaui");
    private final List<IAudioPlayer.MediaPlayerListener> listeners = new ArrayList<IAudioPlayer.MediaPlayerListener>();

    public SoundPlayer() {
    }

    public SoundPlayer(BRelTime delay) {
        this.delay = delay;
    }

    @Override
    public boolean addMediaObject(BValue source, Object sound) {
        Array sources = this.soundToSourcesMap.get(sound);
        if (sources == null) {
            sources = new Array(BValue.class);
            sources.add((Object)source);
            this.soundToSourcesMap.put(sound, (Array<BValue>)sources);
            this.sourceToSoundMap.put(source, sound);
            this.media.enqueue(sound);
            return true;
        }
        if (!sources.contains((Object)source)) {
            sources.add((Object)source);
            this.soundToSourcesMap.put(sound, (Array<BValue>)sources);
            this.sourceToSoundMap.put(source, sound);
            this.media.enqueue(sound);
            return true;
        }
        return false;
    }

    @Override
    public void removeMediaObject(BValue source) {
        Object sound = this.sourceToSoundMap.remove(source);
        Array<BValue> sources = this.soundToSourcesMap.get(sound);
        if (sources != null) {
            sources.remove((Object)source);
            if (sources.size() == 0) {
                this.soundToSourcesMap.remove(sound);
            }
        }
    }

    @Override
    public boolean hasMediaObjects() {
        return this.media.size() > 0 && this.soundToSourcesMap.size() > 0;
    }

    @Override
    public void setDelay(BRelTime delay) {
        this.delay = delay.getMillis() < 1000L ? BRelTime.make((long)1000L) : delay;
    }

    @Override
    public BRelTime getDelay() {
        return this.delay;
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    protected void processMediaObject(Object obj) throws Exception {
        this.beep();
    }

    @Override
    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public void play() throws Exception {
        this.play(true);
    }

    @Override
    public void play(boolean continuous) throws Exception {
        this.play(continuous, this.delay);
    }

    @Override
    public void play(boolean continuous, BRelTime delay) throws Exception {
        this.delay = delay;
        if (this.media.isEmpty()) {
            throw new Exception("Cannot play: Media File(s) not specified.");
        }
        if (this.isPlaying) {
            return;
        }
        this.stopRequest = false;
        PlayThread play = new PlayThread(continuous);
        play.start();
    }

    @Override
    public void stop() {
        this.stopRequest = true;
        this.soundToSourcesMap.clear();
        this.sourceToSoundMap.clear();
        this.media.clear();
    }

    public void fireMediaPlayerStopped() {
        for (IAudioPlayer.MediaPlayerListener listener : this.listeners) {
            listener.mediaPlayerStopped();
        }
    }

    @Override
    public void addListener(IAudioPlayer.MediaPlayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IAudioPlayer.MediaPlayerListener listener) {
        this.listeners.remove(listener);
    }

    private class PlayThread
    extends Thread {
        private final boolean continuous;

        PlayThread(boolean continuous) {
            super("Alarm: MediaPlayer");
            this.continuous = continuous;
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (!SoundPlayer.this.media.isEmpty()) {
                        SoundPlayer.this.isPlaying = true;
                        Object obj = SoundPlayer.this.media.dequeue();
                        if (SoundPlayer.this.stopRequest) break block4;
                        if (SoundPlayer.this.soundToSourcesMap.get(obj) != null) {
                            SoundPlayer.this.processMediaObject(obj);
                            if (this.continuous) {
                                SoundPlayer.this.media.enqueue(obj);
                            }
                        }
                        try {
                            Thread.sleep(SoundPlayer.this.delay.getMillis());
                            continue block4;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    logger.severe("BAlarmConsole.soundAlarm: failed to play alarm sound: " + e);
                    break;
                }
            }
            if (SoundPlayer.this.stopRequest || !this.continuous && SoundPlayer.this.media.isEmpty()) {
                SoundPlayer.this.fireMediaPlayerStopped();
            }
            SoundPlayer.this.stopRequest = false;
            SoundPlayer.this.isPlaying = false;
            SoundPlayer.this.media.clear();
        }
    }
}

