/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.AlarmTableModel;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BUuid;

public class SourceTableModel
extends ConsoleTableModel {
    protected BConsoleRecipient recip;
    private List<AlarmList> srcList = new ArrayList<AlarmList>();
    private Map<BOrdList, AlarmList> bySrc = new HashMap<BOrdList, AlarmList>();
    private UuidList byUuid = new UuidList();
    private boolean holdUpdates = false;
    private boolean updatePending = false;
    BIAlarmServiceView alarmServiceView;
    public Context context;

    public SourceTableModel(ConsoleColumns columns, BConsoleRecipient recip, Context context) {
        super(columns);
        this.recip = recip;
        this.context = context;
    }

    @Override
    public void init(BIAlarmServiceView alarmServiceView, Context cx) {
        super.init(alarmServiceView, cx);
        this.alarmServiceView = alarmServiceView;
        this.context = cx;
    }

    public synchronized void load(Cursor<BAlarmRecord> cursor) {
        this.setHoldUpdates(true);
        this.clear();
        this.doAdd(cursor);
        this.setHoldUpdates(false);
    }

    public synchronized void add(Cursor<BAlarmRecord> cursor) {
        this.setHoldUpdates(true);
        this.doAdd(cursor);
        this.setHoldUpdates(false);
    }

    private synchronized void doAdd(Cursor<BAlarmRecord> cursor) {
        while (cursor.next()) {
            BAlarmRecord rec = (BAlarmRecord)cursor.get();
            this.recip.lease();
            if (!this.recip.accept(rec)) continue;
            rec = this.updateAlarmRecord(rec);
            this.update(rec, false);
        }
        this.sortByColumn(this.getLastSortColumn(), this.getLastSortAscending());
    }

    protected BAlarmRecord updateAlarmRecord(BAlarmRecord rec) {
        return rec;
    }

    @Override
    public synchronized BAlarmRecord getRecord(int index) {
        if (index < this.srcList.size()) {
            return this.srcList.get(index).getMostRecentRecord();
        }
        return null;
    }

    public synchronized int getRecordCount(int index) {
        return this.srcList.get(index).size();
    }

    public synchronized BAlarmRecord getRecordAt(int srcIndex, int rowIndex) {
        AlarmList list = this.srcList.get(srcIndex);
        AlarmEntry entry = list.getEntry(rowIndex);
        return entry.rec;
    }

    public synchronized void clear() {
        this.srcList.clear();
        this.bySrc.clear();
        this.byUuid.clear();
        this.updateTable();
    }

    @Override
    public int getAlarmCount() {
        return this.byUuid.getAlarmCount();
    }

    @Override
    public int getSourceCount() {
        return this.getRowCount();
    }

    private synchronized void add(BAlarmRecord rec, boolean sort) {
        BOrdList src = (rec = this.updateAlarmRecord(rec)).getSource();
        AlarmList list = this.bySrc.get(src);
        if (list == null) {
            list = new AlarmList(src);
            this.srcList.add(list);
            this.bySrc.put(src, list);
            AlarmEntry entry = list.add(rec);
            this.byUuid.put(rec.getUuid(), entry);
        } else {
            AlarmEntry entry = list.add(rec);
            this.byUuid.put(rec.getUuid(), entry);
        }
        if (sort) {
            this.sortListByColumn(list, this.getLastSortColumn(), this.getLastSortAscending());
            this.sortByColumn(this.getLastSortColumn(), this.getLastSortAscending());
        }
        this.updateTable();
    }

    @Override
    public synchronized int getAlarmCount(BOrdList src) {
        if (src == null) {
            return 0;
        }
        AlarmList alarmList = this.bySrc.get(src);
        if (alarmList != null) {
            return alarmList.size();
        }
        return 0;
    }

    @Override
    public synchronized BAlarmRecord getRecord(BOrdList src, int index) {
        if (src == null) {
            return null;
        }
        AlarmList list = this.bySrc.get(src);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.getRecord(index);
    }

    public synchronized void update(BAlarmRecord rec) {
        this.update(rec, true);
    }

    public synchronized void update(BAlarmRecord rec, boolean sort) {
        AlarmEntry entry = this.byUuid.get(rec.getUuid(), rec.getSource());
        if (entry != null && entry.rec.getSource().equals((Object)rec.getSource())) {
            BAlarmRecord oldRec = entry.rec;
            entry.rec = rec = this.updateAlarmRecord(rec);
            if (!oldRec.isAcknowledged() && !oldRec.isAckPending() && entry.rec.isAckPending()) {
                entry.list.ackPendingCount++;
                entry.list.unackedCount--;
            } else if (oldRec.isAckPending() && entry.rec.isAcknowledged()) {
                entry.list.ackPendingCount--;
                entry.list.ackedCount++;
            } else if (oldRec.isAckPending() && !entry.rec.isAcknowledged() && !entry.rec.isAckPending()) {
                entry.list.ackPendingCount--;
                entry.list.unackedCount++;
            } else if (oldRec.isAcknowledged() && !entry.rec.isAcknowledged() && !entry.rec.isAckPending()) {
                entry.list.ackedCount--;
                entry.list.unackedCount++;
            } else if (oldRec.isAcknowledged() && entry.rec.isAckPending()) {
                entry.list.ackedCount--;
                entry.list.ackPendingCount++;
            } else if (entry.rec.isAcknowledged() && !oldRec.isAcknowledged() && !oldRec.isAckPending()) {
                entry.list.ackedCount++;
                entry.list.unackedCount--;
            }
            entry.list.fireModified();
            this.updateTable();
        } else {
            this.add(rec, sort);
        }
    }

    public synchronized void remove(BAlarmRecord rec) {
        BUuid uuid = rec.getUuid();
        AlarmEntry[] entries = this.byUuid.get(uuid);
        for (int i = 0; i < entries.length; ++i) {
            AlarmEntry entry = entries[i];
            if (entry == null) {
                return;
            }
            this.byUuid.remove(uuid);
            AlarmList list = entry.list;
            list.remove(entry);
            if (list.size() != 0) continue;
            this.bySrc.remove(list.getSource());
            this.srcList.remove(list);
        }
        this.sortByColumn(this.getLastSortColumn(), this.getLastSortAscending());
        this.updateTable();
    }

    public synchronized void removeSource(BOrdList src) {
        AlarmList list = this.bySrc.get(src);
        for (int i = 0; i < list.size(); ++i) {
            AlarmEntry entry = list.getEntry(i);
            this.byUuid.remove(entry.rec.getUuid());
        }
        this.bySrc.remove(src);
        this.srcList.remove(list);
        this.updateTable();
    }

    public synchronized int getRowCount() {
        return this.srcList.size();
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int colIndex) {
        if (colIndex == 3) {
            ConsoleColumns.Column col = this.getColumns().getColumn(colIndex);
            BAlarmRecord rec = this.getRecord(rowIndex);
            if (rec == null) {
                return "";
            }
            AlarmList list = this.bySrc.get(rec.getSource());
            if (list == null) {
                return "";
            }
            StringBuffer ackColVal = new StringBuffer();
            ackColVal.append(list.getAckedCount() + " " + BAckState.acked.getDisplayTag(this.context) + " / " + list.getUnackedCount() + " " + BAckState.unacked.getDisplayTag(this.context));
            if (list.getAckPendingCount() > 0) {
                ackColVal.append(" / " + list.getAckPendingCount() + " " + BAckState.ackPending.getDisplayTag(this.context));
            }
            return ackColVal.toString();
        }
        return super.getValueAt(rowIndex, colIndex);
    }

    public synchronized AlarmTableModel getModelForSource(BOrdList source) {
        AlarmList list = this.bySrc.get(source);
        if (list == null) {
            return null;
        }
        AlarmTableModel model = new AlarmTableModel(this.getColumns(), list);
        model.sortByColumn(this.getLastSortColumn(), this.getLastSortAscending());
        model.init(this.alarmServiceView, this.context);
        return model;
    }

    public synchronized int getUnackedCountForSource(BOrdList source) {
        if (this.bySrc.get(source) == null) {
            return 0;
        }
        return this.bySrc.get(source).getUnackedCount();
    }

    public synchronized int getAckedCountForSource(BOrdList source) {
        if (this.bySrc.get(source) == null) {
            return 0;
        }
        return this.bySrc.get(source).getAckedCount();
    }

    public synchronized int getAckPendingCountForSource(BOrdList source) {
        if (this.bySrc.get(source) == null) {
            return 0;
        }
        return this.bySrc.get(source).getAckPendingCount();
    }

    private synchronized void setHoldUpdates(boolean hold) {
        this.holdUpdates = hold;
        if (!this.holdUpdates && this.updatePending) {
            this.updatePending = false;
            this.updateTable();
        }
    }

    public synchronized void updateTable() {
        if (this.holdUpdates) {
            this.updatePending = true;
        } else {
            super.updateTable();
        }
    }

    public synchronized void updateTable(boolean resizeCols) {
        if (this.holdUpdates) {
            this.updatePending = true;
        } else {
            super.updateTable(resizeCols);
        }
    }

    public synchronized void sortByColumn(int col, boolean ascending) {
        if (col < 0 || col >= super.getColumnCount()) {
            return;
        }
        this.setInitialSort(col, ascending);
        ConsoleColumns.Column column = this.getColumns().getColumn(col);
        if (ascending) {
            this.sortSrcList(column, SortUtil.ASCENDING);
        } else {
            this.sortSrcList(column, SortUtil.DESCENDING);
        }
    }

    public void sortSrcList(ConsoleColumns.Column col, Comparator<? super Object> comparator) {
        int n = this.srcList.size();
        for (int incr = n / 2; incr >= 1; incr /= 2) {
            for (int i = incr; i < n; ++i) {
                int j;
                AlarmList tempValue = this.srcList.get(i);
                Object tempKey = col.getValue(tempValue.getMostRecentRecord());
                for (j = i; j >= incr && comparator.compare(tempKey, col.getValue(this.srcList.get(j - incr).getMostRecentRecord())) <= 0; j -= incr) {
                    if (comparator.compare(tempKey, col.getValue(this.srcList.get(j - incr).getMostRecentRecord())) == 0) {
                        BAbsTime ts1 = tempValue.getMostRecentRecord().getTimestamp();
                        BAbsTime ts2 = this.srcList.get(j - incr).getMostRecentRecord().getTimestamp();
                        if (!ts2.isBefore(ts1)) break;
                        this.srcList.set(j, this.srcList.get(j - incr));
                        continue;
                    }
                    this.srcList.set(j, this.srcList.get(j - incr));
                }
                this.srcList.set(j, tempValue);
            }
        }
    }

    public synchronized void sortListByColumn(AlarmList list, int col, boolean ascending) {
        if (col < 0 || col >= super.getColumnCount()) {
            return;
        }
        this.setInitialSort(col, ascending);
        ConsoleColumns.Column column = this.getColumns().getColumn(col);
        if (ascending) {
            list.sort(column, SortUtil.ASCENDING);
        } else {
            list.sort(column, SortUtil.DESCENDING);
        }
    }

    class UuidList {
        private HashMap<BUuid, HashMap<BOrdList, AlarmEntry>> byUuid = new HashMap();
        private int alarmCount = 0;

        UuidList() {
        }

        public void put(BUuid uuid, AlarmEntry entry) {
            HashMap<Object, AlarmEntry> entries = this.byUuid.get(uuid);
            if (entries == null) {
                entries = new HashMap();
            }
            entries.put(entry.rec.getSource(), entry);
            this.byUuid.put(uuid, entries);
            ++this.alarmCount;
        }

        public AlarmEntry get(BUuid uuid, BOrdList source) {
            HashMap<BOrdList, AlarmEntry> entries = this.byUuid.get(uuid);
            if (entries == null) {
                return null;
            }
            return entries.get(source);
        }

        public AlarmEntry[] get(BUuid uuid) {
            HashMap<BOrdList, AlarmEntry> entries = this.byUuid.get(uuid);
            if (entries == null) {
                return new AlarmEntry[0];
            }
            Object[] arr = entries.values().toArray();
            AlarmEntry[] returnValue = new AlarmEntry[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                returnValue[i] = (AlarmEntry)arr[i];
            }
            return returnValue;
        }

        public int size() {
            return this.byUuid.size();
        }

        public int getAlarmCount() {
            return this.alarmCount;
        }

        public void clear() {
            this.byUuid.clear();
            this.alarmCount = 0;
        }

        public void remove(BUuid uuid) {
            HashMap<BOrdList, AlarmEntry> entries = this.byUuid.get(uuid);
            this.byUuid.remove(uuid);
            this.alarmCount -= entries.size();
        }
    }

    class AlarmEntry {
        public AlarmList list;
        public BAlarmRecord rec;

        public AlarmEntry(AlarmList list, BAlarmRecord rec) {
            this.list = list;
            this.rec = rec;
        }
    }

    class AlarmList {
        private BOrdList src;
        private List<AlarmEntry> entries;
        private TableModel tableModel;
        private AlarmEntry mostRecentEntry;
        private int ackedCount = 0;
        private int unackedCount = 0;
        private int ackPendingCount = 0;

        public AlarmList(BOrdList src) {
            this.src = src;
            this.entries = new ArrayList<AlarmEntry>(1);
        }

        public void setModel(TableModel tableModel) {
            this.tableModel = tableModel;
        }

        public TableModel getModel() {
            return this.tableModel;
        }

        public void fireModified() {
            if (this.tableModel != null) {
                this.tableModel.updateTable();
            }
        }

        public BOrdList getSource() {
            return this.src;
        }

        public int size() {
            return this.entries.size();
        }

        public AlarmEntry getEntry(int index) {
            return this.entries.get(index);
        }

        public AlarmEntry getEntry(BUuid uuid) {
            for (AlarmEntry entry : this.entries) {
                if (!entry.rec.getUuid().equals((Object)uuid)) continue;
                return entry;
            }
            return null;
        }

        public int getAckedCount() {
            return this.ackedCount;
        }

        public int getUnackedCount() {
            return this.unackedCount;
        }

        public int getAckPendingCount() {
            return this.ackPendingCount;
        }

        public BAlarmRecord getMostRecentRecord() {
            return this.mostRecentEntry.rec;
        }

        public BAlarmRecord getRecord(int index) {
            return this.getEntry((int)index).rec;
        }

        public AlarmEntry add(BAlarmRecord newRec) {
            BAbsTime newTs = newRec.getTimestamp();
            AlarmEntry entry = new AlarmEntry(this, newRec);
            this.entries.add(entry);
            if (entry.rec.isAcknowledged()) {
                ++this.ackedCount;
            } else if (entry.rec.getAckState() == BAckState.ackPending) {
                ++this.ackPendingCount;
            } else {
                ++this.unackedCount;
            }
            if (this.mostRecentEntry == null || newTs.isAfter(this.mostRecentEntry.rec.getTimestamp())) {
                this.mostRecentEntry = entry;
            }
            this.fireModified();
            return entry;
        }

        public void remove(AlarmEntry entry) {
            this.entries.remove(entry);
            if (entry.rec.isAcknowledged()) {
                --this.ackedCount;
            } else if (entry.rec.getAckState() == BAckState.ackPending) {
                --this.ackPendingCount;
            } else {
                --this.unackedCount;
            }
            if (entry.rec.getUuid().equals((Object)this.mostRecentEntry.rec.getUuid())) {
                int count = this.entries.size();
                this.mostRecentEntry = null;
                for (int i = 0; i < count; ++i) {
                    if (this.mostRecentEntry == null) {
                        this.mostRecentEntry = this.entries.get(i);
                    }
                    AlarmEntry existing = this.entries.get(i);
                    if (!existing.rec.getTimestamp().isAfter(this.mostRecentEntry.rec.getTimestamp())) continue;
                    this.mostRecentEntry = existing;
                }
            }
            this.fireModified();
        }

        public void removeAll() {
            this.entries.clear();
            this.mostRecentEntry = null;
            this.ackedCount = 0;
            this.unackedCount = 0;
            this.ackPendingCount = 0;
            this.fireModified();
        }

        public void sort(ConsoleColumns.Column col, Comparator<? super Object> comparator) {
            int n = this.entries.size();
            for (int incr = n / 2; incr >= 1; incr /= 2) {
                for (int i = incr; i < n; ++i) {
                    int j;
                    AlarmEntry tempValue = this.entries.get(i);
                    Object tempKey = col.getValue(tempValue.rec);
                    for (j = i; j >= incr && comparator.compare(tempKey, col.getValue(this.entries.get((int)(j - incr)).rec)) <= 0; j -= incr) {
                        if (comparator.compare(tempKey, col.getValue(this.entries.get((int)(j - incr)).rec)) == 0) {
                            BAbsTime ts1 = tempValue.rec.getTimestamp();
                            BAbsTime ts2 = this.entries.get((int)(j - incr)).rec.getTimestamp();
                            if (!ts2.isBefore(ts1)) break;
                            this.entries.set(j, this.entries.get(j - incr));
                            continue;
                        }
                        this.entries.set(j, this.entries.get(j - incr));
                    }
                    this.entries.set(j, tempValue);
                }
            }
        }
    }
}

