/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.TrayIconListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTrayIcon
extends BComponent {
    public static final Type TYPE = Sys.loadType(BTrayIcon.class);
    private long nativePeer;
    private long nativeImage;
    private String toolTip;
    private Vector<TrayIconListener> listeners = new Vector();
    private static final Object NATIVE_PEER_LOCK;
    public static int YELLOW_ICON;
    public static int GRAY_ICON;
    public static int GREEN_ICON;
    public static int RED_ICON;
    public static int WHITE_ICON;

    public Type getType() {
        return TYPE;
    }

    public BTrayIcon make() {
        return new BTrayIcon();
    }

    public BTrayIcon() {
        this.nativeImage = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"));
        this.toolTip = "Niagara Alarms";
    }

    public BTrayIcon(int image, String toolTip) {
        this.nativeImage = image;
        this.toolTip = toolTip;
    }

    public boolean isShowing() {
        return this.nativePeer > 0L;
    }

    public long getImage() {
        return this.nativeImage;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setImage(long image) {
        this.nativeImage = image;
    }

    public void setToolTip(String tip) {
        this.toolTip = tip;
    }

    public void show() {
        this.doShow();
    }

    public void updateTrayIcon() {
        this.updateTrayIcon(this.nativeImage, this.toolTip);
    }

    public void updateTrayIcon(String toolTip) {
        this.updateTrayIcon(this.nativeImage, toolTip);
    }

    public void updateTrayIcon(long image) {
        this.updateTrayIcon(image, this.toolTip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrayIcon(long image, String toolTip) {
        this.nativeImage = image;
        this.toolTip = toolTip;
        Object object = NATIVE_PEER_LOCK;
        synchronized (object) {
            if (this.nativePeer > 0L) {
                this.nativePeer = this.nativeUpdate(this.nativeImage, toolTip, this.nativePeer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        Object object = NATIVE_PEER_LOCK;
        synchronized (object) {
            if (this.nativePeer > 0L) {
                this.nativeHide(this.nativePeer);
            }
            this.nativePeer = 0L;
        }
    }

    private void doShow() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = NATIVE_PEER_LOCK;
                synchronized (object) {
                    BTrayIcon.this.nativePeer = BTrayIcon.this.nativeShow(BTrayIcon.this.nativeImage, BTrayIcon.this.toolTip, BTrayIcon.this.nativePeer);
                }
            }
        }.start();
    }

    public void fireClicked() {
        Vector listenersClone = (Vector)this.listeners.clone();
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            TrayIconListener listener = (TrayIconListener)e.nextElement();
            listener.onTrayIconClicked(this);
        }
    }

    public void fireDoubleClicked() {
        Vector listenersClone = (Vector)this.listeners.clone();
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            TrayIconListener listener = (TrayIconListener)e.nextElement();
            listener.onTrayIconDoubleClicked(this);
        }
    }

    public void addTrayIconListener(TrayIconListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeTrayIconListener(TrayIconListener listener) {
        this.listeners.removeElement(listener);
    }

    private native long nativeShow(long var1, String var3, long var4);

    private synchronized native long nativeUpdate(long var1, String var3, long var4);

    private native void nativeHide(long var1);

    private static synchronized native long nativeLoadImage(String var0, int var1) throws UnsatisfiedLinkError;

    private static synchronized native int nativeFreeImage(long var0) throws UnsatisfiedLinkError;

    public static long loadImage(String filename) {
        return BTrayIcon.loadImage(filename, 0);
    }

    public static long loadImage(String filename, int index) {
        try {
            return BTrayIcon.nativeLoadImage(filename, index);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            return -1L;
        }
    }

    protected static void freeImage(int image) {
        try {
            BTrayIcon.nativeFreeImage(image);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BTrayIcon tt = new BTrayIcon();
        long start = System.currentTimeMillis();
        tt.show();
        long mid = System.currentTimeMillis();
        tt.updateTrayIcon("77 UnAcked Alarms");
        long end = System.currentTimeMillis();
        System.out.println("show: " + (mid - start) + "ms");
        System.out.println("end: " + (end - mid) + "ms");
        System.out.println("total: " + (end - start) + "ms");
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.loadLibrary("trayIcon");
                    return null;
                }
            });
        }
        catch (Throwable e) {
            System.out.println("ERROR: Cannot load trayIcon native library");
            System.out.println("  " + e);
        }
        NATIVE_PEER_LOCK = new Object();
        YELLOW_ICON = 0;
        GRAY_ICON = 1;
        GREEN_ICON = 2;
        RED_ICON = 3;
        WHITE_ICON = 4;
    }
}

