/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BNotesDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BNotesDialog.class);
    BWidget widget;
    String username;
    BTextEditorPane historyPane;
    BTextEditorPane addPane;
    Command addCmd;
    Command closeCmd;
    boolean newNotes = false;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BNotesDialog.class);

    public Type getType() {
        return TYPE;
    }

    public BNotesDialog() {
        throw new IllegalStateException();
    }

    public BNotesDialog(BWidget widget, String notesText, String username, boolean canModify) {
        super(widget, lexicon.getText("alarm.notes"), true);
        this.widget = widget;
        this.username = username;
        this.historyPane = new BTextEditorPane(notesText, 12, 80, false);
        this.addPane = new BTextEditorPane("", 6, 80, true);
        this.addCmd = new AddCmd((BWidget)this);
        if (!canModify) {
            this.addCmd.setEnabled(false);
        }
        this.closeCmd = new CloseCmd((BWidget)this);
        BButton addBtn = new BButton(this.addCmd, true, true);
        BButton closeBtn = new BButton(this.closeCmd, true, true);
        BGridPane toolBar = new BGridPane(2);
        toolBar.setColumnAlign(BHalign.fill);
        toolBar.setUniformColumnWidth(true);
        toolBar.add("add", (BValue)addBtn);
        toolBar.add("close", (BValue)closeBtn);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)this.historyPane));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.addPane));
        pane.setBottom((BWidget)new BBorderPane((BWidget)toolBar));
        this.setContent((BWidget)pane);
    }

    public void open() {
        this.newNotes = false;
        this.addPane.getEditor().requestFocus();
        super.open();
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public String getNewNotes() {
        if (!this.newNotes) {
            return null;
        }
        StringBuffer notes = new StringBuffer();
        notes.append("## " + BAbsTime.now() + " - " + this.username + " ##\n");
        notes.append(this.addPane.getText());
        notes.append("\n\n");
        return notes.toString();
    }

    class CloseCmd
    extends Command {
        CloseCmd(BWidget owner) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.close");
        }

        public CommandArtifact doInvoke() {
            BNotesDialog.this.close();
            return null;
        }
    }

    class AddCmd
    extends Command {
        AddCmd(BWidget owner) {
            super(owner, (Lexicon)lexicon, "commands.addNote");
        }

        public CommandArtifact doInvoke() {
            BNotesDialog.this.newNotes = true;
            BNotesDialog.this.close();
            return null;
        }
    }
}

