/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.portal.BAlarmPortalOptions;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BPoint;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BFrame;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;

public class BAlarmDialog
extends BFrame {
    public static final Action update = BAlarmDialog.newAction((int)4, null);
    public static final Action handleHyperlink = BAlarmDialog.newAction((int)4, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BAlarmDialog.class);
    private BLabel lastAlarm;
    private BLabel lastAlarmSrc;
    private BLabel lastAlarmMsg;
    private BHyperlinkLabel lastAlarmHyperlink;
    private BLabel status;
    private BAlarmRecord lastAlarmRecord;
    private boolean lastAlarmRecordChanged;
    private BHyperlinkLabel imgLabel;
    private String title;
    private boolean fullyConnected = false;
    private int acked;
    private int unacked;
    private boolean sourcesInAlarm;
    private boolean alwaysOnTop;
    private boolean uncloseable;
    private boolean closed = true;
    private BAlarmPortalTool tool;
    static BImage alarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    static BImage alarmRed = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    static BImage alarmGreen = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage ALARM_YELLOW = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarm.gif");
    private static BImage ALARM_GREEN = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmGreen.gif");
    private static BImage ALARM_RED = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmRed.gif");
    private static BImage ALARM_WHITE = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmWhite.gif");
    private static BImage ALARM_GRAY = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmGray.gif");
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAlarmDialog.class);
    public BAlarmConsoleOptions options = BAlarmConsoleOptions.getDefault();
    public static final BFacets TIME_FACETS = BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);

    public void update() {
        this.invoke(update, null, null);
    }

    public void handleHyperlink(BMouseEvent event) {
        this.invoke(handleHyperlink, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmDialog() {
        throw new IllegalStateException();
    }

    public BAlarmDialog(BAlarmPortalTool tool, String title, BImage icon, BAlarmRecord alarm, int acked, int unacked, boolean alwaysOnTop, boolean uncloseable) {
        super(title);
        this.acked = acked;
        this.unacked = unacked;
        this.title = title;
        this.alwaysOnTop = alwaysOnTop;
        this.uncloseable = uncloseable;
        this.tool = tool;
        BAlarmPortalOptions options = BAlarmPortalOptions.getDefault();
        BPoint pos = options.getPopupPosition();
        this.setVisible(true);
        this.setIconImage(icon);
        String lastAlarmText = lexicon.getText("portal.popup.lastAlarm") + ": ";
        String lastAlarmSrcText = lexicon.getText("portal.popup.source") + ": ";
        String lastAlarmMsgText = lexicon.getText("portal.popup.message") + ": ";
        String lastAlarmHyperlinkText = lexicon.getText("portal.popup.hyperlink") + ": ";
        BEdgePane mainPane = new BEdgePane();
        BGridPane leftPane = new BGridPane(1);
        leftPane.setValign(BValign.top);
        leftPane.setHalign(BHalign.center);
        leftPane.setColumnAlign(BHalign.center);
        this.imgLabel = new BHyperlinkLabel();
        this.imgLabel.setImage(ALARM_GRAY);
        this.imgLabel.setBackground(BColor.white.toBrush());
        BBorderPane imgBorder = new BBorderPane((BWidget)this.imgLabel);
        imgBorder.setBorder(BBorder.make((double)1.0, (int)1, (BBrush)BColor.black.toBrush()));
        imgBorder.setMargin(BInsets.make((double)15.0, (double)20.0, (double)10.0, (double)20.0));
        imgBorder.setPadding(BInsets.NULL);
        leftPane.add(null, (BValue)imgBorder);
        this.linkTo((BComponent)this.imgLabel, (Slot)BWidget.mouseEvent, (Slot)handleHyperlink);
        this.status = new BLabel();
        this.status.setHalign(BHalign.center);
        this.status.setPadding(BInsets.make((double)0.0, (double)10.0, (double)0.0, (double)10.0));
        leftPane.add(null, (BValue)this.status);
        BGridPane centerPane = new BGridPane(2);
        centerPane.setRowAlign(BValign.top);
        centerPane.setColumnAlign(BHalign.left);
        BLabel lastAlarmLabel = new BLabel(lastAlarmText);
        lastAlarmLabel.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        lastAlarmLabel.setHalign(BHalign.left);
        centerPane.add(null, (BValue)lastAlarmLabel);
        this.lastAlarm = new BLabel();
        this.lastAlarm.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        this.lastAlarm.setHalign(BHalign.left);
        centerPane.add(null, (BValue)this.lastAlarm);
        BLabel lastAlarmSrcLabel = new BLabel(lastAlarmSrcText);
        lastAlarmSrcLabel.setHalign(BHalign.left);
        centerPane.add(null, (BValue)lastAlarmSrcLabel);
        this.lastAlarmSrc = new BLabel();
        this.lastAlarmSrc.setHalign(BHalign.left);
        centerPane.add(null, (BValue)this.lastAlarmSrc);
        BLabel lastAlarmMsgLabel = new BLabel(lastAlarmMsgText);
        lastAlarmMsgLabel.setHalign(BHalign.left);
        centerPane.add(null, (BValue)lastAlarmMsgLabel);
        this.lastAlarmMsg = new BLabel();
        this.lastAlarmMsg.setHalign(BHalign.left);
        centerPane.add(null, (BValue)this.lastAlarmMsg);
        BLabel lastAlarmHyperlinkLabel = new BLabel(lastAlarmHyperlinkText);
        lastAlarmHyperlinkLabel.setHalign(BHalign.left);
        lastAlarmHyperlinkLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)10.0, (double)0.0));
        centerPane.add(null, (BValue)lastAlarmHyperlinkLabel);
        this.lastAlarmHyperlink = new BHyperlinkLabel();
        this.lastAlarmHyperlink.setHalign(BHalign.left);
        this.lastAlarmHyperlink.setPadding(BInsets.make((double)0.0, (double)0.0, (double)10.0, (double)0.0));
        centerPane.add(null, (BValue)this.lastAlarmHyperlink);
        this.linkTo((BComponent)this.lastAlarmHyperlink, (Slot)BWidget.mouseEvent, (Slot)handleHyperlink);
        mainPane.setLeft((BWidget)leftPane);
        mainPane.setCenter((BWidget)centerPane);
        mainPane.computePreferredSize();
        this.setScreenBounds(pos.x(), pos.y(), mainPane.getPreferredWidth() + 50.0, mainPane.getPreferredHeight() + 50.0);
        this.setContent((BWidget)mainPane);
        if (alarm != null) {
            this.updateLastAlarm(alarm);
        }
        try {
            this.doLoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setAlwaysOnTop(title, alwaysOnTop);
        Thread updateThread = new Thread(){

            @Override
            public void run() {
                while (!BAlarmDialog.this.closed) {
                    BAlarmDialog.this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        updateThread.start();
    }

    protected void doLoad() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.loadLibrary("alarmDialog");
                return null;
            }
        });
    }

    public void windowClosing(BWindowEvent event) {
        if (!this.uncloseable) {
            this.close();
        }
    }

    public void open() {
        if (this.closed) {
            this.closed = false;
            super.open();
        }
    }

    public void close() {
        this.tool.onAlarmDialogClosed(this);
        this.closed = true;
        this.releaseNativeResources(this.title);
        this.setVisible(false);
        super.close();
    }

    public void windowDeactivated(BWindowEvent event) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
        }
    }

    public void windowActivated(BWindowEvent event) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
        }
    }

    public void windowDeiconified(BWindowEvent event) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
        }
    }

    public void windowIconified(BWindowEvent event) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
            if (this.alwaysOnTop) {
                this.toTop(this.title);
            }
        }
    }

    public int getPixel(BWidget c, int x, int y) {
        c = (BWidget)c.getParent();
        while (c.getParent() != null) {
            Point p = new Point(c.getX(), c.getY());
            x = (int)((double)x + p.x);
            y = (int)((double)y + p.y);
            c = (BWidget)c.getParent();
        }
        return this.getPixel(x -= 3, y -= 22);
    }

    public void doUpdate() {
        if (this.lastAlarmRecord != null && this.lastAlarmRecordChanged) {
            this.lastAlarmRecordChanged = false;
            String source = this.lastAlarmRecord.getSource().toString();
            BObject sourceName = this.lastAlarmRecord.getAlarmData().get("sourceName");
            if (sourceName != null && !sourceName.toString().equals("")) {
                source = BFormat.make((String)this.lastAlarmRecord.getAlarmData().get("sourceName").toString()).format((Object)this.lastAlarmRecord);
            }
            this.lastAlarmSrc.setText(source);
            this.lastAlarm.setText(this.lastAlarmRecord.getTimestamp().toString());
            this.lastAlarm.setImage(alarmImg);
            String text = "";
            if (this.lastAlarmRecord.getAlarmData().get("msgText") != null) {
                text = this.lastAlarmRecord.getAlarmData().get("msgText").toString();
            }
            this.lastAlarmMsg.setText(lexicon.getText(BFormat.make((String)text).format((Object)this.lastAlarmRecord)));
            String hyperlink = "";
            if (this.lastAlarmRecord.getAlarmData().get("hyperlinkOrd") != null) {
                hyperlink = this.lastAlarmRecord.getAlarmData().get("hyperlinkOrd").toString();
                this.lastAlarmHyperlink.setText(BFormat.make((String)hyperlink).format((Object)this.lastAlarmRecord));
                this.lastAlarmHyperlink.setOrd(BOrd.make((String)hyperlink));
                this.lastAlarmHyperlink.setVisible(true);
                this.imgLabel.setOrd(BOrd.make((String)hyperlink));
            } else {
                this.lastAlarmHyperlink.setVisible(false);
                this.lastAlarmHyperlink.setOrd(BOrd.NULL);
                this.imgLabel.setOrd(BOrd.NULL);
            }
        }
        Object[] args = new Object[]{new Integer(this.acked), new Integer(this.unacked)};
        this.status.setText(lexicon.getText("portal.popup.unackedAlarms", args));
        this.updateImage(this.sourcesInAlarm);
        BWidget content = this.getContent();
        content.computePreferredSize();
        this.setScreenBounds(this.getScreenBounds().x(), this.getScreenBounds().y(), content.getPreferredWidth() + 50.0, content.getPreferredHeight() + 50.0);
        this.repaint();
        this.toTop(this.title);
    }

    public void updateLastAlarm(BAlarmRecord lastAlarmRecord) {
        this.lastAlarmRecord = lastAlarmRecord;
        this.lastAlarmRecordChanged = true;
    }

    public void updateAlarmCounts(int ackedCount, int unackedCount, boolean sourcesInAlarm) {
        boolean changed = ackedCount != this.acked;
        changed |= unackedCount != this.unacked;
        changed |= sourcesInAlarm != this.sourcesInAlarm;
        this.unacked = unackedCount;
        this.acked = ackedCount;
        this.sourcesInAlarm = sourcesInAlarm;
    }

    private void updateImage(BImage img) {
        if (!this.imgLabel.getImage().equals((Object)img)) {
            this.imgLabel.setImage(img);
        }
    }

    private void updateImage(boolean sourcesInAlarm) {
        if (!this.fullyConnected) {
            this.updateImage(ALARM_GRAY);
        } else if (this.unacked > 0) {
            if (sourcesInAlarm) {
                this.updateImage(ALARM_RED);
            } else {
                this.updateImage(ALARM_GREEN);
            }
        } else if (this.unacked == 0 && this.acked > 0) {
            this.updateImage(ALARM_YELLOW);
        } else if (this.acked == 0 && this.unacked == 0) {
            this.updateImage(ALARM_WHITE);
        }
    }

    public void doHandleHyperlink(BMouseEvent event) {
        switch (event.getId()) {
            case 501: {
                this.fireHyperlink(this.lastAlarmHyperlink.getOrd());
            }
        }
    }

    public void fireHyperlink(BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        this.tool.onAlarmDialogHyperlink(this, ord);
    }

    public void setUncloseable(boolean uncloseable) {
        this.uncloseable = uncloseable;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        this.setAlwaysOnTop(this.title, alwaysOnTop);
        if (alwaysOnTop) {
            this.toTop(this.title);
        }
    }

    public void setFullyConnected(boolean fullyConnected) {
        this.fullyConnected = fullyConnected;
    }

    public native void setAlwaysOnTop(String var1, boolean var2);

    public native void toTop(String var1);

    public native int getPixel(int var1, int var2);

    public native void releaseNativeResources(String var1);
}

