/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import java.util.ArrayList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.gx.BFont;
import javax.baja.gx.Insets;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BIWbViewExporter;

public class BAlarmConsoleToPdf
extends BPdfExporter
implements BIWbViewExporter {
    public static final Property showAllColumns = BAlarmConsoleToPdf.newProperty((int)0, (boolean)false, null);
    public static final Property showOnlySelectedRows = BAlarmConsoleToPdf.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BAlarmConsoleToPdf.class);
    private BPdfFlowPane pane;
    private PdfDocument doc;
    private PdfOp op;
    private String msgTxt = null;
    private String notesTxt = null;
    private boolean showAlarmData = false;
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private static final int MAXSTR = 70;

    public boolean getShowAllColumns() {
        return this.getBoolean(showAllColumns);
    }

    public void setShowAllColumns(boolean v) {
        this.setBoolean(showAllColumns, v, null);
    }

    public boolean getShowOnlySelectedRows() {
        return this.getBoolean(showOnlySelectedRows);
    }

    public void setShowOnlySelectedRows(boolean v) {
        this.setBoolean(showOnlySelectedRows, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        this.op = op;
        BAlarmConsole console = (BAlarmConsole)op.get();
        TableModel model = console.sourceTable.getModel();
        TableSelection selection = console.sourceTable.getController().getSelection();
        BWidgetToPdf exporter = new BWidgetToPdf();
        this.doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        this.pane = new BPdfFlowPane();
        this.makeHeader(console.recipient);
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (this.getShowOnlySelectedRows() && (!this.getShowOnlySelectedRows() || !selection.isSelected(i))) continue;
            this.makeRecord(model, i);
        }
        this.pane.setupPane();
        exporter.renderDocument((BWidget)this.pane, this.doc, op);
    }

    private void makeHeader(BConsoleRecipient recipient) {
        BFont headerFont = BFont.make((String)lex.getText("alarmConsoleToPdf.font.reportHeader"));
        BFont normal = BFont.make((String)lex.getText("alarmConsoleToPdf.font.normal"));
        BLabel rec = new BLabel(lex.getText("alarmConsoleToPdf.header") + " " + recipient.getDisplayName((Context)this.op));
        rec.setHalign(BHalign.left);
        rec.setFont(headerFont);
        this.pane.add(null, (BValue)rec);
        BLabel ts = new BLabel(BAbsTime.now().toString((Context)this.op), normal, BHalign.left);
        this.pane.add(null, (BValue)ts);
    }

    private void makeRecord(TableModel model, int row) {
        this.notesTxt = null;
        this.msgTxt = null;
        BAlarmRecord record = (BAlarmRecord)model.getSubject(row);
        StringBuffer sb = new StringBuffer();
        BString src = (BString)record.getAlarmData().get("sourceName");
        if (src != null && src != BString.DEFAULT) {
            sb.append(BFormat.make((String)src.toString((Context)this.op)).format((Object)record));
        } else {
            sb.append(record.get(BAlarmRecord.source).toString((Context)this.op));
        }
        sb.append(" - ").append(record.getSourceState().toString((Context)this.op)).append(" / ");
        sb.append(record.getAckState().toString((Context)this.op));
        BLabel source = new BLabel(sb.toString(), BFont.make((String)lex.getText("alarmConsoleToPdf.font.source")), BHalign.left);
        source.setImage(model.getRowIcon(row));
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        this.buildColumnsAndValues(columnNames, values, model, row);
        if (this.showAlarmData) {
            BFacets alarmData = record.getAlarmData();
            String[] keys = alarmData.list();
            columnNames.add("");
            values.add("");
            for (int j = 0; j < keys.length; ++j) {
                String value = alarmData.get(keys[j]).toString((Context)this.op);
                if (keys[j].equals("notes")) {
                    this.notesTxt = value;
                    continue;
                }
                columnNames.add("Alarm Data (" + keys[j] + ")");
                if (keys[j].equals("msgText") && value.length() > 70) {
                    value = value.substring(0, 68) + "...";
                }
                values.add(value);
            }
        }
        BTable table = new BTable((TableModel)new Model(columnNames, values));
        this.pane.add(null, (BValue)new BLabel(""));
        this.pane.add(null, (BValue)source);
        this.pane.add(null, (BValue)table);
        if (this.msgTxt != null) {
            this.buildMultiLineLabels("Message", this.msgTxt, ' ');
        }
        if (this.notesTxt != null) {
            this.pane.add(null, (BValue)new BLabel(""));
            this.buildMultiLineLabels("Note", this.notesTxt, ' ');
        }
    }

    private void buildColumnsAndValues(ArrayList<String> columnNames, ArrayList<Object> values, TableModel model, int row) {
        if (this.getShowAllColumns()) {
            String[] colNames = model.getColumnNames();
            for (int i = 0; i < colNames.length; ++i) {
                String colName = colNames[i];
                if (colName.equals("Msg Text")) {
                    this.msgTxt = model.getRowValues(row)[i].toString();
                    if (this.msgTxt.length() > 70 || this.msgTxt.length() == 0) continue;
                    this.msgTxt = null;
                } else if (colName.equals("Alarm Data")) {
                    this.showAlarmData = true;
                    continue;
                }
                columnNames.add(colName);
                values.add(model.getRowValues(row)[i]);
            }
        } else {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                String colName = model.getColumnName(i);
                if (colName.equals("Msg Text")) {
                    this.msgTxt = model.getValueAt(row, i).toString();
                    if (this.msgTxt.length() > 70 || this.msgTxt.length() == 0) continue;
                    this.msgTxt = null;
                } else if (colName.equals("Alarm Data")) {
                    this.showAlarmData = true;
                    continue;
                }
                columnNames.add(colName);
                values.add(model.getValueAt(row, i));
            }
        }
    }

    private void buildMultiLineLabels(String name, String value, char sep) {
        if (value == null || value.length() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(name).append(":  ").append(value);
        BLabel[] lines = this.split(sb.toString(), sep);
        for (int i = 0; i < lines.length; ++i) {
            this.pane.add(null, (BValue)lines[i]);
        }
    }

    private BLabel[] split(String value, char sep) {
        BFont font = BFont.make((String)lex.getText("alarmConsoleToPdf.font.normal"));
        Insets m = this.doc.getMargins();
        double pageWidth = this.doc.getPageSize().width - m.right;
        ArrayList<BLabel> lines = new ArrayList<BLabel>();
        String working = value;
        while (font.width(working) > pageWidth) {
            int tempIndex;
            int splitIndex = working.indexOf(sep, 0);
            boolean hyphenate = false;
            if (splitIndex == -1 || font.width(working.substring(0, splitIndex)) > pageWidth) {
                hyphenate = true;
                tempIndex = 1;
                while (font.width(working.substring(0, tempIndex)) < pageWidth) {
                    ++tempIndex;
                }
                splitIndex = tempIndex - 2;
            } else {
                tempIndex = splitIndex;
                String temp = working.substring(0, splitIndex + 1);
                while (font.width(temp) < pageWidth && tempIndex != -1) {
                    splitIndex = tempIndex;
                    tempIndex = working.indexOf(sep, tempIndex + 1);
                    temp = working.substring(0, tempIndex + 1);
                }
            }
            String line = working.substring(0, splitIndex + 1);
            if (hyphenate) {
                line = line + "-";
            }
            working = working.substring(splitIndex + 1);
            lines.add(new BLabel(line, font, BHalign.left));
        }
        lines.add(new BLabel(working, font, BHalign.left));
        return lines.toArray(new BLabel[lines.size()]);
    }

    class Model
    extends TableModel {
        private String[] cols = new String[]{"Attribute", "Value"};
        private ArrayList<String> names = new ArrayList();
        private ArrayList<Object> values = new ArrayList();

        public Model(ArrayList<String> columnNames, ArrayList<Object> values) {
            this.names = columnNames;
            this.values = values;
        }

        public int getRowCount() {
            return this.names.size();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int col) {
            return this.cols[col];
        }

        public Object getValueAt(int row, int col) {
            return col == 0 ? this.names.get(row) : this.values.get(row);
        }
    }
}

