/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.pdf;

import com.tridium.alarm.ui.BAlarmDbView;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.PdfUtil;
import java.util.logging.Level;
import javax.baja.gx.BFont;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmDbView"})})
public class BPdfAlarmDbView
extends BPdfFlowPane {
    public static final Type TYPE = Sys.loadType(BPdfAlarmDbView.class);
    private static Lexicon bqlLex = Lexicon.make((String)"bql");
    private static Lexicon pdfLex = Lexicon.make((String)"pdf");

    public Type getType() {
        return TYPE;
    }

    public void fromWidget(BWidget widget, PdfOp op) {
        BDynamicTimeRange alarmDbRange;
        if (!(widget instanceof BAlarmDbView)) {
            return;
        }
        BAlarmDbView alarmDb = (BAlarmDbView)widget;
        alarmDb.doQuery();
        try {
            alarmDbRange = alarmDb.getRange();
        }
        catch (Exception e) {
            PdfUtil.log.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        BLabel name = new BLabel(alarmDb.getTypeDisplayName(null));
        BLabel range = new BLabel(BPdfAlarmDbView.getRangeStr(alarmDbRange, (Context)op));
        name.setFont(BFont.make((String)pdfLex.getText("pdf.propertySheetToPdf.font")));
        name.setHalign(BHalign.left);
        range.setHalign(BHalign.left);
        TableModel model = alarmDb.getTable().getModel();
        BTable table = new BTable((TableModel)new Model(model));
        this.add(null, (BValue)name);
        this.add(null, (BValue)range);
        this.add(null, (BValue)new BLabel(""));
        this.add(null, (BValue)table);
        this.setupPane();
    }

    private static String getRangeStr(BDynamicTimeRange range, Context cx) {
        BAbsTime now = BAbsTime.now();
        BTimeZone timeZone = range.getFixedStartTime().getTimeZone();
        BAbsTime start = range.getStartTime(now, timeZone);
        BAbsTime end = range.getEndTime(now, timeZone);
        StringBuilder s = new StringBuilder();
        if (start == null || start.isNull()) {
            s.append(bqlLex.getText("dynamicTimeRangeFE.epoch"));
        } else {
            s.append(start.toString(cx));
            s.append("  ").append(bqlLex.getText("dynamicTimeRangeFE.to")).append("  ");
        }
        if (end == null || end.isNull()) {
            s.append(bqlLex.getText("dynamicTimeRangeFE.now"));
        } else {
            s.append(end.toString(cx));
        }
        return s.toString();
    }

    class Model
    extends TableModel {
        TableModel orig;

        Model(TableModel orig) {
            this.orig = orig;
        }

        public int getColumnCount() {
            return this.orig.getColumnCount();
        }

        public int getRowCount() {
            return this.orig.getRowCount();
        }

        public String getColumnName(int col) {
            return this.orig.getColumnName(col);
        }

        public Object getValueAt(int row, int col) {
            return this.orig.getValueAt(row, col);
        }
    }
}

