/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.tridium.authn.ScramServerCallback;
import com.tridium.authn.UserKeyFactory;
import com.tridium.gauth.BGoogleAuthenticationScheme;
import com.tridium.net.HttpUtil;
import com.tridium.nre.auth.NiagaraStationAlgorithmBundle;
import com.tridium.nre.auth.ScramAlgorithmBundle;
import com.tridium.nre.auth.ScramServer;
import com.tridium.web.session.WebSessionUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"gauth:GoogleAuthenticationScheme"})})
public class BWebGoogleAuthCallbackHandler
extends BWebCallbackHandler {
    public static final Type TYPE = Sys.loadType(BWebGoogleAuthCallbackHandler.class);
    public static final String ACTION_CLIENT_FIRST_MESSAGE = "sendClientFirstMessage";
    public static final String ACTION_CLIENT_FINAL_MESSAGE = "sendClientFinalMessage";
    public static final String KEY_CLIENT_FIRST_MESSAGE = "clientFirstMessage";
    public static final String KEY_CLIENT_FINAL_MESSAGE = "clientFinalMessage";
    private ScramServer scramServer = null;
    private String username = null;
    private boolean finalRequest = false;
    private String token = null;

    public Type getType() {
        return TYPE;
    }

    public int handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] pairs;
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.finalRequest) {
            return 0;
        }
        if (req.getContentType() == null || !req.getContentType().startsWith("application/x-niagara-login-support")) {
            return 3;
        }
        byte[] buf = new byte[req.getContentLength()];
        DataInputStream in = new DataInputStream((InputStream)req.getInputStream());
        in.readFully(buf);
        String contents = new String(buf);
        for (String pair : pairs = TextUtil.split((String)contents, (char)'&')) {
            int index = pair.indexOf(61);
            String key = pair.substring(0, index);
            String value = pair.substring(index + 1);
            params.put(HttpUtil.decodeUrl((String)key), BWebGoogleAuthCallbackHandler.decodeValue(key, value));
        }
        if (((String)params.get("action")).equals(ACTION_CLIENT_FIRST_MESSAGE)) {
            String clientFirstMessage = (String)params.get(KEY_CLIENT_FIRST_MESSAGE);
            this.scramServer = new ScramServer((ScramAlgorithmBundle)NiagaraStationAlgorithmBundle.getInstance(), (ScramServer.IUserKeyFactory)new UserKeyFactory(BGoogleAuthenticationScheme.TYPE));
            this.username = ScramServer.extractUsername((String)clientFirstMessage);
            String serverFirstMessage = this.scramServer.createServerFirstMessage(clientFirstMessage);
            WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
            resp.setStatus(200);
            resp.setContentType("text/plain");
            resp.getWriter().print(serverFirstMessage);
            resp.getWriter().flush();
            return 1;
        }
        if (((String)params.get("action")).equals(ACTION_CLIENT_FINAL_MESSAGE)) {
            String clientFinalMessage = (String)params.get(KEY_CLIENT_FINAL_MESSAGE);
            if (this.scramServer == null) {
                throw new AuthenticationException("CallbackHandler in incorrect state");
            }
            String serverFinalMessage = null;
            try {
                serverFinalMessage = this.scramServer.createServerFinalMessage(clientFinalMessage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            resp.setStatus(200);
            resp.setContentType("text/plain");
            resp.getWriter().print(serverFinalMessage);
            resp.getWriter().flush();
            return 1;
        }
        if (((String)params.get("action")).equals("sendGoogleToken")) {
            this.token = (String)params.get("token");
            this.finalRequest = true;
            return 1;
        }
        resp.sendError(400);
        return 1;
    }

    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof ScramServerCallback) {
                ((ScramServerCallback)callback).setServer(this.scramServer);
                ((ScramServerCallback)callback).setUsername(this.username);
                continue;
            }
            if (callback instanceof TextInputCallback) {
                ((TextInputCallback)callback).setText(this.token);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
    }

    private static String decodeValue(String key, String value) {
        if (key.equals(KEY_CLIENT_FIRST_MESSAGE) || key.equals(KEY_CLIENT_FINAL_MESSAGE)) {
            return value;
        }
        return HttpUtil.decodeUrl((String)value);
    }
}

