/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.tridium.web.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.BILoginHTMLForm;

@NiagaraType(agent={@AgentOn(types={"gauth:GoogleAuthenticationScheme"})})
public class BGoogleAuthLoginHTMLForm
extends BStruct
implements BILoginHTMLForm {
    public static final Type TYPE = Sys.loadType(BGoogleAuthLoginHTMLForm.class);
    private static final BOrd TEMPLATE_ORD = BOrd.make((String)"module://gauth/com/tridium/gauth/rc/googleAuthLoginFormN4.vm");
    private static final BOrd RESET_TEMPLATE_ORD = BOrd.make((String)"module://web/com/tridium/web/rc/passwordResetFormN4.vm");

    public Type getType() {
        return TYPE;
    }

    public String getLoginFormHTML(Context context, boolean passwordReset) throws IOException {
        if (context == null) {
            context = new BasicContext();
        }
        Lexicon webLex = Lexicon.make((String)"web", (Locale)new Locale(context.getLanguage()));
        Lexicon lex = Lexicon.make((String)"gauth", (Locale)new Locale(context.getLanguage()));
        String username = this.getLabel(context, "login.username", webLex);
        String password = this.getLabel(context, "login.password", webLex);
        String token = this.getLabel(context, "auth.token", lex);
        String login = this.getLabel(context, "login", webLex);
        String newPass = this.getLabel(context, "login.password.new", webLex);
        String confirm = this.getLabel(context, "login.password.new.retype", webLex);
        String changeuser = this.getLabel(context, "login.changeuser", webLex);
        BString initUsername = (BString)context.getFacet("initUsername");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("login", login);
        map.put("userName", username);
        map.put("password", password);
        map.put("token", token);
        map.put("new", newPass);
        map.put("confirm", confirm);
        map.put("changeUser", changeuser);
        if (initUsername != null) {
            map.put("initUsername", initUsername.getString());
        } else {
            map.put("initUsername", "");
        }
        String form = passwordReset ? Template.process((BOrd)RESET_TEMPLATE_ORD, (boolean)true) : Template.process((BOrd)TEMPLATE_ORD, (boolean)true);
        String processedForm = Template.process(map, (String)form);
        return processedForm;
    }

    private String getLabel(Context context, String key, Lexicon lex) {
        BString bString = (BString)context.getFacet(key);
        if (bString != null) {
            return bString.getString();
        }
        return lex.getHtmlSafe(key);
    }
}

