/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.tridium.authn.ScramServerCallback;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.util.FoxScramShaUtil;
import com.tridium.gauth.BGoogleAuthenticationScheme;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.fox.authn.BFoxCallbackHandler;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraType(agent={@AgentOn(types={"gauth:GoogleAuthenticationScheme"})})
public class BFoxGoogleAuthCallbackHandler
extends BFoxCallbackHandler {
    public static final Type TYPE = Sys.loadType(BFoxGoogleAuthCallbackHandler.class);
    String username = null;
    private String token = null;

    public Type getType() {
        return TYPE;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ScramServerCallback scramCallback = null;
        TextInputCallback tokenCallback = null;
        for (Callback callback : callbacks) {
            if (callback instanceof ScramServerCallback) {
                scramCallback = (ScramServerCallback)callback;
                continue;
            }
            if (callback instanceof TextInputCallback) {
                tokenCallback = (TextInputCallback)callback;
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
        if (scramCallback != null) {
            this.username = FoxScramShaUtil.handleScramServerCallback((FoxSession)this.session, scramCallback, (Type)BGoogleAuthenticationScheme.TYPE);
            if (tokenCallback != null && scramCallback.getServer().isAuthenticated()) {
                try {
                    this.session.setState("server.tune receive authToken");
                    FoxMessage in = this.session.receiveTuning("authToken");
                    this.token = in.getString("authToken");
                    tokenCallback.setText(this.token);
                }
                catch (Exception e) {
                    Logger.getLogger("authentication").warning("Could not authenticate: " + e.getLocalizedMessage());
                    AuthenticationUtil.debug((Level)Level.WARNING, (String)("Callback error with " + tokenCallback.getClass().getName()), (Throwable)e);
                }
            }
        }
    }

    public String getUsername() {
        return this.username;
    }
}

