/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BRemoteModuleList;
import com.tridium.platDaemon.ui.softwaremanager.BSoftwareManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.baja.platform.ICancelHint;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class ImportFromPlatformCommand
extends AsyncCommand {
    private BSoftwareManager installer;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    public static final Logger logger = Logger.getLogger("platform");

    public ImportFromPlatformCommand(BSoftwareManager owner, String label) {
        super((BWidget)owner, label);
        this.installer = owner;
    }

    public ImportFromPlatformCommand(BSoftwareManager owner) {
        this(owner, lex.get("SoftwareManager.command.importPlatform.label"));
    }

    public void doInvokeAsync() {
        try {
            BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)this.installer.getDaemonSession(), (DaemonSessionTaskListener)this.getInstaller());
            BRemoteModuleList remoteModules = (BRemoteModuleList)platform.getModuleList();
            BWbShell shell = BWbShell.getWbShell((BWidget)this.installer);
            if (shell != null) {
                shell.enterBusy();
            }
            AtomicLong totalSize = new AtomicLong(0L);
            long unregisteredCount = remoteModules.getUnregisteredModules((DaemonSessionTaskListener)this.getInstaller()).peek(module -> totalSize.getAndAdd(module.getInstallableFileSize())).count();
            if (unregisteredCount > 0L) {
                if (4 == BDialog.confirm((BWidget)this.installer, (String)lex.getText("SoftwareManager.platformImport.importModules.title"), (Object)lex.getText("SoftwareManager.platformImport.importModules.message", new Object[]{unregisteredCount, totalSize.get() / 1024L}))) {
                    remoteModules.importUnregisteredModules((DaemonSessionTaskListener)this.installer, (ICancelHint)this.installer);
                }
            } else {
                BDialog.message((BWidget)this.installer, (String)lex.getText("SoftwareManager.platformImport.importModules.title"), (Object)lex.getText("SoftwareManager.platformImport.noImports"));
            }
            if (shell != null) {
                shell.exitBusy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BSoftwareManager getInstaller() {
        return this.installer;
    }

    public void setInstaller(BSoftwareManager installer) {
        this.installer = installer;
    }
}

