/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.platDaemon.ui.softwaremanager.BSoftwareManagerFilter;
import com.tridium.platDaemon.ui.softwaremanager.BStatusFilter;
import com.tridium.ui.BOptionDialog;
import java.util.HashSet;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BGridPane;

public class BInstallerTableFilterPrompt
extends BGridPane {
    public static final Type TYPE = Sys.loadType(BInstallerTableFilterPrompt.class);
    private BCheckList statusCheckList;
    private BTextField installableNameTextField;
    private BRadioButton includeButton;

    public Type getType() {
        return TYPE;
    }

    private BInstallerTableFilterPrompt(BSoftwareManagerFilter currentValue) {
        super(1);
        int i;
        BGridPane innerGrid = new BGridPane(3);
        innerGrid.setRowGap(6.0);
        innerGrid.setColumnAlign(BHalign.fill);
        if (currentValue == null) {
            currentValue = new BSoftwareManagerFilter();
        }
        this.statusCheckList = new BCheckList();
        this.statusCheckList.setModel((ListModel)new StatusListModel());
        ListSelection sel = this.statusCheckList.getSelection();
        String[] selectedStrings = currentValue.getStatusFilter().getStatusStrings();
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < selectedStrings.length; ++i) {
            set.add(selectedStrings[i]);
        }
        for (i = 0; i < this.statusCheckList.getItemCount(); ++i) {
            String item = (String)this.statusCheckList.getItem(i);
            if (!set.contains(item)) continue;
            sel.select(i);
        }
        BButton allButton = new BButton((Command)new CheckAllCommand());
        BButton clearButton = new BButton((Command)new ClearCommand());
        innerGrid.add(null, (BValue)new BCheckBox((ToggleCommand)new EnableCommand(new BWidget[]{this.statusCheckList, allButton, clearButton}, currentValue.getStatusFilter().getIsEnabled(), "InstallerTableFilterPrompt.enableStatus")));
        innerGrid.add(null, (BValue)this.statusCheckList);
        BGridPane buttonGrid = new BGridPane(1);
        buttonGrid.setColumnAlign(BHalign.fill);
        buttonGrid.setHalign(BHalign.left);
        buttonGrid.add(null, (BValue)allButton);
        buttonGrid.add(null, (BValue)clearButton);
        innerGrid.add(null, (BValue)buttonGrid);
        this.installableNameTextField = new BTextField(currentValue.getNameFilter().getPattern());
        ToggleCommandGroup commandGroup = new ToggleCommandGroup();
        buttonGrid = new BGridPane(1);
        ToggleCommand cmd = new IncludeCommand();
        this.includeButton = new BRadioButton(cmd);
        buttonGrid.add(null, (BValue)this.includeButton);
        commandGroup.add(cmd);
        cmd.setSelected(!currentValue.getNameFilter().getExclude());
        cmd = new ExcludeCommand();
        BRadioButton excludeButton = new BRadioButton(cmd);
        buttonGrid.add(null, (BValue)excludeButton);
        commandGroup.add(cmd);
        cmd.setSelected(currentValue.getNameFilter().getExclude());
        innerGrid.add(null, (BValue)new BCheckBox((ToggleCommand)new EnableCommand(new BWidget[]{this.installableNameTextField, this.includeButton, excludeButton}, currentValue.getNameFilter().getIsEnabled(), "InstallerTableFilterPrompt.enableName")));
        innerGrid.add(null, (BValue)this.installableNameTextField);
        innerGrid.add(null, (BValue)buttonGrid);
        this.add(null, (BValue)innerGrid);
    }

    public static BSoftwareManagerFilter getFilter(BWidget parent, BSoftwareManagerFilter currentValue) {
        BInstallerTableFilterPrompt prompt = new BInstallerTableFilterPrompt(currentValue);
        BOptionDialog dlg = new BOptionDialog(parent, TYPE.getModule().getLexicon().getText("InstallerTableFilterPrompt.dlgTitle"), (BWidget)prompt, 3, null, null);
        dlg.getOkButton().setText(TYPE.getModule().getLexicon().getText("InstallerTableFilterPrompt.applyButton"));
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        if (dlg.getResult() == 1) {
            return prompt.getFilter();
        }
        return null;
    }

    protected BSoftwareManagerFilter getFilter() {
        BSoftwareManagerFilter result = new BSoftwareManagerFilter();
        result.getStatusFilter().setIsEnabled(this.statusCheckList.isEnabled());
        for (int i = 0; i < this.statusCheckList.getItemCount(); ++i) {
            if (!this.statusCheckList.getSelection().isSelected(i)) continue;
            result.getStatusFilter().include(BStatusFilter.stringToStatus(this.statusCheckList.getItem(i).toString()));
        }
        result.getNameFilter().setIsEnabled(this.installableNameTextField.isEnabled());
        result.getNameFilter().setPattern(this.installableNameTextField.getText());
        result.getNameFilter().setExclude(!this.includeButton.isSelected());
        result.setIsEnabled(result.getStatusFilter().getIsEnabled() || result.getNameFilter().getIsEnabled());
        return result;
    }

    private class StatusListModel
    extends ListModel {
        private String[] strings = BStatusFilter.getAvailableStrings();

        public int getItemCount() {
            return this.strings.length;
        }

        public Object getItem(int row) {
            return this.strings[row];
        }
    }

    private class ExcludeCommand
    extends ToggleCommand {
        public ExcludeCommand() {
            super((BWidget)BInstallerTableFilterPrompt.this, TYPE.getModule(), "InstallerTableFilterPrompt.ExcludeCommand");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private class IncludeCommand
    extends ToggleCommand {
        public IncludeCommand() {
            super((BWidget)BInstallerTableFilterPrompt.this, TYPE.getModule(), "InstallerTableFilterPrompt.IncludeCommand");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private class ClearCommand
    extends Command {
        public ClearCommand() {
            super((BWidget)BInstallerTableFilterPrompt.this, TYPE.getModule(), "InstallerTableFilterPrompt.ClearCommand");
        }

        public CommandArtifact doInvoke() {
            BInstallerTableFilterPrompt.this.statusCheckList.getSelection().deselectAll();
            return null;
        }
    }

    private class CheckAllCommand
    extends Command {
        public CheckAllCommand() {
            super((BWidget)BInstallerTableFilterPrompt.this, TYPE.getModule(), "InstallerTableFilterPrompt.CheckAllCommand");
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < BInstallerTableFilterPrompt.this.statusCheckList.getItemCount(); ++i) {
                BInstallerTableFilterPrompt.this.statusCheckList.getSelection().select(i);
            }
            return null;
        }
    }

    private class EnableCommand
    extends ToggleCommand {
        private BWidget[] widgets;

        public EnableCommand(BWidget[] pWidgets, boolean initialState, String lexTag) {
            super((BWidget)BInstallerTableFilterPrompt.this, TYPE.getModule(), lexTag);
            this.widgets = pWidgets;
            this.setSelected(initialState);
            this.invoke();
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < this.widgets.length; ++i) {
                this.widgets[i].setEnabled(this.isSelected());
            }
            return null;
        }
    }
}

