/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.licenseinstall;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.ReloadLicenseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Properties;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;

@NiagaraType
public class BLicenseList
extends BList {
    public static final Type TYPE = Sys.loadType(BLicenseList.class);
    public static final IFileFilter importFilter = new ExtFileFilter("TODO", "license,lar");
    public static final IFileFilter filter = new ExtFileFilter("TODO", "license");
    public static final IFileFilter larFilter = new ExtFileFilter("TODO", "lar");
    public static final IFilePathFilter larPathFilter = new ExtPathFilter("lar");
    private final Validator validator;
    private final AsyncCommand deleteCommand;
    private final Command viewCommand;
    private BLicenseManager manager;
    private BDaemonSession session;

    public Type getType() {
        return TYPE;
    }

    public BLicenseList() {
        this.setModel(new Model());
        this.validator = new Validator();
        this.setPasteEnabled(true);
        this.deleteCommand = new DeleteFileCommand();
        this.viewCommand = new ViewFileCommand();
    }

    public CommandArtifact doDelete() throws Exception {
        this.deleteCommand.invoke();
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        BObject[] vals;
        Mark mark = Mark.getCurrent();
        if (mark != null && (vals = mark.getValues())[0] instanceof BIFile && importFilter.accept((BIFile)vals[0]) && this.validator.accept((BIFile)vals[0])) {
            this.transferFile((BIFile)vals[0]);
        }
        return null;
    }

    public IFileFilter getValidator() {
        return this.validator;
    }

    public int dragOver(TransferContext cx) {
        Mark mark;
        if (cx.getEnvelope().supports(TransferFormat.mark) && (mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark)).getValues()[0] instanceof BIFile && importFilter.accept((BIFile)mark.getValues()[0])) {
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        if (mark.getValues()[0] instanceof BIFile && importFilter.accept((BIFile)mark.getValues()[0]) && this.validator.accept((BIFile)mark.getValues()[0])) {
            this.transferFile((BIFile)mark.getValues()[0]);
        }
        return null;
    }

    public Command getDeleteCommand() {
        return this.deleteCommand;
    }

    public Command getViewCommand() {
        return this.viewCommand;
    }

    public void loadValue(BDaemonSession session, BLicenseManager manager) throws AuthenticationException {
        this.manager = manager;
        this.session = session;
        ((Model)this.getModel()).loadValue();
    }

    public LicenseInfo getLicenseInfo(int index) {
        return ((Model)this.getModel()).getLicenseInfo(index);
    }

    public FilePath getFilePath(int index) {
        return ((Model)this.getModel()).getFilePath(index);
    }

    public String getFileName(int index) {
        return ((Model)this.getModel()).getFileName(index);
    }

    public long getFileSize(int index) {
        return ((Model)this.getModel()).getFileSize(index);
    }

    public String getFileContents(int index) {
        return ((Model)this.getModel()).getFileContents(index);
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public String getHostId() {
        return this.getDaemonSession().getHostProperties().getHostId();
    }

    public String getBrandId() {
        return ((Model)this.getModel()).getBrandId();
    }

    public synchronized LicenseInfo[] getLicenses() throws Exception {
        Model model = (Model)this.getModel();
        LicenseInfo[] result = new LicenseInfo[model.getItemCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = model.getLicenseInfo(i);
        }
        return result;
    }

    public void transferFile(BIFile file) throws Exception {
        LicenseInfo[] toInstall = PortalLicenseUtil.getLicenseInfo((BIFile)file, (String)this.getHostId(), (String)this.getBrandId());
        LicenseInfo[] installed = this.getLicenses();
        LicenseSync sync = PortalLicenseUtil.syncLicenses((String)this.getHostId(), (LicenseInfo[])installed, (LicenseInfo[])toInstall);
        this.manager.sync((LicenseSync<LicenseInfo>)sync, null);
    }

    public boolean deleteFiles(int[] indices) throws AuthenticationException {
        try {
            if (this.session == null) {
                return false;
            }
            FileTransferMessage msg = new FileTransferMessage((BDaemonFileSpace)this.session.getFileSpace());
            for (int index : indices) {
                msg.addDelete(((Model)this.getModel()).getFilePath(index));
            }
            if (DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)msg, null, (DaemonSessionTaskListener)this.manager)) {
                this.loadValue(this.session, this.manager);
                this.getSelection().deselectAll();
                this.session.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
                return true;
            }
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
        return false;
    }

    public boolean deleteFile(int index) throws AuthenticationException {
        try {
            if (this.session == null) {
                return false;
            }
            if (DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)((Model)this.getModel()).getFilePath(index), (BDaemonFileSpace)this.session.getFileSpace()), null, (DaemonSessionTaskListener)this.manager)) {
                this.loadValue(this.session, this.manager);
                this.getSelection().deselectAll();
                this.session.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
                return true;
            }
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
        return false;
    }

    private class Validator
    implements IFileFilter {
        private Validator() {
        }

        public boolean accept(BIFile file) {
            try {
                if (file instanceof BLicenseFile) {
                    LicenseInfo license = new LicenseInfo(file);
                    if (BLicenseList.this.getHostId().equals(license.vendorLicense.getHostId())) {
                        if (BLicenseList.this.getBrandId() != null && license.vendorLicense.getBrandId() != null && !BLicenseList.this.getBrandId().equals(license.vendorLicense.getBrandId())) {
                            BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.cantChangeBrand.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.cantChangeBrand.message", new Object[]{license}));
                            return false;
                        }
                        if (license.allowsLocalWbAccess()) {
                            return true;
                        }
                        BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.message", new Object[]{file.getFilePath().getBody()}));
                        return false;
                    }
                    BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.badHostId.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.badHostId.message"));
                    return false;
                }
                if (file instanceof BLicenseArchiveFile) {
                    int nUpdates = 0;
                    for (VendorLicense lic : ((BLicenseArchiveFile)file).getLicenses(BLicenseList.this.getHostId())) {
                        if (BLicenseList.this.getBrandId() != null && lic.getBrandId() != null && !BLicenseList.this.getBrandId().equals(lic.getBrandId())) continue;
                        LicenseInfo license = new LicenseInfo(lic, file);
                        if (!license.allowsLocalWbAccess()) {
                            BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.message", new Object[]{license}));
                            return false;
                        }
                        ++nUpdates;
                    }
                    if (nUpdates == 0) {
                        BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.noHostLicenses.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.noHostLicenses.message"));
                        return false;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platDaemon", "LicenseManager.addLicenseException", (Throwable)e);
            }
        }

        public String getDescription(Context cx) {
            return "TODO";
        }
    }

    private static class Row {
        public LicenseInfo licenseInfo;

        public Row(VendorLicense pLicense, BIFile pFile) throws Exception {
            this.licenseInfo = new LicenseInfo(pLicense, pFile);
            LicenseDatabase.LOCAL_INSTANCE.add(pLicense);
        }
    }

    public class Model
    extends ListModel {
        private final Array<Row> rows = new Array(Row.class);
        private String brandId = null;

        public int getItemCount() {
            return this.rows.size();
        }

        public Object getItem(int index) {
            if (this.getLicenseInfo((int)index).vendorLicense.getHostId().equals(BLicenseList.this.getHostId())) {
                return this.getLicenseInfo(index).toString();
            }
            return this.getLexicon().getText("LicenseManager.badHostId.label", new Object[]{this.getLicenseInfo((int)index).vendorLicense.getVendor()});
        }

        public Row getRow(int index) {
            return (Row)this.rows.get(index);
        }

        public BIFile getFile(int index) {
            return this.getRow((int)index).licenseInfo.file;
        }

        public String getFileName(int index) {
            return this.getFile(index).getFileName();
        }

        public FilePath getFilePath(int index) {
            return this.getFile(index).getFilePath();
        }

        public long getFileSize(int index) {
            return this.getFile(index).getSize();
        }

        public LicenseInfo getLicenseInfo(int index) {
            return this.getRow((int)index).licenseInfo;
        }

        public String getFileContents(int index) {
            if (BLicenseList.this.session == null) {
                return "";
            }
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                this.getLicenseInfo((int)index).vendorLicense.save((OutputStream)bytes);
                return bytes.toString();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public void loadValue() throws AuthenticationException {
            block17: {
                try {
                    BIFile brandProps;
                    this.rows.clear();
                    this.brandId = null;
                    BDirectory dir = (BDirectory)BLicenseList.this.session.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath((boolean)BLicenseList.this.session.getHostProperties().isNiagara4()));
                    if (dir != null) {
                        for (BIFile file : dir.listFiles()) {
                            VendorLicense lic;
                            if (!(file instanceof BLicenseFile) || !(lic = VendorLicense.make((BIFile)file)).getHostId().equals(BLicenseList.this.getHostId()) || lic.getBrandId() != null && this.brandId != null && !lic.getBrandId().equals(this.brandId)) continue;
                            this.rows.add((Object)new Row(lic, file));
                            if (this.brandId != null) continue;
                            this.brandId = lic.getBrandId();
                        }
                    }
                    if (this.brandId != null || (brandProps = BLicenseList.this.session.getFileSpace().findFile(SystemFilePaths.getBrandPropsPath((boolean)BLicenseList.this.session.getHostProperties().isNiagara4()))) == null) break block17;
                    Properties props = new Properties();
                    try (InputStream in = brandProps.getInputStream();){
                        props.load(in);
                        this.brandId = props.getProperty("brand.id", null);
                    }
                }
                catch (AuthenticationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    BDaemonSessionView.log.log(Level.SEVERE, "error loading file list", e);
                }
            }
            this.updateList();
        }

        public String getBrandId() {
            return this.brandId;
        }

        private Lexicon getLexicon() {
            return BDaemonSessionView.TYPE.getModule().getLexicon();
        }
    }

    private class ViewFileCommand
    extends Command {
        public ViewFileCommand() {
            super((BWidget)BLicenseList.this, TYPE.getModule(), "LicenseManager.view");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                int ix = BLicenseList.this.getSelectedIndex();
                BDialog.message((BWidget)BLicenseList.this, (String)BLicenseList.this.getFileName(ix), (Object)new BTextEditorPane(BLicenseList.this.getFileContents(ix), 20, 80, false));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class DeleteFileCommand
    extends AsyncCommand {
        public DeleteFileCommand() {
            super((BWidget)BLicenseList.this, TYPE.getModule(), "LicenseManager.delete");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                if (BLicenseList.this.session.getHostProperties().getIsLicenseReadonly()) {
                    throw new LocalizableRuntimeException("platDaemon", "LicenseManager.readonlyLicenses");
                }
                int[] ix = BLicenseList.this.getSelectedIndices();
                if (4 == BDialog.confirm((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.delete.confirmTitle"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.delete.confirmMessage"))) {
                    BLicenseList.this.deleteFiles(ix);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }
}

