/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.licenseinstall;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.daemon.message.ReloadLicenseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;

@NiagaraType
public class BCertList
extends BList {
    public static final Type TYPE = Sys.loadType(BCertList.class);
    public static final IFileFilter filter = new ExtFileFilter("TODO", "certificate");
    private final AsyncCommand deleteCommand;
    private final Command viewCommand;
    private BLicenseManager manager;
    private BDaemonSession session;

    public Type getType() {
        return TYPE;
    }

    public BCertList() {
        super((ListModel)new Model());
        this.setPasteEnabled(true);
        this.deleteCommand = new DeleteFileCommand();
        this.viewCommand = new ViewFileCommand();
    }

    public CommandArtifact doDelete() throws Exception {
        this.deleteCommand.invoke();
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        BObject[] vals;
        Mark mark = Mark.getCurrent();
        if (mark != null && (vals = mark.getValues())[0] instanceof BIFile && filter.accept((BIFile)vals[0]) && filter.accept((BIFile)vals[0])) {
            this.transferFile((BIFile)vals[0]);
        }
        return null;
    }

    public int dragOver(TransferContext cx) {
        Mark mark;
        if (cx.getEnvelope().supports(TransferFormat.mark) && (mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark)).getValues()[0] instanceof BIFile && filter.accept((BIFile)mark.getValues()[0])) {
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        if (mark.getValues()[0] instanceof BIFile && filter.accept((BIFile)mark.getValues()[0]) && filter.accept((BIFile)mark.getValues()[0])) {
            this.transferFile((BIFile)mark.getValues()[0]);
        }
        return null;
    }

    public Command getDeleteCommand() {
        return this.deleteCommand;
    }

    public Command getViewCommand() {
        return this.viewCommand;
    }

    public String getFileName(int index) {
        return ((Model)this.getModel()).getFileName(index);
    }

    public long getFileSize(int index) {
        return ((Model)this.getModel()).getFileSize(index);
    }

    public FilePath getFilePath(int index) {
        return ((Model)this.getModel()).getFilePath(index);
    }

    public void transferFile(BIFile file) throws Exception {
        CertificateInfo[] toInstall = new CertificateInfo[]{new CertificateInfo(file)};
        CertificateInfo[] installed = this.getCertificates();
        LicenseSync sync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installed, (CertificateInfo[])toInstall);
        this.manager.sync(null, (LicenseSync<CertificateInfo>)sync);
    }

    public boolean deleteFiles(int[] indices) throws AuthenticationException {
        return ((Model)this.getModel()).deleteFiles(indices);
    }

    public boolean deleteFile(int index) throws AuthenticationException {
        return ((Model)this.getModel()).deleteFile(index);
    }

    public String getFileContents(int index) {
        return ((Model)this.getModel()).getFileContents(index);
    }

    public void loadValue(BDaemonSession session, BLicenseManager manager) throws AuthenticationException {
        this.manager = manager;
        this.session = session;
        ((Model)this.getModel()).loadValue(session, manager);
    }

    public synchronized CertificateInfo[] getCertificates() throws Exception {
        Model model = (Model)this.getModel();
        CertificateInfo[] result = new CertificateInfo[model.getItemCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = model.getCert(i);
        }
        return result;
    }

    private static class Row {
        public BIFile file;
        public CertificateInfo cert;

        public Row(BIFile pFile) throws Exception {
            this.file = pFile;
            this.cert = new CertificateInfo(pFile);
        }
    }

    public static class Model
    extends ListModel {
        private final Array<Row> rows = new Array(Row.class);
        private BDaemonSession session;
        private BLicenseManager manager;

        public int getItemCount() {
            return this.rows.size();
        }

        public Object getItem(int index) {
            return this.getCert(index);
        }

        public String getFileName(int index) {
            return this.getFile(index).getFileName();
        }

        public long getFileSize(int index) {
            return this.getFile(index).getSize();
        }

        public FilePath getFilePath(int index) {
            return this.getFile(index).getFilePath();
        }

        public InputStream getFileContentStream(int index) throws AuthenticationException {
            try {
                return this.session.getInputStream((DaemonMessage)new GetFileMessage(this.getFilePath(index), (BDaemonFileSpace)this.session.getFileSpace()));
            }
            catch (ConnectException ce) {
                return null;
            }
        }

        public boolean deleteFiles(int[] indices) throws AuthenticationException {
            try {
                if (this.session == null) {
                    return false;
                }
                FileTransferMessage msg = new FileTransferMessage((BDaemonFileSpace)this.session.getFileSpace());
                for (int indice : indices) {
                    msg.addDelete(this.getFilePath(indice));
                }
                if (DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)msg, null, (DaemonSessionTaskListener)this.manager)) {
                    this.loadValue(this.session, this.manager);
                    this.getSelection().deselectAll();
                    this.session.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                    BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
                    return true;
                }
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            return false;
        }

        public boolean deleteFile(int index) throws AuthenticationException {
            try {
                if (this.session == null) {
                    return false;
                }
                if (DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)this.getFilePath(index), (BDaemonFileSpace)this.session.getFileSpace()), null, (DaemonSessionTaskListener)this.manager)) {
                    this.loadValue(this.session, this.manager);
                    this.getSelection().deselectAll();
                    this.session.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                    BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
                    return true;
                }
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            return false;
        }

        public Row getRow(int index) {
            return (Row)this.rows.get(index);
        }

        public CertificateInfo getCert(int index) {
            return this.getRow((int)index).cert;
        }

        public BIFile getFile(int index) {
            return this.getRow((int)index).file;
        }

        public String getFileContents(int index) {
            if (this.session == null) {
                return "";
            }
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                this.getCert((int)index).vendorCertificate.save((OutputStream)bytes);
                return bytes.toString();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public void loadValue(BDaemonSession session, BLicenseManager manager) throws AuthenticationException {
            this.session = session;
            this.manager = manager;
            try {
                this.rows.clear();
                BDirectory dir = (BDirectory)session.getFileSpace().findFile(SystemFilePaths.getCertificatesDirPath((BIFileSpace)session.getFileSpace()));
                if (dir != null) {
                    BIFile[] files;
                    for (BIFile file : files = dir.listFiles()) {
                        if (!filter.accept(file)) continue;
                        this.rows.add((Object)new Row(file));
                    }
                }
            }
            catch (AuthenticationException ae) {
                throw ae;
            }
            catch (Exception e) {
                BDaemonSessionView.log.log(Level.SEVERE, "error loading file list", e);
            }
            this.updateList();
        }
    }

    private class ViewFileCommand
    extends Command {
        public ViewFileCommand() {
            super((BWidget)BCertList.this, TYPE.getModule(), "LicenseManager.view");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                int ix = BCertList.this.getSelectedIndex();
                BDialog.message((BWidget)BCertList.this, (String)BCertList.this.getFileName(ix), (Object)new BTextEditorPane(BCertList.this.getFileContents(ix), 20, 80, false));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class DeleteFileCommand
    extends AsyncCommand {
        public DeleteFileCommand() {
            super((BWidget)BCertList.this, TYPE.getModule(), "LicenseManager.delete");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                if (BCertList.this.session.getHostProperties().getIsLicenseReadonly()) {
                    throw new LocalizableRuntimeException("platDaemon", "LicenseManager.readonlyCertificates");
                }
                int[] ix = BCertList.this.getSelectedIndices();
                if (4 == BDialog.confirm((BWidget)BCertList.this, (String)BCertList.this.getLexicon().getText("LicenseManager.delete.confirmTitle"), (Object)BCertList.this.getLexicon().getText("LicenseManager.delete.confirmMessage"))) {
                    BCertList.this.deleteFiles(ix);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }
}

