/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.filetransfer;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.filetransfer.BDirectoryTable;
import com.tridium.platDaemon.ui.widget.BDirectoryChoice;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.BStringPromptDialog;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BFolder;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BFileTransferClient
extends BDaemonSessionView
implements CommandBindings.Support {
    public static final Action handleLocalDirChanged = BFileTransferClient.newAction((int)4, null);
    public static final Action handleRemoteDirChanged = BFileTransferClient.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BFileTransferClient.class);
    BDirectoryTable localTable;
    BDirectoryTable remoteTable;
    private AsyncCommand deleteCommand;
    private UpLocalCommand upLocalCommand;
    private AsyncCommand changeLocalDirCommand;
    private AsyncCommand changeRemoteDirCommand;
    private UpRemoteCommand upRemoteCommand;
    private BDirectoryChoice localDirChoice;
    private BDirectoryChoice remoteDirChoice;
    private BLabel localLabel;
    private BLabel remoteLabel;

    public void handleLocalDirChanged() {
        this.invoke(handleLocalDirChanged, null, null);
    }

    public void handleRemoteDirChanged() {
        this.invoke(handleRemoteDirChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFileTransferClient() {
        BIBeamPane ibeam = new BIBeamPane();
        BFlowPane flowPane = new BFlowPane(BHalign.left);
        AsyncGroup cg = new AsyncGroup();
        this.upLocalCommand = new UpLocalCommand();
        BButton button = new BButton((Command)this.upLocalCommand, false, true);
        flowPane.add(null, (BValue)button);
        cg.add((AsyncGroup.AsyncGroupMember)this.upLocalCommand);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.localDirChoice = new BDirectoryChoice();
        flowPane.add(null, (BValue)this.localDirChoice);
        this.linkTo((BComponent)this.localDirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleLocalDirChanged);
        this.localTable = new BDirectoryTable((BWbView)this);
        BBorderPane borderPane = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)flowPane, 6.0, 0.0, 2.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)this.localTable, BBorder.inset, BInsets.DEFAULT)), 4.0, 2.0, 0.0, 2.0);
        ibeam.setLeft((BWidget)borderPane);
        this.localLabel = new BLabel();
        borderPane.setLabel((BWidget)this.localLabel);
        flowPane = new BFlowPane(BHalign.left);
        this.upRemoteCommand = new UpRemoteCommand();
        button = new BButton((Command)this.upRemoteCommand, false, true);
        flowPane.add(null, (BValue)button);
        cg.add((AsyncGroup.AsyncGroupMember)this.upRemoteCommand);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.remoteDirChoice = new BDirectoryChoice();
        flowPane.add(null, (BValue)this.remoteDirChoice);
        this.linkTo((BComponent)this.remoteDirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleRemoteDirChanged);
        this.remoteTable = new BDirectoryTable((BWbView)this);
        borderPane = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)flowPane, 6.0, 0.0, 2.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)this.remoteTable, BBorder.inset, BInsets.DEFAULT)), 4.0, 2.0, 0.0, 2.0);
        ibeam.setRight((BWidget)borderPane);
        this.remoteLabel = new BLabel();
        borderPane.setLabel((BWidget)this.remoteLabel);
        this.remoteTable.setOtherTable((BTable)this.localTable);
        this.remoteTable.setController((TableController)new DirectoryTableController(this.remoteTable.getCommandBindings()));
        this.localTable.setOtherTable((BTable)this.remoteTable);
        this.localTable.setController((TableController)new DirectoryTableController(this.localTable.getCommandBindings()));
        BGridPane buttons = new BGridPane(1);
        buttons.setColumnAlign(BHalign.fill);
        TransferCommand uploadCommand = new TransferCommand(this.localTable, this.remoteTable, "FileTransferClient.upload");
        buttons.add(null, (BValue)new BButton((Command)uploadCommand, false, true));
        cg.add((AsyncGroup.AsyncGroupMember)uploadCommand);
        TransferCommand downloadCommand = new TransferCommand(this.remoteTable, this.localTable, "FileTransferClient.download");
        buttons.add(null, (BValue)new BButton((Command)downloadCommand, false, true));
        cg.add((AsyncGroup.AsyncGroupMember)downloadCommand);
        this.deleteCommand = new DeleteCommand();
        buttons.add(null, (BValue)new BButton((Command)this.deleteCommand, false, true));
        cg.add((AsyncGroup.AsyncGroupMember)this.deleteCommand);
        ibeam.setCenter((BWidget)new BBorderPane((BWidget)buttons, 0.0, 4.0, 0.0, 4.0));
        this.changeLocalDirCommand = new ChangeDirectoryCommand(this.localTable);
        this.localTable.addCommand((Command)this.changeLocalDirCommand, BCommandEnablePolicy.singleSelection);
        cg.add((AsyncGroup.AsyncGroupMember)this.changeLocalDirCommand);
        this.localTable.addCommand((Command)uploadCommand, BCommandEnablePolicy.anySelection);
        this.localTable.addCommand((Command)this.deleteCommand, BCommandEnablePolicy.anySelection);
        this.localTable.addCommand((Command)new MakeSubDirectoryCommand(this.localTable), BCommandEnablePolicy.empty);
        this.localTable.addCommand((Command)new RefreshCommand(this.localTable), BCommandEnablePolicy.always);
        this.localTable.setCommandSupport(this);
        this.localTable.setCommandEnabledStates();
        this.changeRemoteDirCommand = new ChangeDirectoryCommand(this.remoteTable);
        this.remoteTable.addCommand((Command)this.changeRemoteDirCommand, BCommandEnablePolicy.singleSelection);
        cg.add((AsyncGroup.AsyncGroupMember)this.changeRemoteDirCommand);
        this.remoteTable.addCommand((Command)downloadCommand, BCommandEnablePolicy.anySelection);
        this.remoteTable.addCommand((Command)this.deleteCommand, BCommandEnablePolicy.anySelection);
        this.remoteTable.addCommand((Command)new MakeSubDirectoryCommand(this.remoteTable), BCommandEnablePolicy.empty);
        this.remoteTable.addCommand((Command)new RefreshCommand(this.remoteTable), BCommandEnablePolicy.always);
        this.remoteTable.setCommandSupport(this);
        this.remoteTable.setCommandEnabledStates();
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)new BBorderPane((BWidget)ibeam, 5.0, 0.0, 5.0, 0.0)));
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.localTable.deactivated();
    }

    protected FilePath loadPreferredDir(String dirKey) {
        BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
        BComponent hostValues = (BComponent)options.get(SlotPath.escape((String)(this.getDaemonSession().getHost().getHostname() + ':' + String.valueOf(this.getDaemonSession().getPort()))));
        if (hostValues == null) {
            return null;
        }
        BString dirValue = (BString)hostValues.get(dirKey);
        return dirValue == null ? null : new FilePath(dirValue.toString());
    }

    protected void savePreferredDir(String dirKey, BDirectory value) {
        BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
        StringBuilder hostKey = new StringBuilder(this.getDaemonSession().getHost().getHostname());
        hostKey.append(':');
        hostKey.append(String.valueOf(this.getDaemonSession().getPort()));
        BComponent hostValues = (BComponent)options.get(SlotPath.escape((String)hostKey.toString()));
        if (hostValues == null) {
            hostValues = new BFolder();
            options.add(SlotPath.escape((String)hostKey.toString()), (BValue)hostValues);
        }
        if (hostValues.get(dirKey) == null) {
            hostValues.add(dirKey, (BValue)BString.make((String)value.getFilePath().getBody()));
        } else {
            hostValues.set(dirKey, (BValue)BString.make((String)value.getFilePath().getBody()));
        }
        options.save();
    }

    @Override
    protected void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        try {
            BDirectory localDir;
            session.reloadHostProperties();
            FilePath localPath = this.loadPreferredDir("localPath");
            if (localPath == null) {
                localPath = new FilePath("~");
            }
            if ((localDir = (BDirectory)BFileSystem.INSTANCE.findFile(localPath)) == null) {
                localDir = BFileSystem.INSTANCE.getSysHome();
            }
            this.localDirChoice.setDirectory(localDir);
            this.localLabel.setText(this.getLexicon().getText("FileTransferClient.local.heading"));
            this.localLabel.setImage(BImage.make((BIcon)BLocalHost.INSTANCE.getIcon()));
            FilePath remotePath = this.loadPreferredDir("remotePath");
            if (remotePath == null) {
                remotePath = new FilePath("~");
            }
            session.getFileSpace().listFiles();
            BDaemonDirectoryStore remoteStore = BDaemonDirectoryStore.make((BDaemonFileSpace)session.getFileSpace(), (FilePath)remotePath, (boolean)false, (boolean)true, (boolean)true, null);
            if (remoteStore == null) {
                remotePath = new FilePath("~");
                remoteStore = BDaemonDirectoryStore.make((BDaemonFileSpace)session.getFileSpace(), (FilePath)remotePath, (boolean)false, (boolean)true, (boolean)true, null);
            }
            BDirectory remoteDir = new BDirectory((BIFileStore)remoteStore);
            this.remoteDirChoice.setDirectory(remoteDir);
            this.remoteLabel.setText(this.getLexicon().getText("FileTransferClient.remote.heading", new Object[]{session.getRemoteAddressString()}));
            this.remoteLabel.setImage(BImage.make((BIcon)session.getIcon()));
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public void doHandleLocalDirChanged() {
        BDirectory localDir = this.localDirChoice.getDirectory();
        BWbShell shell = this.getWbShell();
        try {
            shell.enterBusy();
            this.localTable.load(localDir, this);
            this.upLocalCommand.checkEnabled(localDir);
            this.savePreferredDir("localPath", localDir);
        }
        finally {
            shell.exitBusy();
        }
    }

    public void doHandleRemoteDirChanged() {
        BDirectory remoteDir = this.remoteDirChoice.getDirectory();
        BWbShell shell = this.getWbShell();
        try {
            shell.enterBusy();
            this.remoteTable.load(remoteDir, this);
            this.upRemoteCommand.checkEnabled((BDaemonDirectoryStore)remoteDir.getStore());
            this.savePreferredDir("remotePath", remoteDir);
        }
        finally {
            shell.exitBusy();
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (command == this.deleteCommand) {
            this.deleteCommand.setEnabled(!this.localTable.getSelection().isEmpty() || !this.remoteTable.getSelection().isEmpty());
        } else if (!bindingBasedState) {
            command.setEnabled(false);
        } else if (command == this.changeLocalDirCommand) {
            command.setEnabled(this.localTable.getSelectedFiles()[0] instanceof BDirectory);
        } else if (command == this.changeRemoteDirCommand) {
            command.setEnabled(this.remoteTable.getSelectedFiles()[0] instanceof BDirectory);
        } else {
            command.setEnabled(true);
        }
    }

    class MakeSubDirectoryCommand
    extends AsyncCommand {
        private BDirectoryTable table;

        public MakeSubDirectoryCommand(BDirectoryTable pTable) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.mkdir");
            this.table = pTable;
        }

        public void doInvokeAsync() {
            try {
                String name = BStringPromptDialog.getString((BWidget)this.table, null, (String)BFileTransferClient.this.getLexicon().getText("FileTransferClient.mkdir.dlgTitle"), (String)BFileTransferClient.this.getLexicon().getText("FileTransferClient.mkdir.dlgMessage"));
                if (name != null && name.trim().length() > 0) {
                    this.table.makeSubDirectory(name);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    class ChangeDirectoryCommand
    extends AsyncCommand {
        private BDirectoryTable table;

        public ChangeDirectoryCommand(BDirectoryTable pTable) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.changeDir");
            this.table = pTable;
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            BIFile selFile = this.table.getSelectedFiles()[0];
            if (this.table == BFileTransferClient.this.localTable) {
                BFileTransferClient.this.localDirChoice.setDirectory((BDirectory)selFile);
            } else {
                BFileTransferClient.this.remoteDirChoice.setDirectory((BDirectory)selFile);
            }
        }
    }

    class RefreshCommand
    extends AsyncCommand {
        private BDirectoryTable table;

        public RefreshCommand(BDirectoryTable pTable) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.refresh");
            this.table = pTable;
        }

        public void doInvokeAsync() {
            try {
                this.table.refresh();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    class DeleteCommand
    extends AsyncCommand {
        public DeleteCommand() {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.delete");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                if (BFileTransferClient.this.localTable.getSelection().getRows().length > 0) {
                    BFileTransferClient.this.localTable.doDelete();
                } else {
                    BFileTransferClient.this.remoteTable.doDelete();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    class TransferCommand
    extends AsyncCommand {
        private BDirectoryTable sourceTable;
        private BDirectoryTable targetTable;

        public TransferCommand(BDirectoryTable pSourceTable, BDirectoryTable pTargetTable, String lexPrefix) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), lexPrefix);
            this.sourceTable = pSourceTable;
            this.targetTable = pTargetTable;
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                this.targetTable.insertTransferData(this.sourceTable.getSelectedFilesAsMark());
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class UpLocalCommand
    extends AsyncCommand {
        public UpLocalCommand() {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.upLocal");
        }

        public void checkEnabled(BDirectory dir) {
            String abspath = ((BLocalFileStore)dir.getStore()).getLocalFile().getAbsolutePath();
            Object parentNode = dir.getNavParent();
            if (parentNode == null || !(parentNode instanceof BDirectory)) {
                BDirectory localDir = BFileTransferClient.this.localDirChoice.getDirectory();
                FilePath parentPath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)localDir.getStore()).getParent();
                parentNode = parentPath == null ? null : BFileSystem.INSTANCE.findFile(parentPath);
            }
            if (parentNode != null && parentNode instanceof BDirectory) {
                String abspathparent = ((BLocalFileStore)((BDirectory)parentNode).getStore()).getLocalFile().getAbsolutePath();
                this.setEnabled(!abspath.equals(abspathparent));
            } else {
                this.setEnabled(false);
            }
        }

        public void doInvokeAsync() {
            try {
                FilePath parentPath;
                BDirectory localDir = BFileTransferClient.this.localDirChoice.getDirectory();
                BINavNode parentNode = localDir.getNavParent();
                if (!(parentNode != null && parentNode instanceof BDirectory || (parentPath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)localDir.getStore()).getParent()) == null)) {
                    parentNode = BFileSystem.INSTANCE.findFile(parentPath);
                }
                if (parentNode != null && parentNode instanceof BDirectory) {
                    BFileTransferClient.this.localTable.getSelection().deselectAll();
                    BFileTransferClient.this.localDirChoice.setDirectory((BDirectory)parentNode);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class UpRemoteCommand
    extends AsyncCommand {
        public UpRemoteCommand() {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.upRemote");
        }

        public void checkEnabled(BDaemonDirectoryStore store) {
            FilePath normPath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)store);
            if (normPath.depth() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }

        public void doInvokeAsync() {
            try {
                BFileTransferClient.this.remoteTable.getSelection().deselectAll();
                BDirectory remoteDir = BFileTransferClient.this.remoteDirChoice.getDirectory();
                FilePath parentPath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)remoteDir.getStore()).getParent();
                if (parentPath != null) {
                    BDaemonDirectoryStore remoteStore = BDaemonDirectoryStore.make((BDaemonFileSpace)BFileTransferClient.this.getDaemonSession().getFileSpace(), (FilePath)parentPath, (boolean)false, (boolean)true, (boolean)true, null);
                    BFileTransferClient.this.remoteDirChoice.setDirectory(new BDirectory((BIFileStore)remoteStore));
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class DirectoryTableController
    extends CommandBindings.TableController {
        public DirectoryTableController(CommandBindings pBindings) {
            super(pBindings);
        }

        protected void backgroundPressed(BMouseEvent event) {
            BFileTransferClient.this.remoteTable.getSelection().deselectAll();
            BFileTransferClient.this.localTable.getSelection().deselectAll();
            super.backgroundPressed(event);
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BDirectoryTable dirTable = (BDirectoryTable)this.getTable();
            if (dirTable.isDirectory(row)) {
                if (dirTable == BFileTransferClient.this.localTable) {
                    BFileTransferClient.this.localDirChoice.setDirectory(dirTable.getDirectory(row));
                } else {
                    BFileTransferClient.this.remoteDirChoice.setDirectory(dirTable.getDirectory(row));
                }
            }
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }
}

