/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.nre.platform.NREMemoryPool;
import com.tridium.platDaemon.ui.config.BMultiSlider;
import com.tridium.platDaemon.ui.config.BMultiSliderEvent;
import com.tridium.platDaemon.ui.config.BNreMemoryPoolBar;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetNreMemoryMessage;
import com.tridium.platform.daemon.message.UpdateNreMemoryMessage;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.util.LabelUtil;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BPen;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.shape.BRect;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraAction(name="handleSliderModified", parameterType="BMultiSliderEvent", defaultValue="new BMultiSliderEvent()")
public class BNreConfigurationPrompt
extends BEdgePane {
    public static final Action handleSliderModified = BNreConfigurationPrompt.newAction((int)0, (BValue)new BMultiSliderEvent(), null);
    public static final Type TYPE = Sys.loadType(BNreConfigurationPrompt.class);
    private NreMemoryConfiguration currentConfiguration;
    private BLabel heapSpaceSize;
    private BLabel metaSpaceSize;
    private BLabel codeCacheSize;
    private BLabel ramDiskSize;
    private BLabel systemSize;
    private ResetCommand resetCommand;
    private SaveCommand saveCommand;
    private int nreConfigServletVersion = 0;
    private boolean ramDiskPresent = false;
    private BMultiSlider memoryPoolSlider;
    private BNreMemoryPoolBar memoryPoolBar;
    public boolean changesOccurred = false;
    public boolean ramDiskChangeOccurred = false;
    public UpdateNreMemoryMessage updateMessage = null;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public void handleSliderModified(BMultiSliderEvent parameter) {
        this.invoke(handleSliderModified, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BNreConfigurationPrompt(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        int i;
        this.currentConfiguration = NreMemoryConfiguration.getNreMemoryConfiguration(daemonSession);
        this.nreConfigServletVersion = this.currentConfiguration.version;
        BGridPane descriptionPane = new BGridPane(2);
        descriptionPane.setRowAlign(BValign.top);
        descriptionPane.setColumnAlign(BHalign.left);
        NREMemoryPool ramDiskPool = this.currentConfiguration.ramDiskMemoryPool;
        boolean bl = this.ramDiskPresent = ramDiskPool.getDefaultSize() > 0 || ramDiskPool.getMinimumSize() > 0 || ramDiskPool.getMaximumSize() > 0;
        if (this.nreConfigServletVersion >= 2) {
            LabelUtil.addLabelWidgetPair((BPane)descriptionPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.systemDescriptionLabel"), (BWidget)new BLabel(lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.systemDescription", new Object[]{this.currentConfiguration.systemMemoryPool.getMinimumSize()}), BHalign.left));
        }
        LabelUtil.addLabelWidgetPair((BPane)descriptionPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.heapDescriptionLabel"), (BWidget)new BLabel(lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.heapDescription", new Object[]{this.currentConfiguration.heapSpaceMemoryPool.getMinimumSize()}), BHalign.left));
        LabelUtil.addLabelWidgetPair((BPane)descriptionPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.metaDescriptionLabel"), (BWidget)new BLabel(lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.metaDescription", new Object[]{this.currentConfiguration.metaSpaceMemoryPool.getMinimumSize()}), BHalign.left));
        LabelUtil.addLabelWidgetPair((BPane)descriptionPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.codeDescriptionLabel"), (BWidget)new BLabel(lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.codeDescription", new Object[]{this.currentConfiguration.codeCacheMemoryPool.getMinimumSize()}), BHalign.left));
        if (this.ramDiskPresent) {
            LabelUtil.addLabelWidgetPair((BPane)descriptionPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.ramDescriptionLabel"), (BWidget)new BLabel(lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.ramDescription", new Object[]{this.currentConfiguration.ramDiskMemoryPool.getMinimumSize()}), BHalign.left));
        }
        BFlowPane legend = new BFlowPane();
        if (this.nreConfigServletVersion >= 2) {
            legend.add(null, (BValue)new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), BNreMemoryPoolBar.NULL_BAR.getSystemBarBrush(), BColor.black.toBrush(), BPen.make((double)1.0)));
            legend.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.systemLabel"), (boolean)true));
            this.systemSize = new BLabel(String.valueOf(this.currentConfiguration.systemMemoryPool.getCurrentSize()));
            legend.add(null, (BValue)this.systemSize);
            legend.add(null, (BValue)new BLabel("MB"));
        }
        legend.add(null, (BValue)new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), BNreMemoryPoolBar.NULL_BAR.getHeapBarBrush(), BColor.black.toBrush(), BPen.make((double)1.0)));
        legend.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.heapLabel"), (boolean)true));
        this.heapSpaceSize = new BLabel(String.valueOf(this.currentConfiguration.heapSpaceMemoryPool.getCurrentSize()));
        legend.add(null, (BValue)this.heapSpaceSize);
        legend.add(null, (BValue)new BLabel("MB"));
        legend.add(null, (BValue)new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), BNreMemoryPoolBar.NULL_BAR.getMetaBarBrush(), BColor.black.toBrush(), BPen.make((double)1.0)));
        legend.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.metaLabel"), (boolean)true));
        this.metaSpaceSize = new BLabel(String.valueOf(this.currentConfiguration.metaSpaceMemoryPool.getCurrentSize()));
        legend.add(null, (BValue)this.metaSpaceSize);
        legend.add(null, (BValue)new BLabel("MB"));
        legend.add(null, (BValue)new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), BNreMemoryPoolBar.NULL_BAR.getCodeBarBrush(), BColor.black.toBrush(), BPen.make((double)1.0)));
        legend.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.codeLabel"), (boolean)true));
        this.codeCacheSize = new BLabel(String.valueOf(this.currentConfiguration.codeCacheMemoryPool.getCurrentSize()));
        legend.add(null, (BValue)this.codeCacheSize);
        legend.add(null, (BValue)new BLabel("MB"));
        if (this.ramDiskPresent) {
            legend.add(null, (BValue)new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), BNreMemoryPoolBar.NULL_BAR.getRamBarBrush(), BColor.black.toBrush(), BPen.make((double)1.0)));
            legend.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.nreConfigurationPrompt.ramLabel"), (boolean)true));
            this.ramDiskSize = new BLabel(String.valueOf(this.currentConfiguration.ramDiskMemoryPool.getCurrentSize()));
            legend.add(null, (BValue)this.ramDiskSize);
            legend.add(null, (BValue)new BLabel("MB"));
        }
        BGridPane legendGrid = new BGridPane(1);
        legendGrid.setHalign(BHalign.center);
        legendGrid.add("legend_center", (BValue)legend);
        ArrayList<Double> currentSizes = new ArrayList<Double>();
        ArrayList<Double> minimumSizes = new ArrayList<Double>();
        ArrayList<Double> maximumSizes = new ArrayList<Double>();
        if (this.nreConfigServletVersion >= 2) {
            currentSizes.add(Double.valueOf(this.currentConfiguration.systemMemoryPool.getCurrentSize()));
        }
        currentSizes.add(Double.valueOf(this.currentConfiguration.heapSpaceMemoryPool.getCurrentSize()));
        currentSizes.add(Double.valueOf(this.currentConfiguration.metaSpaceMemoryPool.getCurrentSize()));
        currentSizes.add(Double.valueOf(this.currentConfiguration.codeCacheMemoryPool.getCurrentSize()));
        if (this.ramDiskPresent) {
            currentSizes.add(Double.valueOf(this.currentConfiguration.ramDiskMemoryPool.getCurrentSize()));
        }
        if (this.nreConfigServletVersion >= 2) {
            minimumSizes.add(Double.valueOf(this.currentConfiguration.systemMemoryPool.getMinimumSize()));
        }
        minimumSizes.add(Double.valueOf(this.currentConfiguration.heapSpaceMemoryPool.getMinimumSize()));
        minimumSizes.add(Double.valueOf(this.currentConfiguration.metaSpaceMemoryPool.getMinimumSize()));
        minimumSizes.add(Double.valueOf(this.currentConfiguration.codeCacheMemoryPool.getMinimumSize()));
        if (this.ramDiskPresent) {
            minimumSizes.add(Double.valueOf(this.currentConfiguration.ramDiskMemoryPool.getMinimumSize()));
        }
        if (this.nreConfigServletVersion >= 2) {
            maximumSizes.add(Double.valueOf(this.currentConfiguration.systemMemoryPool.getMaximumSize()));
        }
        maximumSizes.add(Double.valueOf(this.currentConfiguration.heapSpaceMemoryPool.getMaximumSize()));
        maximumSizes.add(Double.valueOf(this.currentConfiguration.metaSpaceMemoryPool.getMaximumSize()));
        maximumSizes.add(Double.valueOf(this.currentConfiguration.codeCacheMemoryPool.getMaximumSize()));
        if (this.ramDiskPresent) {
            maximumSizes.add(Double.valueOf(this.currentConfiguration.ramDiskMemoryPool.getMaximumSize()));
        }
        double[] currentSizesArray = new double[currentSizes.size()];
        double[] minimumSizesArray = new double[minimumSizes.size()];
        double[] maximumSizesArray = new double[maximumSizes.size()];
        for (i = 0; i < currentSizes.size(); ++i) {
            currentSizesArray[i] = (Double)currentSizes.get(i);
        }
        for (i = 0; i < minimumSizes.size(); ++i) {
            minimumSizesArray[i] = (Double)minimumSizes.get(i);
        }
        for (i = 0; i < maximumSizes.size(); ++i) {
            maximumSizesArray[i] = (Double)maximumSizes.get(i);
        }
        this.memoryPoolSlider = new BMultiSlider(0.0, this.currentConfiguration.totalMemoryPool, 1.0, currentSizesArray, minimumSizesArray, maximumSizesArray);
        this.memoryPoolSlider.setOrientation(BOrientation.horizontal);
        this.memoryPoolBar = new BNreMemoryPoolBar(this.currentConfiguration.totalMemoryPool, this.currentConfiguration.version, this.ramDiskPresent);
        this.updateBar();
        this.linkTo(null, (BComponent)this.memoryPoolSlider, (Slot)BMultiSlider.valuesModified, (Slot)handleSliderModified);
        BGridPane visualPane = new BGridPane(1);
        visualPane.setColumnAlign(BHalign.fill);
        visualPane.add("legend", (BValue)legendGrid);
        visualPane.add("visual", (BValue)this.memoryPoolBar);
        visualPane.add("slider", (BValue)this.memoryPoolSlider);
        this.setTop((BWidget)new BWizardHeader(BImage.make((String)"module://icons/x32/warning.png"), lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.header"), lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.description")));
        this.setCenter((BWidget)new BBorderPane((BWidget)descriptionPane));
        this.setBottom((BWidget)new BBorderPane((BWidget)visualPane, 0.0, 10.0, 10.0, 10.0));
        this.resetCommand = new ResetCommand();
        this.saveCommand = new SaveCommand();
    }

    public static BNreConfigurationPrompt prompt(BWidget owner, BDaemonSession session) throws ConnectException, AuthenticationException {
        BNreConfigurationPrompt result = new BNreConfigurationPrompt(session);
        if (1 == BCommandDialog.open((BWidget)owner, (String)lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.title"), (Object)((Object)result), (DialogCommand[])new DialogCommand[]{result.resetCommand, result.saveCommand, DialogCommand.makeCancel((BWidget)result)}, null, (BInsets)BInsets.make((double)0.0, (double)10.0, (double)10.0, (double)10.0), (BInsets)BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))) {
            return result;
        }
        return null;
    }

    public void doHandleSliderModified(BMultiSliderEvent multiSliderEvent) {
        this.resetCommand.setEnabled(true);
        this.saveCommand.setEnabled(true);
        double[] newMemoryValues = multiSliderEvent.getValues();
        int index = 0;
        if (this.nreConfigServletVersion >= 2) {
            this.systemSize.setText(TextUtil.padLeft((String)Integer.valueOf((int)newMemoryValues[index++]).toString(), (int)3));
        }
        this.heapSpaceSize.setText(TextUtil.padLeft((String)Integer.valueOf((int)newMemoryValues[index++]).toString(), (int)3));
        this.metaSpaceSize.setText(TextUtil.padLeft((String)Integer.valueOf((int)newMemoryValues[index++]).toString(), (int)3));
        this.codeCacheSize.setText(TextUtil.padLeft((String)Integer.valueOf((int)newMemoryValues[index++]).toString(), (int)3));
        if (this.ramDiskPresent) {
            this.ramDiskSize.setText(TextUtil.padLeft((String)Integer.valueOf((int)newMemoryValues[index]).toString(), (int)3));
        }
        this.updateBar();
        this.resetCommand.updateEnabledState();
        this.saveCommand.updateEnabledState();
    }

    private void updateBar() {
        this.memoryPoolBar.setSystemValue(this.nreConfigServletVersion >= 2 ? Integer.parseInt(this.systemSize.getText().trim()) : 0);
        this.memoryPoolBar.setHeapValue(Integer.parseInt(this.heapSpaceSize.getText().trim()));
        this.memoryPoolBar.setMetaValue(Integer.parseInt(this.metaSpaceSize.getText().trim()));
        this.memoryPoolBar.setCodeValue(Integer.parseInt(this.codeCacheSize.getText().trim()));
        this.memoryPoolBar.setRAMValue(this.ramDiskPresent ? Integer.parseInt(this.ramDiskSize.getText().trim()) : 0);
        this.memoryPoolBar.repaint();
    }

    private class SaveCommand
    extends DialogCommand {
        public SaveCommand() {
            super((BWidget)BNreConfigurationPrompt.this, 1, UiLexicon.bajaui().getText("commands.save.label"), null, null, null);
            this.updateEnabledState();
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                int ramDiskValue;
                int systemValue = BNreConfigurationPrompt.this.nreConfigServletVersion >= 2 ? Integer.parseInt(BNreConfigurationPrompt.this.systemSize.getText().trim()) : 0;
                int heapSpaceValue = Integer.parseInt(BNreConfigurationPrompt.this.heapSpaceSize.getText().trim());
                int metaSpaceValue = Integer.parseInt(BNreConfigurationPrompt.this.metaSpaceSize.getText().trim());
                int codeCacheValue = Integer.parseInt(BNreConfigurationPrompt.this.codeCacheSize.getText().trim());
                int n = ramDiskValue = BNreConfigurationPrompt.this.ramDiskPresent ? Integer.parseInt(BNreConfigurationPrompt.this.ramDiskSize.getText().trim()) : 0;
                if (BNreConfigurationPrompt.this.nreConfigServletVersion >= 2 && systemValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.systemMemoryPool.getCurrentSize() || heapSpaceValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.heapSpaceMemoryPool.getCurrentSize() || metaSpaceValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.metaSpaceMemoryPool.getCurrentSize() || codeCacheValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.codeCacheMemoryPool.getCurrentSize() || BNreConfigurationPrompt.this.ramDiskPresent && ramDiskValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.ramDiskMemoryPool.getCurrentSize()) {
                    BNreConfigurationPrompt.this.changesOccurred = true;
                    BNreConfigurationPrompt.this.ramDiskChangeOccurred = BNreConfigurationPrompt.this.ramDiskPresent && ramDiskValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.ramDiskMemoryPool.getCurrentSize();
                    BNreConfigurationPrompt.this.updateMessage = BNreConfigurationPrompt.this.nreConfigServletVersion >= 2 && systemValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.systemMemoryPool.getDefaultSize() || heapSpaceValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.heapSpaceMemoryPool.getDefaultSize() || metaSpaceValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.metaSpaceMemoryPool.getDefaultSize() || codeCacheValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.codeCacheMemoryPool.getDefaultSize() || BNreConfigurationPrompt.this.ramDiskPresent && ramDiskValue != ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.ramDiskMemoryPool.getDefaultSize() ? new UpdateNreMemoryMessage(BNreConfigurationPrompt.this.nreConfigServletVersion, heapSpaceValue, metaSpaceValue, ramDiskValue, codeCacheValue, systemValue) : new UpdateNreMemoryMessage();
                }
                this.updateEnabledState();
                BNreConfigurationPrompt.this.resetCommand.updateEnabledState();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            super.doInvoke();
            return null;
        }

        public void updateEnabledState() {
            boolean nonDefault = false;
            if (BNreConfigurationPrompt.this.nreConfigServletVersion >= 2) {
                nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.systemMemoryPool.getDefaultSize() != Integer.parseInt(BNreConfigurationPrompt.this.systemSize.getText().trim());
            }
            nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.heapSpaceMemoryPool.getCurrentSize() != Integer.parseInt(BNreConfigurationPrompt.this.heapSpaceSize.getText().trim());
            nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.metaSpaceMemoryPool.getCurrentSize() != Integer.parseInt(BNreConfigurationPrompt.this.metaSpaceSize.getText().trim());
            nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.codeCacheMemoryPool.getCurrentSize() != Integer.parseInt(BNreConfigurationPrompt.this.codeCacheSize.getText().trim());
            if (BNreConfigurationPrompt.this.ramDiskPresent) {
                nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.ramDiskMemoryPool.getCurrentSize() != Integer.parseInt(BNreConfigurationPrompt.this.ramDiskSize.getText().trim());
            }
            this.setEnabled(nonDefault);
        }
    }

    private class ResetCommand
    extends DialogCommand {
        public ResetCommand() {
            super((BWidget)BNreConfigurationPrompt.this, -1, lex.getText("PlatformAdministration.dialog.nreConfigurationPrompt.reset"), null, null, null);
            this.updateEnabledState();
        }

        public CommandArtifact doInvoke() {
            try {
                if (BNreConfigurationPrompt.this.nreConfigServletVersion >= 2) {
                    BNreConfigurationPrompt.this.systemSize.setText(TextUtil.padLeft((String)String.valueOf(((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.systemMemoryPool.getDefaultSize()), (int)3));
                }
                BNreConfigurationPrompt.this.heapSpaceSize.setText(TextUtil.padLeft((String)String.valueOf(((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.heapSpaceMemoryPool.getDefaultSize()), (int)3));
                BNreConfigurationPrompt.this.metaSpaceSize.setText(TextUtil.padLeft((String)String.valueOf(((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.metaSpaceMemoryPool.getDefaultSize()), (int)3));
                BNreConfigurationPrompt.this.codeCacheSize.setText(TextUtil.padLeft((String)String.valueOf(((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.codeCacheMemoryPool.getDefaultSize()), (int)3));
                if (BNreConfigurationPrompt.this.ramDiskPresent) {
                    BNreConfigurationPrompt.this.ramDiskSize.setText(TextUtil.padLeft((String)String.valueOf(((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.ramDiskMemoryPool.getDefaultSize()), (int)3));
                }
                BVector values = new BVector();
                int count = 0;
                if (BNreConfigurationPrompt.this.nreConfigServletVersion >= 2) {
                    values.add("thumb" + count++, (BValue)BDouble.make((double)((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.systemMemoryPool.getDefaultSize()));
                }
                values.add("thumb" + count++, (BValue)BDouble.make((double)((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.heapSpaceMemoryPool.getDefaultSize()));
                values.add("thumb" + count++, (BValue)BDouble.make((double)((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.metaSpaceMemoryPool.getDefaultSize()));
                values.add("thumb" + count++, (BValue)BDouble.make((double)((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.codeCacheMemoryPool.getDefaultSize()));
                if (BNreConfigurationPrompt.this.ramDiskPresent) {
                    values.add("thumb" + count, (BValue)BDouble.make((double)((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.ramDiskMemoryPool.getDefaultSize()));
                }
                BNreConfigurationPrompt.this.memoryPoolSlider.setThumbValues(values);
                BNreConfigurationPrompt.this.memoryPoolSlider.repaint();
                BNreConfigurationPrompt.this.updateBar();
                this.updateEnabledState();
                BNreConfigurationPrompt.this.saveCommand.updateEnabledState();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }

        public void updateEnabledState() {
            boolean nonDefault = false;
            if (BNreConfigurationPrompt.this.nreConfigServletVersion >= 2) {
                nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.systemMemoryPool.getDefaultSize() != Integer.parseInt(BNreConfigurationPrompt.this.systemSize.getText().trim());
            }
            nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.heapSpaceMemoryPool.getDefaultSize() != Integer.parseInt(BNreConfigurationPrompt.this.heapSpaceSize.getText().trim());
            nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.metaSpaceMemoryPool.getDefaultSize() != Integer.parseInt(BNreConfigurationPrompt.this.metaSpaceSize.getText().trim());
            nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.codeCacheMemoryPool.getDefaultSize() != Integer.parseInt(BNreConfigurationPrompt.this.codeCacheSize.getText().trim());
            if (BNreConfigurationPrompt.this.ramDiskPresent) {
                nonDefault |= ((BNreConfigurationPrompt)BNreConfigurationPrompt.this).currentConfiguration.ramDiskMemoryPool.getDefaultSize() != Integer.parseInt(BNreConfigurationPrompt.this.ramDiskSize.getText().trim());
            }
            this.setEnabled(nonDefault);
        }
    }

    private static class NreMemoryConfiguration {
        NREMemoryPool heapSpaceMemoryPool;
        NREMemoryPool metaSpaceMemoryPool;
        NREMemoryPool codeCacheMemoryPool;
        NREMemoryPool ramDiskMemoryPool;
        NREMemoryPool systemMemoryPool;
        int totalMemoryPool;
        int version;

        private NreMemoryConfiguration() {
        }

        static NreMemoryConfiguration getNreMemoryConfiguration(BDaemonSession session) throws ConnectException, AuthenticationException {
            XElem nreMemoryConfigurationElem;
            NreMemoryConfiguration configuration = new NreMemoryConfiguration();
            try {
                nreMemoryConfigurationElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)GetNreMemoryMessage.getInstance())).parse();
            }
            catch (ConnectException | AuthenticationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BajaRuntimeException("Failed to parse remote nre configuration (" + e + ")");
            }
            configuration.version = 1;
            try {
                configuration.version = nreMemoryConfigurationElem.geti("version");
            }
            catch (Exception e) {
                // empty catch block
            }
            configuration.totalMemoryPool = nreMemoryConfigurationElem.geti("totalMemory");
            try {
                configuration.heapSpaceMemoryPool = NreMemoryConfiguration.parseMemoryPool("heapSpace", nreMemoryConfigurationElem, configuration.version);
                configuration.metaSpaceMemoryPool = NreMemoryConfiguration.parseMemoryPool("metaSpace", nreMemoryConfigurationElem, configuration.version);
                configuration.ramDiskMemoryPool = NreMemoryConfiguration.parseMemoryPool("ramDisk", nreMemoryConfigurationElem, configuration.version);
                configuration.codeCacheMemoryPool = NreMemoryConfiguration.parseMemoryPool("codeCache", nreMemoryConfigurationElem, configuration.version);
                if (configuration.version >= 2) {
                    configuration.systemMemoryPool = NreMemoryConfiguration.parseMemoryPool("system", nreMemoryConfigurationElem, configuration.version);
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException("Failed to parse remote nre configuration sub-elements (" + e + ")");
            }
            return configuration;
        }

        private static NREMemoryPool parseMemoryPool(String poolName, XElem parentElement, int version) throws Exception {
            XElem subElem = parentElement.elem(poolName);
            if (subElem == null) {
                throw new Exception("Missing " + poolName + " element");
            }
            int maximumSize = 65535;
            int defaultSize = subElem.geti("default");
            int currentSize = subElem.geti("current");
            int minimumSize = subElem.geti("minimum");
            if (version >= 3) {
                maximumSize = subElem.geti("maximum");
            }
            NREMemoryPool toUpdate = new NREMemoryPool(minimumSize, maximumSize, defaultSize);
            toUpdate.setCurrentSize(currentSize);
            return toUpdate;
        }
    }
}

