/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.message.DaemonDebugMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DaemonUsbBackupMessage;
import com.tridium.platform.daemon.message.QnxInetdMessage;
import com.tridium.platform.daemon.message.SshdMessage;
import com.tridium.platform.daemon.message.UpdateInetMessage;
import com.tridium.platform.daemon.message.UpdateSshdMessage;
import com.tridium.platform.ui.util.PortConfigController;
import com.tridium.ui.BOptionDialog;
import java.io.InputStream;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class AdvancedOptionsPrompt {
    BOptionDialog dialog;
    boolean debugSupported;
    boolean sshdSupported;
    boolean legacySshd;
    boolean inetdSupported;
    boolean usbBackupSupported;
    boolean defaultCredentialsPresent = false;
    BCheckBox daemonDebugEnabledCheckBox = null;
    String originalDaemonDebugSettings;
    BCheckBox telnetEnabledCheckBox = null;
    BTextField telnetPortTextField = null;
    BCheckBox ftpEnabledCheckBox = null;
    BTextField ftpPortTextField = null;
    String originalInetdSettings;
    BCheckBox sshEnabledCheckBox = null;
    BTextField sshPortTextField = null;
    String originalSshSettings;
    BCheckBox usbBackupEnabledCheckBox = null;
    String originalUsbBackupSettings;
    OkCommand okCommand;
    static Lexicon lex = Lexicon.make((String)"platDaemon");

    public static boolean sessionSupportsAdvancedOptions(BDaemonSession session) {
        BHostProperties sessionHostProperties = session.getHostProperties();
        return sessionHostProperties.supportsServlet("debug") || sessionHostProperties.supportsServlet("sshd") || sessionHostProperties.supportsServlet("usbbackup") || sessionHostProperties.supportsServlet("qnxinetd") || sessionHostProperties.supportsServlet("qnxsshd");
    }

    public static boolean updateSettings(BWidget owner, BDaemonSession session, boolean defaultCredentialsPresent) {
        try {
            BOptionDialog dialog = new BOptionDialog(owner, lex.getText("AdvancedOptionsPrompt.dlgTitle"), (BWidget)new BNullWidget(), 3, null, null);
            AdvancedOptionsPrompt prompt = new AdvancedOptionsPrompt(dialog, session, defaultCredentialsPresent);
            dialog.setBoundsCenteredOnOwner();
            dialog.open();
            boolean changesMade = false;
            if (dialog.getResult() == 1) {
                if (prompt.debugSupported && prompt.debugChanged()) {
                    session.sendMessage((DaemonMessage)new DaemonDebugMessage(prompt.daemonDebugEnabledCheckBox.isSelected()));
                    changesMade = true;
                }
                if (prompt.inetdSupported && prompt.inetdChanged()) {
                    session.sendMessage((DaemonMessage)new UpdateInetMessage(prompt.ftpEnabledCheckBox.isSelected(), Integer.valueOf(prompt.ftpPortTextField.getText()).intValue(), prompt.telnetEnabledCheckBox.isSelected(), Integer.valueOf(prompt.telnetPortTextField.getText()).intValue()));
                    changesMade = true;
                } else if (prompt.sshdSupported && prompt.sshdChanged()) {
                    session.sendMessage((DaemonMessage)new UpdateSshdMessage(prompt.legacySshd, prompt.sshEnabledCheckBox.isSelected(), Integer.valueOf(prompt.sshPortTextField.getText()).intValue()), 20000);
                    changesMade = true;
                }
                if (prompt.usbBackupSupported && prompt.usbBackupChanged()) {
                    session.sendMessage((DaemonMessage)new DaemonUsbBackupMessage(prompt.usbBackupEnabledCheckBox.isSelected()));
                    changesMade = true;
                }
                session.reloadHostProperties();
                return changesMade;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return false;
    }

    private AdvancedOptionsPrompt(BOptionDialog dialog, BDaemonSession session, boolean defaultCredentialsPresent) {
        this.dialog = dialog;
        this.defaultCredentialsPresent = defaultCredentialsPresent;
        this.okCommand = new OkCommand(this);
        dialog.getOkButton().setCommand((Command)this.okCommand, true, false);
        BGridPane parentGrid = new BGridPane(1);
        BHostProperties hostProperties = session.getHostProperties();
        this.debugSupported = hostProperties.supportsServlet("debug");
        this.inetdSupported = hostProperties.supportsServlet("qnxinetd");
        boolean bl = this.sshdSupported = hostProperties.supportsServlet("qnxsshd") || hostProperties.supportsServlet("sshd");
        if (this.sshdSupported) {
            this.legacySshd = hostProperties.supportsServlet("qnxsshd");
        }
        this.usbBackupSupported = hostProperties.supportsServlet("usbbackup");
        if (this.inetdSupported) {
            BGridPane inetdGrid = new BGridPane(3);
            int telnetdPort = -1;
            int ftpdPort = -1;
            try {
                XElem elem = XParser.make((InputStream)session.getInputStream((DaemonMessage)QnxInetdMessage.getInstance(), 0)).parse();
                ftpdPort = elem.geti("fp", -1);
                telnetdPort = elem.geti("tp", -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ftpPortTextField = new BTextField("", 4);
            this.telnetPortTextField = new BTextField("", 4);
            this.ftpEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxInetdPrompt.ftpEnabled", this.ftpPortTextField));
            inetdGrid.add(null, (BValue)this.ftpEnabledCheckBox);
            inetdGrid.add(null, (BValue)new BLabel(lex.getText("QnxInetdPrompt.port")));
            inetdGrid.add(null, (BValue)this.ftpPortTextField);
            this.ftpPortTextField.setController((TextController)new PortConfigController());
            this.ftpPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
            this.telnetEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxInetdPrompt.telnetEnabled", this.telnetPortTextField));
            inetdGrid.add(null, (BValue)this.telnetEnabledCheckBox);
            inetdGrid.add(null, (BValue)new BLabel(lex.getText("QnxInetdPrompt.port")));
            inetdGrid.add(null, (BValue)this.telnetPortTextField);
            this.telnetPortTextField.setController((TextController)new PortConfigController());
            this.telnetPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
            if (ftpdPort < 0) {
                this.ftpEnabledCheckBox.setSelected(false);
                this.ftpPortTextField.setText("21");
                this.ftpPortTextField.setEnabled(false);
            } else {
                this.ftpEnabledCheckBox.setSelected(true);
                this.ftpPortTextField.setText(String.valueOf(ftpdPort));
            }
            if (telnetdPort < 0) {
                this.telnetEnabledCheckBox.setSelected(false);
                this.telnetPortTextField.setText("23");
                this.telnetPortTextField.setEnabled(false);
            } else {
                this.telnetEnabledCheckBox.setSelected(true);
                this.telnetPortTextField.setText(String.valueOf(telnetdPort));
            }
            this.originalInetdSettings = String.valueOf(this.telnetEnabledCheckBox.isSelected()) + String.valueOf(telnetdPort) + String.valueOf(this.ftpEnabledCheckBox.isSelected()) + String.valueOf(ftpdPort);
            parentGrid.add(null, (BValue)inetdGrid);
        } else if (this.sshdSupported) {
            BGridPane sshdGrid = new BGridPane(3);
            int sshdPort = -1;
            try {
                XElem elem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new SshdMessage(this.legacySshd), 0)).parse();
                sshdPort = elem.geti("port", -1);
            }
            catch (Exception elem) {
                // empty catch block
            }
            this.sshPortTextField = new BTextField("", 4);
            this.sshEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxSshdPrompt.sshEnabled", this.sshPortTextField));
            sshdGrid.add(null, (BValue)this.sshEnabledCheckBox);
            sshdGrid.add(null, (BValue)new BLabel(lex.getText("QnxSshdPrompt.port")));
            sshdGrid.add(null, (BValue)this.sshPortTextField);
            this.sshPortTextField.setController((TextController)new PortConfigController());
            this.sshPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
            if (sshdPort < 0) {
                this.sshEnabledCheckBox.setSelected(false);
                this.sshPortTextField.setText("22");
                this.sshPortTextField.setEnabled(false);
            } else {
                this.sshEnabledCheckBox.setSelected(true);
                this.sshPortTextField.setText(String.valueOf(sshdPort));
            }
            if (defaultCredentialsPresent) {
                this.sshEnabledCheckBox.setEnabled(false);
                this.sshPortTextField.setEnabled(false);
            }
            this.originalSshSettings = String.valueOf(this.sshEnabledCheckBox.isSelected()) + String.valueOf(sshdPort);
            parentGrid.add(null, (BValue)sshdGrid);
        }
        if (this.debugSupported) {
            BGridPane debugGrid = new BGridPane(1);
            boolean daemonDebugEnabled = false;
            try {
                XElem debugElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new DaemonDebugMessage())).parse();
                daemonDebugEnabled = debugElem.getb("daemonDebug", false);
            }
            catch (Exception debugElem) {
                // empty catch block
            }
            this.daemonDebugEnabledCheckBox = new BCheckBox(lex.getText("AdvancedOptionsPrompt.debugEnabled"));
            debugGrid.add(null, (BValue)this.daemonDebugEnabledCheckBox);
            this.daemonDebugEnabledCheckBox.setSelected(daemonDebugEnabled);
            this.originalDaemonDebugSettings = String.valueOf(daemonDebugEnabled);
            parentGrid.add(null, (BValue)debugGrid);
        }
        if (this.usbBackupSupported) {
            BGridPane usbGrid = new BGridPane(1);
            boolean usbBackupEnabled = false;
            try {
                XElem usbElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new DaemonUsbBackupMessage())).parse();
                usbBackupEnabled = usbElem.getb("enabled", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.usbBackupEnabledCheckBox = new BCheckBox(lex.getText("AdvancedOptionsPrompt.usbBackupEnabled"));
            usbGrid.add(null, (BValue)this.usbBackupEnabledCheckBox);
            this.usbBackupEnabledCheckBox.setSelected(usbBackupEnabled);
            this.originalUsbBackupSettings = String.valueOf(usbBackupEnabled);
            parentGrid.add(null, (BValue)usbGrid);
        }
        dialog.setContent((BWidget)new BBorderPane((BWidget)parentGrid, 6.0, 6.0, 6.0, 6.0));
    }

    boolean debugChanged() {
        return !String.valueOf(this.daemonDebugEnabledCheckBox.isSelected()).equalsIgnoreCase(this.originalDaemonDebugSettings);
    }

    boolean usbBackupChanged() {
        return !String.valueOf(this.usbBackupEnabledCheckBox.isSelected()).equalsIgnoreCase(this.originalUsbBackupSettings);
    }

    boolean inetdChanged() {
        return !(String.valueOf(this.telnetEnabledCheckBox.isSelected()) + this.telnetPortTextField.getText() + String.valueOf(this.ftpEnabledCheckBox.isSelected()) + this.ftpPortTextField.getText()).equalsIgnoreCase(this.originalInetdSettings);
    }

    boolean sshdChanged() {
        return !(String.valueOf(this.sshEnabledCheckBox.isSelected()) + this.sshPortTextField.getText()).equalsIgnoreCase(this.originalSshSettings);
    }

    private static class NotNullModel
    extends TextModel {
        private OkCommand command;

        public NotNullModel(OkCommand pCommand) {
            this.command = pCommand;
        }

        protected void textModified() {
            this.command.check();
        }
    }

    static class EnabledCommand
    extends ToggleCommand {
        private BTextField textField;

        public EnabledCommand(AdvancedOptionsPrompt prompt, String commandTextKey, BTextField pTextField) {
            super((BWidget)prompt.dialog, lex.getText(commandTextKey), null, null, null);
            this.textField = pTextField;
        }

        public CommandArtifact doInvoke() {
            this.textField.setEnabled(this.isSelected());
            return null;
        }
    }

    static class OkCommand
    extends Command {
        AdvancedOptionsPrompt prompt;

        public OkCommand(AdvancedOptionsPrompt prompt) {
            super((BWidget)prompt.dialog, UiLexicon.bajaui().getText("action.ok"), null, null, null);
            this.prompt = prompt;
        }

        public CommandArtifact doInvoke() {
            return null;
        }

        public void check() {
            if (this.prompt.inetdSupported) {
                this.setEnabled(this.prompt.telnetPortTextField.getText().length() > 0 && this.prompt.ftpPortTextField.getText().length() > 0);
            } else if (this.prompt.sshdSupported) {
                this.setEnabled(this.prompt.sshPortTextField.getText().length() > 0);
            }
        }
    }
}

