/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopierOptions;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platDaemon.ui.stationtransfer.StationNameController;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCoordinatedGridPane;
import com.tridium.platform.ui.util.BDirectoryTree;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.platform.ui.util.EnumRadioGroup;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.util.LabelUtil;
import com.tridium.ui.util.ValidatingTextController;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BInsets;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.security.BPassword;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeModel;
import javax.baja.util.LexiconText;
import javax.baja.util.PatternFilter;

public class StationStep
extends CommissioningWizardStep {
    private boolean stepInitialized = false;
    private StationListModel listModel;
    private BTextField targetNameTextField;
    private BCheckBox startStationCheckBox;
    private BCheckBox autoStartCheckBox;
    private BStationSurrogate remoteStation = null;
    private BCoordinatedGridPane passPhraseGrid;
    private BLabel passPhraseHeaderLabel;
    private BLabel passPhrasePromptLabel;
    private BPasswordFE passPhraseFE;
    private PBEEncodingInfo encodingInfo;
    private BLabel errorLabel;
    private boolean passPhraseRequired = false;
    private boolean invalidSelection = false;

    public StationStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
        BGridPane grid = new BGridPane(1);
        grid.setHalign(BHalign.left);
        grid.setValign(BValign.top);
        BCoordinatedGridPane innerGrid = new BCoordinatedGridPane(2);
        innerGrid.setValign(BValign.top);
        innerGrid.setRowAlign(BValign.top);
        innerGrid.setHalign(BHalign.left);
        BListDropDown dropDown = new BListDropDown();
        this.listModel = new StationListModel();
        dropDown.getList().setModel((ListModel)this.listModel);
        dropDown.getList().setMultipleSelection(false);
        dropDown.getList().setController((ListController)new StationListController(this));
        LabelUtil.addLabelWidgetPair((BPane)innerGrid, (LexiconText)this.getLexiconText("CommissioningWizard.stationStep.chooseStation"), (BWidget)dropDown);
        this.targetNameTextField = new BTextField("", 30, false);
        LabelUtil.addLabelWidgetPair((BPane)innerGrid, (LexiconText)this.getLexiconText("CommissioningWizard.stationStep.targetStationName"), (BWidget)this.targetNameTextField);
        this.targetNameTextField.setController((TextController)ValidatingTextController.make(updatedText -> updatedText == null || updatedText.length() == 0 || updatedText.length() <= 32 && SlotPath.isValidName((String)updatedText)));
        grid.add(null, (BValue)innerGrid);
        grid.add(null, (BValue)new BBox(0.0, 5.0));
        this.passPhraseHeaderLabel = new BLabel(LEX.getText("CommissioningWizard.stationStep.passPhraseHeader"), BHalign.left);
        grid.add(null, (BValue)this.passPhraseHeaderLabel);
        this.passPhraseHeaderLabel.setWordWrapEnabled(true);
        this.passPhraseGrid = new BCoordinatedGridPane(innerGrid);
        this.passPhraseGrid.setValign(BValign.top);
        this.passPhraseGrid.setRowAlign(BValign.top);
        this.passPhraseGrid.setHalign(BHalign.left);
        this.passPhrasePromptLabel = LabelUtil.makeLabel((String)LEX.getText("CommissioningWizard.stationStep.passPhrasePrompt"), (boolean)true);
        this.passPhraseGrid.add(null, (BValue)this.passPhrasePromptLabel);
        this.passPhraseFE = new BPasswordFE();
        this.passPhraseGrid.add(null, (BValue)this.passPhraseFE);
        this.passPhraseGrid.add(null, (BValue)new BBox(0.0, 5.0));
        this.passPhraseGrid.add(null, (BValue)new BNullWidget());
        grid.add(null, (BValue)this.passPhraseGrid);
        try {
            this.setEncodingInfo(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startStationCheckBox = new BCheckBox(LEX.getText("StationCopier.StartStationStep.start.description"));
        grid.add(null, (BValue)this.startStationCheckBox);
        this.autoStartCheckBox = new BCheckBox(LEX.getText("StationCopier.StartStationStep.autoStart.description"));
        grid.add(null, (BValue)this.autoStartCheckBox);
        grid.add(null, (BValue)new BBox(0.0, 5.0));
        this.errorLabel = new BLabel("", BHalign.left);
        grid.add(null, (BValue)this.errorLabel);
        StyleUtils.addStyleClass((IStylable)this.errorLabel, (String)"error");
        this.autoStartCheckBox.setEnabled(false);
        this.startStationCheckBox.setEnabled(false);
        this.targetNameTextField.setModel((TextModel)new ModeControlModel(this));
        this.targetNameTextField.setController((TextController)new StationNameController());
        this.setContent((BWidget)new BEdgePane((BWidget)new BLabel(LEX.getText("CommissioningWizard.stationStep.header"), BHalign.left), null, null, null, (BWidget)new BBorderPane((BWidget)grid, 4.0, 0.0, 0.0, 0.0)));
        ContentStep contentStep = new ContentStep(wizardModel);
        this.nextStep = contentStep;
        contentStep.priorStep = this;
        DetailsStep detailsStep = new DetailsStep(wizardModel);
        contentStep.nextStep = detailsStep;
        detailsStep.priorStep = contentStep;
        DispositionStep dispostionStep = new DispositionStep(wizardModel);
        detailsStep.nextStep = dispostionStep;
        dispostionStep.priorStep = detailsStep;
        DeleteStep deleteStep = new DeleteStep(wizardModel);
        dispostionStep.nextStep = deleteStep;
        deleteStep.priorStep = dispostionStep;
        this.lastStep = deleteStep;
        BStationCopierOptions stationCopierOptions = BStationCopierOptions.make();
        String fileExcludeList = stationCopierOptions.getFilePatternExcludeList();
        String directoryExcludeList = stationCopierOptions.getDirectoryPatternExcludeList();
        wizardModel.fileExcludePatterns = PatternFilter.parseList((String)fileExcludeList, (String)" ");
        wizardModel.directoryExcludePatterns = PatternFilter.parseList((String)directoryExcludeList, (String)" ");
    }

    @Override
    public String getStepName() {
        return "stationStep";
    }

    @Override
    public String getSectionName() {
        return "station";
    }

    @Override
    public void enter() {
        this.initStep();
        int i = this.listModel.indexOfDirectory(this.wizardModel.stationDir);
        if (i >= 0) {
            this.listModel.getList().setSelectedIndex(i);
        } else {
            this.listModel.getList().getSelection().deselectAll();
        }
        this.targetNameTextField.setEditable(i > 0);
        if (this.wizardModel.targetStationName == null) {
            this.targetNameTextField.setText("");
        } else {
            this.targetNameTextField.setText(this.wizardModel.targetStationName);
        }
        this.autoStartCheckBox.setSelected(this.wizardModel.autoStart);
        if (this.startStationCheckBox.isEnabled()) {
            this.startStationCheckBox.setSelected(this.wizardModel.startStation);
        } else {
            this.startStationCheckBox.setSelected(false);
        }
    }

    public void setStationName(String stationName) throws Exception {
        if (stationName == null) {
            this.remoteStation = null;
            this.targetNameTextField.setEditable(false);
            this.targetNameTextField.setText("");
            this.autoStartCheckBox.setEnabled(false);
            this.startStationCheckBox.setEnabled(false);
        } else {
            this.remoteStation = BStationSurrogate.make((BDaemonSession)this.wizardModel.daemonSession, (String)stationName);
            this.targetNameTextField.setText(stationName);
            this.targetNameTextField.setEditable(true);
            this.autoStartCheckBox.setEnabled(true);
            this.autoStartCheckBox.setSelected(this.wizardModel.autoStart);
            if (this.wizardModel.restartEnabled) {
                this.startStationCheckBox.setEnabled(true);
                this.startStationCheckBox.setSelected(this.wizardModel.startStation);
            } else {
                this.startStationCheckBox.setEnabled(false);
                this.startStationCheckBox.setSelected(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exit(int direction) {
        try {
            BDirectoryTree.DirectoryTreeNode dataRecoveryNode;
            BDirectoryTree.DirectoryTreeNode alarmNode;
            if (this.listModel.getList().getSelectedIndex() <= 0) {
                this.wizardModel.stationDir = null;
                this.wizardModel.targetStationName = null;
                this.wizardModel.localStationBogLock = null;
                this.wizardModel.stationSurrogate = null;
                this.wizardModel.encodingInfo = null;
                this.wizardModel.stationBogPassphrase = null;
                return true;
            }
            if (this.passPhraseRequired) {
                boolean passPhraseValid;
                block39: {
                    passPhraseValid = false;
                    try (SecretChars passPhraseTestCopy = null;){
                        BPassword value = (BPassword)this.passPhraseFE.saveValue(null);
                        if (value != null && this.encodingInfo.test(passPhraseTestCopy = value.getSecretChars())) {
                            this.errorLabel.setText("");
                            this.wizardModel.stationBogPassphrase = value.getSecretChars();
                            this.wizardModel.encodingInfo = this.encodingInfo;
                            passPhraseValid = true;
                            break block39;
                        }
                        EnumSet errors = EnumSet.noneOf(PBEValidator.ValidationFault.class);
                        if (value != null) {
                            try (SecretChars secretChars = value.getSecretChars();){
                                errors = PBEValidator.checkPassPhraseValidity((SecretChars)secretChars);
                            }
                        }
                        if (errors.contains(PBEValidator.ValidationFault.FIPS_MIN_LENGTH)) {
                            this.errorLabel.setText(LEX.getText("CommissioningWizard.stationStep.passPhraseLength", new Object[]{SecurityInitializer.getInstance().getFipsInformation().getFipsVersion(), PasswordStrength.MINIMUM_ALLOWED_LENGTH}));
                        } else {
                            this.errorLabel.setText(LEX.getText("CommissioningWizard.stationStep.badPassPhrase"));
                        }
                    }
                }
                if (!passPhraseValid && direction == 2) {
                    return false;
                }
            } else {
                this.wizardModel.stationBogPassphrase = null;
                this.wizardModel.encodingInfo = this.encodingInfo;
            }
            this.wizardModel.stationDir = this.listModel.getStationDirectory(this.listModel.getList().getSelectedIndex());
            this.wizardModel.targetStationName = this.targetNameTextField.getText();
            this.wizardModel.stationSurrogate = this.remoteStation;
            this.wizardModel.autoStart = this.autoStartCheckBox.isSelected();
            this.wizardModel.startStation = this.startStationCheckBox.isSelected();
            this.wizardModel.directoryTreeModel = new BDirectoryTree.DirectoryTreeModel();
            this.wizardModel.directoryTreeModel.setRootDirectory(this.wizardModel.stationDir);
            BDirectoryTree.DirectoryTreeNode histNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0)).getChild("history");
            this.wizardModel.isAxMigration = false;
            if (histNode != null) {
                if (histNode.getDirectory().getNavChild("history.zip") == null == this.wizardModel.daemonSession.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
                    this.wizardModel.isAxMigration = true;
                    histNode.setChecked(true, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                    histNode.setCheckEnabled(true, true);
                    histNode.setExpanded(false);
                } else {
                    histNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                    histNode.setCheckEnabled(false, true);
                    histNode.setExpanded(false);
                }
            }
            if ((alarmNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0)).getChild("alarm")) != null) {
                if (alarmNode.getDirectory().getNavChild("alarm.zip") == null == this.wizardModel.daemonSession.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
                    this.wizardModel.isAxMigration = true;
                    alarmNode.setChecked(true, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                    alarmNode.setCheckEnabled(true, true);
                    alarmNode.setExpanded(false);
                } else {
                    alarmNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                    alarmNode.setCheckEnabled(false, true);
                    alarmNode.setExpanded(false);
                }
            }
            if ((dataRecoveryNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0)).getChild("dataRecovery")) != null) {
                dataRecoveryNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                dataRecoveryNode.setCheckEnabled(false, true);
                dataRecoveryNode.setExpanded(false);
            }
            if (log.isLoggable(Level.FINE)) {
                StringBuffer patterns = new StringBuffer();
                for (PatternFilter fileExcludePattern : this.wizardModel.fileExcludePatterns) {
                    patterns.append(fileExcludePattern.getPattern()).append(' ');
                }
                log.fine("Excluding file patterns: \"" + patterns.toString() + "\" in commissioning wizard station step");
                patterns = new StringBuffer();
                for (PatternFilter directoryExcludePattern : this.wizardModel.directoryExcludePatterns) {
                    patterns.append(directoryExcludePattern.getPattern()).append(' ');
                }
                log.fine("Excluding directory patterns: \"" + patterns.toString() + "\" in commissioning wizard station step");
            }
            this.wizardModel.directoryTreeModel.setDirectoryStates((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0), this.wizardModel.directoryExcludePatterns, false, false, false);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return true;
    }

    @Override
    public int getMode() {
        if (this.listModel.getList().getSelectedIndex() == 0 || !this.invalidSelection && this.listModel.getList().getSelectedIndex() > 0 && this.targetNameTextField.getText().trim().length() > 0) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean isSkipped() {
        return this.wizardModel.skipStation;
    }

    private void initStep() {
        if (!this.stepInitialized) {
            try {
                BDaemonDirectoryStore store = BDaemonDirectoryStore.make((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace(), (FilePath)SystemFilePaths.getStationsDirPath((boolean)true));
                if (store == null) {
                    DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)SystemFilePaths.getStationsDirPath((boolean)true), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()), null, null);
                    store = BDaemonDirectoryStore.make((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace(), (FilePath)SystemFilePaths.getStationsDirPath((boolean)true));
                }
                this.wizardModel.targetStationsRoot = new BDirectory((BIFileStore)store);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            this.stepInitialized = true;
        }
    }

    public void setInvalidSelection(String messageLexKey) {
        if (messageLexKey == null) {
            this.invalidSelection = false;
            this.errorLabel.setText("");
        } else {
            this.invalidSelection = true;
            this.errorLabel.setText(LEX.getText(messageLexKey));
        }
    }

    public void setEncodingInfo(BBogFile stationBog) throws Exception {
        if (stationBog == null) {
            this.passPhraseRequired = false;
            this.encodingInfo = null;
        } else {
            this.encodingInfo = stationBog.getPBEEncodingInfo();
            this.passPhraseRequired = stationBog.usesReversibleEncryptionPassPhrase() && this.encodingInfo != null && (!this.wizardModel.skipSystemPassword || !this.wizardModel.daemonSession.validateSystemPassPhrase((PBEValidator)this.encodingInfo));
        }
        this.passPhraseGrid.setVisible(this.passPhraseRequired);
        this.passPhraseHeaderLabel.setVisible(this.passPhraseRequired);
        this.passPhrasePromptLabel.setVisible(this.passPhraseRequired);
        this.passPhraseFE.setVisible(this.passPhraseRequired);
    }

    private static class RemoteStationListSelection
    extends ListSelection {
        private final CommissioningWizardStep step;

        public RemoteStationListSelection(CommissioningWizardStep pStep) {
            this.step = pStep;
        }

        public void select(int index, boolean clear) {
            super.select(index, clear);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void select(int[] indices) {
            super.select(indices);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void deselect(int index) {
            super.deselect(index);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void deselectAll() {
            super.deselectAll();
            this.step.wizardModel.update(this.step.getMode());
        }
    }

    private static class RemoteStationListModel
    extends ListModel {
        BStationSurrogate[] stations;

        public RemoteStationListModel(CommissioningWizardModel pWizardModel) {
            ArrayList<BAppSurrogate> stationArray = new ArrayList<BAppSurrogate>();
            Collections.addAll(stationArray, pWizardModel.getSurrogates());
            stationArray.removeIf(o -> !(o instanceof BStationSurrogate));
            this.stations = new BStationSurrogate[stationArray.size()];
            for (int i = 0; i < stationArray.size(); ++i) {
                this.stations[i] = (BStationSurrogate)stationArray.get(i);
            }
        }

        public Object getItem(int index) {
            return this.getStation(index).getStationName();
        }

        public BStationSurrogate getStation(int index) {
            return this.stations[index];
        }

        public int indexOfStation(BStationSurrogate station) {
            if (station == null) {
                return -1;
            }
            for (int i = 0; i < this.stations.length; ++i) {
                if (!station.getStationName().equals(this.stations[i].getStationName())) continue;
                return i;
            }
            return -1;
        }

        public int getItemCount() {
            return this.stations.length;
        }
    }

    private static class DeleteStep
    extends CommissioningWizardStep {
        private RemoteStationListModel listModel = null;
        private boolean stepInitialized = false;

        public DeleteStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
        }

        @Override
        public String getStepName() {
            return "stationDeleteStep";
        }

        @Override
        public String getSectionName() {
            return "station";
        }

        @Override
        public void enter() {
            this.initStep();
            if (this.listModel.getList() != null) {
                this.listModel.getSelection().deselectAll();
                for (int i = 0; i < this.wizardModel.stationsToDelete.size(); ++i) {
                    int modelIdx = this.listModel.indexOfStation(this.wizardModel.stationsToDelete.get(i));
                    if (modelIdx < 0) continue;
                    this.listModel.getList().getSelection().select(modelIdx);
                }
            }
        }

        @Override
        public boolean exit(int direction) {
            this.wizardModel.stationsToDelete.clear();
            if (this.listModel.getItemCount() > 1) {
                for (int aSelected : this.listModel.getList().getSelectedIndices()) {
                    this.wizardModel.stationsToDelete.add(this.listModel.getStation(aSelected));
                }
            } else if (this.listModel.getItemCount() == 1) {
                this.wizardModel.stationsToDelete.add(this.listModel.getStation(0));
            }
            return true;
        }

        @Override
        public int getMode() {
            this.initStep();
            if (this.listModel.getItemCount() < 2 || this.listModel.getList().getSelectedIndex() >= 0) {
                return 3;
            }
            return 1;
        }

        @Override
        public boolean isSkipped() {
            if (this.wizardModel.skipStation || this.wizardModel.targetStationName == null) {
                this.wizardModel.stationsToDelete.clear();
                return true;
            }
            int newCount = this.wizardModel.getSurrogates().length;
            int max = this.wizardModel.daemonSession.getHostProperties().getMaxStations();
            BDirectory subdir = (BDirectory)this.wizardModel.targetStationsRoot.getNavChild(this.wizardModel.targetStationName);
            if (subdir == null) {
                ++newCount;
            }
            return newCount <= max;
        }

        private void initStep() {
            if (!this.stepInitialized) {
                this.listModel = new RemoteStationListModel(this.wizardModel);
                if (this.listModel.getItemCount() > 1) {
                    BScrollPane scrollPane = new BScrollPane((BWidget)new BList((ListModel)this.listModel));
                    this.listModel.getList().setSelection((ListSelection)new RemoteStationListSelection(this));
                    scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                    scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                    BLabel label = new BLabel(BDialog.WARNING_ICON, LEX.getText("CommissioningWizard.stationDeleteStep.chooseHeader", new Object[]{String.valueOf(this.wizardModel.daemonSession.getHostProperties().getMaxStations())}));
                    label.setHalign(BHalign.left);
                    this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)label, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT)));
                } else if (this.listModel.getItemCount() == 1) {
                    BLabel label = new BLabel(BDialog.WARNING_ICON, LEX.getText("CommissioningWizard.stationDeleteStep.deleteHeader", new Object[]{this.listModel.getStation(0).getStationName()}));
                    label.setHalign(BHalign.left);
                    this.setContent((BWidget)new BEdgePane((BWidget)label, null, null, null, null));
                }
                this.stepInitialized = true;
            }
        }
    }

    private static class DispositionStep
    extends CommissioningWizardStep {
        private EnumRadioGroup group;

        public DispositionStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
        }

        @Override
        public String getStepName() {
            return "stationDispositionStep";
        }

        @Override
        public String getSectionName() {
            return "station";
        }

        @Override
        public void enter() {
            BGridPane gridPane = new BGridPane(1);
            gridPane.setValign(BValign.top);
            gridPane.setHalign(BHalign.left);
            this.group = new EnumRadioGroup(this.wizardModel.owner, new String[]{LEX.getText("StationCopier.clean.fullDesc", new Object[]{this.wizardModel.targetStationName}), BStationDispositionEnum.replaceDuplicates.getDisplayTag(null)}, (BEnum[])new BFrozenEnum[]{BStationDispositionEnum.clean, BStationDispositionEnum.replaceDuplicates}, (BEnum)this.wizardModel.stationDisposition);
            for (BWidget groupWidget : this.group.getWidgets()) {
                gridPane.add(null, (BValue)groupWidget);
            }
            this.setContent((BWidget)gridPane);
        }

        @Override
        public boolean exit(int direction) {
            this.wizardModel.stationDisposition = (BStationDispositionEnum)this.group.getValue();
            this.wizardModel.stationsToDelete.clear();
            if (this.wizardModel.stationDisposition == BStationDispositionEnum.clean) {
                RemoteStationListModel remoteStations = new RemoteStationListModel(this.wizardModel);
                for (int i = 0; i < remoteStations.getItemCount(); ++i) {
                    if (!remoteStations.getItem(i).equals(this.wizardModel.targetStationName) || this.wizardModel.stationsToDelete.contains(remoteStations.getStation(i))) continue;
                    this.wizardModel.stationsToDelete.add(remoteStations.getStation(i));
                    break;
                }
            }
            return true;
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipStation || !this.targetDirectoryExists();
        }

        @Override
        public int getMode() {
            return 3;
        }

        private boolean targetDirectoryExists() {
            try {
                BDirectory subdir = (BDirectory)this.wizardModel.targetStationsRoot.getNavChild(this.wizardModel.targetStationName);
                return subdir != null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error checking for station directory existence", e);
                return false;
            }
        }
    }

    private static class DetailsStep
    extends CommissioningWizardStep {
        private final BEdgePane rightPane = new BEdgePane();
        private BDirectoryTree tree = null;

        public DetailsStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
            BLabel label = new BLabel(LEX.getText("StationCopier.DetailsStep.description"));
            label.setHalign(BHalign.left);
            this.rightPane.setTop((BWidget)new BBorderPane((BWidget)label, 0.0, 0.0, 8.0, 0.0));
            this.setContent((BWidget)this.rightPane);
        }

        @Override
        public String getStepName() {
            return "stationDetailsStep";
        }

        @Override
        public String getSectionName() {
            return "station";
        }

        @Override
        public void enter() {
            if (this.tree == null) {
                this.tree = new BDirectoryTree((TreeModel)this.wizardModel.directoryTreeModel);
                this.rightPane.setCenter((BWidget)new BScrollPane((BWidget)this.tree));
            } else if (this.wizardModel.directoryTreeModel != this.tree.getModel()) {
                this.tree.setModel((TreeModel)this.wizardModel.directoryTreeModel);
            }
            this.getWidget().relayout();
        }

        @Override
        public boolean exit(int direction) {
            return true;
        }

        @Override
        public boolean isSkipped() {
            if (this.wizardModel.skipStation) {
                return true;
            }
            if (this.wizardModel.stationContent != BStationContentEnum.selectedDirectories) {
                return true;
            }
            try {
                for (BIFile kid : this.wizardModel.stationDir.listFiles()) {
                    if (!kid.isDirectory()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error checking for subdirectories", e);
            }
            return true;
        }

        @Override
        public int getMode() {
            return 3;
        }
    }

    private static class ContentStep
    extends CommissioningWizardStep {
        private EnumRadioGroup group;
        private boolean hasSetDispositionDefault = false;

        public ContentStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
        }

        @Override
        public String getStepName() {
            return "stationContentStep";
        }

        @Override
        public String getSectionName() {
            return "station";
        }

        @Override
        public void enter() {
            BGridPane gridPane = new BGridPane(1);
            gridPane.setValign(BValign.top);
            gridPane.setHalign(BHalign.left);
            BStationContentEnum initialValue = this.wizardModel.stationContent;
            if (this.sourceHasSubdirs()) {
                if (this.wizardModel.isAxMigration) {
                    if (initialValue == BStationContentEnum.everything) {
                        initialValue = BStationContentEnum.selectedDirectories;
                    }
                    this.group = new EnumRadioGroup(this.wizardModel.owner, (BEnum[])new BFrozenEnum[]{BStationContentEnum.selectedDirectories, BStationContentEnum.configOnly}, (BEnum)initialValue, null);
                } else {
                    this.group = new EnumRadioGroup(this.wizardModel.owner, (BEnum[])new BFrozenEnum[]{BStationContentEnum.selectedDirectories, BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)initialValue, null);
                }
            } else {
                if (initialValue == BStationContentEnum.selectedDirectories) {
                    initialValue = BStationContentEnum.everything;
                }
                this.group = new EnumRadioGroup(this.wizardModel.owner, (BEnum[])new BFrozenEnum[]{BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)initialValue, null);
            }
            for (BWidget groupWidget : this.group.getWidgets()) {
                gridPane.add(null, (BValue)groupWidget);
            }
            this.setContent((BWidget)gridPane);
            gridPane.relayout();
        }

        @Override
        public boolean exit(int direction) {
            this.wizardModel.stationContent = (BStationContentEnum)this.group.getValue();
            if (!this.hasSetDispositionDefault) {
                this.hasSetDispositionDefault = true;
                if (this.group.getValue() == BStationContentEnum.everything) {
                    this.wizardModel.stationDisposition = BStationDispositionEnum.clean;
                }
            }
            return true;
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipStation || this.wizardModel.stationDir == null || this.configBogOnly();
        }

        @Override
        public int getMode() {
            return 3;
        }

        private boolean configBogOnly() {
            try {
                for (BIFile file : this.wizardModel.stationDir.listFiles()) {
                    if (!(file.isDirectory() ? !this.ignoreDirectory((BDirectory)file) : !file.getFileName().equals("config.bog") && !this.ignoreFile(file))) continue;
                    return false;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error checking for station directory existence", e);
            }
            return true;
        }

        private boolean ignoreFile(BIFile file) {
            for (PatternFilter fileExcludePattern : this.wizardModel.fileExcludePatterns) {
                if (!fileExcludePattern.accept(file)) continue;
                return true;
            }
            return false;
        }

        private boolean ignoreDirectory(BDirectory directory) {
            for (PatternFilter directoryExcludePattern : this.wizardModel.directoryExcludePatterns) {
                if (!directoryExcludePattern.accept((BIFile)directory)) continue;
                return true;
            }
            return false;
        }

        private boolean sourceHasSubdirs() {
            try {
                for (BIFile file : this.wizardModel.stationDir.listFiles()) {
                    if (!file.isDirectory()) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error checking for station directory existence", e);
                return false;
            }
        }
    }

    private static class ModeControlModel
    extends TextModel {
        private final CommissioningWizardStep step;

        public ModeControlModel(CommissioningWizardStep pStep) {
            this.step = pStep;
        }

        protected void textModified() {
            this.step.wizardModel.update(this.step.getMode());
        }
    }

    private static class StationListModel
    extends ListModel {
        private final List<BDirectory> stationDirs;

        public StationListModel() {
            BDirectory stationRoot = (BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getStationsDirPath((boolean)true));
            this.stationDirs = new ArrayList<BDirectory>();
            if (stationRoot != null) {
                for (BIFile kid : stationRoot.listFiles()) {
                    if (!(kid instanceof BDirectory)) continue;
                    BINavNode configBogNode = kid.getNavChild("config.bog");
                    try {
                        if (configBogNode == null || ((BBogFile)configBogNode).getBogVersion().compareTo(ValueDocEncoder.BOG_VERSION_4) < 0) continue;
                        this.stationDirs.add((BDirectory)kid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public int indexOfDirectory(BDirectory dir) {
            if (dir == null) {
                return 0;
            }
            int result = this.stationDirs.indexOf(dir);
            if (result >= 0) {
                return result + 1;
            }
            return -1;
        }

        public int getItemCount() {
            return this.stationDirs.size() + 1;
        }

        public BDirectory getStationDirectory(int index) {
            if (index == 0) {
                return null;
            }
            return this.stationDirs.get(index - 1);
        }

        public Object getItem(int index) {
            if (index == 0) {
                return LEX.getText("CommissioningWizard.stationStep.noStation");
            }
            return this.getStationDirectory(index).getFileName();
        }
    }

    private static class StationListController
    extends ListController {
        private final StationStep step;

        StationListController(StationStep pStep) {
            this.step = pStep;
        }

        protected void handleEnter(BKeyEvent event) {
            super.handleEnter(event);
            this.updateEnabledStates(this.getList().getSelection().getItem());
        }

        protected void checkSelection(BMouseEvent event, int item) {
            super.checkSelection(event, item);
            this.updateEnabledStates(item);
        }

        public void itemEntered(BMouseEvent event, int index) {
            this.getSelection().deselectAll();
            this.getSelection().select(index);
        }

        public void updateEnabledStates(int item) {
            block10: {
                try {
                    this.step.setInvalidSelection(null);
                    this.step.setEncodingInfo(null);
                    if (item < 1) {
                        this.step.setStationName(null);
                        break block10;
                    }
                    BDirectory stationDir = this.step.listModel.getStationDirectory(this.step.listModel.getList().getSelectedIndex());
                    BBogFile stationBog = (BBogFile)stationDir.getNavChild("config.bog");
                    if (stationBog.isModified()) {
                        this.step.setInvalidSelection("CommissioningWizard.stationStep.stationFileLocked");
                    } else {
                        try {
                            if (stationBog.usesKeyRingEncryption()) {
                                this.step.setInvalidSelection("CommissioningWizard.stationStep.cannotTransferKeyring");
                            } else {
                                this.step.setEncodingInfo(stationBog);
                            }
                        }
                        catch (Exception e) {
                            this.step.setInvalidSelection("CommissioningWizard.stationStep.passPhraseError");
                            CommissioningWizardStep.log.log(Level.SEVERE, "error processing bog password encoding", e);
                        }
                    }
                    this.step.setStationName(this.step.listModel.getStationDirectory(item).getFileName());
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
    }
}

