/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.ui.util.BBox;
import com.tridium.util.MapUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

public class RuntimeProfileStep
extends CommissioningWizardStep {
    private Map<RuntimeProfile, BCheckBox> checkBoxes = new TreeMap<RuntimeProfile, BCheckBox>();

    public RuntimeProfileStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
        BGridPane content = new BGridPane(1);
        content.setValign(BValign.top);
        content.setHalign(BHalign.left);
        content.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.runtimeProfile.header"), BHalign.left));
        content.add(null, (BValue)new BBox(0.0, 5.0));
        content.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.runtimeProfile.prompt"), BHalign.left));
        for (final RuntimeProfile profile : RuntimeProfile.values()) {
            ToggleCommand cmd = new ToggleCommand((BWidget)content, Lexicon.make((String)"platDaemon", (Context)wizardModel.daemonSession.getSessionContext()).getText(String.format("RuntimeProfile.%s.long", profile.name())), null, null, Lexicon.make((String)"platDaemon", (Context)wizardModel.daemonSession.getSessionContext()).getText(String.format("RuntimeProfile.%s.long", profile.name()))){
                private RuntimeProfile cmdProfile;
                {
                    super(x0, x1, x2, x3, x4);
                    this.cmdProfile = profile;
                }

                public synchronized void setSelected(boolean selected) {
                    super.setSelected(selected);
                    if (selected && this.cmdProfile.equals((Object)RuntimeProfile.wb)) {
                        ((BCheckBox)RuntimeProfileStep.this.checkBoxes.get(RuntimeProfile.ux)).setSelected(true);
                    } else if (selected && this.cmdProfile.equals((Object)RuntimeProfile.ux)) {
                        ((BCheckBox)RuntimeProfileStep.this.checkBoxes.get(RuntimeProfile.wb)).setSelected(true);
                    } else if (!selected && this.cmdProfile.equals((Object)RuntimeProfile.ux)) {
                        ((BCheckBox)RuntimeProfileStep.this.checkBoxes.get(RuntimeProfile.wb)).setSelected(false);
                    } else if (!selected && this.cmdProfile.equals((Object)RuntimeProfile.wb)) {
                        ((BCheckBox)RuntimeProfileStep.this.checkBoxes.get(RuntimeProfile.ux)).setSelected(false);
                    }
                }
            };
            BCheckBox checkBox = new BCheckBox(cmd);
            this.checkBoxes.put(profile, checkBox);
            content.add(null, (BValue)checkBox);
        }
        for (Map.Entry entry : this.checkBoxes.entrySet()) {
            switch (wizardModel.daemonSession.getHostProperties().getSupportForRuntimeProfile((RuntimeProfile)entry.getKey())) {
                case required: {
                    ((BCheckBox)entry.getValue()).setSelected(true);
                    ((BCheckBox)entry.getValue()).setEnabled(false);
                    break;
                }
                case optional: {
                    ((BCheckBox)entry.getValue()).setEnabled(true);
                    break;
                }
                case unsupported: {
                    ((BCheckBox)entry.getValue()).setSelected(false);
                    ((BCheckBox)entry.getValue()).setEnabled(false);
                }
            }
        }
        this.setContent((BWidget)content);
    }

    @Override
    public String getStepName() {
        return "runtimeProfile";
    }

    @Override
    public String getSectionName() {
        return "runtimeProfile";
    }

    @Override
    public void enter() {
        if (this.wizardModel.enabledRuntimeProfiles == null) {
            this.wizardModel.enabledRuntimeProfiles = new HashSet<RuntimeProfile>();
            for (String string : this.wizardModel.daemonSession.getHostProperties().getEnabledRuntimeProfileNames().split(",")) {
                this.wizardModel.enabledRuntimeProfiles.add(RuntimeProfile.valueOf((String)string));
            }
        }
        for (RuntimeProfile runtimeProfile : RuntimeProfile.values()) {
            this.checkBoxes.get(runtimeProfile).setSelected(this.wizardModel.enabledRuntimeProfiles.contains(runtimeProfile));
        }
    }

    @Override
    public boolean exit(int direction) {
        Set checkedProfiles = this.checkBoxes.entrySet().stream().filter(entry -> ((BCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (this.wizardModel.enabledRuntimeProfiles == null || !MapUtil.compare(checkedProfiles, this.wizardModel.enabledRuntimeProfiles).matchesExactly()) {
            this.wizardModel.enabledRuntimeProfiles = checkedProfiles;
            this.wizardModel.runtimeProfilesChanged = true;
        }
        return true;
    }

    @Override
    public int getMode() {
        return 3;
    }

    @Override
    public boolean isSkipped() {
        return this.wizardModel.skipRuntimeProfiles;
    }
}

