/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BByteInstallable;
import com.tridium.install.installable.BDeleteFileInstallable;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.UserAccount;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.commissioningwizard.LexiconSourceModel;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;

public class ReviewStep
extends CommissioningWizardStep {
    private int mode = 0;

    public ReviewStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
    }

    @Override
    public String getStepName() {
        return "review";
    }

    @Override
    public String getSectionName() {
        return "wizard";
    }

    @Override
    public void enter() {
        try {
            BLabel headerLabel;
            boolean mustReboot = false;
            boolean showNoChangesDetails = false;
            this.mode = 0;
            this.wizardModel.update(0);
            this.wizardModel.noChanges = true;
            this.wizardModel.solution = this.wizardModel.distSolution == null ? (this.wizardModel.moduleScenario == null ? this.wizardModel.initialScenario : this.wizardModel.moduleScenario) : this.wizardModel.distSolution;
            BIndentPane indent = new BIndentPane();
            if (!this.wizardModel.solution.canCommit()) {
                this.wizardModel.noChanges = false;
                headerLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText(this.wizardModel.softwareReadonly ? "CommissioningWizard.review.softwareReadonly.header" : "CommissioningWizard.review.unavailable.header"), (boolean)false);
                indent.add((BWidget)headerLabel);
                indent.indent();
                indent.add((BWidget)new BBox(0.0, 5.0));
                for (UnmeetableDependency dependency : this.wizardModel.solution.getUnmeetableDependencies()) {
                    indent.add(dependency.toString());
                }
                indent.add((BWidget)new BBox(0.0, 5.0));
                indent.unindent();
                if (!this.wizardModel.isSoftwareReadonly()) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.unavailable.footer"), (boolean)false));
                }
            } else {
                BGridPane grid;
                BGridPane installables;
                ArrayList<Object> extraInstallables;
                headerLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.header"), (boolean)false);
                indent.add((BWidget)headerLabel);
                indent.add((BWidget)new BBox(0.0, 10.0));
                if (!this.wizardModel.skipModules && this.wizardModel.moduleScenario.hasChanges()) {
                    this.wizardModel.noChanges = false;
                }
                if (!this.wizardModel.skipSyncLocalTime && this.wizardModel.syncLocalTime) {
                    this.wizardModel.noChanges = false;
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.dateTime.header"), (boolean)true));
                    indent.indent();
                    indent.add(this.getLexiconText("CommissioningWizard.review.dateTime.syncLocalTime"));
                    indent.unindent();
                }
                if (!this.wizardModel.skipStation) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.station.header"), (boolean)true));
                    indent.indent();
                    if (this.wizardModel.stationDir == null) {
                        indent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
                    } else {
                        this.wizardModel.noChanges = false;
                        if (!this.wizardModel.restartEnabled) {
                            mustReboot = true;
                        }
                        extraInstallables = new ArrayList<Object>();
                        for (BIFile file : this.getStationTransferContents()) {
                            extraInstallables.add(new BFileInstallable(file, this.getStationDestDir(file.getFilePath())));
                        }
                        this.wizardModel.solution = this.wizardModel.solution.solve(null, null, null, extraInstallables.toArray(new BInstallable[extraInstallables.size()]), (InstallableRegistry)LocalInstallableRegistry.getInstance());
                        BGridPane grid2 = new BGridPane(2);
                        grid2.setValign(BValign.top);
                        grid2.setHalign(BHalign.left);
                        LabelUtil.addLabelWidgetPair((BPane)grid2, (LexiconText)this.getLexiconText("CommissioningWizard.review.station.source"), (BWidget)new BLabel(this.wizardModel.stationDir.getFilePath().getBody()), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid2, (LexiconText)this.getLexiconText("CommissioningWizard.stationStep.targetStationName"), (BWidget)new BLabel(this.wizardModel.targetStationName), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid2, (LexiconText)this.getLexiconText("CommissioningWizard.review.station.content"), (BWidget)new BLabel(this.wizardModel.stationContent.getDisplayTag(null)), (boolean)false);
                        if (this.wizardModel.targetStationsRoot.getNavChild(this.wizardModel.targetStationName) != null) {
                            if (this.wizardModel.stationDisposition == BStationDispositionEnum.clean) {
                                LabelUtil.addLabelWidgetPair((BPane)grid2, (LexiconText)this.getLexiconText("CommissioningWizard.review.station.disposition"), (BWidget)new BLabel(LEX.getText("StationCopier.clean.fullDesc", new Object[]{this.wizardModel.targetStationName})), (boolean)false);
                            } else {
                                LabelUtil.addLabelWidgetPair((BPane)grid2, (LexiconText)this.getLexiconText("CommissioningWizard.review.station.disposition"), (BWidget)new BLabel(BStationDispositionEnum.replaceDuplicates.getDisplayTag(null)), (boolean)false);
                            }
                            LabelUtil.addLabelWidgetPair((BPane)grid2, (LexiconText)this.getLexiconText("ApplicationDirector.column.isAutoStart"), (BWidget)new BLabel(String.valueOf(this.wizardModel.autoStart)), (boolean)false);
                        }
                        if (this.wizardModel.stationsToDelete.size() > 0) {
                            StringBuilder deleteNames = new StringBuilder();
                            for (int i = 0; i < this.wizardModel.stationsToDelete.size(); ++i) {
                                String stationName = this.wizardModel.stationsToDelete.get(i).getStationName();
                                deleteNames.append(stationName);
                                deleteNames.append(" ");
                            }
                            LabelUtil.addLabelWidgetPair((BPane)grid2, (LexiconText)this.getLexiconText("CommissioningWizard.review.station.delete"), (BWidget)new BLabel(deleteNames.toString()), (boolean)false);
                        }
                        indent.add((BWidget)grid2);
                    }
                    indent.unindent();
                }
                if (!this.wizardModel.skipRuntimeProfiles) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.runtimeProfiles.header"), (boolean)true));
                    indent.indent();
                    if (!this.wizardModel.runtimeProfilesChanged) {
                        indent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
                    } else {
                        this.wizardModel.noChanges = false;
                        indent.add(String.join((CharSequence)",", this.wizardModel.enabledRuntimeProfiles.stream().map(Enum::name).collect(Collectors.toList())));
                    }
                    indent.unindent();
                }
                if (!this.wizardModel.isSoftwareReadonly() && ((BInstallable[])(installables = this.wizardModel.solution.getToInstall())).length > 0) {
                    this.wizardModel.noChanges = false;
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.module.header"), (boolean)true));
                    indent.indent();
                    for (BInstallable installable : installables) {
                        if (installable.getPart() != null) {
                            indent.add(BVersion.formatNameVersion((BPart)installable.getPart(), null));
                            continue;
                        }
                        if (!(installable instanceof BDistribution)) continue;
                        indent.add(BVersion.formatNameVersion((String)installable.getInstallableName(), (BVersion)installable.getVersion(), null));
                    }
                    indent.unindent();
                }
                if (!this.wizardModel.skipTcp) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.tcp.header"), (boolean)true));
                    indent.indent();
                    if (this.wizardModel.updateTcpIpSettings) {
                        mustReboot = true;
                        this.wizardModel.noChanges = false;
                        grid = new BGridPane(2);
                        grid.setValign(BValign.top);
                        grid.setHalign(BHalign.left);
                        this.wizardModel.solution = new InstallScenario(this.wizardModel.solution.getTargetPlatform(), this.wizardModel.solution.getModulesToUninstall(), null, this.wizardModel.solution.getToInstall(), null, this.wizardModel.tcpIpSettings, this.wizardModel.solution.getNewModuleContent(), this.wizardModel.solution.getNewEnabledRuntimeProfiles(), this.wizardModel.solutionParams, (InstallableRegistry)LocalInstallableRegistry.getInstance(), this.wizardModel.solution.getCertValidator()).solve();
                        boolean ipv6Supported = false;
                        SlotCursor c = this.wizardModel.tcpIpSettings.getAdapters().getProperties();
                        while (c.next(BTcpIpAdapterSettings.class)) {
                            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
                            if (!adapter.getIsIpv6Supported()) continue;
                            ipv6Supported = true;
                            break;
                        }
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.hostName"), (BWidget)new BLabel(this.wizardModel.tcpIpSettings.getHostName()), (boolean)false);
                        if (ipv6Supported) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.niagaraUsesIpv6"), (BWidget)new BLabel(String.valueOf(this.wizardModel.tcpIpSettings.getNiagaraUsesIpv6())), (boolean)false);
                        }
                        if (!this.wizardModel.tcpIpSettings.getUsesAdapterLevelSettings()) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.domain"), (BWidget)new BLabel(this.wizardModel.tcpIpSettings.getDomain()), (boolean)false);
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.gateway"), (BWidget)new BLabel(this.wizardModel.tcpIpSettings.getDefaultGateway()), (boolean)false);
                            StringBuilder dnsHosts = new StringBuilder();
                            SlotCursor cursor = this.wizardModel.tcpIpSettings.getDnsHosts().getProperties();
                            while (cursor.next(BString.class)) {
                                dnsHosts.append(cursor.get().toString());
                                dnsHosts.append(" ");
                            }
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)new BLabel(dnsHosts.toString()), (boolean)false);
                            if (ipv6Supported) {
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)new BLabel(this.wizardModel.tcpIpSettings.getIpv6DefaultGateway()), (boolean)false);
                                StringBuilder dns6Hosts = new StringBuilder();
                                SlotCursor cursor2 = this.wizardModel.tcpIpSettings.getIpv6DnsHosts().getProperties();
                                while (cursor2.next(BString.class)) {
                                    dns6Hosts.append(cursor2.get().toString());
                                    dns6Hosts.append(" ");
                                }
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)new BLabel(dns6Hosts.toString()), (boolean)false);
                            }
                        }
                        if (this.wizardModel.linkCfgHostSettings != null) {
                            boolean showLinkReview = true;
                            if (this.wizardModel.linkCfgHostSettings.getLinkModesSupported().getPropertyCount() == 1 && this.wizardModel.linkCfgHostSettings.getLinkModeSettings().getLinkMode().getOrdinal() == 0) {
                                showLinkReview = false;
                            }
                            if (showLinkReview) {
                                BDaisyChainSettings daisyChainSettings;
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.activeLinkMode"), (BWidget)new BLabel(this.wizardModel.linkCfgHostSettings.getLinkModeSettings().getLinkMode().getDisplayTag(null)), (boolean)false);
                                if (this.wizardModel.linkCfgHostSettings.getLinkModeSettings() instanceof BDaisyChainSettings && (daisyChainSettings = (BDaisyChainSettings)this.wizardModel.linkCfgHostSettings.getLinkModeSettings()).getIsStpSupported()) {
                                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpLabel"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getIsStpEnabled())), (boolean)false);
                                    if (daisyChainSettings.getIsStpEnabled()) {
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpBridgePriority"), (BWidget)new BLabel(daisyChainSettings.getBridgePriority().getDisplayTag(null)), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpPortPriority1"), (BWidget)new BLabel(daisyChainSettings.getPortPriority1().getDisplayTag(null)), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpPortPriority2"), (BWidget)new BLabel(daisyChainSettings.getPortPriority2().getDisplayTag(null)), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpHelloTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getHelloTime())), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpForwardDelayTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getForwardDelayTime())), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpMaxAgingTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getMaxAgingTime())), (boolean)false);
                                    }
                                }
                            }
                        }
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.interfaceCategory"), (BWidget)new BNullWidget(), (boolean)false);
                        indent.add((BWidget)grid);
                        indent.indent();
                        boolean firstPass = true;
                        SlotCursor c2 = this.wizardModel.tcpIpSettings.getAdapters().getProperties();
                        while (c2.next(BTcpIpAdapterSettings.class)) {
                            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c2.get();
                            grid = new BGridPane(2);
                            grid.setValign(BValign.top);
                            grid.setHalign(BHalign.left);
                            if (!firstPass) {
                                grid.add(null, (BValue)new BBox(1.0, 1.0));
                                grid.add(null, (BValue)new BBox(1.0, 1.0));
                            }
                            firstPass = false;
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.interfaceId"), (BWidget)new BLabel(adapter.getAdapterId()), (boolean)false);
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.interfaceDesc"), (BWidget)new BLabel(adapter.getDescription()), (boolean)false);
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.macAddress"), (BWidget)new BLabel(adapter.getMediaAccessControlAddress()), (boolean)false);
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isAdapterEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsAdapterEnabled())), (boolean)false);
                            if (adapter.getIsAdapterEnabled()) {
                                BDhcpdAdapterSettings dhcpdAdapterSettings;
                                SlotCursor cursor;
                                if (adapter.getCanUseDhcp()) {
                                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isDhcpEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsDhcpEnabled())), (boolean)false);
                                    if (!adapter.getIsDhcpEnabled()) {
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipAddress"), (BWidget)new BLabel(adapter.getIpAddress()), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.subnetMask"), (BWidget)new BLabel(adapter.getSubnetMask()), (boolean)false);
                                        if (this.wizardModel.tcpIpSettings.getUsesAdapterLevelSettings()) {
                                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.domain"), (BWidget)new BLabel(adapter.getDomain()), (boolean)false);
                                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.gateway"), (BWidget)new BLabel(adapter.getDefaultGateway()), (boolean)false);
                                            StringBuilder dnsHosts = new StringBuilder();
                                            cursor = adapter.getDnsHosts().getProperties();
                                            while (cursor.next(BString.class)) {
                                                dnsHosts.append(cursor.get().toString());
                                                dnsHosts.append(" ");
                                            }
                                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)new BLabel(dnsHosts.toString()), (boolean)false);
                                        }
                                    }
                                }
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6Supported"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6Supported())), (boolean)false);
                                if (adapter.getIsIpv6Supported()) {
                                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6Enabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6Enabled())), (boolean)false);
                                    if (adapter.getIsIpv6Enabled()) {
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6DhcpEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6DhcpEnabled())), (boolean)false);
                                        if (!adapter.getIsIpv6DhcpEnabled()) {
                                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Address"), (BWidget)new BLabel(adapter.getIpv6Address()), (boolean)false);
                                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6SubnetPrefixLength"), (BWidget)new BLabel(String.valueOf(adapter.getIpv6SubnetPrefixLength())), (boolean)false);
                                            if (this.wizardModel.tcpIpSettings.getUsesAdapterLevelSettings()) {
                                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)new BLabel(adapter.getIpv6DefaultGateway()), (boolean)false);
                                                StringBuilder dns6Hosts = new StringBuilder();
                                                cursor = adapter.getIpv6DnsHosts().getProperties();
                                                while (cursor.next(BString.class)) {
                                                    dns6Hosts.append(cursor.get().toString());
                                                    dns6Hosts.append(" ");
                                                }
                                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)new BLabel(dns6Hosts.toString()), (boolean)false);
                                            }
                                        }
                                    }
                                }
                                if ((dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.get("dhcpdAdapterSettings")) != null) {
                                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.isDhcpdEnabled"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getIsDhcpdIpv4Enabled())), (boolean)false);
                                    if (dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) {
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.defaultLeaseTime.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getDefaultLeaseTime())), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.maxLeaseTime.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getMaxLeaseTime())), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.subnet.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getSubnet()), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.netmask.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getSubnetMask()), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.rangestart.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getStartClientAddress()), (boolean)false);
                                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.rangesize.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getRange())), (boolean)false);
                                    }
                                }
                            }
                            indent.add((BWidget)grid);
                        }
                        indent.unindent();
                    } else {
                        indent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
                    }
                    indent.unindent();
                }
                if (!this.wizardModel.skipSystemPassword && this.wizardModel.newSystemPassword != null && this.wizardModel.oldSystemPassword != null) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.systemPassword"), (boolean)true));
                }
                if (!this.wizardModel.skipAuth) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.auth.header"), (boolean)true));
                    indent.indent();
                    if (this.wizardModel.authUsersChanged || this.wizardModel.authMethodChanged) {
                        this.wizardModel.noChanges = false;
                        grid = new BGridPane(2);
                        grid.setValign(BValign.top);
                        grid.setHalign(BHalign.left);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("CommissioningWizard.review.auth.method"), (BWidget)new BLabel(this.wizardModel.authMethod), (boolean)false);
                        if (DaemonAuthUtil.isNativeScheme((String)this.wizardModel.authMethod)) {
                            if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                                UserAccount toAdd;
                                BIndentPane subIndent = new BIndentPane();
                                boolean changes = false;
                                if (this.wizardModel.nativeUsersToAdd.size() > 0 || this.wizardModel.newNativeUserAccountToAdd != null) {
                                    changes = true;
                                    subIndent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authNativeUsersStep.toAdd.label"), (boolean)false));
                                    subIndent.indent();
                                    if (this.wizardModel.newNativeUserAccountToAdd != null) {
                                        subIndent.add(this.wizardModel.newNativeUserAccountToAdd.getAccountName());
                                    }
                                    for (int i = 0; i < this.wizardModel.nativeUsersToAdd.size(); ++i) {
                                        toAdd = this.wizardModel.nativeUsersToAdd.get(i);
                                        subIndent.add(toAdd.getAccountName());
                                    }
                                    subIndent.unindent();
                                }
                                if (this.wizardModel.nativeUsersToRemove.size() > 0 || this.wizardModel.defaultNativeUserAccountToRemove != null) {
                                    changes = true;
                                    subIndent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authNativeUsersStep.toRemove.label"), (boolean)false));
                                    subIndent.indent();
                                    if (this.wizardModel.defaultAccountPresent) {
                                        subIndent.add(this.wizardModel.defaultNativeUserAccountToRemove.getAccountName() + " " + this.getLexiconText("CommissioningWizard.authNativeUsersStep.toRemove.label.default").getText(null));
                                    }
                                    for (int i = 0; i < this.wizardModel.nativeUsersToRemove.size(); ++i) {
                                        toAdd = this.wizardModel.nativeUsersToRemove.get(i);
                                        subIndent.add(toAdd.getAccountName());
                                    }
                                    subIndent.unindent();
                                }
                                if (this.wizardModel.nativePasswordsToChange.size() > 0) {
                                    changes = true;
                                    subIndent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authNativeUsersStep.changePassword.label"), (boolean)false));
                                    subIndent.indent();
                                    for (int i = 0; i < this.wizardModel.nativePasswordsToChange.size(); ++i) {
                                        toAdd = this.wizardModel.nativePasswordsToChange.get(i);
                                        subIndent.add(toAdd.getAccountName());
                                    }
                                    subIndent.unindent();
                                }
                                if (!changes) {
                                    subIndent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
                                }
                                grid.add(null, (BValue)subIndent);
                            } else {
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authNativeGroupStep.adminList.label"), (BWidget)new BLabel(this.wizardModel.nativeAdminGroup.getFullyQualifiedName()), (boolean)false);
                            }
                        } else if (DaemonAuthUtil.isFileScheme((String)this.wizardModel.authMethod)) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authFileDomainUserStep.user.label"), (BWidget)new BLabel(this.wizardModel.fileDomainAdminUser), (boolean)false);
                        }
                        indent.add((BWidget)grid);
                    } else {
                        indent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
                    }
                    indent.unindent();
                }
                if (!this.wizardModel.skipLexicon) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.lex.header"), (boolean)true));
                    indent.indent();
                    if (this.wizardModel.lexLocalesToInstall.size() == 0) {
                        indent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
                    } else {
                        this.wizardModel.noChanges = false;
                        extraInstallables = new ArrayList();
                        boolean searchLexiconFiles = true;
                        BDirectory lexDir = (BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getLexiconHomePath((boolean)true));
                        if (lexDir == null) {
                            searchLexiconFiles = false;
                        }
                        for (int i = 0; i < this.wizardModel.lexLocalesToInstall.size(); ++i) {
                            LexiconSourceModel locale = this.wizardModel.lexLocalesToInstall.get(i);
                            if (!searchLexiconFiles || locale.lexDir == null) continue;
                            extraInstallables.add(new BFileInstallable((BIFile)locale.lexDir, SystemFilePaths.getLexiconHomePath((boolean)true)));
                            indent.add(locale.lexDir.getFileName());
                        }
                        this.wizardModel.solution = this.wizardModel.solution.solve(null, null, null, extraInstallables.toArray(new BInstallable[extraInstallables.size()]), (InstallableRegistry)LocalInstallableRegistry.getInstance());
                    }
                    indent.unindent();
                }
                if (!this.wizardModel.skipLicense) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.license.header"), (boolean)true));
                    indent.indent();
                    if (this.wizardModel.getLicenseSelection() == null) {
                        indent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
                    } else {
                        this.syncLicenses(indent, this.wizardModel.getLicenseSelection().getLicenseSync(), this.wizardModel.getLicenseSelection().getReviewHeader());
                        showNoChangesDetails |= this.wizardModel.getLicenseSelection().showNoChangesDetailsInReview();
                    }
                    indent.unindent();
                    if (this.wizardModel.certificatesToInstall.size() > 0) {
                        this.wizardModel.noChanges = false;
                        indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.cert.header"), (boolean)true));
                        indent.indent();
                        extraInstallables = new ArrayList();
                        for (int i = 0; i < this.wizardModel.certificatesToInstall.size(); ++i) {
                            CertificateInfo cert = this.wizardModel.certificatesToInstall.get(i);
                            indent.add(cert.toString());
                            extraInstallables.add(new BByteInstallable(new FilePath("!security/certificates/" + cert.vendorCertificate.getVendor() + ".certificate"), cert.getXmlContent()));
                        }
                        this.wizardModel.solution = this.wizardModel.solution.solve(null, null, null, extraInstallables.toArray(new BInstallable[extraInstallables.size()]), (InstallableRegistry)LocalInstallableRegistry.getInstance());
                        indent.unindent();
                    }
                }
                if (this.wizardModel.targetStationName != null && this.wizardModel.startStation) {
                    if (this.wizardModel.restartEnabled) {
                        indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.startApps.header"), (boolean)true));
                        indent.indent();
                        if (this.wizardModel.targetStationName != null && this.wizardModel.startStation) {
                            indent.add(this.wizardModel.targetStationName);
                        }
                        indent.unindent();
                    } else {
                        mustReboot = true;
                    }
                }
                if (mustReboot) {
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.reboot.header"), (boolean)true));
                    indent.indent();
                    indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.review.reboot.message")));
                    indent.unindent();
                }
            }
            this.mode = 1;
            if (this.wizardModel.getSolution() == null || this.wizardModel.getSolution().canCommit()) {
                this.mode |= 4;
            }
            this.wizardModel.update(this.mode);
            if (this.wizardModel.noChanges && !showNoChangesDetails) {
                this.setContent((BWidget)new BEdgePane((BWidget)new BLabel(LEX.getText("CommissioningWizard.review.nochange"), BHalign.left), null, null, null, null));
            } else {
                if (this.wizardModel.noChanges) {
                    headerLabel.setText(this.getLexiconText("CommissioningWizard.review.header.nochange").getText(null));
                }
                BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 4.0, 4.0, 4.0, 4.0));
                scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                this.setContent((BWidget)scrollPane);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean exit(int direction) {
        return true;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    private List<BIFile> getStationTransferContents() {
        ArrayList<BIFile> result = new ArrayList<BIFile>();
        if (this.wizardModel.stationContent == BStationContentEnum.selectedDirectories) {
            Iterator i = this.wizardModel.directoryTreeModel.getCheckedDirectories();
            while (i.hasNext()) {
                BIFile[] files;
                BDirectory sd = (BDirectory)i.next();
                for (BIFile file : files = sd.listFiles()) {
                    if (file.isDirectory() || this.ignoreFile(file)) continue;
                    result.add(file);
                }
            }
        } else if (this.wizardModel.stationContent == BStationContentEnum.everything) {
            TreeSet<FilePath> exclude = new TreeSet<FilePath>((Comparator<FilePath>)FilePathComparator.INSTANCE);
            exclude.add(this.wizardModel.stationDir.getFilePath().merge("history"));
            exclude.add(this.wizardModel.stationDir.getFilePath().merge("alarm"));
            exclude.add(this.wizardModel.stationDir.getFilePath().merge("dataRecovery"));
            this.addAllDataFiles(this.wizardModel.stationDir, exclude, result);
        } else if (this.wizardModel.stationContent == BStationContentEnum.configOnly) {
            result.add((BIFile)this.wizardModel.stationDir.getNavChild("config.bog"));
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    private void addAllDataFiles(BDirectory dir, Set<FilePath> exclude, List<BIFile> result) {
        BIFile[] files;
        for (BIFile file : files = dir.listFiles()) {
            if (exclude.contains(file.getFilePath())) continue;
            if (file.isDirectory()) {
                if (this.ignoreDirectory((BDirectory)file)) continue;
                this.addAllDataFiles((BDirectory)file, exclude, result);
                continue;
            }
            if (this.ignoreFile(file)) continue;
            result.add(file);
        }
    }

    private boolean ignoreFile(BIFile file) {
        for (int i = 0; i < this.wizardModel.fileExcludePatterns.length; ++i) {
            if (!this.wizardModel.fileExcludePatterns[i].accept(file)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreDirectory(BDirectory directory) {
        for (int i = 0; i < this.wizardModel.directoryExcludePatterns.length; ++i) {
            if (!this.wizardModel.directoryExcludePatterns[i].accept((BIFile)directory)) continue;
            return true;
        }
        return false;
    }

    private FilePath getStationDestDir(FilePath sourcePath) {
        FilePath result = this.wizardModel.targetStationsRoot.getFilePath().merge(this.wizardModel.targetStationName);
        for (int i = this.wizardModel.stationDir.getFilePath().depth(); i < sourcePath.depth() - 1; ++i) {
            result = result.merge(sourcePath.nameAt(i));
        }
        return result;
    }

    private void syncLicenses(BIndentPane indent, LicenseSync<LicenseInfo> sync, String header) {
        if (sync == null || sync.unchanged()) {
            indent.add(this.getLexiconText("CommissioningWizard.review.nochange"));
        } else {
            ByteArrayOutputStream bytes;
            int i;
            ArrayList<Object> extraInstallables = new ArrayList<Object>();
            this.wizardModel.noChanges = false;
            indent.add(this.getLexiconText(header));
            int count = sync.toRemove.size();
            if (count != 0) {
                indent.indent();
                indent.add(this.getLexiconText("CommissioningWizard.license.remove"));
                indent.indent();
            }
            for (i = 0; i < count; ++i) {
                LicenseInfo remove = (LicenseInfo)sync.toRemove.get(i);
                indent.add(remove.toString());
                extraInstallables.add(new BDeleteFileInstallable(remove.file));
            }
            if (count != 0) {
                indent.unindent(2);
            }
            if ((count = sync.toAdd.size()) != 0) {
                indent.indent();
                indent.add(this.getLexiconText("CommissioningWizard.license.add"));
                indent.indent();
            }
            for (i = 0; i < count; ++i) {
                LicenseInfo add = (LicenseInfo)sync.toAdd.get(i);
                indent.add(add.toString());
                bytes = new ByteArrayOutputStream();
                try {
                    add.vendorLicense.save((OutputStream)bytes);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
                extraInstallables.add(new BByteInstallable(add.getInstalledFilePath(true), bytes.toByteArray()));
            }
            if (count != 0) {
                indent.unindent(2);
            }
            if ((count = sync.toUpdate.size()) != 0) {
                indent.indent();
                indent.add(this.getLexiconText("CommissioningWizard.license.update"));
                indent.indent();
            }
            for (i = 0; i < count; ++i) {
                LicenseInfo update = (LicenseInfo)sync.toUpdate.get(i);
                indent.add(update.toString());
                bytes = new ByteArrayOutputStream();
                try {
                    update.vendorLicense.save((OutputStream)bytes);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
                extraInstallables.add(new BByteInstallable(update.getInstalledFilePath(true), bytes.toByteArray()));
            }
            if (count != 0) {
                indent.unindent(2);
            }
            try {
                this.wizardModel.solution = this.wizardModel.solution.solve(null, null, null, extraInstallables.toArray(new BInstallable[extraInstallables.size()]), (InstallableRegistry)LocalInstallableRegistry.getInstance());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }
}

