/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platform.SystemFilePaths;
import com.tridium.sys.registry.NModuleInfo;
import java.util.ArrayList;
import java.util.List;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.registry.LexiconInfo;
import javax.baja.sys.Sys;

public class LexiconSourceModel
implements Comparable<LexiconSourceModel> {
    String locale;
    BDirectory lexDir;
    List<NModuleInfo> lexModules;

    LexiconSourceModel(String locale) {
        this.locale = locale;
        this.lexDir = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath(SystemFilePaths.getLexiconHomePath((boolean)true).getBody() + "/" + locale));
        this.lexModules = new ArrayList<NModuleInfo>();
        for (LexiconInfo lexiconModule : Sys.getRegistry().getLexicons()) {
            NModuleInfo m;
            String lang = lexiconModule.getLanguage();
            if (lang == null || lang.length() <= 0 || !lang.equals(locale) || (m = (NModuleInfo)Sys.getRegistry().getModule(lexiconModule.getContainerModuleName(), lexiconModule.getContainerRuntimeProfile())) == null || this.hasLexModule(m)) continue;
            this.lexModules.add(m);
        }
    }

    boolean hasLexModule(NModuleInfo m) {
        String mName = m.getModuleName();
        for (NModuleInfo lexModule : this.lexModules) {
            String lexModuleName = lexModule.getModuleName();
            if (!mName.equals(lexModuleName)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object value) {
        return value != null && value instanceof LexiconSourceModel && ((LexiconSourceModel)value).locale.equals(this.locale);
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    @Override
    public int compareTo(LexiconSourceModel o) {
        return o == null ? 1 : this.locale.compareTo(o.locale);
    }

    public List<NModuleInfo> getLexModules() {
        return this.lexModules;
    }

    public void setLexModules(List<NModuleInfo> lexModules) {
        this.lexModules = lexModules;
    }
}

