/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public abstract class CommissioningWizardStep {
    private BEdgePane contentPane;
    private final BEdgePane stepPane;
    CommissioningWizardStep priorStep = null;
    CommissioningWizardStep nextStep = null;
    CommissioningWizardStep lastStep = this;
    CommissioningWizardStep stepAfterSection = null;
    protected CommissioningWizardModel wizardModel;
    static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    static final Logger log = Logger.getLogger("platDaemon");

    public CommissioningWizardStep(CommissioningWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.contentPane = new BEdgePane(null, null, null, null, null);
        this.stepPane = new BEdgePane((BWidget)new BWizardHeader(this.getIcon(), LEX.getText("CommissioningWizard." + this.getSectionName() + ".sectionDesc"), LEX.get("CommissioningWizard." + this.getStepName() + ".desc", "")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
    }

    public BWidget getWidget() {
        return this.stepPane;
    }

    public final BImage getIcon() {
        String iconOrd = LEX.get("CommissioningWizard." + this.getSectionName() + ".sectionIcon", null);
        return iconOrd == null ? null : BImage.make((String)iconOrd);
    }

    public abstract String getStepName();

    public abstract String getSectionName();

    public void sendDaemonMessages() {
    }

    protected void setContent(BWidget content) {
        this.contentPane.setCenter(content);
        content.relayout();
        this.contentPane.relayout();
    }

    public boolean showCancelPrompt() {
        return true;
    }

    public int getMode() {
        int result = 0;
        CommissioningWizardStep step = this.priorStep;
        while (step != null && step.isSkipped()) {
            step = step.priorStep;
        }
        if (step != null) {
            result = 1;
        }
        step = this.nextStep;
        while (step != null && step.isSkipped()) {
            step = step.nextStep;
        }
        result = step == null ? (result |= 4) : (result |= 2);
        return result;
    }

    public void enter() {
    }

    public boolean checkBack() {
        return true;
    }

    public boolean checkNext() {
        return true;
    }

    public boolean exit(int direction) {
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isSkipped() {
        return false;
    }

    protected LexiconText getLexiconText(String key) {
        return LexiconText.make((String)"platDaemon", (String)key);
    }

    public void setStepAfterSection(CommissioningWizardStep value) {
        this.stepAfterSection = value;
        this.lastStep.nextStep = value;
        if (value != null) {
            value.priorStep = this.lastStep;
        }
    }
}

