/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DistLicenseFeatureFilter;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.Jre8AzulDistLicenseFeatureFilter;
import com.tridium.install.Qnx7DistLicenseFeatureFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.FileLock;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.commissioningwizard.AuthStep;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningParameters;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.commissioningwizard.DistStep;
import com.tridium.platDaemon.ui.commissioningwizard.FinishPane;
import com.tridium.platDaemon.ui.commissioningwizard.FirstStep;
import com.tridium.platDaemon.ui.commissioningwizard.LexiconSourceModel;
import com.tridium.platDaemon.ui.commissioningwizard.LexiconStep;
import com.tridium.platDaemon.ui.commissioningwizard.LicenseSelection;
import com.tridium.platDaemon.ui.commissioningwizard.LicenseStep;
import com.tridium.platDaemon.ui.commissioningwizard.ModuleStep;
import com.tridium.platDaemon.ui.commissioningwizard.ReviewStep;
import com.tridium.platDaemon.ui.commissioningwizard.RuntimeProfileStep;
import com.tridium.platDaemon.ui.commissioningwizard.StationStep;
import com.tridium.platDaemon.ui.commissioningwizard.SystemPasswordStep;
import com.tridium.platDaemon.ui.commissioningwizard.TcpIpStep;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.ui.util.BDirectoryTree;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class CommissioningWizardModel
extends WizardModel
implements ICancelHint,
InstallableFilter {
    BWidget owner = null;
    BWbShell shell = null;
    BDaemonSession daemonSession = null;
    boolean noChanges = false;
    DaemonSessionTaskHandler sessionTaskHandler = null;
    SolutionParameters solutionParams = null;
    boolean reconnectOnFinish = false;
    boolean isAdmin = false;
    boolean isNpsdk = false;
    boolean isFips = false;
    boolean softwareReadonly = false;
    boolean skipDist = false;
    boolean requireDist = false;
    boolean enableDist = true;
    InstallScenario distSolution = null;
    boolean skipModules = false;
    boolean requireModules = true;
    boolean enableModules = true;
    InstallScenario initialScenario = null;
    InstallScenario moduleScenario = null;
    boolean moduleScenarioHasDists = false;
    boolean enableRuntimeProfiles = false;
    boolean skipRuntimeProfiles = false;
    boolean runtimeProfilesChanged = false;
    Set<RuntimeProfile> enabledRuntimeProfiles = null;
    boolean updateTcpIpSettings = false;
    BTcpIpHostSettings tcpIpSettings = null;
    BTcpIpHostSettings originalTcpIpSettings = null;
    boolean hostFileDirty = false;
    boolean skipTcp = false;
    boolean enableTcp = true;
    BDhcpdHostSettings dhcpdHostSettings = null;
    boolean updateDhcpdSettings = false;
    BLinkCfgHostSettings linkCfgHostSettings = null;
    boolean updateLinkSettings = false;
    boolean systemPasswordReadonly = false;
    boolean defaultSystemPasswordPresent = false;
    boolean skipSystemPassword = true;
    BPassword newSystemPassword = null;
    BPassword oldSystemPassword = null;
    boolean requireSystemPassword = false;
    boolean enableSystemPassword = true;
    String authMethod;
    XElem authInfo = null;
    boolean authReadonly = false;
    boolean authUsersChanged = false;
    boolean authMethodChanged = false;
    boolean requireAuth = false;
    boolean skipAuth = false;
    boolean enableAuth = true;
    boolean skipConfigUsers = false;
    boolean enableConfigUsers = true;
    boolean forceChangeUsers = false;
    boolean forceChangeListFilled = false;
    List<String> forceChangeUserList = new ArrayList<String>();
    Set<String> authTypesSupported = null;
    boolean defaultAccountPresent = false;
    String defaultAccountUserName = null;
    String fileDomainAdminUser = "tridium";
    BPassword fileDomainAdminPassword = BPassword.DEFAULT;
    BUsernameAndPassword newCredentials = null;
    UserAccount newNativeUserAccountToAdd = null;
    UserAccount defaultNativeUserAccountToRemove = null;
    GroupAccount nativeAdminGroup = null;
    List<UserAccount> nativeUsersToRemove = new ArrayList<UserAccount>();
    List<UserAccount> nativeUsersToAdd = new ArrayList<UserAccount>();
    List<UserAccount> nativePasswordsToChange = new ArrayList<UserAccount>();
    List<XmlResponseMessage> authMessageQueue = new ArrayList<XmlResponseMessage>();
    BDirectoryTree.DirectoryTreeModel directoryTreeModel = null;
    BDirectory stationDir = null;
    String targetStationName = null;
    boolean startStation = false;
    boolean isAxMigration = false;
    boolean autoStart = true;
    boolean autoRestart = true;
    BStationContentEnum stationContent = BStationContentEnum.everything;
    BStationDispositionEnum stationDisposition = BStationDispositionEnum.replaceDuplicates;
    FileLock localStationBogLock = null;
    BDirectory targetStationsRoot = null;
    BStationSurrogate stationSurrogate = null;
    List<BStationSurrogate> stationsToDelete = new ArrayList<BStationSurrogate>();
    boolean skipStation = false;
    PatternFilter[] fileExcludePatterns = null;
    PatternFilter[] directoryExcludePatterns = null;
    SecretChars stationBogPassphrase = null;
    PBEEncodingInfo encodingInfo = null;
    List<LexiconSourceModel> lexLocalesToInstall = new ArrayList<LexiconSourceModel>();
    boolean skipLexicon = true;
    LicenseStep licenseStep = null;
    String brandId = null;
    boolean portalAvailable = false;
    List<LicenseInfo> currentLicenses = new ArrayList<LicenseInfo>();
    LicenseSync<LicenseInfo> fileLicenseSync = null;
    Version currentLicenseVersion = null;
    LicenseSelection licenseSelection = null;
    Version maxCoreVersion = null;
    Optional<Long> maintenanceExpiration = null;
    Optional<Long> unreleasedSwAccessExpiration = null;
    boolean skipLicense = false;
    boolean requireLicense = false;
    boolean enableLicense = true;
    boolean licenseReadonly = false;
    List<CertificateInfo> certificatesToInstall = new ArrayList<CertificateInfo>();
    Set<String> availableCertVendors = null;
    List<CertificateInfo> currentCertificates = new ArrayList<CertificateInfo>();
    List<CertificateInfo> localCertificates = new ArrayList<CertificateInfo>();
    boolean systemTimeReadonly = false;
    boolean syncLocalTime = false;
    boolean requireSyncLocalTime = false;
    boolean enableSyncLocalTime = true;
    boolean skipSyncLocalTime = true;
    InstallScenario solution = null;
    boolean canceled;
    CommissioningWizardStep currentStep = null;
    BAppSurrogate[] surrogates = null;
    boolean restartEnabled = true;
    boolean anyAppHalted = false;
    boolean anyAppRunning = false;
    public static Lexicon lex = Lexicon.make((String)"platDaemon");
    static final Logger log = Logger.getLogger("platDaemon");

    public CommissioningWizardModel(BWidget pOwner, BDaemonSession pSession, boolean pRequireDistStep) throws Exception {
        this.daemonSession = pSession;
        this.isAdmin = this.daemonSession.getHostProperties().hasFullAccess();
        this.restartEnabled = this.daemonSession.getHostProperties().getAllowStationRestart();
        this.isNpsdk = this.daemonSession.getHostProperties().getIsNpsdk();
        this.startStation = this.restartEnabled;
        if (pOwner != null) {
            this.owner = pOwner;
            this.shell = BWbShell.getWbShell((BWidget)this.owner);
            this.sessionTaskHandler = new DaemonSessionTaskHandler(this.owner);
            this.solutionParams = new CommissioningParameters(this.sessionTaskHandler, this);
            if (!this.isNpsdk) {
                String[] qnx7Filter = new Qnx7DistLicenseFeatureFilter();
                Jre8AzulDistLicenseFeatureFilter jre8AzulFilter = new Jre8AzulDistLicenseFeatureFilter();
                this.solutionParams.addFilter((InstallableFilter)qnx7Filter);
                this.solutionParams.addFilter((InstallableFilter)jre8AzulFilter);
            }
        }
        if (!CommissioningWizardModel.hostModelAllowsCommissioning(this.daemonSession)) {
            throw new UnsupportedOperationException(lex.getText("CommissioningWizard.cannotCommission", new Object[]{this.daemonSession.getHostProperties().getModelName()}));
        }
        if (!this.isAdmin) {
            this.skipTcp = true;
            this.enableTcp = false;
        }
        this.softwareReadonly = this.daemonSession.getHostProperties().getIsSoftwareReadonly();
        this.enabledRuntimeProfiles = new HashSet<RuntimeProfile>();
        if (this.daemonSession.getHostProperties().getEnabledRuntimeProfileNames() != null) {
            for (String profileName : this.daemonSession.getHostProperties().getEnabledRuntimeProfileNames().split(",")) {
                this.enabledRuntimeProfiles.add(RuntimeProfile.valueOf((String)profileName));
            }
        }
        if (this.softwareReadonly) {
            if (pRequireDistStep) {
                throw new UnsupportedOperationException(lex.getText("CommissioningWizard.cannotCommissionReadonly"));
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("disabling software installation steps because software configuration for target is readonly");
            }
            this.skipDist = true;
            this.enableDist = false;
            this.requireDist = false;
            this.skipRuntimeProfiles = true;
            this.enableRuntimeProfiles = false;
            this.skipModules = true;
            this.enableModules = false;
            this.requireModules = false;
        } else {
            BIFile sysProps = this.daemonSession.getFileSpace().findFile(new FilePath("!defaults/system.properties"));
            BIFile platformBog = this.daemonSession.getFileSpace().findFile(new FilePath("!defaults/platform.bog"));
            if (pRequireDistStep || sysProps == null || platformBog == null) {
                this.skipDist = false;
                this.enableDist = true;
                this.requireDist = true;
            } else {
                this.skipDist = false;
                this.enableDist = true;
                this.requireDist = false;
            }
            this.skipModules = false;
            this.enableModules = true;
            this.requireModules = true;
            this.skipRuntimeProfiles = false;
            this.enableRuntimeProfiles = true;
        }
        if (!this.skipTcp) {
            if (this.getPlatform().getOsPart().getPartName().startsWith("win") && (this.getPlatform().getNrePart().isNull() || this.getPlatform().getNrePart().getVersion().getVendorVersion().compareTo(new Version("3.4")) < 0)) {
                this.skipTcp = true;
                this.enableTcp = false;
            }
            BTcpIpHostSettings settings = new BTcpIpHostSettings();
            TcpUtil.loadFromSession((BTcpIpHostSettings)settings, (BDaemonSession)this.daemonSession);
            if (settings.getIsReadonly()) {
                this.skipTcp = true;
                this.enableTcp = false;
            }
        }
        if (!this.skipAuth) {
            this.authInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new AuthenticationInfoMessage(), "text/xml")).parse();
            XElem authElem = this.authInfo.elem("auth");
            assert (authElem != null);
            this.authMethod = authElem.get("type");
            this.authReadonly = authElem.getb("readonly", false);
            this.authTypesSupported = new HashSet<String>();
            String authTypesSupportedCSV = authElem.get("authTypesSupported", null);
            if (authTypesSupportedCSV == null) {
                this.authTypesSupported.add("digest/file");
                boolean nativeAuthSupport = false;
                try {
                    BOsPart os = this.getPlatform().getOsPart();
                    boolean nativeAuthSupportedDefault = os.getPartName().toLowerCase().startsWith("win");
                    nativeAuthSupport = authElem.getb("nativeAuthSupported", nativeAuthSupportedDefault);
                }
                catch (Exception os) {
                    // empty catch block
                }
                if (nativeAuthSupport) {
                    this.authTypesSupported.add("basic/native");
                }
            } else {
                Collections.addAll(this.authTypesSupported, authTypesSupportedCSV.split(","));
            }
            XElem elem = authElem.elem("admingroup");
            if (elem != null) {
                this.nativeAdminGroup = new GroupAccount(elem.get("name"), elem.get("id"));
            }
            if ((elem = authElem.elem("user")) != null) {
                if (DaemonAuthUtil.isFileScheme((String)this.authMethod)) {
                    this.fileDomainAdminUser = elem.get("name");
                } else if (DaemonAuthUtil.isNativeScheme((String)this.authMethod)) {
                    BNativeUserTable.defaultAccountUserName = this.defaultAccountUserName = elem.get("name", null);
                }
                this.defaultAccountPresent = elem.getb("default", false);
            }
            if (this.authReadonly) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("disabling authentication step because authentication configuration for target is readonly");
                }
                this.requireAuth = false;
                this.forceChangeUsers = false;
                this.skipAuth = true;
                this.enableAuth = false;
                this.skipConfigUsers = true;
                this.enableConfigUsers = false;
            } else if (this.defaultAccountPresent && (!DaemonAuthUtil.isNativeScheme((String)this.authMethod) || this.daemonSession.getHostProperties().supportsServlet("acctmgt"))) {
                this.skipAuth = false;
                this.enableAuth = false;
                this.requireAuth = true;
            }
        }
        if (this.daemonSession.getHostProperties().supportsServlet("systempw")) {
            XElem systemPasswordElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
            this.systemPasswordReadonly = systemPasswordElem.getb("readonly", false);
            this.defaultSystemPasswordPresent = systemPasswordElem.getb("default", false);
            if (this.systemPasswordReadonly) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("disabling system passphrase step because value for target is readonly");
                }
                this.requireSystemPassword = false;
                this.skipSystemPassword = true;
                this.enableSystemPassword = false;
            } else if (this.defaultSystemPasswordPresent) {
                this.skipSystemPassword = false;
                this.enableSystemPassword = false;
                this.requireSystemPassword = true;
            } else {
                this.enableSystemPassword = true;
                this.requireSystemPassword = false;
            }
        } else {
            this.skipSystemPassword = true;
            this.requireSystemPassword = false;
            this.enableSystemPassword = false;
        }
        this.systemTimeReadonly = this.daemonSession.getHostProperties().getIsSystemTimeReadonly();
        BAbsTime remoteLocalTime = DaemonTimeUtil.getLocalTime((BDaemonSession)this.daemonSession);
        BAbsTime localTime = BAbsTime.now();
        if (this.systemTimeReadonly) {
            this.requireSyncLocalTime = false;
            this.skipSyncLocalTime = true;
            this.enableSyncLocalTime = false;
        } else if (Math.abs(localTime.getMillis() - remoteLocalTime.getMillis()) > 3600000L) {
            this.enableSyncLocalTime = false;
            this.requireSyncLocalTime = true;
            this.skipSyncLocalTime = false;
        }
        if (pOwner != null) {
            this.licenseStep = new LicenseStep(this);
            FirstStep firstStep = new FirstStep(this);
            this.currentStep = firstStep;
            firstStep.nextStep = this.licenseStep;
            this.licenseStep.priorStep = firstStep;
            StationStep ss = new StationStep(this);
            RuntimeProfileStep runtimeProfileStep = new RuntimeProfileStep(this);
            this.licenseStep.setStepAfterSection(runtimeProfileStep);
            runtimeProfileStep.nextStep = ss;
            ss.priorStep = runtimeProfileStep;
            LexiconStep ls = new LexiconStep(this);
            ss.setStepAfterSection(ls);
            ModuleStep ms = new ModuleStep(this);
            ls.setStepAfterSection(ms);
            DistStep distStep = new DistStep(this);
            ms.setStepAfterSection(distStep);
            TcpIpStep tcp = new TcpIpStep(this);
            distStep.nextStep = tcp;
            tcp.priorStep = distStep;
            SystemPasswordStep pass = new SystemPasswordStep(this);
            tcp.nextStep = pass;
            pass.priorStep = tcp;
            AuthStep as = new AuthStep(this);
            pass.nextStep = as;
            as.priorStep = pass;
            ReviewStep rev = new ReviewStep(this);
            as.setStepAfterSection(rev);
        }
    }

    public CommissioningWizardModel(BDaemonSession pSession, boolean pRequireDistStep, DaemonSessionTaskListener sessionTaskListener) throws Exception {
        this(null, pSession, pRequireDistStep);
        this.solutionParams = new CommissioningParameters(sessionTaskListener, this);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getTitle() {
        return lex.getText("CommissioningWizard.title", new Object[]{this.daemonSession.getRemoteHost().getNavDisplayName(null)});
    }

    public boolean cancel() {
        if ((!this.getCurrentStep().showCancelPrompt() || BDialog.confirm((BWidget)this.getWizard(), (String)lex.getText("CommissioningWizard.cancel.title"), (Object)lex.getText("CommissioningWizard.cancel.message")) == 4) && this.getCurrentStep().cancel()) {
            if (this.sessionTaskHandler != null) {
                this.sessionTaskHandler.cancelAllTasks();
            }
            this.canceled = true;
            return true;
        }
        return false;
    }

    public void setWizard(BWizard wizard) {
        super.setWizard(wizard);
        if (this.sessionTaskHandler != null) {
            this.sessionTaskHandler.setOwner((BWidget)wizard);
        }
        this.owner = wizard;
    }

    public void init() {
        CommissioningWizardStep step = this.currentStep;
        while (step != null && step.isSkipped()) {
            step = step.nextStep;
        }
        if (this.owner != null) {
            this.update(0);
        }
        if (step != null) {
            step.enter();
            this.update(step);
        }
    }

    public void back() {
        try {
            if (!this.getCurrentStep().checkBack()) {
                return;
            }
            CommissioningWizardStep step = this.getCurrentStep().priorStep;
            if (step != null && this.getCurrentStep().exit(1)) {
                while (step != null && step.isSkipped()) {
                    step = step.priorStep;
                }
                if (step != null) {
                    this.update(0);
                    step.enter();
                    this.update(step);
                }
            }
        }
        catch (Throwable t) {
            BDialog.error((BWidget)this.getWizard(), (String)lex.getText("CommissioningWizard.error.dlgTitle"), (Object)lex.getText("CommissioningWizard.error.dlgMessage"), (Throwable)t);
        }
    }

    public void next() {
        if (!this.getCurrentStep().checkNext()) {
            return;
        }
        new Thread("CommishWizardModel-next"){

            @Override
            public void run() {
                try {
                    if (CommissioningWizardModel.this.owner != null) {
                        CommissioningWizardModel.this.owner.enterBusy();
                    }
                    CommissioningWizardStep step = CommissioningWizardModel.this.getCurrentStep().nextStep;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("next step: " + step.getStepName());
                    }
                    if (CommissioningWizardModel.this.getCurrentStep().exit(2)) {
                        while (step != null && step.isSkipped()) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("skipping step: " + step.getStepName());
                            }
                            step = step.nextStep;
                        }
                        assert (step != null);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("   next step: " + step.getStepName());
                        }
                        if (!CommissioningWizardModel.this.isCanceled() && null != CommissioningWizardModel.this.owner) {
                            CommissioningWizardModel.this.update(0);
                            step.enter();
                            CommissioningWizardModel.this.update(step);
                        }
                    }
                }
                catch (Throwable t) {
                    BDialog.error((BWidget)CommissioningWizardModel.this.getWizard(), (String)lex.getText("CommissioningWizard.error.dlgTitle"), (Object)lex.getText("CommissioningWizard.error.dlgMessage"), (Throwable)t);
                }
                finally {
                    if (CommissioningWizardModel.this.owner != null) {
                        CommissioningWizardModel.this.owner.exitBusy();
                    }
                }
            }
        }.start();
    }

    public boolean finish() {
        if (this.getCurrentStep().exit(4)) {
            if (!this.noChanges) {
                FinishPane.openDialog(this);
            }
            if (this.reconnectOnFinish && this.shell != null) {
                this.shell.hyperlink(BOrd.make((BOrd)this.daemonSession.getAbsoluteOrd(), (String)"view:platDaemon:PlatformAdministration"));
            }
            return true;
        }
        return false;
    }

    public CommissioningWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(CommissioningWizardStep step) {
        if (null != this.owner) {
            this.currentStep = step;
            this.update(step.getWidget(), step.getMode());
        }
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(700.0, 480.0);
    }

    public BAppSurrogate[] getSurrogates() {
        if (this.surrogates == null) {
            try {
                for (BAppSurrogate surrogate : this.surrogates = new SessionSurrogates(this.daemonSession).getAll()) {
                    if (surrogate.getAppStatus() == BStationStatus.failed || surrogate.getAppStatus() == BStationStatus.halted) {
                        this.anyAppHalted = true;
                        continue;
                    }
                    if (!surrogate.isAppRunning()) continue;
                    this.anyAppRunning = true;
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return this.surrogates;
    }

    public BRemoteDaemonPlatform getPlatform() throws Exception {
        return BRemoteDaemonPlatform.make((BDaemonSession)this.daemonSession, (DaemonSessionTaskListener)this.sessionTaskHandler);
    }

    public LicenseSelection getLicenseSelection() {
        return this.licenseSelection;
    }

    public void setLicenseSelection(LicenseSelection value) {
        if (this.licenseSelection != value) {
            this.licenseSelection = value;
            this.maxCoreVersion = null;
            this.maintenanceExpiration = null;
            this.unreleasedSwAccessExpiration = null;
            this.initialScenario = null;
            this.moduleScenario = null;
            this.moduleScenarioHasDists = false;
            this.solution = null;
            Collection<LicenseInfo> licenses = this.getEffectiveLicenses();
            for (InstallableFilter filter : this.solutionParams.installableFilters) {
                if (!(filter instanceof DistLicenseFeatureFilter)) continue;
                ((DistLicenseFeatureFilter)filter).setLicenses(licenses);
            }
        }
    }

    public LicenseSync<LicenseInfo> getFileLicenseSync() {
        return this.fileLicenseSync;
    }

    public void setFileLicenseSync(LicenseSync<LicenseInfo> value) {
        this.fileLicenseSync = value;
        this.maxCoreVersion = null;
        this.maintenanceExpiration = null;
        this.unreleasedSwAccessExpiration = null;
    }

    public Collection<LicenseInfo> getEffectiveLicenses() {
        HashMap<String, LicenseInfo> licenses = new HashMap<String, LicenseInfo>();
        for (LicenseInfo license : this.getCurrentLicenses()) {
            licenses.put(license.getFile().getFileName(), license);
        }
        if (this.licenseSelection != null && this.licenseSelection.getLicenseSync() != null) {
            LicenseSync<LicenseInfo> sync = this.licenseSelection.getLicenseSync();
            for (LicenseInfo toRemove : sync.toRemove) {
                licenses.remove(toRemove.getFile().getFileName());
            }
            for (LicenseInfo toAdd : sync.toAdd) {
                licenses.put(toAdd.getInstalledFileName(), toAdd);
            }
            for (LicenseInfo toUpdate : sync.toUpdate) {
                licenses.put(toUpdate.getInstalledFileName(), toUpdate);
            }
        }
        return licenses.values();
    }

    public Version getNewLicenseVersion() {
        Objects.requireNonNull(this.getLicenseSelection(), "License selection is null");
        Objects.requireNonNull(this.getLicenseSelection().getLicenseSync(), "License selection returns null LicenseSync");
        for (LicenseInfo l : this.getLicenseSelection().getLicenseSync().toAdd) {
            if (!l.vendorLicense.getVendor().equalsIgnoreCase("tridium")) continue;
            return l.vendorLicense.getVersion();
        }
        for (LicenseInfo l : this.getLicenseSelection().getLicenseSync().toUpdate) {
            if (!l.vendorLicense.getVendor().equalsIgnoreCase("tridium")) continue;
            return l.vendorLicense.getVersion();
        }
        return this.currentLicenseVersion;
    }

    public Optional<Long> getMaintenanceExpiration() {
        if (this.maintenanceExpiration == null) {
            Objects.requireNonNull(this.getLicenseSelection(), "License selection is null");
            Objects.requireNonNull(this.getLicenseSelection().getLicenseSync(), "License selection returns null LicenseSync");
            this.maintenanceExpiration = Optional.empty();
            this.checkForMaintenanceExpiration(this.getLicenseSelection().getLicenseSync().toAdd);
            this.checkForMaintenanceExpiration(this.getLicenseSelection().getLicenseSync().toUpdate);
            if (!this.maintenanceExpiration.isPresent()) {
                this.checkForMaintenanceExpiration(this.currentLicenses);
            }
        }
        return this.maintenanceExpiration;
    }

    public Optional<Long> getUnreleasedSwAccessExpiration() {
        if (this.unreleasedSwAccessExpiration == null) {
            Objects.requireNonNull(this.getLicenseSelection(), "License selection is null");
            Objects.requireNonNull(this.getLicenseSelection().getLicenseSync(), "License selection returns null LicenseSync");
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.checkForUnreleasedSwAccessExpiration(this.getLicenseSelection().getLicenseSync().toAdd);
            this.checkForUnreleasedSwAccessExpiration(this.getLicenseSelection().getLicenseSync().toUpdate);
            if (!this.unreleasedSwAccessExpiration.isPresent()) {
                this.checkForUnreleasedSwAccessExpiration(this.currentLicenses);
            }
        }
        return this.unreleasedSwAccessExpiration;
    }

    public Version getMaxCoreVersion() {
        if (this.maxCoreVersion == null) {
            Version newLicenseVersion = this.getNewLicenseVersion();
            this.maxCoreVersion = newLicenseVersion == null ? Version.ZERO : new Version(newLicenseVersion.major() + "." + (newLicenseVersion.minor() + 1));
        }
        return this.maxCoreVersion;
    }

    private void checkForUnreleasedSwAccessExpiration(List<LicenseInfo> licenses) {
        for (LicenseInfo l : licenses) {
            if (!l.vendorLicense.getVendor().equalsIgnoreCase("tridium") || !l.vendorLicense.getUnreleasedSwAccessExpiration().isPresent() || this.unreleasedSwAccessExpiration.isPresent() && this.unreleasedSwAccessExpiration.get() >= (Long)l.vendorLicense.getUnreleasedSwAccessExpiration().get()) continue;
            this.unreleasedSwAccessExpiration = l.vendorLicense.getUnreleasedSwAccessExpiration();
        }
    }

    private void checkForMaintenanceExpiration(List<LicenseInfo> licenses) {
        for (LicenseInfo l : licenses) {
            if (!l.vendorLicense.getVendor().equalsIgnoreCase("tridium") || !l.vendorLicense.getMaintenanceExpiration().isPresent() || this.maintenanceExpiration.isPresent() && this.maintenanceExpiration.get() >= (Long)l.vendorLicense.getMaintenanceExpiration().get()) continue;
            this.maintenanceExpiration = l.vendorLicense.getMaintenanceExpiration();
        }
    }

    private boolean allowInstallableUnderSMA(BInstallable inst) {
        if (this.getMaintenanceExpiration().isPresent() && (Long)inst.getReleaseDate().get() <= this.getMaintenanceExpiration().get()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Selected license specifies active SMA date '" + new Date(this.getMaintenanceExpiration().get()) + "' for installable release date '" + inst.getReleaseDateString() + "', SMA permits installation of '" + inst.getInstallableName() + ":" + inst.getVersion().getVendorVersion() + "'");
            }
            return true;
        }
        return false;
    }

    private boolean allowUnreleasedSoftware(BInstallable inst) {
        if (inst.getReleaseDate().isPresent()) {
            return true;
        }
        if (this.getUnreleasedSwAccessExpiration().isPresent()) {
            if (this.getUnreleasedSwAccessExpiration().get() > System.currentTimeMillis()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Selected license specifies active 'unreleasedSwAccessExpiration' date '" + new Date(this.getUnreleasedSwAccessExpiration().get()) + "', feature permits installation of unreleased installable '" + inst.getInstallableName() + ":" + inst.getVersion().getVendorVersion() + "'");
                }
                return true;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Selected license '" + TextUtil.truncate((String)this.getLicenseSelection().getReviewHeader(), (int)15) + "' feature 'unreleasedSwAccessExpiration' date '" + new Date(this.getUnreleasedSwAccessExpiration().get()) + "' is not active, preventing installation of unreleased installable '" + inst.getInstallableName() + "'");
            }
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Selected license '" + TextUtil.truncate((String)this.getLicenseSelection().getReviewHeader(), (int)15) + "' does not permit installation of unreleased installable '" + inst.getInstallableName() + "', license requires active 'unreleasedSwAccessExpiration' feature");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean acceptInstallable(BInstallable inst) {
        if ((inst instanceof BModuleInstallable || inst instanceof BDistribution) && this.softwareReadonly) {
            return false;
        }
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.commissioning.ignoreLicenseVersion")).booleanValue()) {
            return true;
        }
        try {
            Version maxCoreVersion = this.getMaxCoreVersion();
            if (inst.getInstallableName().startsWith("nre-core") || inst.getInstallableName().equals("baja")) {
                if (inst.getVersion().getVendor().equalsIgnoreCase("tridium")) {
                    if (!inst.getReleaseDate().isPresent()) return this.allowUnreleasedSoftware(inst);
                    if (this.allowInstallableUnderSMA(inst)) {
                        return true;
                    }
                } else if (this.getMaintenanceExpiration().isPresent()) {
                    return true;
                }
                if (inst.getVersion().getVendorVersion().compareTo(maxCoreVersion) < 0) return true;
                if (!log.isLoggable(Level.FINE)) return false;
                log.fine("Selected license '" + TextUtil.truncate((String)this.getLicenseSelection().getReviewHeader(), (int)15) + "' specifies version '" + this.getNewLicenseVersion() + "', installable '" + inst.getInstallableName() + "' requires '" + inst.getVersion().getVendorVersion() + "'");
                return false;
            }
            if (!(inst instanceof BDistribution) || !BPart.matchesName((String)inst.getInstallableFileName(), (String)this.getPlatform().getConfigDistFileName())) return true;
            for (BDependency configDep : inst.getAllDependencies()) {
                if (configDep.getPartType() != BNrePart.TYPE) continue;
                if (inst.getVersion().getVendor().equalsIgnoreCase("tridium")) {
                    if (!inst.getReleaseDate().isPresent()) return this.allowUnreleasedSoftware(inst);
                    if (this.allowInstallableUnderSMA(inst)) {
                        return true;
                    }
                } else if (this.getMaintenanceExpiration().isPresent()) {
                    return true;
                }
                if (configDep.getVersion().getVendorVersion().compareTo(maxCoreVersion) < 0) return true;
                if (!log.isLoggable(Level.FINE)) return false;
                log.fine("Selected license '" + TextUtil.truncate((String)this.getLicenseSelection().getReviewHeader(), (int)15) + "' specifies version '" + this.getNewLicenseVersion() + "', installable '" + inst.getInstallableName() + "' requires '" + inst.getVersion().getVendorVersion() + "'");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception occurred when determining if " + inst.getInstallableName() + " was acceptable, disallowing installable", e);
            return false;
        }
    }

    public boolean isDefaultSystemPasswordPresent() {
        return this.defaultSystemPasswordPresent;
    }

    public void setDefaultSystemPasswordPresent(boolean defaultSystemPasswordPresent) {
        this.defaultSystemPasswordPresent = defaultSystemPasswordPresent;
    }

    public boolean getSystemPasswordReadonly() {
        return this.systemPasswordReadonly;
    }

    public void setSystemPasswordReadonly(boolean systemPasswordReadonly) {
        this.systemPasswordReadonly = systemPasswordReadonly;
    }

    public boolean isRequireSystemPassword() {
        return this.requireSystemPassword;
    }

    public void setRequireSystemPassword(boolean requireSystemPassword) {
        this.requireSystemPassword = requireSystemPassword;
    }

    public void setEnableSystemPassword(boolean enableSystemPassword) {
        this.enableSystemPassword = enableSystemPassword;
    }

    public boolean isEnableSystemPassword() {
        return this.enableSystemPassword;
    }

    public BPassword getNewSystemPassword() {
        return this.newSystemPassword;
    }

    public void setNewSystemPassword(BPassword newSystemPassword) {
        this.newSystemPassword = newSystemPassword;
    }

    public BPassword getOldSystemPassword() {
        return this.oldSystemPassword;
    }

    public void setOldSystemPassword(BPassword oldSystemPassword) {
        this.oldSystemPassword = oldSystemPassword;
    }

    public boolean isSkipSystemPassword() {
        return this.skipSystemPassword;
    }

    public void setSkipSystemPassword(boolean skipSystemPassword) {
        this.skipSystemPassword = skipSystemPassword;
    }

    public List<UserAccount> getNativePasswordsToChange() {
        return this.nativePasswordsToChange;
    }

    public void setNativePasswordsToChange(List<UserAccount> nativePasswordsToChange) {
        this.nativePasswordsToChange = nativePasswordsToChange;
    }

    public boolean getAuthReadonly() {
        return this.authReadonly;
    }

    public void setAuthReadonly(boolean authReadonly) {
        this.authReadonly = authReadonly;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public boolean isAuthUsersChanged() {
        return this.authUsersChanged;
    }

    public void setAuthUsersChanged(boolean authUsersChanged) {
        this.authUsersChanged = authUsersChanged;
    }

    public boolean isAuthMethodChanged() {
        return this.authMethodChanged;
    }

    public void setAuthMethodChanged(boolean authMethodChanged) {
        this.authMethodChanged = authMethodChanged;
    }

    public boolean isRequireAuth() {
        return this.requireAuth;
    }

    public void setRequireAuth(boolean requireAuth) {
        this.requireAuth = requireAuth;
    }

    public boolean isSkipAuth() {
        return this.skipAuth;
    }

    public void setSkipAuth(boolean skipAuth) {
        this.skipAuth = skipAuth;
    }

    public boolean isEnableAuth() {
        return this.enableAuth;
    }

    public void setEnableAuth(boolean enableAuth) {
        this.enableAuth = enableAuth;
    }

    public boolean isForceChangeUsers() {
        return this.forceChangeUsers;
    }

    public void setForceChangeUsers(boolean forceChangeUsers) {
        this.forceChangeUsers = forceChangeUsers;
    }

    public boolean isSkipConfigUsers() {
        return this.skipConfigUsers;
    }

    public void setSkipConfigUsers(boolean skipConfigUsers) {
        this.skipConfigUsers = skipConfigUsers;
    }

    public boolean isEnableConfigUsers() {
        return this.enableConfigUsers;
    }

    public void setEnableConfigUsers(boolean enableConfigUsers) {
        this.enableConfigUsers = enableConfigUsers;
    }

    public boolean isDefaultAccountPresent() {
        return this.defaultAccountPresent;
    }

    public void setDefaultAccountPresent(boolean defaultAccountPresent) {
        this.defaultAccountPresent = defaultAccountPresent;
    }

    public String getDefaultAccountUserName() {
        return this.defaultAccountUserName;
    }

    public void setDefaultAccountUserName(String defaultAccountUserName) {
        this.defaultAccountUserName = defaultAccountUserName;
    }

    public UserAccount getDefaultNativeUserAccountToRemove() {
        return this.defaultNativeUserAccountToRemove;
    }

    public void setDefaultNativeUserAccountToRemove(UserAccount defaultNativeUserAccountToRemove) {
        this.defaultNativeUserAccountToRemove = defaultNativeUserAccountToRemove;
    }

    public BPassword getFileDomainAdminPassword() {
        return this.fileDomainAdminPassword;
    }

    public void setFileDomainAdminPassword(BPassword fileDomainAdminPassword) {
        this.fileDomainAdminPassword = fileDomainAdminPassword;
    }

    public String getFileDomainAdminUser() {
        return this.fileDomainAdminUser;
    }

    public void setFileDomainAdminUser(String fileDomainAdminUser) {
        this.fileDomainAdminUser = fileDomainAdminUser;
    }

    public BUsernameAndPassword getNewCredentials() {
        return this.newCredentials;
    }

    public void setNewCredentials(BUsernameAndPassword newCredentials) {
        this.newCredentials = newCredentials;
    }

    public UserAccount getNewNativeUserAccountToAdd() {
        return this.newNativeUserAccountToAdd;
    }

    public void setNewNativeUserAccountToAdd(UserAccount newNativeUserAccountToAdd) {
        this.newNativeUserAccountToAdd = newNativeUserAccountToAdd;
    }

    public GroupAccount getNativeAdminGroup() {
        return this.nativeAdminGroup;
    }

    public void setNativeAdminGroup(GroupAccount nativeAdminGroup) {
        this.nativeAdminGroup = nativeAdminGroup;
    }

    public List<UserAccount> getNativeUsersToAdd() {
        return this.nativeUsersToAdd;
    }

    public void setNativeUsersToAdd(List<UserAccount> nativeUsersToAdd) {
        this.nativeUsersToAdd = nativeUsersToAdd;
    }

    public List<UserAccount> getNativeUsersToRemove() {
        return this.nativeUsersToRemove;
    }

    public void setNativeUsersToRemove(List<UserAccount> nativeUsersToRemove) {
        this.nativeUsersToRemove = nativeUsersToRemove;
    }

    public List<XmlResponseMessage> getAuthMessageQueue() {
        return this.authMessageQueue;
    }

    public void setAuthMessageQueue(List<XmlResponseMessage> authMessageQueue) {
        this.authMessageQueue = authMessageQueue;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(boolean autoRestart) {
        this.autoRestart = autoRestart;
    }

    public Set<String> getAuthTypesSupported() {
        return this.authTypesSupported;
    }

    public void setAuthTypesSupported(Set<String> authTypesSupported) {
        this.authTypesSupported = authTypesSupported;
    }

    public boolean isSkipLicense() {
        return this.skipLicense;
    }

    public void setSkipLicense(boolean skipLicense) {
        this.skipLicense = skipLicense;
    }

    public boolean isRequireLicense() {
        return this.requireLicense;
    }

    public void setRequireLicense(boolean requireLicense) {
        this.requireLicense = requireLicense;
    }

    public boolean isEnableLicense() {
        return this.enableLicense;
    }

    public void setEnableLicense(boolean enableLicense) {
        this.enableLicense = enableLicense;
    }

    public boolean isLicensesReadonly() {
        return this.licenseReadonly;
    }

    public void setLicenseReadonly(boolean licenseReadonly) {
        this.licenseReadonly = licenseReadonly;
    }

    public List<LicenseInfo> getCurrentLicenses() {
        return this.currentLicenses;
    }

    public void setCurrentLicenses(List<LicenseInfo> currentLicenses) {
        this.currentLicenses = currentLicenses;
    }

    public Version getCurrentLicenseVersion() {
        return this.currentLicenseVersion;
    }

    public void setCurrentLicenseVersion(Version currentLicenseVersion) {
        this.currentLicenseVersion = currentLicenseVersion;
    }

    public List<CertificateInfo> getCertificatesToInstall() {
        return this.certificatesToInstall;
    }

    public void setCertificatesToInstall(List<CertificateInfo> certificatesToInstall) {
        this.certificatesToInstall = certificatesToInstall;
    }

    public Set<String> getAvailableCertVendors() {
        return this.availableCertVendors;
    }

    public void setAvailableCertVendors(Set<String> availableCertVendors) {
        this.availableCertVendors = availableCertVendors;
    }

    public List<CertificateInfo> getCurrentCertificates() {
        return this.currentCertificates;
    }

    public void setCurrentCertificates(List<CertificateInfo> currentCertificates) {
        this.currentCertificates = currentCertificates;
    }

    public String getBrandId() {
        return this.brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public List<CertificateInfo> getLocalCertificates() {
        return this.localCertificates;
    }

    public void setLocalCertificates(List<CertificateInfo> localCertificates) {
        this.localCertificates = localCertificates;
    }

    public boolean isSoftwareReadonly() {
        return this.softwareReadonly;
    }

    public void setSoftwareReadonly(boolean softwareReadonly) {
        this.softwareReadonly = softwareReadonly;
    }

    public boolean isSkipDist() {
        return this.skipDist;
    }

    public void setSkipDist(boolean skipDist) {
        this.skipDist = skipDist;
    }

    public boolean isRequireDist() {
        return this.requireDist;
    }

    public void setRequireDist(boolean requireDist) {
        this.requireDist = requireDist;
    }

    public boolean isEnableDist() {
        return this.enableDist;
    }

    public void setEnableDist(boolean enableDist) {
        this.enableDist = enableDist;
    }

    public boolean isSkipModules() {
        return this.skipModules;
    }

    public void setSkipModules(boolean skipModules) {
        this.skipModules = skipModules;
    }

    public boolean isRequireModules() {
        return this.requireModules;
    }

    public void setRequireModules(boolean requireModels) {
        this.requireModules = this.requireModules;
    }

    public boolean isEnableModules() {
        return this.enableModules;
    }

    public void setEnableModules(boolean enableModules) {
        this.enableModules = enableModules;
    }

    public boolean isEnableRuntimeProfiles() {
        return this.enableRuntimeProfiles;
    }

    public void setEnableRuntimeProfiles(boolean enableRuntimeProfiles) {
        this.enableRuntimeProfiles = enableRuntimeProfiles;
    }

    public boolean isSkipRuntimeProfiles() {
        return this.skipRuntimeProfiles;
    }

    public void setSkipRuntimeProfiles(boolean skipRuntimeProfiles) {
        this.skipRuntimeProfiles = skipRuntimeProfiles;
    }

    public Set<RuntimeProfile> getEnabledRuntimeProfiles() {
        return this.enabledRuntimeProfiles;
    }

    public void setEnabledRuntimeProfiles(Set<RuntimeProfile> enabledRuntimeProfiles) {
        this.enabledRuntimeProfiles = enabledRuntimeProfiles;
    }

    public SolutionParameters getSolutionParams() {
        return this.solutionParams;
    }

    public void setSolutionParams(SolutionParameters solutionParms) {
        this.solutionParams = solutionParms;
    }

    public InstallScenario getInitialScenario() {
        return this.initialScenario;
    }

    public void setInitialScenario(InstallScenario initialScenario) {
        this.initialScenario = initialScenario;
    }

    public InstallScenario getModuleScenario() {
        return this.moduleScenario;
    }

    public void setModuleScenario(InstallScenario moduleScenario) {
        this.moduleScenario = moduleScenario;
    }

    public boolean isModuleScenarioHasDists() {
        return this.moduleScenarioHasDists;
    }

    public void setModuleScenarioHasDists(boolean moduleScenarioHasDists) {
        this.moduleScenarioHasDists = moduleScenarioHasDists;
    }

    public InstallScenario getSolution() {
        return this.solution;
    }

    public void setSolution(InstallScenario solution) {
        this.solution = solution;
    }

    public InstallScenario getDistSolution() {
        return this.distSolution;
    }

    public void setDistSolution(InstallScenario distSolution) {
        this.distSolution = distSolution;
    }

    public BDirectory getStationDir() {
        return this.stationDir;
    }

    public void setStationDir(BDirectory stationDir) {
        this.stationDir = stationDir;
    }

    public SecretChars getStationBogPassphrase() {
        return this.stationBogPassphrase;
    }

    public void setStationBogPassphrase(SecretChars stationBogPassphrase) {
        this.stationBogPassphrase = stationBogPassphrase;
    }

    public String getTargetStationName() {
        return this.targetStationName;
    }

    public void setTargetStationName(String targetStationName) {
        this.targetStationName = targetStationName;
    }

    public boolean isStartStation() {
        return this.startStation;
    }

    public void setStartStation(boolean startStation) {
        this.startStation = startStation;
    }

    public BStationSurrogate getStationSurrogate() {
        return this.stationSurrogate;
    }

    public void setStationSurrogate(BStationSurrogate stationSurrogate) {
        this.stationSurrogate = stationSurrogate;
    }

    public BStationContentEnum getStationContent() {
        return this.stationContent;
    }

    public void setStationContent(BStationContentEnum stationContent) {
        this.stationContent = stationContent;
    }

    public BDirectory getTargetStationsRoot() {
        return this.targetStationsRoot;
    }

    public void setTargetStationsRoot(BDirectory targetStationsRoot) {
        this.targetStationsRoot = targetStationsRoot;
    }

    public boolean isSkipStation() {
        return this.skipStation;
    }

    public void setSkipStation(boolean skipStation) {
        this.skipStation = skipStation;
    }

    public void setStationsToDelete(List<BStationSurrogate> stationsToDelete) {
        this.stationsToDelete = stationsToDelete;
    }

    public List<BStationSurrogate> getStationsToDelete() {
        return this.stationsToDelete;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public BDirectoryTree.DirectoryTreeModel getDirectoryTreeModel() {
        return this.directoryTreeModel;
    }

    public void setDirectoryTreeModel(BDirectoryTree.DirectoryTreeModel directoryTreeModel) {
        this.directoryTreeModel = directoryTreeModel;
    }

    public PBEEncodingInfo getEncodingInfo() {
        return this.encodingInfo;
    }

    public void setEncodingInfo(PBEEncodingInfo encodingInfo) {
        this.encodingInfo = encodingInfo;
    }

    public boolean isSkipTcp() {
        return this.skipTcp;
    }

    public void setSkipTcp(boolean skipTcp) {
        this.skipTcp = skipTcp;
    }

    public boolean isEnableTcp() {
        return this.enableTcp;
    }

    public void setEnableTcp(boolean enableTcp) {
        this.enableTcp = enableTcp;
    }

    public boolean isUpdateTcpIpSettings() {
        return this.updateTcpIpSettings;
    }

    public void setUpdateTcpIpSettings(boolean updateTcpIpSettings) {
        this.updateTcpIpSettings = updateTcpIpSettings;
    }

    public boolean isUpdateDhcpdSettings() {
        return this.updateDhcpdSettings;
    }

    public void setUpdateDhcpdSettings(boolean updateDhcpdSettings) {
        this.updateDhcpdSettings = updateDhcpdSettings;
    }

    public boolean isUpdateLinkSettings() {
        return this.updateLinkSettings;
    }

    public void setUpdateLinkSettings(boolean updateLinkSettings) {
        this.updateLinkSettings = updateLinkSettings;
    }

    public boolean isSystemTimeReadonly() {
        return this.systemTimeReadonly;
    }

    public void setSystemTimeReadonly(boolean systemTimeReadonly) {
        this.systemTimeReadonly = systemTimeReadonly;
    }

    public boolean isSyncLocalTime() {
        return this.syncLocalTime;
    }

    public void setSyncLocalTime(boolean syncLocalTime) {
        this.syncLocalTime = syncLocalTime;
    }

    public boolean isSkipSyncLocalTime() {
        return this.skipSyncLocalTime;
    }

    public void setSkipSyncLocalTime(boolean skipSyncLocalTime) {
        this.skipSyncLocalTime = skipSyncLocalTime;
    }

    public boolean isRequireSyncLocalTime() {
        return this.requireSyncLocalTime;
    }

    public void setRequireSyncLocalTime(boolean requireSyncLocalTime) {
        this.requireSyncLocalTime = requireSyncLocalTime;
    }

    public boolean isEnableSyncLocalTime() {
        return this.enableSyncLocalTime;
    }

    public void setEnableSyncLocalTime(boolean enableSyncLocalTime) {
        this.enableSyncLocalTime = enableSyncLocalTime;
    }

    public boolean isRestartEnabled() {
        return this.restartEnabled;
    }

    public void setRestartEnabled(boolean restartEnabled) {
        this.restartEnabled = restartEnabled;
    }

    public boolean isNoChanges() {
        return this.noChanges;
    }

    public void setNoChanges(boolean noChanges) {
        this.noChanges = noChanges;
    }

    public boolean isNpsdk() {
        return this.isNpsdk;
    }

    public void setNpsdk(boolean npsdk) {
        this.isNpsdk = npsdk;
    }

    public boolean isAxMigration() {
        return this.isAxMigration;
    }

    public void setAxMigration(boolean axMigration) {
        this.isAxMigration = axMigration;
    }

    public PatternFilter[] getFileExcludePatterns() {
        return this.fileExcludePatterns;
    }

    public void setFileExcludePatterns(PatternFilter[] fileExcludePatterns) {
        this.fileExcludePatterns = fileExcludePatterns;
    }

    public PatternFilter[] getDirectoryExcludePatterns() {
        return this.directoryExcludePatterns;
    }

    public void setDirectoryExcludePatterns(PatternFilter[] directoryExcludePatterns) {
        this.directoryExcludePatterns = directoryExcludePatterns;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public static boolean hostModelAllowsCommissioning(BDaemonSession daemon) {
        if (daemon.getHostProperties().getIsNpsdk()) {
            return true;
        }
        String hostModel = daemon.getHostProperties().getModelName();
        boolean legacyHostModel = "NPM3".equalsIgnoreCase(hostModel) || "NPM3E".equalsIgnoreCase(hostModel) || "NPM6".equalsIgnoreCase(hostModel) || "NPM6E".equalsIgnoreCase(hostModel) || "JVLN".equalsIgnoreCase(hostModel);
        return !legacyHostModel;
    }
}

