/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platcrypto.ui.CertificateWizardModel;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.workbench.commands.SessionInfoCommand;
import com.tridium.workbench.nav.BSessionMenuAgent;
import javax.baja.naming.BISession;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BDaemonSessionMenuAgent
extends BSessionMenuAgent {
    public static final BDaemonSessionMenuAgent INSTANCE = new BDaemonSessionMenuAgent();
    public static final Type TYPE = Sys.loadType(BDaemonSessionMenuAgent.class);
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BISession session = (BISession)target;
        SessionInfoCommand info = new SessionInfoCommand(owner, target);
        BMenu menu = super.doMakeMenu(owner, target, cx);
        menu.add(null, (Command)info);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, (BValue)new BActionMenuItem((Command)new CommissioningWizardCommand(owner, (BDaemonSession)target)), null);
        menu.add(null, (BValue)new BActionMenuItem((Command)new CertificateWizardCommand(owner, (BDaemonSession)target)), null);
        if (!session.isConnected()) {
            info.setEnabled(false);
        }
        return menu;
    }

    private class CertificateWizardCommand
    extends Command {
        private BDaemonSession session;

        public CertificateWizardCommand(BWidget pOwner, BDaemonSession pSession) {
            super(pOwner, lex, "CertWizard.openWizard");
            this.session = pSession;
            try {
                this.setEnabled(this.session.isConnected() && this.session.getHostProperties().isNiagara4());
            }
            catch (Exception e) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            try {
                BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
                BWizard.open((BWidget)this.getOwner(), (WizardModel)new CertificateWizardModel(this.session));
            }
            catch (Throwable throwable) {
            }
            finally {
                BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
            }
            return null;
        }
    }

    private class CommissioningWizardCommand
    extends Command {
        private BDaemonSession session;

        public CommissioningWizardCommand(BWidget pOwner, BDaemonSession pSession) {
            super(pOwner, lex, "DaemonSessionMenuAgent.openWizard");
            this.session = pSession;
            try {
                this.setEnabled(this.session.isConnected() && this.session.getHostProperties().isNiagara4() && this.session.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full) && !this.session.getHostProperties().getNiagaraR2Enabled() && !this.session.usesLocalNiagaraHome());
            }
            catch (Exception e) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            try {
                BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
                BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), this.session, false));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
            }
            return null;
        }
    }
}

