/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.install.BDependency;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platDaemon.ui.softwaremanager.BSignatureDetailsPane;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbView;

public class BModuleView
extends BWbView {
    public static final Type TYPE = Sys.loadType(BModuleView.class);
    private BLabel fileNameLabel;
    private BLabel fileSizeLabel;
    private BLabel moduleNameLabel;
    private BLabel descLabel;
    private BLabel versionLabel;
    private BLabel statusLabel;
    private BLabel releaseDateLabel;
    private BGridPane depsGrid;
    private BScrollPane topScroll;
    private BSignatureDetailsPane signaturePane;
    private CertificateChainValidator certValidator;

    public Type getType() {
        return TYPE;
    }

    public BModuleView() {
        this(null, ModuleVerificationMode.low);
    }

    public BModuleView(CertificateChainValidator certValidator, ModuleVerificationMode verificationMode) {
        BGridPane outerGrid = new BGridPane(1);
        outerGrid.setValign(BValign.top);
        outerGrid.setStretchColumn(0);
        outerGrid.setColumnAlign(BHalign.fill);
        BGridPane ledger = new BGridPane(2);
        ledger.setStretchColumn(1);
        ledger.setColumnGap(10.0);
        this.fileNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.fileName"), (BWidget)this.fileNameLabel);
        this.fileSizeLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.fileSize"), (BWidget)this.fileSizeLabel);
        this.moduleNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.moduleName"), (BWidget)this.moduleNameLabel);
        this.descLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.desc"), (BWidget)this.descLabel);
        this.versionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.version"), (BWidget)this.versionLabel);
        this.releaseDateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.releaseDate"), (BWidget)this.releaseDateLabel);
        this.statusLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.status"), (BWidget)this.statusLabel);
        outerGrid.add(null, (BValue)ledger);
        if (certValidator == null) {
            certValidator = new CertificateChainValidator();
            CoreCryptoManager mgr = AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
            ICoreTrustStore trustStore = mgr.getSystemTrustStore();
            certValidator.addTrustAnchors(trustStore);
        }
        this.certValidator = certValidator;
        this.signaturePane = new BSignatureDetailsPane(certValidator, verificationMode, 440);
        this.signaturePane.setLabel(LexiconText.make((Type)TYPE, (String)"ModuleFileView.signatureDetails").getText(null));
        outerGrid.add(null, (BValue)this.signaturePane);
        this.depsGrid = new BGridPane(1);
        outerGrid.add(null, (BValue)new BBorderPane((BWidget)this.depsGrid, LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"ModuleFileView.depsHeader"), (boolean)true)));
        this.depsGrid.setHalign(BHalign.left);
        this.topScroll = new BScrollPane((BWidget)new BBorderPane((BWidget)new BEdgePane(null, null, null, null, (BWidget)outerGrid), 10.0, 10.0, 10.0, 10.0));
        this.topScroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        this.topScroll.setViewportBackground(Theme.scrollPane().getControlBackground());
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        Optional releaseDateLong;
        BModulePart module;
        BModuleInstallable inst;
        if (value instanceof BIFile) {
            inst = BModuleInstallable.make((BIFile)((BIFile)value), (boolean)true, (boolean)false);
            module = inst.getModulePart();
        } else if (value instanceof BModuleInstallable) {
            inst = (BModuleInstallable)value;
            inst.lease(Integer.MAX_VALUE);
            module = inst.getModulePart();
        } else {
            module = (BModulePart)value;
            inst = (BModuleInstallable)module.getInstallable();
            inst.lease(Integer.MAX_VALUE);
        }
        JarSignatureRegistry registry = Nre.getJarSignatureRegistry();
        registry.checkReload();
        inst.getModulePart().initCodeSigners(Nre.getJarSignatureRegistry());
        registry.save();
        this.fileNameLabel.setText(inst.getInstallableFileName());
        this.fileSizeLabel.setText(DaemonFileUtil.fileSize((long)inst.getInstallableFileSize()));
        this.moduleNameLabel.setText(module.getPartName());
        this.descLabel.setText(module.getDescription());
        this.versionLabel.setText(module.getVersion().toString());
        this.statusLabel.setText(module.getStatus().toString(context));
        if (module.getStatus().equals((Object)BModuleStatus.ok)) {
            List statuses = module.getSignatureStatus(this.certValidator);
            boolean isError = false;
            for (ModuleSignatureStatusEnum status : statuses) {
                if (status.isAcceptable(ModuleVerificationMode.low)) continue;
                isError = true;
                break;
            }
            if (isError) {
                this.statusLabel.setText(LexiconText.make((String)"platDaemon", (String)"PartDetailsPane.signatureErrorStatus").getText(context));
            } else if (!statuses.contains(ModuleSignatureStatusEnum.OK) && !statuses.contains(ModuleSignatureStatusEnum.UNKNOWN)) {
                this.statusLabel.setText(LexiconText.make((String)"platDaemon", (String)"PartDetailsPane.signatureWarningStatus").getText(context));
            }
        }
        if ((releaseDateLong = module.getReleaseDate()).isPresent()) {
            this.releaseDateLabel.setText(LicenseUtil.formatDate((long)((Long)releaseDateLong.get())));
        } else {
            this.releaseDateLabel.setText(LexiconText.make((String)"platDaemon", (String)"ModuleFileView.releaseDate.none").get(context, "none"));
        }
        this.signaturePane.loadValue(module);
        this.depsGrid.removeAll();
        SlotCursor c = module.getDependencies().getProperties();
        while (c.next()) {
            BDependency dep = (BDependency)c.get();
            this.depsGrid.add(null, (BValue)new BLabel(BImage.make((BIcon)BPart.getPartTypeIcon((Type)dep.getPartType())), dep.toString()));
        }
        this.setContent((BWidget)new BBorderPane((BWidget)this.topScroll, BBorder.inset, BInsets.DEFAULT));
    }
}

