/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.BDaemonSSLStatus;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.PortConfigController;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.security.AuthenticationException;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BDaemonSSLSettingsView
extends BDaemonSessionView {
    public static final Action settingModified = BDaemonSSLSettingsView.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BDaemonSSLSettingsView.class);
    private final DialogCommand saveCommand;
    private final BGridPane grid = new BGridPane(2);
    private BPlatformSSLSettings settings = null;
    private BHostProperties hostProperties = null;
    private BListDropDown sslStatusDd;
    private BTextField sslPortTextField;
    private BTextDropDown sslAliasTextDd;
    private BListDropDown sslAlgTypeDd;
    private BListDropDown tlsCipherSuiteGroupDd = null;
    private BBooleanFE tlsExtendedMasterSecretFE = null;
    public static BIcon ICON = BIcon.std((String)"daemon.png");
    private static final boolean EDITABLE = true;
    private static final int MAX_ALIAS_DISPLAY_WIDTH = 25;
    private static final int MIN_ALIAS_DISPLAY_WIDTH = 8;
    private static final Version MIN_CIPHER_SUITE_GROUP_VERSION = new Version("4.4.73.25");

    public void settingModified(BWidgetEvent evt) {
        this.invoke(settingModified, (BValue)evt, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDaemonSSLSettingsView() {
        this.grid.setRowGap(5.0);
        this.grid.setHalign(BHalign.center);
        this.grid.setValign(BValign.center);
        BScrollPane scrollPane = new BScrollPane((BWidget)this.grid);
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bounded = new BConstrainedPane((BWidget)scrollPane);
        bounded.setMinSize(225.0, 130.0);
        this.setContent((BWidget)bounded);
        this.saveCommand = new SaveCommand();
    }

    @Override
    protected void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        if (session.getHostProperties().getSslSupported()) {
            this.hostProperties = session.getHostProperties();
            BPlatformSSLSettings settings = this.hostProperties.getSslSettings();
            this.settings = new BPlatformSSLSettings(settings);
            this.createSSLEnabledDropDown(settings);
            this.createSSLPortTextField(settings);
            BDaemonSSLSettingsView.loadAliases(session, settings);
            this.createKeyAlias(settings);
            this.createAlgTypeDropDown(settings);
            this.createExtendedMasterSecretDropDown(settings);
            try {
                if (new Version(this.hostProperties.getDaemonVersion()).compareTo(MIN_CIPHER_SUITE_GROUP_VERSION) >= 0) {
                    this.createCipherSuitesGroupDropDown(settings);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createSSLEnabledDropDown(BPlatformSSLSettings sslSettings) {
        this.sslStatusDd = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.sslStatus"), (BWidget)this.sslStatusDd);
        DefaultListModel model = (DefaultListModel)this.sslStatusDd.getList().getModel();
        int[] ordinals = BDaemonSSLStatus.make((int)0).getRange().getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            if (i == 3) continue;
            model.addItem(null, (Object)BDaemonSSLStatus.make((int)ordinals[i]));
        }
        int index = 0;
        if (sslSettings.getSslEnabled()) {
            index = sslSettings.getSslOnly() ? 2 : 1;
        }
        this.sslStatusDd.getList().setSelectedIndex(index);
        this.linkTo((BComponent)this.sslStatusDd, (Slot)BListDropDown.valueModified, (Slot)settingModified);
        this.sslStatusDd.setEnabled(!sslSettings.getSslEnabledStateReadonly());
    }

    private void createSSLPortTextField(BPlatformSSLSettings sslSettings) {
        String sslPort = sslSettings.getSslPort() < 0 ? "" : String.valueOf(sslSettings.getSslPort());
        this.sslPortTextField = new BTextField(sslPort, 5);
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.sslPort"), (BWidget)this.sslPortTextField);
        this.sslPortTextField.setController((TextController)new PortConfigController());
        this.linkTo((BComponent)this.sslPortTextField, (Slot)BTextField.textModified, (Slot)settingModified);
    }

    private void createKeyAlias(BPlatformSSLSettings sslSettings) {
        String currentAlias = sslSettings.getKeyAlias();
        ArrayList<String> aliases = sslSettings.getAliases();
        int maxWidth = 8;
        boolean currentAliasFound = false;
        if (aliases != null) {
            for (String alias : aliases) {
                if (alias.equalsIgnoreCase(currentAlias)) {
                    currentAliasFound = true;
                }
                if (alias.length() <= maxWidth) continue;
                if (alias.length() < 25) {
                    maxWidth = alias.length();
                    continue;
                }
                maxWidth = 25;
                break;
            }
        } else {
            aliases = new ArrayList<String>();
        }
        if (!currentAliasFound) {
            aliases.add(currentAlias);
        }
        this.sslAliasTextDd = new BTextDropDown(aliases, maxWidth, true);
        BList list = this.sslAliasTextDd.getList();
        for (int i = 0; i < list.getItemCount(); ++i) {
            String listAlias = (String)list.getItem(i);
            if (!listAlias.equalsIgnoreCase(currentAlias)) continue;
            list.setSelectedIndex(i);
            this.sslAliasTextDd.setText((String)list.getSelectedItem());
            break;
        }
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.sslKeyAlias"), (BWidget)this.sslAliasTextDd);
        this.linkTo((BComponent)this.sslAliasTextDd, (Slot)BTextDropDown.valueModified, (Slot)settingModified);
    }

    private static void loadAliases(BDaemonSession session, BPlatformSSLSettings settings) {
        BHostProperties props = session.getHostProperties();
        if (props.getSslSupported() && props.supportsServlet("crypto")) {
            try {
                InputStream in = session.getInputStream("crypto?action=sendServerAliases", BDaemonSession.DEFAULT_TIMEOUT, null, null);
                XElem aliasesElem = XParser.make((InputStream)in).parse();
                settings.loadAliases(aliasesElem);
            }
            catch (Exception e) {
                log.fine("Exception loading aliases.");
            }
        }
    }

    private void createAlgTypeDropDown(BPlatformSSLSettings sslSettings) {
        this.sslAlgTypeDd = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.sslAlgType"), (BWidget)this.sslAlgTypeDd);
        DefaultListModel algTypeModel = (DefaultListModel)this.sslAlgTypeDd.getList().getModel();
        int[] algTypeOrdinals = BSslTlsEnum.make((int)1).getRange().getOrdinals();
        for (int i = 0; i < algTypeOrdinals.length; ++i) {
            BSslTlsEnum type = BSslTlsEnum.make((int)algTypeOrdinals[i]);
            algTypeModel.addItem(null, (Object)type);
            if (type != sslSettings.getSslAlgType()) continue;
            this.sslAlgTypeDd.getList().setSelectedIndex(i);
        }
        this.linkTo((BComponent)this.sslAlgTypeDd, (Slot)BListDropDown.valueModified, (Slot)settingModified);
        boolean canEdit = !sslSettings.getFipsMode() && this.hostProperties.isNiagara4();
        this.sslAlgTypeDd.setEnabled(canEdit);
    }

    private void createCipherSuitesGroupDropDown(BPlatformSSLSettings settings) {
        this.tlsCipherSuiteGroupDd = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.tlsCipherSuiteGroup"), (BWidget)this.tlsCipherSuiteGroupDd);
        DefaultListModel tlsCipherSuiteGroupsModel = (DefaultListModel)this.tlsCipherSuiteGroupDd.getList().getModel();
        int[] cipherSuitesGroupOrdinal = BTlsCipherSuiteGroup.make((int)0).getRange().getOrdinals();
        for (int i = 0; i < cipherSuitesGroupOrdinal.length; ++i) {
            BTlsCipherSuiteGroup type = BTlsCipherSuiteGroup.make((int)cipherSuitesGroupOrdinal[i]);
            tlsCipherSuiteGroupsModel.addItem(null, (Object)type);
            if (type != settings.getTlsCipherSuiteGroup()) continue;
            this.tlsCipherSuiteGroupDd.getList().setSelectedIndex(i);
        }
        this.linkTo((BComponent)this.tlsCipherSuiteGroupDd, (Slot)BListDropDown.valueModified, (Slot)settingModified);
        boolean canEdit = !settings.getFipsMode();
        this.sslAlgTypeDd.setEnabled(canEdit);
    }

    private void createExtendedMasterSecretDropDown(BPlatformSSLSettings settings) {
        this.tlsExtendedMasterSecretFE = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.extendedMasterSecret"), (BWidget)this.tlsExtendedMasterSecretFE);
        if (!settings.getUseExtendedMasterSecret().equals("true") && !settings.getUseExtendedMasterSecret().equals("false")) {
            this.tlsExtendedMasterSecretFE.loadValue((BObject)BBoolean.FALSE);
            this.tlsExtendedMasterSecretFE.setEnabled(false);
        } else {
            this.tlsExtendedMasterSecretFE.loadValue((BObject)BBoolean.make((String)settings.getUseExtendedMasterSecret()));
        }
        this.linkTo((BComponent)this.tlsExtendedMasterSecretFE, (Slot)BBooleanFE.setModified, (Slot)settingModified);
    }

    public DialogCommand getSaveCommand() {
        return this.saveCommand;
    }

    public BPlatformSSLSettings getSettings() {
        String useExtendedMasterSecret;
        this.settings.setKeyAlias(this.sslAliasTextDd.getText());
        this.settings.setSslAlgType((BSslTlsEnum)this.sslAlgTypeDd.getSelectedItem());
        this.settings.setSslPort(Integer.valueOf(this.sslPortTextField.getText()).intValue());
        this.settings.setSslEnabled(this.sslStatusDd.getSelectedIndex() == 1 || this.sslStatusDd.getSelectedIndex() == 2);
        this.settings.setSslOnly(this.sslStatusDd.getSelectedIndex() == 2);
        if (this.tlsCipherSuiteGroupDd != null) {
            this.settings.setTlsCipherSuiteGroup((BTlsCipherSuiteGroup)this.tlsCipherSuiteGroupDd.getSelectedItem());
        }
        try {
            useExtendedMasterSecret = ((BBoolean)this.tlsExtendedMasterSecretFE.saveValue()).getTag();
        }
        catch (Exception e) {
            useExtendedMasterSecret = "true";
        }
        this.settings.setUseExtendedMasterSecret(useExtendedMasterSecret);
        return this.settings;
    }

    public void doSettingModified(BWidgetEvent event) {
        this.saveCommand.setEnabled(this.sslPortTextField.getText().length() != 0);
    }

    public BIcon getIcon() {
        return ICON;
    }

    private class SaveCommand
    extends DialogCommand {
        public SaveCommand() {
            super((BWidget)BDaemonSSLSettingsView.this, 1, UiLexicon.bajaui().getText("commands.save.label"), null, null, null);
            this.setEnabled(false);
        }
    }
}

