/*
 * Decompiled with CFR 0.152.
 */
package com.ic.icsmartviewconfig;

import com.ic.icsmartviewconfig.BIStatusObserver;
import com.ic.icsmartviewconfig.BStatusData;
import com.ic.icsmartviewconfig.BStatusEnum;
import java.util.logging.Logger;
import javax.baja.status.BStatus;

class BStatusObserverManager
implements BIStatusObserver {
    public static final String THIS_CLASS_NAME = "BStatusObserverManager";
    private Logger log;
    public static final String FAULT_CAUSE_DEFAULT = "";
    private BStatusData[] disableStatusObserverData;
    private BStatusData[] disableStatusPrototypes;
    private int disableStatusObserverDataLength;
    private BStatusData[] faultStatusObserverData;
    private BStatusData[] faultStatusPrototypes;
    private int faultStatusObserverDataLength;

    public BStatusObserverManager(int disablesLenght, BStatusData[] disableStatusPrototypes, int faultsLength, BStatusData[] faultStatusPrototypes, Logger log) {
        this.disableStatusObserverData = new BStatusData[disablesLenght];
        this.disableStatusPrototypes = disableStatusPrototypes;
        this.disableStatusObserverDataLength = 0;
        this.faultStatusObserverData = new BStatusData[faultsLength];
        this.faultStatusPrototypes = faultStatusPrototypes;
        this.faultStatusObserverDataLength = 0;
        this.log = log;
    }

    @Override
    public void subscribeStatus(BStatusEnum statusType) {
        BStatusData statusData = this.getStatusData(statusType);
        if (statusData != null) {
            if (statusData.getStatus().equals((Object)BStatus.fault) && BStatusData.isSubscribed(statusData, this.faultStatusObserverData) == -1) {
                this.faultStatusObserverData[this.faultStatusObserverDataLength++] = statusData;
                if (this.faultStatusObserverDataLength > 1) {
                    BStatusData.sortByPriorities(this.faultStatusObserverData);
                }
                this.log.finer("BStatusObserverManager: Fault status subscribe!");
            } else if (statusData.getStatus().equals((Object)BStatus.disabled) && BStatusData.isSubscribed(statusData, this.disableStatusObserverData) == -1) {
                this.disableStatusObserverData[this.disableStatusObserverDataLength++] = statusData;
                if (this.disableStatusObserverDataLength > 1) {
                    BStatusData.sortByPriorities(this.disableStatusObserverData);
                }
                this.log.finer("BStatusObserverManager: Disabled status subscribed!");
            }
        } else {
            this.log.warning("BStatusObserverManager: The BStatusData prototypes doesn't contain BStatusEnum ordinal value: " + Integer.toString(statusType.getOrdinal()));
        }
    }

    @Override
    public void unsubscribeStatus(BStatusEnum statusType) {
        BStatusData statusData = this.getStatusData(statusType);
        if (statusData != null) {
            int faultStatusSubscriptionIndex = BStatusData.isSubscribed(statusData, this.faultStatusObserverData);
            int disableStatusSubscriptionIndex = BStatusData.isSubscribed(statusData, this.disableStatusObserverData);
            if (statusData.getStatus().equals((Object)BStatus.fault) && faultStatusSubscriptionIndex >= 0) {
                this.faultStatusObserverData[faultStatusSubscriptionIndex] = null;
                if (--this.faultStatusObserverDataLength > 0) {
                    BStatusData.moveNullsToArrayEnd(this.faultStatusObserverData, faultStatusSubscriptionIndex);
                }
                this.log.finer("BStatusObserverManager: Fault status unsubscribed");
            } else if (statusData.getStatus().equals((Object)BStatus.disabled) && disableStatusSubscriptionIndex >= 0) {
                this.disableStatusObserverData[disableStatusSubscriptionIndex] = null;
                if (--this.disableStatusObserverDataLength >= 0) {
                    BStatusData.moveNullsToArrayEnd(this.disableStatusObserverData, disableStatusSubscriptionIndex);
                }
                this.log.finer("BStatusObserverManager: Disabled status unsubscribed");
            }
        }
    }

    public String getMostImportantFaultCause() {
        return this.faultStatusObserverData[0] != null ? this.faultStatusObserverData[0].getFaultCause() : FAULT_CAUSE_DEFAULT;
    }

    public static BStatusData getPrototype(int ordinal, BStatusData[] prototypes) {
        for (int i = 0; i < prototypes.length; ++i) {
            if (prototypes[i].getStatusTypeOrdinal() != ordinal) continue;
            return prototypes[i];
        }
        return null;
    }

    private BStatusData getStatusData(BStatusEnum statusType) {
        int ordinal = statusType.getOrdinal();
        if (ordinal == 4 || ordinal == 5) {
            return BStatusObserverManager.getPrototype(ordinal, this.disableStatusPrototypes);
        }
        return BStatusObserverManager.getPrototype(ordinal, this.faultStatusPrototypes);
    }

    public final boolean isDisabled() {
        return this.disableStatusObserverData[0] != null;
    }

    public final boolean isFault() {
        return this.faultStatusObserverData[0] != null;
    }

    public final boolean isSubscribed(BStatusEnum statusType) {
        BStatusData statusData = this.getStatusData(statusType);
        if (statusData != null) {
            return BStatusData.isSubscribed(statusData, this.disableStatusObserverData) >= 0 || BStatusData.isSubscribed(statusData, this.faultStatusObserverData) >= 0;
        }
        this.log.warning("BStatusObserverManager: The BStatusData prototypes doesn't contain BStatusEnum ordinal value: " + Integer.toString(statusType.getOrdinal()));
        return false;
    }
}

