/*
 * Decompiled with CFR 0.152.
 */
package com.ic.icsmartviewconfig;

import javax.baja.status.BStatus;

class BStatusData
implements Comparable<BStatusData> {
    public static final String THIS_CLASS_NAME = "BStatusData";
    private int statusTypeOrdinal;
    private String faultCause;
    private int priority;
    private BStatus status;

    public BStatusData(int statusTypeOrdinal, BStatus status, String faultCause, int priority) {
        this.faultCause = faultCause;
        this.priority = priority;
        this.status = status;
        this.statusTypeOrdinal = statusTypeOrdinal;
    }

    public String getFaultCause() {
        return this.faultCause;
    }

    public int getPriority() {
        return this.priority;
    }

    public BStatus getStatus() {
        return this.status;
    }

    public int getStatusTypeOrdinal() {
        return this.statusTypeOrdinal;
    }

    public static int isSubscribed(BStatusData statusData, BStatusData[] statusObserverData) {
        if (statusData != null) {
            for (int i = 0; i < statusObserverData.length; ++i) {
                if (statusObserverData[i] == null || !statusObserverData[i].compare(statusData)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean compare(BStatusData o) {
        return this.getFaultCause().compareTo(o.getFaultCause()) == 0 && this.getPriority() == o.getPriority() && this.getStatus().getBits() == o.getStatus().getBits() && this.getStatusTypeOrdinal() == o.getStatusTypeOrdinal();
    }

    @Override
    public int compareTo(BStatusData o) {
        if (o != null) {
            return this.getPriority() - o.getPriority();
        }
        return this.getPriority() - 100;
    }

    public boolean hasHigherPriority(BStatusData statusData) {
        return this.getPriority() > statusData.getPriority();
    }

    public static void moveNullsToArrayEnd(BStatusData[] array, int startIndex) {
        for (int i = startIndex; i < array.length - 1; ++i) {
            if (array[i] != null) continue;
            if (array[i + 1] == null) {
                return;
            }
            array[i] = array[i + 1];
            array[i + 1] = null;
        }
    }

    public static void sortByPriorities(BStatusData[] array) {
        int len = array.length;
        BStatusData.moveNullsToArrayEnd(array, 0);
        if (len >= 2 && array[0] != null && array[1] != null) {
            for (int i = 0; i < len - 1; ++i) {
                boolean swapped = false;
                for (int j = 0; j < len - 1 - i && array[j + 1] != null; ++j) {
                    if (array[j].compareTo(array[j + 1]) <= 0) continue;
                    BStatusData temp = array[j];
                    array[j] = array[j + 1];
                    array[j + 1] = temp;
                    swapped = true;
                }
                if (!swapped) break;
            }
        }
    }
}

