/*
 * Decompiled with CFR 0.152.
 */
package com.ic.icsmartviewconfig;

import com.ic.icsmartviewconfig.BExt;
import com.ic.icsmartviewconfig.BLedColorEnum;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BLedExt
extends BExt {
    public static final Property facets = BLedExt.newProperty((int)0, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BLedColorEnum.TYPE)), null);
    public static final Action writeLedOff = BLedExt.newAction((int)16);
    public static final Action writeLedOn = BLedExt.newAction((int)16);
    public static final Action writeLedColor = BLedExt.newAction((int)16, (BValue)BLedColorEnum.DEFAULT, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BLedColorEnum.TYPE)));
    public static final Property ledOn = BLedExt.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property ledColor = BLedExt.newProperty((int)8, (BValue)BLedColorEnum.DEFAULT, null);
    public static final String THIS_CLASS_NAME = "BLedExt";
    private int ledColorPreviousState;
    private int ledPreviousState;
    public static final Type TYPE = Sys.loadType(BLedExt.class);

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public void writeLedOff() {
        this.invoke(writeLedOff, null);
    }

    public void writeLedOn() {
        this.invoke(writeLedOn, null);
    }

    public void writeLedColor(BLedColorEnum arg) {
        this.invoke(writeLedColor, (BValue)arg, null);
    }

    public BStatusBoolean getLedOn() {
        return (BStatusBoolean)this.get(ledOn);
    }

    public void setLedOn(BStatusBoolean v) {
        this.set(ledOn, (BValue)v);
    }

    public BLedColorEnum getLedColor() {
        return (BLedColorEnum)this.get(ledColor);
    }

    public void setLedColor(BLedColorEnum v) {
        this.set(ledColor, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doWriteLedOff() {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                log.finer("writeLedOff() action invoked");
                this.sendRequest("POST", "/api/v2/ledOff", null);
                log.finest("doWriteLedOff() sets POST request to '/api/v2/ledOff'");
            } else {
                log.warning("BLedExt: writeLedOff() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    public void doWriteLedOn() {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                log.finer("writeLedOn() action invoked");
                this.sendRequest("POST", "/api/v2/ledOn", null);
                log.finest("doWriteLedOn() sets POST request to '/api/v2/ledOn'");
            } else {
                log.warning("BLedExt: writeLedOn() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    public void doWriteLedColor(BLedColorEnum v) {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                int ordinal = v.getOrdinal();
                String hexOrdinal = BLedColorEnum.ordinalToHexString(ordinal);
                log.finer("writeLedColor() action invoked with " + hexOrdinal + " API hex value");
                if (ordinal >= 4 && ordinal <= 23) {
                    this.sendRequest("POST", "/api/v2/led/" + hexOrdinal, null);
                    log.finest("doWriteLedColor() sets POST request to '/api/v2/led/" + hexOrdinal + "'");
                } else {
                    log.warning("writeLedColor() action tried to set out of range (" + hexOrdinal + ") color!");
                }
            } else {
                log.warning("BLedExt: writeLedColor() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    @Override
    public void doForceWrite() {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                log.fine("forceWrite() action invoked");
                if (this.getLedOn().getStatus().isNull()) {
                    this.doWriteLedColor(this.getLedColor());
                } else if (this.getLedOn().getBoolean()) {
                    this.doWriteLedOn();
                    this.doWriteLedColor(this.getLedColor());
                } else {
                    this.doWriteLedOff();
                }
            } else {
                log.warning("BLedExt: forceWrite() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.parentRecipient = this.getParentRecipient();
        if (property.equals(ledOn)) {
            int value = BLedExt.getStatusBooleanValue((BStatusBoolean)this.get(property));
            if (value == 1 && this.ledPreviousState != 1) {
                log.finest("Led property changing invoked the doWriteLedOn() method");
                this.doWriteLedOn();
            } else if (value == 0 && this.ledPreviousState != 0) {
                log.finest("Led property changing invoked the doWriteLedOff() method");
                this.doWriteLedOff();
            }
            this.ledPreviousState = value;
        } else if (property.equals(ledColor)) {
            int ledColorOrdinal = ((BLedColorEnum)this.get(property)).getOrdinal();
            log.finer("Property ledColor changed, API value == " + BLedColorEnum.ordinalToHexString(ledColorOrdinal));
            if (this.ledColorPreviousState != ledColorOrdinal) {
                log.finest("LedColor property value differnet than in previous state");
                this.ledColorPreviousState = ledColorOrdinal;
                this.doWriteLedColor((BLedColorEnum)this.get(property));
            }
        }
    }

    @Override
    public void started() {
        super.started();
        if (this.parentRecipient == null) {
            log.severe("BLedExt: Parent component couldn't be loaded!");
        } else {
            log.finer("BLedExt: Parent component was loaded!");
        }
        this.ledColorPreviousState = this.getLedColor().getOrdinal();
        this.ledPreviousState = BLedExt.getStatusBooleanValue(this.getLedOn());
    }
}

