/*
 * Decompiled with CFR 0.152.
 */
package com.ic.icsmartviewconfig;

import com.ic.icsmartviewconfig.BExt;
import com.ic.icsmartviewconfig.BIcSmartViewRecipient;
import java.util.logging.Level;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="kioskMode", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=8), @NiagaraProperty(name="kioskUnlockPassword", type="BPassword", defaultValue="BPassword.make(BKioskModeExt.DEFAULT_PASSWORD)", flags=8, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"wbutil:UserPasswordFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"webEditors:UserPasswordEditor\"")})})
@NiagaraActions(value={@NiagaraAction(name="writeLock", flags=16), @NiagaraAction(name="writeUnlock", flags=16), @NiagaraAction(name="writeKioskUnlockPassword", parameterType="BPassword", defaultValue="BPassword.make(BKioskModeExt.DEFAULT_PASSWORD)", flags=16, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"wbutil:UserPasswordFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"webEditors:UserPasswordEditor\"")})})
public final class BKioskModeExt
extends BExt {
    public static final Property kioskMode = BKioskModeExt.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property kioskUnlockPassword = BKioskModeExt.newProperty((int)8, (BValue)BPassword.make((String)"password"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"wbutil:UserPasswordFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"webEditors:UserPasswordEditor")));
    public static final Action writeLock = BKioskModeExt.newAction((int)16, null);
    public static final Action writeUnlock = BKioskModeExt.newAction((int)16, null);
    public static final Action writeKioskUnlockPassword = BKioskModeExt.newAction((int)16, (BValue)BPassword.make((String)"password"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"wbutil:UserPasswordFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"webEditors:UserPasswordEditor")));
    public static final Type TYPE = Sys.loadType(BKioskModeExt.class);
    public static final String THIS_CLASS_NAME = "BKioskModeExt";
    private static final String DEFAULT_PASSWORD = "password";
    private String passwordPreviousState;
    private int modePreviousState;

    public BStatusBoolean getKioskMode() {
        return (BStatusBoolean)this.get(kioskMode);
    }

    public void setKioskMode(BStatusBoolean v) {
        this.set(kioskMode, (BValue)v, null);
    }

    public BPassword getKioskUnlockPassword() {
        return (BPassword)this.get(kioskUnlockPassword);
    }

    public void setKioskUnlockPassword(BPassword v) {
        this.set(kioskUnlockPassword, (BValue)v, null);
    }

    public void writeLock() {
        this.invoke(writeLock, null, null);
    }

    public void writeUnlock() {
        this.invoke(writeUnlock, null, null);
    }

    public void writeKioskUnlockPassword(BPassword parameter) {
        this.invoke(writeKioskUnlockPassword, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doForceWrite() {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                this.tryLogIfLoggable(Level.FINE, "forceWrite() action invoked");
                if (this.getKioskMode().getBoolean()) {
                    this.doWriteLock();
                } else {
                    this.doWriteUnlock();
                }
                this.doWriteKioskUnlockPassword(this.getKioskUnlockPassword());
            } else {
                log.warning("BKioskModeExt: doForceWrite() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    public void doWriteLock() {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                this.tryLogIfLoggable(Level.FINER, "doWriteLock() action invoked");
                this.sendRequest("POST", "/lock", null);
                this.tryLogIfLoggable(Level.FINEST, "doWriteLock() sets POST request to '/lock'");
            } else {
                log.warning("BKioskModeExt: doWriteLock() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    public void doWriteUnlock() {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                this.tryLogIfLoggable(Level.FINER, "doWriteUnlock() action invoked");
                this.sendRequest("POST", "/unlock", null);
                this.tryLogIfLoggable(Level.FINEST, "doWriteUnlock() sets POST request to '/unlock'");
            } else {
                log.warning("BKioskModeExt: doWriteUnlock() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    public void doWriteKioskUnlockPassword(BPassword v) {
        if (this.areParentsStarted()) {
            if (this.isParentReadyToSendRequest()) {
                this.tryLogIfLoggable(Level.FINER, "doWriteKioskUnlockPassword() action invoked with new password: *****");
                this.sendRequest("POST", "/api/v2/lockPassword", BIcSmartViewRecipient.generatePostData(DEFAULT_PASSWORD, v.getValue(), true));
                this.tryLogIfLoggable(Level.FINEST, "doWriteKioskUnlockPassword() sets POST request to '/api/v2/lockPassword' using body: " + BIcSmartViewRecipient.generatePostData(DEFAULT_PASSWORD, "******", true));
            } else {
                log.warning("BKioskModeExt: doWriteKioskUnlockPassword() action wasn't invoked, because parent BIcSmartViewRecipient component is disabled or its parent service is in fault!");
            }
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.parentRecipient = this.getParentRecipient();
        if (property.equals(kioskMode)) {
            int value = BKioskModeExt.getStatusBooleanValue((BStatusBoolean)this.get(property));
            if (value == 1 && this.modePreviousState != 1) {
                this.tryLogIfLoggable(Level.FINEST, "kioskMode property changing invoked the doWriteLock() method");
                this.doWriteLock();
            } else if (value == 0 && this.modePreviousState != 0) {
                this.tryLogIfLoggable(Level.FINEST, "kioskMode property changing invoked the doWriteUnlock() method");
                this.doWriteUnlock();
            }
            this.modePreviousState = value;
        } else if (property.equals(kioskUnlockPassword)) {
            String newPassword = ((BPassword)this.get(property)).getValue();
            this.tryLogIfLoggable(Level.FINER, "kioskUnlockPassword property changed to *****");
            if (!newPassword.equals(this.passwordPreviousState)) {
                this.tryLogIfLoggable(Level.FINEST, "kioskUnlockPassword property value differnet than in previous state");
                this.passwordPreviousState = newPassword;
                this.doWriteKioskUnlockPassword(BPassword.make((String)newPassword));
            }
        }
    }

    @Override
    public void started() {
        super.started();
        if (this.parentRecipient == null) {
            log.severe("BKioskModeExt: Parent component couldn't be loaded!");
        } else {
            this.tryLogIfLoggable(Level.FINER, "Parent component was loaded!");
        }
        this.passwordPreviousState = this.getKioskUnlockPassword().getValue();
        this.modePreviousState = BKioskModeExt.getStatusBooleanValue(this.getKioskMode());
    }
}

