/*
 * Decompiled with CFR 0.152.
 */
package com.ic.icsmartviewconfig;

import com.ic.icsmartviewconfig.BIPingable;
import com.ic.icsmartviewconfig.BIStatusObserver;
import com.ic.icsmartviewconfig.BStatusData;
import com.ic.icsmartviewconfig.BStatusEnum;
import com.ic.icsmartviewconfig.BStatusObserverManager;
import java.util.logging.Logger;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;

public class BIcSmartViewService
extends BComponent
implements BIService,
BIStatus,
BIStatusObserver {
    public static final Property status = BIcSmartViewService.newProperty((int)75, (BValue)BStatus.stale, null);
    public static final Property faultCause = BIcSmartViewService.newProperty((int)67, (String)"", null);
    public static final Property enabled = BIcSmartViewService.newProperty((int)0, (boolean)true, null);
    public static final Action pingAllChildren = BIcSmartViewService.newAction((int)16);
    public static final String THIS_CLASS_NAME = "BIcSmartViewService";
    public static final String LOGGER_NAME = "iC_SmartView_Config";
    public static final Logger log = Logger.getLogger("iC_SmartView_Config");
    public boolean duplicated = false;
    private boolean componentStarted;
    private BStatusObserverManager observerManager;
    private static final int DISABLED_PRIORITY_DISABLED_BY_SLOT = 0;
    private static final String FAULT_CAUSE_COMPONENT_DUPLICATED = "Service is duplicated!";
    private static final int FAULT_PRIORITY_COMPONENT_DUPLICATED = 0;
    private static final int FAULT_STATUS_OBSERVER_DATA_MAX_LENGTH = 1;
    private static final int DISABLE_STATUS_OBSERVER_DATA_MAX_LENGTH = 1;
    private static final BIcon icon = BIcon.make((String)"module://iC_SmartView_Config/icons/iCSmartViewService.png");
    public static final Type TYPE = Sys.loadType(BIcSmartViewService.class);

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public void pingAllChildren() {
        this.invoke(pingAllChildren, null);
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type getType() {
        return TYPE;
    }

    public void doPingAllChildren() {
        log.fine("BIcSmartViewService: PingAllChildren action invoked!");
        BIPingable[] children = (BIPingable[])this.getChildren(BIPingable.class);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                children[i].ping();
            }
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() {
        if (this.duplicated) {
            return;
        }
        log.finer("Service started");
    }

    public void serviceStopped() {
        if (this.duplicated) {
            return;
        }
        log.finer("Service stopped");
    }

    private static final BStatusData[] getDisablePrototype() {
        BStatusData[] result = new BStatusData[]{new BStatusData(4, BStatus.disabled, "", 0)};
        return result;
    }

    private static final BStatusData[] getFaultPrototype() {
        BStatusData[] result = new BStatusData[]{new BStatusData(6, BStatus.fault, FAULT_CAUSE_COMPONENT_DUPLICATED, 0)};
        return result;
    }

    @Override
    public void subscribeStatus(BStatusEnum statusType) {
        log.finest("BIcSmartViewService: subscribe: " + Integer.toString(statusType.getOrdinal()));
        this.observerManager.subscribeStatus(statusType);
        this.updateStatus();
    }

    @Override
    public void unsubscribeStatus(BStatusEnum statusType) {
        log.finest("BIcSmartViewService: unsubscribe: " + Integer.toString(statusType.getOrdinal()));
        this.observerManager.unsubscribeStatus(statusType);
        if (statusType.getOrdinal() == 4 && this.getStatus().isFault()) {
            this.verifyDuplication();
        }
        this.updateStatus();
    }

    private void updateStatus() {
        int newStatus = 0;
        log.fine("BIcSmartViewService: Update status");
        boolean observerManagerIsDisabled = this.observerManager.isDisabled();
        boolean observerManagerIsFault = this.observerManager.isFault();
        if (!observerManagerIsDisabled && !observerManagerIsFault) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
            log.finer("BIcSmartViewService: Set status OK");
        } else {
            if (observerManagerIsDisabled) {
                newStatus |= 1;
            }
            if (observerManagerIsFault) {
                newStatus |= 2;
                this.setFaultCause(this.observerManager.getMostImportantFaultCause());
            } else {
                this.setFaultCause("");
            }
            this.setStatus(BStatus.make((int)newStatus));
            log.finer("BIcSmartViewService: Set status bits flags as " + Integer.toString(newStatus));
        }
        this.updateAllChildren();
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled)) {
            log.fine("BIcSmartViewService: Enabled slot has changed!");
            boolean enabledValue = this.getEnabled();
            log.finest("BIcSmartViewService: Enabled slot == " + Boolean.toString(enabledValue));
            if (!this.getStatus().isFault() && enabledValue) {
                this.serviceStarted();
            } else {
                this.serviceStopped();
            }
            if (enabledValue) {
                this.unsubscribeStatus(BStatusEnum.Disable);
            } else {
                this.subscribeStatus(BStatusEnum.Disable);
            }
            if (this.duplicated) {
                return;
            }
        }
        if (this.duplicated) {
            return;
        }
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BServiceContainer;
    }

    public void started() {
        this.componentStarted = false;
        log.finer("BIcSmartViewService: Component started!");
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.observerManager = new BStatusObserverManager(1, BIcSmartViewService.getDisablePrototype(), 1, BIcSmartViewService.getFaultPrototype(), log);
        this.verifyDuplication();
        if (!this.getEnabled()) {
            this.subscribeStatus(BStatusEnum.Disable);
        } else {
            this.serviceStarted();
        }
        this.componentStarted = true;
    }

    protected void updateAllChildren() {
        if (this.componentStarted) {
            BIStatusObserver[] children = (BIStatusObserver[])this.getChildren(BIStatusObserver.class);
            log.finer("BIcSmartViewService: updateAllChildren!");
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    log.finer("BIcSmartViewService: update children: " + Integer.toString(i));
                    if (this.isDisabled()) {
                        children[i].subscribeStatus(BStatusEnum.DisableThrownFromParent);
                    } else {
                        children[i].unsubscribeStatus(BStatusEnum.DisableThrownFromParent);
                    }
                    if (this.isFault()) {
                        children[i].subscribeStatus(BStatusEnum.FaultThrownFromParent);
                        continue;
                    }
                    children[i].unsubscribeStatus(BStatusEnum.FaultThrownFromParent);
                }
            } else {
                log.fine("BIcSmartViewService: children array is NULL");
            }
        }
    }

    private void verifyDuplication() {
        BComponent[] s = Sys.getServices((Type)this.getType());
        if (s != null && s.length > 1) {
            this.subscribeStatus(BStatusEnum.Duplicated);
            this.duplicated = true;
            log.warning("BIcSmartViewService: Component duplicated!");
        } else {
            this.unsubscribeStatus(BStatusEnum.Duplicated);
            if (this.duplicated) {
                this.duplicated = false;
                log.finest("BIcSmartViewService: Component no longer duplicated!");
            }
        }
    }
}

