/*
 * Decompiled with CFR 0.152.
 */
package com.ic.icsmartviewconfig;

import com.ic.icsmartviewconfig.BHttpsThread;
import com.ic.icsmartviewconfig.BIPingable;
import com.ic.icsmartviewconfig.BIRequestObserver;
import com.ic.icsmartviewconfig.BIStatusObserver;
import com.ic.icsmartviewconfig.BIcSmartViewService;
import com.ic.icsmartviewconfig.BRecipientsFolder;
import com.ic.icsmartviewconfig.BStatusData;
import com.ic.icsmartviewconfig.BStatusEnum;
import com.ic.icsmartviewconfig.BStatusObserverManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BIcSmartViewRecipient
extends BComponent
implements BIPingable,
BIRequestObserver,
BIStatus,
BIStatusObserver {
    private String currentIpAddress;
    private String currentPassword;
    private String currentUserName;
    protected BIcSmartViewService parentService;
    protected BHttpsThread httpsThread = null;
    private static final String LEFT_BRACE = "{";
    public static final String THIS_CLASS_NAME = "BIcSmartViewRecipient";
    private static final String DEFAULT_IP_ADDRESS = "###.###.###.###";
    private static final String DEFAULT_USERNAME = "";
    private static final String DEFAULT_PASSWORD = "";
    private static final int MINIMUM_MIN_TIME_BETWEEN_FRAMES = 500;
    private static final int MAXIMUM_MIN_TIME_BETWEEN_FRAMES = 10000;
    private static final int DEFAULT_MIN_TIME_BETWEEN_FRAMES = 500;
    public static final Logger log = Logger.getLogger("iC_SmartView_Config");
    public static final Property status = BIcSmartViewRecipient.newProperty((int)75, (BValue)BStatus.stale, null);
    public static final Property faultCause = BIcSmartViewRecipient.newProperty((int)67, (String)new String(""), null);
    public static final Property enabled = BIcSmartViewRecipient.newProperty((int)0, (boolean)true, null);
    public static final Property ipAddress = BIcSmartViewRecipient.newProperty((int)0, (String)new String("###.###.###.###"), null);
    public static final Property credentials = BIcSmartViewRecipient.newProperty((int)0, (BValue)new BUsernameAndPassword("", ""), null);
    public static final Action ping = BIcSmartViewRecipient.newAction((int)20);
    public static final Property minTimeBetweenFrames = BIcSmartViewRecipient.newProperty((int)4, (BValue)BInteger.make((int)500), (BFacets)BFacets.makeInt((BUnit)BUnit.getUnit((String)"millisecond"), (int)500, (int)10000));
    public static final Property lastOkTime = BIcSmartViewRecipient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFaultTime = BIcSmartViewRecipient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    private BStatusObserverManager observerManager;
    private static final int DISABLED_PRIORITY_DISABLED_BY_SLOT = 0;
    private static final int DISABLED_PRIORITY_DISABLED_BY_PARENT_SERVICE = 1;
    private static final String FAULT_CAUSE_API_ACCESS_EXCEPTION = "API in remote Android Panel disabled! HTTP Status-Code 403: Forbidden Error!";
    private static final int FAULT_PRIORITY_API_ACCESS_EXCEPTION = 7;
    private static final String FAULT_CAUSE_CONNECTION_EXCEPTION = "ConnectException: Could not create socket! Connection timeout! Please ensure if correct IP address has been entered or if remote device is powered up!";
    private static final int FAULT_PRIORITY_CONNECTION_EXCEPTION = 9;
    private static final String FAULT_CAUSE_CREDENTIALS_EXCEPTION = "Not proper credentials in the request! HTTP Status-Code 401: Unauthorized!";
    private static final int FAULT_PRIORITY_CREDENTIALS_EXCEPTION = 4;
    private static final String FAULT_CAUSE_EXCEPTION = "General exception!";
    private static final int FAULT_PRIORITY_EXCEPTION = 13;
    private static final String FAULT_CAUSE_FILE_NOT_FOUND_EXCEPTION = "API method not found in remote Android Panel! Please ensure if correct version of iC_SmartView application has been installed on remote recipient host!";
    private static final int FAULT_PRIORITY_FILE_NOT_FOUND_EXCEPTION = 8;
    private static final String FAULT_CAUSE_INTERRUPTED_EXCEPTION = "HttpsThread took to much time!";
    private static final int FAULT_PRIORITY_INTERRUPTED_EXCEPTION = 11;
    private static final String FAULT_CAUSE_IO_EXCEPTION = "IOException!";
    private static final int FAULT_PRIORITY_IO_EXCEPTION = 12;
    private static final String FAULT_CAUSE_MALFORMED_URL_EXCEPTION = "URL created using IP Address is malformed!";
    private static final int FAULT_PRIORITY_MALFORMED_URL_EXCEPTION = 3;
    private static final String FAULT_CAUSE_PASSWORD_NOT_DECODED = "Failed to decode password!";
    private static final int FAULT_PRIORITY_PASSWORD_NOT_DECODED = 1;
    private static final String FAULT_CAUSE_SECURITY_EXCEPTION = "SecurityException!";
    private static final int FAULT_PRIORITY_SECURITY_EXCEPTION = 10;
    private static final String FAULT_CAUSE_SSL_EXCEPTION_CERTIFICATE = "SSLException: Recipient device certificate was not approved!";
    private static final int FAULT_PRIORITY_SSL_EXCEPTION_CERTIFICATE = 5;
    private static final String FAULT_CAUSE_SSL_EXCEPTION_UNSUPPORTED_MESSAGE = "SSLException: Recipient device replied using unsupported or unrecognized SSL message!";
    private static final int FAULT_PRIORITY_SSL_EXCEPTION_UNSUPPORTED_MESSAGE = 6;
    private static final String FAULT_CAUSE_THROWN_FROM_PARENT_SERVICE = "Parent service has a Fault status!";
    private static final int FAULT_PRIORITY_THROWN_FROM_PARENT_SERVICE = 0;
    private static final String FAULT_CAUSE_UNKNOWN_HOST_EXCEPTION = "IpAddress slot is EMPTY or there is not proper IP address!";
    private static final int FAULT_PRIORITY_UNKNOWN_HOST_EXCEPTION = 2;
    private static final int FAULT_STATUS_OBSERVER_DATA_MAX_LENGTH = 14;
    private static final int DISABLE_STATUS_OBSERVER_DATA_MAX_LENGTH = 2;
    private static final BIcon icon = BIcon.make((String)"module://iC_SmartView_Config/icons/iCSmartViewRecipient.png");
    public static final Type TYPE = Sys.loadType(BIcSmartViewRecipient.class);

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v);
    }

    public BValue getCredentials() {
        return this.get(credentials);
    }

    public void setCredentials(BValue v) {
        this.set(credentials, v, null);
    }

    @Override
    public void ping() {
        this.invoke(ping, null);
    }

    public int getMinTimeBetweenFrames() {
        return this.getInt(minTimeBetweenFrames);
    }

    public void setMinTimeBetweenFrames(int v) {
        this.setInt(minTimeBetweenFrames, v);
    }

    public BAbsTime getLastOkTime() {
        return (BAbsTime)this.get(lastOkTime);
    }

    public void setLastOkTime(BAbsTime v) {
        this.set(lastOkTime, (BValue)v, null);
    }

    public BAbsTime getLastFaultTime() {
        return (BAbsTime)this.get(lastFaultTime);
    }

    public void setLastFaultTime(BAbsTime v) {
        this.set(lastFaultTime, (BValue)v, null);
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type getType() {
        return TYPE;
    }

    public void doPing() {
        this.sendRequest(this);
    }

    @Override
    public void notifyResult(String result) {
        log.fine("BIcSmartViewRecipient: Got results: " + result);
        this.setLastTime(result.contains("OK") && result.length() <= 5 || result.startsWith("{\"autostartId"));
    }

    private static final BStatusData[] getDisablePrototype() {
        BStatusData[] result = new BStatusData[2];
        result[1] = new BStatusData(5, BStatus.disabled, "", 1);
        result[0] = new BStatusData(4, BStatus.disabled, "", 0);
        return result;
    }

    private static final BStatusData[] getFaultPrototype() {
        BStatusData[] result = new BStatusData[14];
        result[7] = new BStatusData(1, BStatus.fault, FAULT_CAUSE_API_ACCESS_EXCEPTION, 7);
        result[9] = new BStatusData(2, BStatus.fault, FAULT_CAUSE_CONNECTION_EXCEPTION, 9);
        result[4] = new BStatusData(3, BStatus.fault, FAULT_CAUSE_CREDENTIALS_EXCEPTION, 4);
        result[13] = new BStatusData(7, BStatus.fault, FAULT_CAUSE_EXCEPTION, 13);
        result[8] = new BStatusData(9, BStatus.fault, FAULT_CAUSE_FILE_NOT_FOUND_EXCEPTION, 8);
        result[11] = new BStatusData(10, BStatus.fault, FAULT_CAUSE_INTERRUPTED_EXCEPTION, 11);
        result[12] = new BStatusData(11, BStatus.fault, FAULT_CAUSE_IO_EXCEPTION, 12);
        result[3] = new BStatusData(12, BStatus.fault, FAULT_CAUSE_MALFORMED_URL_EXCEPTION, 3);
        result[1] = new BStatusData(13, BStatus.fault, FAULT_CAUSE_PASSWORD_NOT_DECODED, 1);
        result[10] = new BStatusData(14, BStatus.fault, FAULT_CAUSE_SECURITY_EXCEPTION, 10);
        result[5] = new BStatusData(15, BStatus.fault, FAULT_CAUSE_SSL_EXCEPTION_CERTIFICATE, 5);
        result[6] = new BStatusData(16, BStatus.fault, FAULT_CAUSE_SSL_EXCEPTION_UNSUPPORTED_MESSAGE, 6);
        result[0] = new BStatusData(8, BStatus.fault, FAULT_CAUSE_THROWN_FROM_PARENT_SERVICE, 0);
        result[2] = new BStatusData(17, BStatus.fault, FAULT_CAUSE_UNKNOWN_HOST_EXCEPTION, 2);
        return result;
    }

    @Override
    public void subscribeStatus(BStatusEnum statusType) {
        log.finest("BIcSmartViewRecipient: subscribe: " + Integer.toString(statusType.getOrdinal()));
        if (this.observerManager != null) {
            this.observerManager.subscribeStatus(statusType);
            this.updateStatus();
        } else {
            log.finer("BIcSmartViewRecipient: subscribeStatus() - observerManager is not declared yet!");
        }
    }

    @Override
    public void unsubscribeStatus(BStatusEnum statusType) {
        if (this.observerManager != null) {
            this.observerManager.unsubscribeStatus(statusType);
            this.updateStatus();
        } else {
            log.finer("BIcSmartViewRecipient: unsubscribeStatus() - observerManager is not declared yet!");
        }
    }

    private void updateStatus() {
        int newStatus = 0;
        boolean observerManagerIsDisabled = this.observerManager.isDisabled();
        boolean observerManagerIsFault = this.observerManager.isFault();
        if (!observerManagerIsDisabled && !observerManagerIsFault) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        } else {
            if (observerManagerIsDisabled) {
                newStatus |= 1;
            }
            if (observerManagerIsFault) {
                newStatus |= 2;
                this.setFaultCause(this.observerManager.getMostImportantFaultCause());
            } else {
                this.setFaultCause("");
            }
            this.setStatus(BStatus.make((int)newStatus));
            log.finer("BIcSmartViewRecipient: Set status bits flags as " + Integer.toString(newStatus));
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.finest("BIcSmartViewRecipient: Slot " + property.toString() + " has changed");
        if (property.equals(enabled)) {
            log.fine("BIcSmartViewRecipient: Enabled slot has changed!");
            boolean enabledValue = this.getBoolean(property);
            log.finest("BIcSmartViewRecipient: Enabled slot == " + Boolean.toString(enabledValue));
            if (this.httpsThread == null) {
                this.httpsThreadBuild();
            }
            if (enabledValue) {
                this.unsubscribeStatus(BStatusEnum.Disable);
                if (this.ipAddressIsValid(this.currentIpAddress)) {
                    this.httpsThread.initThread();
                    this.ping();
                }
            } else {
                this.subscribeStatus(BStatusEnum.Disable);
                if (this.httpsThread != null) {
                    this.httpsThread.interrupThread();
                }
            }
        } else if (property.equals(credentials) || property.equals(ipAddress)) {
            if (this.getStatus().equals((Object)BStatus.disabled)) {
                return;
            }
            if (property.equals(credentials)) {
                log.fine("BIcSmartViewRecipient: Property credentials changed!");
                BUsernameAndPassword uap = (BUsernameAndPassword)this.get(property);
                try {
                    this.currentPassword = uap.getPassword().getValue();
                    this.currentUserName = uap.getUsername();
                }
                catch (SecurityException e) {
                    this.subscribeStatus(BStatusEnum.SecurityException);
                    log.warning("BIcSmartViewRecipient: Failed to decode password: " + e.getMessage());
                }
            } else if (property.equals(ipAddress)) {
                log.fine("BIcSmartViewRecipient: Property ipAddress changed!");
                this.currentIpAddress = this.getString(property);
            }
            if (this.ipAddressIsValid(this.currentIpAddress)) {
                this.httpsThread.setCredentials(this.currentUserName, this.currentPassword);
                this.httpsThread.setIpAddress(this.currentIpAddress);
                if (this.getEnabled()) {
                    this.ping();
                }
            }
        }
    }

    public static final String generatePostData(String key, String value, boolean bracesForValue) {
        String result = "";
        if (key != null && value != null) {
            result = new String(LEFT_BRACE);
            result = result + String.format(bracesForValue ? "\"%s\": \"%s\"" : "\"%s\": %s", key, value) + "}";
        }
        return result;
    }

    public static final String generatePostData(String[] keys, String[] values, boolean[] bracesForValues) {
        String result = "";
        if (keys.length == values.length) {
            result = new String(LEFT_BRACE);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    result = result + ",\n";
                }
                result = result + String.format(bracesForValues[i] ? "\"%s\": \"%s\"" : "\"%s\": %s", keys[i], values[i]);
            }
            result = result + "}";
        }
        return result;
    }

    public static final String generatePostData(String[] keys, String[] values, Boolean[] bracesForValues) {
        int len = bracesForValues.length;
        boolean[] braces = new boolean[len];
        for (int i = 0; i < len; ++i) {
            braces[i] = bracesForValues[i];
        }
        return BIcSmartViewRecipient.generatePostData(keys, values, braces);
    }

    private String getCredentialsPassword() {
        log.finest("BIcSmartViewRecipient: password credential getting");
        BUsernameAndPassword uap = (BUsernameAndPassword)this.getCredentials();
        try {
            return uap.getPassword().getValue();
        }
        catch (SecurityException e) {
            this.subscribeStatus(BStatusEnum.SecurityException);
            log.warning("BIcSmartViewRecipient: Failed to decode password: " + e.getMessage());
            return "";
        }
    }

    private String getCredentialsUsername() {
        log.finest("BIcSmartViewRecipient: username credential getting");
        BUsernameAndPassword uap = (BUsernameAndPassword)this.getCredentials();
        return uap.getUsername();
    }

    private BIcSmartViewService getParentService() {
        BComponent parentComponent = this.getParent().getParentComponent();
        while (!(parentComponent instanceof BIcSmartViewService)) {
            parentComponent = parentComponent.getParent().getParentComponent();
        }
        return (BIcSmartViewService)parentComponent;
    }

    private void httpsThreadBuild() {
        log.finest("BIcSmartViewRecipient: New BHttpsThread created!");
        this.httpsThread = BHttpsThread.builder().statusObserver(this).ipAddress(this.currentIpAddress).userName(this.currentUserName).password(this.currentPassword).build();
        log.finest(this.httpsThread.toString());
    }

    protected boolean ipAddressIsValid(String ipAddr) {
        this.unsubscribeStatus(BStatusEnum.UnknownHostException);
        Pattern pattern = Pattern.compile("^(?:(?:2(?:5[0-5]|[0-4]\\d)|1?\\d?\\d)\\.){3}(?:(?:2(?:5[0-5]|[0-4]\\d)|1?\\d\\d|[1-9]))$");
        Matcher matcher = pattern.matcher(ipAddr);
        if (matcher.matches()) {
            try {
                InetAddress.getByName(ipAddr);
                log.finest("BIcSmartViewRecipient: IP Address OK!");
                return true;
            }
            catch (UnknownHostException e) {
                log.severe("BIcSmartViewRecipient: UnknownHostException occured during component executing: " + e.getMessage());
                this.subscribeStatus(BStatusEnum.UnknownHostException);
                return false;
            }
        }
        log.severe("BIcSmartViewRecipient: UnknownHostException occured during component executing: " + ipAddr);
        this.subscribeStatus(BStatusEnum.UnknownHostException);
        return false;
    }

    public final boolean isCriticalFault() {
        if (this.observerManager == null) {
            return true;
        }
        return this.observerManager.isSubscribed(BStatusEnum.UnknownHostException);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIcSmartViewService || parent instanceof BRecipientsFolder;
    }

    void sendRequest(BIRequestObserver requestObserver) {
        if (this.getStatus().equals((Object)BStatus.disabled) || this.isCriticalFault()) {
            log.finest("BIcSmartViewRecipient: sendRequest() couldn't realized by status disabled or wrong IP Address");
            return;
        }
        log.finest("BIcSmartViewRecipient: sendRequest() invoked - default message");
        this.httpsThread.addRequest(requestObserver);
    }

    void sendRequest(String httpMethod, String api, String body, BIRequestObserver requestObserver) {
        if (this.getStatus().equals((Object)BStatus.disabled) || this.isCriticalFault()) {
            log.finest("BIcSmartViewRecipient: sendRequest() couldn't realized by status disabled or wrong IP Address");
            return;
        }
        log.finest("BIcSmartViewRecipient: sendRequest() invoked, httpMethod == " + httpMethod + ", api == " + api + ", body == " + body);
        this.httpsThread.addRequest(api, body, httpMethod, requestObserver);
    }

    public void setLastTime(boolean resultOK) {
        BAbsTime t;
        log.finest("BIcSmartViewRecipient: SetLastTime");
        long now = System.currentTimeMillis();
        long truncated = now - now % 60000L;
        BAbsTime bAbsTime = t = truncated <= (resultOK ? this.getLastOkTime().getMillis() : this.getLastFaultTime().getMillis()) ? BAbsTime.make((long)now) : BAbsTime.make((long)truncated);
        if (resultOK) {
            log.finer("BIcSmartViewRecipient: SetLastOkTime");
            this.setLastOkTime(t);
        } else {
            log.finer("BIcSmartViewRecipient: SetLastFaultTime");
            this.setLastFaultTime(t);
        }
    }

    public void started() throws Exception {
        log.finer("BIcSmartViewRecipient: Component started!");
        this.observerManager = new BStatusObserverManager(2, BIcSmartViewRecipient.getDisablePrototype(), 14, BIcSmartViewRecipient.getFaultPrototype(), log);
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.parentService = this.getParentService();
        if (this.parentService.getStatus().isDisabled()) {
            this.subscribeStatus(BStatusEnum.DisableThrownFromParent);
        }
        if (this.parentService.getStatus().isFault()) {
            this.subscribeStatus(BStatusEnum.FaultThrownFromParent);
        }
        this.currentPassword = this.getCredentialsPassword();
        this.currentUserName = this.getCredentialsUsername();
        this.currentIpAddress = this.getIpAddress();
        if (!this.parentService.getStatus().isDisabled() && !this.parentService.getStatus().isFault()) {
            this.changed(enabled, null);
        }
    }

    public void stopped() throws Exception {
        if (this.httpsThread != null) {
            this.httpsThread.interrupThread();
        }
        log.finer("BIcSmartViewRecipient: Component stopped!");
    }
}

